/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns;

import com.google.common.base.Splitter;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.client.gui.bns.Theme;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.IWindows;
import me.ichun.mods.ichunutil.client.gui.bns.window.Window;
import me.ichun.mods.ichunutil.client.gui.bns.window.WindowDock;
import me.ichun.mods.ichunutil.client.gui.bns.window.WindowGreyout;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrainable;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.util.IOUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public abstract class Workspace
extends Screen
implements IConstrainable,
IWindows {
    public static final String ELLIPSIS = "\u00e2\u20ac\u00a6";
    private static HashMap<Class<?>, Function<Object, List<String>>> OBJECT_INTERPRETER = new HashMap();
    public int ellipsisLength;
    private Theme theme;
    public ArrayList<Window<?>> windows;
    private boolean renderMinecraftStyle;
    private boolean hasInit;
    private Screen lastScreen;
    public String lastTooltip;
    public int tooltipCooldown;

    @Nonnull
    public static List<String> getInterpretedInfo(Object o) {
        Map.Entry<Class<?>, Function<Object, List<String>>> lastEntryUsed = null;
        List<String> infos = null;
        for (Map.Entry<Class<?>, Function<Object, List<String>>> e : OBJECT_INTERPRETER.entrySet()) {
            if (!e.getKey().isInstance(o) || lastEntryUsed != null && e.getKey().isAssignableFrom(lastEntryUsed.getKey())) continue;
            lastEntryUsed = e;
            infos = e.getValue().apply(o);
        }
        if (infos == null) {
            infos = new ArrayList<String>();
            infos.add(o.toString());
        }
        return infos;
    }

    public static void registerObjectInterpreter(Class<?> clz, Function<Object, List<String>> function) {
        OBJECT_INTERPRETER.put(clz, function);
    }

    public Workspace(Screen lastScreen, ITextComponent title, boolean mcStyle) {
        super(title);
        OBJECT_INTERPRETER.put(File.class, o -> {
            File file = (File)o;
            ArrayList<String> info = new ArrayList<String>();
            info.add(file.getName());
            info.add(new SimpleDateFormat().format(new Date(file.lastModified())));
            info.add(IOUtil.readableFileSize(file.length()));
            return info;
        });
        OBJECT_INTERPRETER.put(Theme.class, o -> Collections.singletonList(((Theme)o).name + " - " + ((Theme)o).author));
        this.ellipsisLength = 0;
        this.theme = Theme.getInstance();
        this.windows = new ArrayList();
        this.lastScreen = lastScreen;
        this.renderMinecraftStyle = mcStyle;
        if (this.canDockWindows()) {
            this.windows.add(new WindowDock<Workspace>(this));
        }
    }

    public <T extends Workspace> T setTheme(Theme theme) {
        this.theme = theme;
        return (T)this;
    }

    public <T extends Workspace> T setMinecraftStyle() {
        this.renderMinecraftStyle = true;
        return (T)this;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public Theme getTheme() {
        return this.theme;
    }

    public void onClose() {
        this.minecraft.func_147108_a(this.lastScreen);
    }

    protected void init() {
        if (!this.hasInit) {
            this.hasInit = true;
            this.ellipsisLength = this.getFontRenderer().func_78256_a(ELLIPSIS);
            this.windows.forEach((Consumer<Window<?>>)((Consumer<Window>)Fragment::init));
        }
        this.minecraft.field_195559_v.func_197967_a(true);
    }

    public boolean hasInit() {
        return this.hasInit;
    }

    public void removed() {
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    public List<Window<?>> children() {
        if (this.canDockWindows()) {
            ArrayList winds = new ArrayList();
            for (int i = 0; i < this.windows.size(); ++i) {
                Window<?> window = this.windows.get(i);
                if (window instanceof WindowDock) {
                    ((WindowDock)window).docked.keySet().forEach(h -> winds.addAll(h.windows));
                    continue;
                }
                winds.add(window);
            }
            winds.remove(this.getDock());
            return winds;
        }
        return this.windows;
    }

    @Override
    public Window<?> addWindow(Window<?> window) {
        if (window.isUnique()) {
            List<Window<?>> allWindows = this.children();
            for (int i = allWindows.size() - 1; i >= 0; --i) {
                Window<?> window1 = allWindows.get(i);
                if (window1.getClass() != window.getClass()) continue;
                if (this.isDocked(window1)) {
                    window1.onClose();
                    this.getDock().removeFromDock(window1);
                    continue;
                }
                this.removeWindow(window1);
            }
        }
        this.windows.add(0, window);
        return window;
    }

    @Override
    public void removeWindow(Window<?> window) {
        if (this.getFocused() == window) {
            this.setFocused(null);
        }
        window.onClose();
        this.windows.remove(window);
    }

    public void bringToFront(Window<?> window) {
        if (window.canBringToFront() && this.windows.remove(window)) {
            this.addWindow(window);
        }
    }

    public void putInCenter(Window<?> window) {
        if (!this.isDocked(window)) {
            window.pos((int)((double)(this.getWidth() - window.getWidth()) / 2.0), (int)((double)(this.getHeight() - window.getHeight()) / 2.0));
        }
    }

    public void openWindowInCenter(Window<?> window, double widthRatio, double heightRatio, boolean greyout) {
        if (widthRatio <= 1.0) {
            window.setWidth((int)((double)window.getParentWidth() * widthRatio));
        } else {
            window.setWidth((int)widthRatio);
        }
        if (heightRatio <= 1.0) {
            window.setHeight((int)((double)window.getParentHeight() * heightRatio));
        } else {
            window.setHeight((int)heightRatio);
        }
        if (greyout) {
            this.addWindowWithGreyout(window);
        } else {
            this.addWindow(window);
        }
        this.putInCenter(window);
        this.setFocused((IGuiEventListener)window);
        window.init();
    }

    public void openWindowInCenter(Window<?> window, double widthRatio, double heightRatio) {
        this.openWindowInCenter(window, widthRatio, heightRatio, false);
    }

    public void openWindowInCenter(Window<?> window, boolean greyout) {
        this.openWindowInCenter(window, 0.5, 0.5, greyout);
    }

    public void openWindowInCenter(Window<?> window) {
        this.openWindowInCenter(window, false);
    }

    public void addWindowWithGreyout(Window<?> window) {
        WindowGreyout<Workspace> greyout = new WindowGreyout<Workspace>(this, window);
        this.addWindow(greyout);
        greyout.init();
        this.addWindow(window);
    }

    public void tick() {
        this.children().forEach(Fragment::tick);
        --this.tooltipCooldown;
    }

    @Nullable
    public <T extends Fragment<?>> T getById(@Nonnull String id) {
        T o = null;
        for (IGuiEventListener iGuiEventListener : this.children()) {
            if (o != null || !(iGuiEventListener instanceof Fragment)) continue;
            o = ((Fragment)iGuiEventListener).getById(id);
        }
        return o;
    }

    public void render(int mouseX, int mouseY, float partialTick) {
        RenderSystem.enableAlphaTest();
        this.renderBackground();
        this.renderWindows(mouseX, mouseY, partialTick);
        this.renderTooltip(mouseX, mouseY, partialTick);
        this.resetBackground();
        RenderSystem.enableAlphaTest();
    }

    public void renderWindows(int mouseX, int mouseY, float partialTick) {
        for (int i = this.windows.size() - 1; i >= 0; --i) {
            Window<?> window = this.windows.get(i);
            window.render(mouseX, mouseY, partialTick);
        }
    }

    public void renderTooltip(int mouseX, int mouseY, float partialTick) {
        Fragment<?> topMost = this.getTopMostFragment(mouseX, mouseY);
        if (topMost != null) {
            String tooltip = topMost.tooltip(mouseX, mouseY);
            if (tooltip != null) {
                if (!tooltip.equals(this.lastTooltip)) {
                    this.lastTooltip = tooltip;
                    this.tooltipCooldown = iChunUtil.configClient.guiTooltipCooldown;
                }
            } else {
                this.lastTooltip = null;
            }
        }
        if (this.lastTooltip != null && this.tooltipCooldown < 0) {
            this.renderTooltip(this.lastTooltip, mouseX, mouseY);
        }
    }

    public void renderTooltip(@Nonnull String tooltip, int mouseX, int mouseY) {
        if (this.renderMinecraftStyle) {
            super.renderTooltip(Splitter.on((String)"\n").splitToList((CharSequence)tooltip), mouseX, mouseY);
        } else {
            FontRenderer font;
            int maxTextWidth;
            int screenHeight;
            int screenWidth;
            ItemStack stack = ItemStack.field_190927_a;
            ArrayList<String> textLines = Splitter.on((String)"\n").splitToList((CharSequence)tooltip);
            RenderTooltipEvent.Pre event = new RenderTooltipEvent.Pre(stack, (List)textLines, mouseX, mouseY, screenWidth = this.width, screenHeight = this.height, maxTextWidth = -1, font = this.getFontRenderer());
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            mouseX = event.getX();
            mouseY = event.getY();
            screenWidth = event.getScreenWidth();
            screenHeight = event.getScreenHeight();
            maxTextWidth = event.getMaxWidth();
            font = event.getFontRenderer();
            RenderSystem.disableDepthTest();
            int tooltipTextWidth = 0;
            for (String textLine : textLines) {
                int textLineWidth = font.func_78256_a(textLine);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            int titleLinesCount = 1;
            int tooltipX = mouseX + 12;
            if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
                needsWrap = true;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<String> wrappedTextLines = new ArrayList<String>();
                for (int i = 0; i < textLines.size(); ++i) {
                    String textLine = (String)textLines.get(i);
                    List wrappedLine = font.func_78271_c(textLine, tooltipTextWidth);
                    if (i == 0) {
                        titleLinesCount = wrappedLine.size();
                    }
                    for (String line : wrappedLine) {
                        int lineWidth = font.func_78256_a(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
            }
            int tooltipY = mouseY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > titleLinesCount) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY < 4) {
                tooltipY = 4;
            } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 4;
            }
            RenderHelper.drawColour(this.getTheme().windowBorder[0], this.getTheme().windowBorder[1], this.getTheme().windowBorder[2], 255, tooltipX - 3, tooltipY - 3, tooltipTextWidth + 6, tooltipHeight + 6, 300.0);
            RenderHelper.drawColour(this.getTheme().windowBackground[0], this.getTheme().windowBackground[1], this.getTheme().windowBackground[2], 255, tooltipX - 2, tooltipY - 2, tooltipTextWidth + 4, tooltipHeight + 4, 300.0);
            MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostBackground(stack, textLines, tooltipX, tooltipY, font, tooltipTextWidth, tooltipHeight));
            int tooltipTop = tooltipY;
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                String line = (String)textLines.get(lineNumber);
                font.func_175063_a(line, (float)tooltipX, (float)tooltipY, -1);
                if (lineNumber + 1 == titleLinesCount) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostText(stack, textLines, tooltipX, tooltipTop, font, tooltipTextWidth, tooltipHeight));
            RenderSystem.enableDepthTest();
        }
    }

    @Nullable
    public Fragment<?> getTopMostFragment(double mouseX, double mouseY) {
        Fragment<?> o = null;
        List<Window<?>> children = this.children();
        for (int i = children.size() - 1; i >= 0; --i) {
            Fragment<?> o1 = children.get(i).getTopMostFragment(mouseX, mouseY);
            if (o1 == null) continue;
            o = o1;
        }
        return o;
    }

    public void resize(Minecraft mc, int width, int height) {
        this.minecraft = mc;
        this.itemRenderer = mc.func_175599_af();
        this.font = mc.field_71466_p;
        this.width = width;
        this.height = height;
        this.setFocused(null);
        this.windows.forEach((Consumer<Window<?>>)((Consumer<Window>)window -> window.resize(mc, width, height)));
    }

    public void renderBackground() {
        if (this.renderMinecraftStyle) {
            super.renderBackground();
        } else {
            RenderSystem.matrixMode((int)5889);
            RenderSystem.loadIdentity();
            RenderSystem.ortho((double)0.0, (double)((double)this.minecraft.func_228018_at_().func_198109_k() / this.minecraft.func_228018_at_().func_198100_s()), (double)((double)this.minecraft.func_228018_at_().func_198091_l() / this.minecraft.func_228018_at_().func_198100_s()), (double)0.0, (double)-5000.0, (double)5000.0);
            RenderSystem.matrixMode((int)5888);
            RenderSystem.loadIdentity();
            RenderSystem.clearColor((float)((float)this.getTheme().workspaceBackground[0] / 255.0f), (float)((float)this.getTheme().workspaceBackground[1] / 255.0f), (float)((float)this.getTheme().workspaceBackground[2] / 255.0f), (float)255.0f);
            RenderSystem.clear((int)16640, (boolean)Minecraft.field_142025_a);
        }
        RenderSystem.pushMatrix();
    }

    public void resetBackground() {
        RenderSystem.popMatrix();
        if (!this.renderMinecraftStyle) {
            RenderSystem.matrixMode((int)5889);
            RenderSystem.loadIdentity();
            RenderSystem.ortho((double)0.0, (double)((double)this.minecraft.func_228018_at_().func_198109_k() / this.minecraft.func_228018_at_().func_198100_s()), (double)((double)this.minecraft.func_228018_at_().func_198091_l() / this.minecraft.func_228018_at_().func_198100_s()), (double)0.0, (double)1000.0, (double)3000.0);
            RenderSystem.matrixMode((int)5888);
            RenderSystem.loadIdentity();
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        }
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.font;
    }

    @Override
    public boolean renderMinecraftStyle() {
        return this.renderMinecraftStyle;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double distX, double distY) {
        return super.mouseDragged(mouseX, mouseY, button, distX, distY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.setDragging(false);
        return this.getFocused() != null && this.getFocused().mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean isObstructed(Window<?> window, double mouseX, double mouseY) {
        for (Window<?> window1 : this.children()) {
            if (!Fragment.isMouseBetween(mouseX, window1.getLeft(), window1.getLeft() + window1.width) || !Fragment.isMouseBetween(mouseY, window1.getTop(), window1.getTop() + window1.height)) continue;
            return window != window1;
        }
        return true;
    }

    public <T extends Window<?>> T getByWindowType(Class<T> clz) {
        List<Window<?>> windows = this.children();
        for (Window<?> window : windows) {
            if (!clz.isAssignableFrom(window.getClass())) continue;
            return (T)window;
        }
        return null;
    }

    @Override
    public boolean canDockWindows() {
        return true;
    }

    public WindowDock<? extends Workspace> getDock() {
        return (WindowDock)this.windows.get(this.windows.size() - 1);
    }

    @Override
    public IWindows.DockInfo getDockInfo(double mouseX, double mouseY, boolean dockStack) {
        if (this.canDockWindows()) {
            return this.getDock().getDockInfo(mouseX, mouseY, dockStack);
        }
        return null;
    }

    @Override
    public void addToDocked(Window<?> docked, Window<?> window) {
        if (this.canDockWindows() && this.getDock().addToDocked(docked, window)) {
            this.removeWindow(window);
        }
    }

    @Override
    public void addToDock(Window<?> window, Constraint.Property.Type type) {
        if (this.canDockWindows()) {
            this.getDock().addToDock(window, type);
            this.removeWindow(window);
        }
    }

    @Override
    public void removeFromDock(Window<?> window) {
        if (this.canDockWindows()) {
            this.getDock().removeFromDock(window);
            this.addWindow(window);
        }
    }

    @Override
    public boolean isDocked(Window<?> window) {
        if (this.canDockWindows()) {
            return this.getDock().isDocked(window);
        }
        return false;
    }

    @Override
    public boolean sameDockStack(IConstrainable window, IConstrainable window1) {
        if (this.canDockWindows()) {
            return this.getDock().sameDockStack(window, window1);
        }
        return false;
    }

    public void setFocused(@Nullable IGuiEventListener gui) {
        IGuiEventListener lastFocused = this.getFocused();
        if (lastFocused instanceof Fragment && gui != lastFocused) {
            ((Fragment)lastFocused).unfocus(gui);
        }
        if (gui instanceof Window) {
            this.bringToFront((Window)gui);
        }
        super.setFocused(gui);
    }

    @Override
    public int getLeft() {
        return 0;
    }

    @Override
    public int getRight() {
        return this.width;
    }

    @Override
    public int getTop() {
        return 0;
    }

    @Override
    public int getBottom() {
        return this.height;
    }

    public static void bindTexture(ResourceLocation rl) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(rl);
    }
}

