/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.IWindows;
import me.ichun.mods.ichunutil.client.gui.bns.window.Window;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrained;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.View;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementList;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementScrollBar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;

public class WindowContextMenu<M extends IWindows>
extends Window<M> {
    private final ElementList<?> list;
    private int minWidth = 1;
    private boolean killed;

    private WindowContextMenu(M parent) {
        super(parent);
        this.setBorderSize(() -> 1);
        this.setView(new ViewContextMenu(this, ""));
        this.list = (ElementList)((ViewContextMenu)this.currentView).elements.get(1);
        this.disableTitle();
        this.disableDocking();
        this.disableDockStacking();
        this.disableDrag();
        this.disableDragResize();
        this.disableUndocking();
    }

    public ElementList<?> getList() {
        return this.list;
    }

    public void setupAround(double posX, double posY, int minWidth, int yFlipHeight) {
        this.width = this.minWidth = minWidth;
        this.resize(Minecraft.func_71410_x(), this.parent.getWidth(), this.parent.getHeight());
        this.height = this.list.getTotalItemHeight() + (Integer)this.borderSize.get() * 2 + this.list.getBorderSize() * 2;
        int pX = (int)posX;
        int pY = (int)posY;
        int screenWidth = this.parent.getWidth();
        int screenHeight = this.parent.getHeight();
        int tooltipX = pX;
        if (tooltipX + minWidth > screenWidth) {
            tooltipX = pX - minWidth;
        }
        int tooltipY = pY;
        int tooltipHeight = this.height;
        if (tooltipY < 0) {
            tooltipY = 0;
        } else if (tooltipY + tooltipHeight > screenHeight) {
            if (tooltipHeight > pY - yFlipHeight) {
                this.height = tooltipHeight = Math.min(Math.max(pY - yFlipHeight, screenHeight - tooltipY) - 2, this.list.getTotalItemHeight() + (Integer)this.borderSize.get() * 2 + this.list.getBorderSize() * 2);
            }
            if (tooltipY + tooltipHeight > screenHeight && (tooltipY = pY - yFlipHeight - tooltipHeight) < 0) {
                tooltipY = screenHeight - tooltipHeight;
            }
        }
        this.constraint.apply();
        this.pos(tooltipX, tooltipY);
        this.resize(Minecraft.func_71410_x(), this.parent.getWidth(), this.parent.getHeight());
    }

    @Override
    public int getMinWidth() {
        return this.minWidth;
    }

    @Override
    public void unfocus(@Nullable IGuiEventListener guiReplacing) {
        super.unfocus(guiReplacing);
        if (!this.killed) {
            this.killed = true;
            this.parent.removeWindow(this);
        }
    }

    public static <M extends IWindows> WindowContextMenu<M> create(M parent, IContextMenu iContextMenu, double posX, double posY, int minWidth, int yFlipHeight) {
        WindowContextMenu<M> windowContextMenu = new WindowContextMenu<M>(parent);
        ElementList<?> list = windowContextMenu.getList();
        List<?> contextMenuObjects = iContextMenu.getObjects();
        Function<Object, String> nameProvider = iContextMenu.getNameProvider();
        BiConsumer<IContextMenu, ElementList.Item<?>> contextMenuReceiver = iContextMenu.getReceiver();
        contextMenuObjects.forEach(o -> list.addItem(o).addTextWrapper((String)nameProvider.apply(o)).setSelectionHandler(item -> {
            ((Workspace)item.getWorkspace()).setFocused(null);
            contextMenuReceiver.accept(iContextMenu, (ElementList.Item<?>)item);
        }));
        if (windowContextMenu.getWorkspace().hasInit()) {
            windowContextMenu.init();
        }
        windowContextMenu.setupAround(posX, posY, minWidth, yFlipHeight);
        windowContextMenu.getWorkspace().addWindow(windowContextMenu);
        windowContextMenu.getWorkspace().setFocused((IGuiEventListener)windowContextMenu);
        return windowContextMenu;
    }

    public static interface IContextMenu {
        @Nonnull
        public List<?> getObjects();

        @Nonnull
        public BiConsumer<IContextMenu, ElementList.Item<?>> getReceiver();

        @Nonnull
        default public Function<Object, String> getNameProvider() {
            return Object::toString;
        }
    }

    private class ViewContextMenu
    extends View<WindowContextMenu<M>> {
        public ViewContextMenu(@Nonnull WindowContextMenu<M> parent, String s) {
            super(parent, s);
            ElementScrollBar sv = new ElementScrollBar(this, ElementScrollBar.Orientation.VERTICAL, 0.6f);
            sv.setConstraint(new Constraint(sv).top(this, Constraint.Property.Type.TOP, 0).bottom(this, Constraint.Property.Type.BOTTOM, 0).right(this, Constraint.Property.Type.RIGHT, 0));
            this.elements.add(sv);
            Object list = new ElementList<ViewContextMenu>(this).setScrollVertical(sv);
            ((Fragment)list).setConstraint(new Constraint((IConstrained)list).left(this, Constraint.Property.Type.LEFT, 0).bottom(this, Constraint.Property.Type.BOTTOM, 0).top(this, Constraint.Property.Type.TOP, 0).right(sv, Constraint.Property.Type.LEFT, 0));
            this.elements.add(list);
        }
    }
}

