/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.IWindows;
import me.ichun.mods.ichunutil.client.gui.bns.window.Window;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrainable;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.client.Minecraft;

public class WindowDock<M extends IWindows>
extends Window<M> {
    public LinkedHashMap<ArrayListHolder, Constraint.Property.Type> docked = new LinkedHashMap();
    public HashMap<Window<?>, WindowSize> dockedOriSize = new HashMap();
    public HashSet<Constraint.Property.Type> disabledDocks = new HashSet();

    public WindowDock(M parent) {
        super(parent);
        this.size(parent.getWidth(), parent.getHeight());
        if (parent instanceof IConstrainable) {
            this.setConstraint(Constraint.matchParent(this, (IConstrainable)parent, 0));
        }
        this.borderSize = () -> iChunUtil.configClient.guiDockPadding;
        this.titleSize = () -> 0;
    }

    @Override
    public boolean canShowTitle() {
        return false;
    }

    @Override
    public boolean hasTitle() {
        return false;
    }

    @Override
    public boolean canDrag() {
        return false;
    }

    @Override
    public boolean canDragResize() {
        return false;
    }

    @Override
    public boolean canBringToFront() {
        return false;
    }

    @Override
    public boolean canBeDocked() {
        return false;
    }

    @Override
    public boolean canBeUndocked() {
        return false;
    }

    @Override
    public void init() {
        this.constraint.apply();
        this.docked.keySet().forEach(h -> h.windows.forEach((Consumer<Window<?>>)((Consumer<Window>)window -> {
            window.constraint.apply();
            window.resize(Minecraft.func_71410_x(), this.width, this.height);
            window.init();
        })));
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        ArrayList<ArrayListHolder> keys = new ArrayList<ArrayListHolder>(this.docked.keySet());
        for (int i = keys.size() - 1; i >= 0; --i) {
            ArrayList<Window<?>> windows = ((ArrayListHolder)keys.get((int)i)).windows;
            windows.forEach((Consumer<Window<?>>)((Consumer<Window>)window -> window.render(mouseX, mouseY, partialTick)));
        }
    }

    @Override
    public void resize(Minecraft mc, int width, int height) {
        this.constraint.apply();
        this.docked.keySet().forEach(h -> h.windows.forEach((Consumer<Window<?>>)((Consumer<Window>)window -> {
            window.constraint.apply();
            window.resize(Minecraft.func_71410_x(), this.width, this.height);
        })));
    }

    @Override
    public void tick() {
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return false;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double distX, double distY) {
        return false;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        Window<?> windowOver = this.getWindowOver(mouseX, mouseY);
        if (windowOver != null) {
            return windowOver.mouseScrolled(mouseX, mouseY, amount);
        }
        return false;
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return !this.parent.isObstructed(this, mouseX, mouseY) && WindowDock.isMouseBetween(mouseX, this.getLeft(), this.getLeft() + this.width) && WindowDock.isMouseBetween(mouseY, this.getTop(), this.getTop() + this.height);
    }

    @Override
    @Nullable
    public Fragment<?> getTopMostFragment(double mouseX, double mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            Fragment fragment = this;
            for (ArrayListHolder h : this.docked.keySet()) {
                for (Window<?> window : h.windows) {
                    Fragment<?> fragment1 = window.getTopMostFragment(mouseX, mouseY);
                    if (fragment1 == null) continue;
                    fragment = fragment1;
                }
            }
            return fragment;
        }
        return null;
    }

    public boolean isDocked(Window<?> window) {
        for (ArrayListHolder h : this.docked.keySet()) {
            if (!h.windows.contains(window)) continue;
            return true;
        }
        return false;
    }

    public boolean sameDockStack(IConstrainable window, IConstrainable window1) {
        for (ArrayListHolder h : this.docked.keySet()) {
            if (!h.windows.contains(window)) continue;
            return h.windows.contains(window1);
        }
        return false;
    }

    public void disableDock(Constraint.Property.Type type) {
        this.disabledDocks.add(type);
    }

    @Nullable
    public IWindows.DockInfo getDockInfo(double mouseX, double mouseY, boolean dockStack) {
        Window<?> window;
        if (dockStack && (window = this.getWindowOver(mouseX, mouseY)) != null && window.canDockStack()) {
            return new IWindows.DockInfo(window, this.getAnchorType(window));
        }
        double left = 0.0;
        double top = 0.0;
        double right = this.width;
        double bottom = this.height;
        for (Map.Entry<ArrayListHolder, Constraint.Property.Type> e : this.docked.entrySet()) {
            for (Window<?> key : e.getKey().windows) {
                Constraint.Property.Type value = e.getValue();
                switch (value) {
                    case LEFT: {
                        if (!((double)key.getRight() > left)) break;
                        left = key.getRight();
                        break;
                    }
                    case TOP: {
                        if (!((double)key.getBottom() > top)) break;
                        top = key.getBottom();
                        break;
                    }
                    case RIGHT: {
                        if (!((double)key.getLeft() < right)) break;
                        right = key.getLeft();
                        break;
                    }
                    case BOTTOM: {
                        if (!((double)key.getTop() < bottom)) break;
                        bottom = key.getTop();
                    }
                }
            }
        }
        int dockSnap = iChunUtil.configClient.guiDockBorder;
        if (mouseY >= top && mouseY < bottom) {
            if (mouseX >= left && mouseX < left + (double)dockSnap && !this.disabledDocks.contains((Object)Constraint.Property.Type.LEFT)) {
                return new IWindows.DockInfo(null, Constraint.Property.Type.LEFT);
            }
            if (mouseX >= right - (double)dockSnap && mouseX < right && !this.disabledDocks.contains((Object)Constraint.Property.Type.RIGHT)) {
                return new IWindows.DockInfo(null, Constraint.Property.Type.RIGHT);
            }
        }
        if (mouseX >= left && mouseX < right) {
            if (mouseY >= top && mouseY < top + (double)dockSnap && !this.disabledDocks.contains((Object)Constraint.Property.Type.TOP)) {
                return new IWindows.DockInfo(null, Constraint.Property.Type.TOP);
            }
            if (mouseY >= bottom - (double)dockSnap && bottom < right && !this.disabledDocks.contains((Object)Constraint.Property.Type.BOTTOM)) {
                return new IWindows.DockInfo(null, Constraint.Property.Type.BOTTOM);
            }
        }
        return null;
    }

    public boolean addToDocked(Window<?> dockedWin, Window<?> window) {
        for (Map.Entry<ArrayListHolder, Constraint.Property.Type> e : this.docked.entrySet()) {
            if (!e.getKey().windows.contains(dockedWin)) continue;
            this.dockedOriSize.put(window, new WindowSize(window.constraint, window.getLeft(), window.getTop(), window.getWidth(), window.getHeight()));
            Constraint.Property.Type dockType = e.getValue();
            ArrayList<Window<?>> dockStack = e.getKey().windows;
            Window<?> lastInStack = dockStack.get(dockStack.size() - 1);
            int maxWidth = -1;
            int maxHeight = -1;
            if (dockType.getAxis().func_176722_c()) {
                maxWidth = window.width;
                for (Window<?> window1 : dockStack) {
                    if (window1.width <= maxWidth) continue;
                    maxWidth = window1.width;
                }
            } else if (dockType.getAxis().func_200128_b()) {
                maxHeight = window.height;
                for (Window<?> window1 : dockStack) {
                    if (window1.height <= maxHeight) continue;
                    maxHeight = window1.height;
                }
            }
            Constraint constraint = new Constraint(window);
            Constraint.Property.Type[] values = Constraint.Property.Type.values();
            for (int i = values.length - 1; i >= 0; --i) {
                Constraint.Property.Type type1 = values[i];
                Window<?> constrainable = this.getWindowAnchor(lastInStack, type1);
                if (dockType.getAxis().func_176722_c() && type1 == Constraint.Property.Type.TOP || dockType.getAxis().func_200128_b() && type1 == Constraint.Property.Type.LEFT) {
                    constrainable = lastInStack;
                    lastInStack.constraint.type(type1.getOpposite(), null, null, 0);
                    if (type1 == Constraint.Property.Type.TOP) {
                        lastInStack.setHeight(this.dockedOriSize.get(lastInStack).height);
                    } else {
                        lastInStack.setWidth(this.dockedOriSize.get(lastInStack).width);
                    }
                }
                if (type1 == dockType.getOpposite()) continue;
                constraint = constrainable != null && !(constrainable instanceof WindowDock) ? constraint.type(type1, constrainable, type1.getOpposite(), -window.borderSize.get().intValue() + (Integer)this.borderSize.get()) : constraint.type(type1, this, type1, -window.borderSize.get().intValue() + (Integer)this.borderSize.get());
            }
            e.getKey().windows.add(window);
            window.setConstraint(constraint);
            for (Window<?> window1 : dockStack) {
                if (maxWidth >= 0) {
                    window1.setWidth(maxWidth);
                } else if (maxHeight >= 0) {
                    window1.setHeight(maxHeight);
                }
                window1.constraint.apply();
                if (!this.getWorkspace().hasInit()) continue;
                window1.resize(Minecraft.func_71410_x(), this.width, this.height);
            }
            return true;
        }
        return false;
    }

    public void addToDock(Window<?> window, Constraint.Property.Type type) {
        this.dockedOriSize.put(window, new WindowSize(window.constraint, window.getLeft(), window.getTop(), window.getWidth(), window.getHeight()));
        Constraint constraint = new Constraint(window);
        for (Constraint.Property.Type type1 : Constraint.Property.Type.values()) {
            IConstrainable constrainable = this.getAnchor(type1);
            if (type1 == type.getOpposite()) continue;
            constraint = constrainable != null ? constraint.type(type1, constrainable, type1.getOpposite(), -window.borderSize.get().intValue() + (Integer)this.borderSize.get()) : constraint.type(type1, this, type1, -window.borderSize.get().intValue() + (Integer)this.borderSize.get());
        }
        ArrayList windows = new ArrayList();
        windows.add(window);
        this.docked.put(new ArrayListHolder(windows), type);
        window.setConstraint(constraint);
        window.constraint.apply();
        if (this.getWorkspace().hasInit()) {
            window.resize(Minecraft.func_71410_x(), this.width, this.height);
        }
    }

    public void removeFromDock(Window<?> window) {
        boolean redoConstraints = false;
        Iterator<Map.Entry<ArrayListHolder, Constraint.Property.Type>> iterator = this.docked.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ArrayListHolder, Constraint.Property.Type> e = iterator.next();
            ArrayList<Window<?>> windows = e.getKey().windows;
            EnumMap<Constraint.Property.Type, Constraint.Property> anchors = new EnumMap<Constraint.Property.Type, Constraint.Property>(Constraint.Property.Type.class);
            if (redoConstraints || windows.contains(window)) {
                for (Constraint.Property.Type type2 : Constraint.Property.Type.values()) {
                    Constraint.Property stackAnchor = this.getStackAnchor(windows, type2);
                    if (stackAnchor == null) continue;
                    anchors.put(type2, stackAnchor);
                }
            }
            if (windows.contains(window)) {
                redoConstraints = true;
                if (windows.size() == 1) {
                    iterator.remove();
                    continue;
                }
                windows.remove(window);
            }
            if (!redoConstraints) continue;
            Constraint.Property.Type dockType = e.getValue();
            for (int i = 0; i < windows.size(); ++i) {
                Window<?> dockWindow = windows.get(i);
                if (i == 0) {
                    Constraint constraint = new Constraint(dockWindow);
                    anchors.forEach((type, property) -> {
                        if (property.getReference() == window) {
                            IConstrainable constrainable = this.getAnchor((Constraint.Property.Type)((Object)type), dockWindow);
                            if (constrainable != null && constrainable != dockWindow) {
                                constraint.type((Constraint.Property.Type)((Object)type), constrainable, type.getOpposite(), -dockWindow.borderSize.get().intValue() + (Integer)this.borderSize.get());
                            } else {
                                constraint.type((Constraint.Property.Type)((Object)type), this, (Constraint.Property.Type)((Object)type), -dockWindow.borderSize.get().intValue() + (Integer)this.borderSize.get());
                            }
                        } else {
                            constraint.type((Constraint.Property.Type)((Object)type), property.getReference(), property.getType(), property.getDist());
                        }
                    });
                    dockWindow.setConstraint(constraint);
                    continue;
                }
                Window<?> lastInStack = windows.get(i - 1);
                Constraint constraint = new Constraint(dockWindow);
                Constraint.Property.Type[] values = Constraint.Property.Type.values();
                for (int ii = values.length - 1; ii >= 0; --ii) {
                    Constraint.Property.Type type1 = values[ii];
                    Window<?> constrainable = this.getWindowAnchor(lastInStack, type1);
                    if (dockType.getAxis().func_176722_c() && type1 == Constraint.Property.Type.TOP || dockType.getAxis().func_200128_b() && type1 == Constraint.Property.Type.LEFT) {
                        constrainable = lastInStack;
                        lastInStack.constraint.type(type1.getOpposite(), null, null, 0);
                        if (type1 == Constraint.Property.Type.TOP) {
                            lastInStack.setHeight(this.dockedOriSize.get(lastInStack).height);
                        } else {
                            lastInStack.setWidth(this.dockedOriSize.get(lastInStack).width);
                        }
                    }
                    if (type1 == dockType.getOpposite()) continue;
                    constraint = constrainable != null && !(constrainable instanceof WindowDock) ? constraint.type(type1, constrainable, type1.getOpposite(), -dockWindow.borderSize.get().intValue() + (Integer)this.borderSize.get()) : constraint.type(type1, this, type1, -dockWindow.borderSize.get().intValue() + (Integer)this.borderSize.get());
                }
                dockWindow.setConstraint(constraint);
            }
            for (Window<?> window1 : windows) {
                window1.constraint.apply();
                if (!this.getWorkspace().hasInit()) continue;
                window1.resize(Minecraft.func_71410_x(), this.width, this.height);
            }
        }
        WindowSize size = this.dockedOriSize.get(window);
        window.setConstraint(size.constraint);
        if (size.x != 0 || size.y != 0) {
            window.setLeft(size.x);
            window.setTop(size.y);
        }
        window.setWidth(size.width);
        window.setHeight(size.height);
        window.resize(Minecraft.func_71410_x(), window.parent.getWidth(), window.parent.getHeight());
        this.dockedOriSize.remove(window);
    }

    @Nullable
    public IConstrainable getAnchor(Constraint.Property.Type type) {
        return this.getAnchor(type, null);
    }

    @Nullable
    public IConstrainable getAnchor(Constraint.Property.Type type, IConstrainable ignored) {
        IConstrainable typeMost = null;
        for (Map.Entry<ArrayListHolder, Constraint.Property.Type> e : this.docked.entrySet()) {
            if (e.getValue() != type || ignored != null && e.getKey().windows.contains(ignored)) continue;
            typeMost = e.getKey().windows.get(0);
        }
        return typeMost;
    }

    @Nullable
    public IConstrainable getWindowAnchor(Window<?> window, Constraint.Property.Type type) {
        return window.constraint.get(type).getReference();
    }

    @Nullable
    public Constraint.Property getStackAnchor(ArrayList<Window<?>> stack, Constraint.Property.Type type) {
        for (Window<?> window : stack) {
            Constraint.Property anchor = window.constraint.get(type);
            if (anchor == Constraint.Property.NONE || stack.contains(anchor.getReference())) continue;
            return anchor;
        }
        return null;
    }

    public Constraint.Property.Type getAnchorType(Window<?> window) {
        for (Map.Entry<ArrayListHolder, Constraint.Property.Type> e : this.docked.entrySet()) {
            if (!e.getKey().windows.contains(window)) continue;
            return e.getValue();
        }
        return null;
    }

    public Window<?> getWindowOver(double mouseX, double mouseY) {
        for (ArrayListHolder h : this.docked.keySet()) {
            for (Window<?> window : h.windows) {
                if (!window.isMouseOver(mouseX, mouseY)) continue;
                return window;
            }
        }
        return null;
    }

    @Nonnull
    public ArrayList<Window<?>> getDockStack(Window<?> window) {
        for (ArrayListHolder h : this.docked.keySet()) {
            if (!h.windows.contains(window)) continue;
            return h.windows;
        }
        return new ArrayList();
    }

    public <M extends IWindows> void edgeGrab(Window<M> draggedWindow, double mouseX, double mouseY, Window.EdgeGrab edgeGrab) {
        Constraint.Property.Type anchorType = this.getAnchorType(draggedWindow);
        if (anchorType != null && (anchorType.getAxis().func_176722_c() && edgeGrab.left && draggedWindow.constraint.get(Constraint.Property.Type.LEFT) == Constraint.Property.NONE || anchorType.getAxis().func_176722_c() && edgeGrab.right && draggedWindow.constraint.get(Constraint.Property.Type.RIGHT) == Constraint.Property.NONE || anchorType.getAxis().func_200128_b() && edgeGrab.top && draggedWindow.constraint.get(Constraint.Property.Type.TOP) == Constraint.Property.NONE || anchorType.getAxis().func_200128_b() && edgeGrab.bottom && draggedWindow.constraint.get(Constraint.Property.Type.BOTTOM) == Constraint.Property.NONE)) {
            ArrayList<Window<M>> dockStack = this.getDockStack(draggedWindow);
            for (int i = 0; i < dockStack.size(); ++i) {
                Window<M> window = dockStack.get(i);
                if (window == draggedWindow) continue;
                window.dragResize(mouseX, mouseY, edgeGrab);
            }
        }
        this.getWorkspace().getDock().init();
    }

    public static class ArrayListHolder {
        public final ArrayList<Window<?>> windows;

        public ArrayListHolder(ArrayList<Window<?>> windows) {
            this.windows = windows;
        }
    }

    public static class WindowSize {
        public final Constraint constraint;
        public final int x;
        public final int y;
        public final int width;
        public final int height;

        public WindowSize(Constraint constraint, int x, int y, int width, int height) {
            this.constraint = constraint;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
    }
}

