/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.view.element;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import net.minecraft.client.Minecraft;

public abstract class Element<P extends Fragment>
extends Fragment<P> {
    public static final List<Element<?>> INFERTILE = Collections.emptyList();
    public String tooltip;

    public Element(@Nonnull P parent) {
        super(parent);
    }

    public <T extends Element<?>> T setPos(int x, int y) {
        this.posX = x;
        this.posY = y;
        return (T)this;
    }

    public <T extends Element<?>> T setSize(int width, int height) {
        this.width = width;
        this.height = height;
        return (T)this;
    }

    public <T extends Element<?>> T setTooltip(String s) {
        this.tooltip = s;
        return (T)this;
    }

    @Override
    @Nullable
    public String tooltip(double mouseX, double mouseY) {
        return this.tooltip;
    }

    @Override
    public void init() {
        this.constraint.apply();
    }

    @Override
    public List<? extends Fragment<?>> children() {
        return INFERTILE;
    }

    public void render(int mouseX, int mouseY, float partialTick) {
    }

    @Override
    public void resize(Minecraft mc, int width, int height) {
        this.constraint.apply();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.isMouseOver(mouseX, mouseY);
    }

    public boolean defaultMouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean changeFocus(boolean direction) {
        return this.parentFragment.getFocused() != this;
    }

    public static void renderMinecraftStyleButton(int posX, int posY, int width, int height, ButtonState state) {
        int yOffset;
        Fragment.bindTexture(Fragment.VANILLA_WIDGETS);
        int n = state == ButtonState.CLICK ? 0 : (yOffset = state == ButtonState.HOVER ? 2 : 1);
        if (height == 20 && width > 15) {
            int i = width - 28;
            int x = posX + 14;
            while (i > 0) {
                int dist = Math.min(i, 172);
                RenderHelper.draw(x, posY, dist, 20.0, 0.0, 0.0546875, (double)(14 + dist) / 256.0, (double)(46 + yOffset * 20) / 256.0, (double)(66 + yOffset * 20) / 256.0);
                i -= dist;
                x += dist;
            }
            RenderHelper.draw(posX, posY, 14.0, 20.0, 0.0, 0.0, 0.0546875, (double)(46 + yOffset * 20) / 256.0, (double)(66 + yOffset * 20) / 256.0);
            RenderHelper.draw(posX + width - 14, posY, 14.0, 20.0, 0.0, 0.7265625, 0.78125, (double)(46 + yOffset * 20) / 256.0, (double)(66 + yOffset * 20) / 256.0);
        } else if (height < 20 && width < 200) {
            RenderHelper.draw(posX, posY + height - (height - 3), width - 3, height - 3, 0.0, 0.0, (double)(width - 3) / 256.0, (double)(66 - (height - 3) + yOffset * 20) / 256.0, (double)(66 + yOffset * 20) / 256.0);
            RenderHelper.draw(posX, posY, width - 3, height - 3, 0.0, 0.0, (double)(width - 3) / 256.0, (double)(46 + yOffset * 20) / 256.0, (double)(46 + (height - 3) + yOffset * 20) / 256.0);
            RenderHelper.draw(posX + width - (width - 3), posY, width - 3, height - 3, 0.0, (200.0 - (double)(width - 3)) / 256.0, 0.78125, (double)(46 + yOffset * 20) / 256.0, (double)(46 + (height - 3) + yOffset * 20) / 256.0);
            RenderHelper.draw(posX + width - (width - 3), posY + height - (height - 3), width - 3, height - 3, 0.0, (double)(200 - (width - 3)) / 256.0, 0.78125, (double)(66 - (height - 3) + yOffset * 20) / 256.0, (double)(66 + yOffset * 20) / 256.0);
        } else {
            Element.cropAndStitch(posX, posY, width, height, 4, 0.0, 46 + yOffset * 20, 200, 20, 256.0, 256.0);
        }
    }

    public static void cropAndStitch(int posX, int posY, int width, int height, int borderSize, double u, double v, int uLength, int vLength, double texWidth, double texHeight) {
        int dist;
        int ii = width - borderSize * 2;
        int xx = posX + borderSize;
        while (ii > 0) {
            int jj = height - borderSize * 2;
            int yy = posY + borderSize;
            int distx = Math.min(ii, uLength - borderSize * 2);
            while (jj > 0) {
                int disty = Math.min(jj, vLength - borderSize * 2);
                RenderHelper.draw(xx, yy, distx, disty, 0.0, (u + (double)borderSize) / texWidth, (u + (double)borderSize + (double)distx) / texWidth, (v + (double)borderSize) / texWidth, (v + (double)borderSize + (double)disty) / texWidth);
                jj -= disty;
                yy += disty;
            }
            ii -= distx;
            xx += distx;
        }
        int i = width - borderSize * 2;
        int x = posX + borderSize;
        while (i > 0) {
            dist = Math.min(i, uLength - borderSize * 2);
            RenderHelper.draw(x, posY, dist, borderSize, 0.0, (u + (double)borderSize) / texWidth, (u + (double)borderSize + (double)dist) / texWidth, v / texHeight, (v + (double)borderSize) / texHeight);
            RenderHelper.draw(x, posY + height - borderSize, dist, borderSize, 0.0, (u + (double)borderSize) / texWidth, (u + (double)borderSize + (double)dist) / texWidth, (v + (double)vLength - (double)borderSize) / texHeight, (v + (double)vLength) / texHeight);
            i -= dist;
            x += dist;
        }
        i = height - borderSize * 2;
        x = posY + borderSize;
        while (i > 0) {
            dist = Math.min(i, vLength - borderSize * 2);
            RenderHelper.draw(posX, x, borderSize, dist, 0.0, u / texWidth, (u + (double)borderSize) / texWidth, (v + (double)borderSize) / texWidth, (v + (double)borderSize + (double)dist) / texWidth);
            RenderHelper.draw(posX + width - borderSize, x, borderSize, dist, 0.0, (u + (double)uLength - (double)borderSize) / texWidth, (u + (double)uLength) / texWidth, (v + (double)borderSize) / texWidth, (v + (double)borderSize + (double)dist) / texWidth);
            i -= dist;
            x += dist;
        }
        RenderHelper.draw(posX, posY + height - borderSize, borderSize, borderSize, 0.0, u / texWidth, (u + (double)borderSize) / texWidth, (v + (double)vLength - (double)borderSize) / texHeight, (v + (double)vLength) / texHeight);
        RenderHelper.draw(posX, posY, borderSize, borderSize, 0.0, u / texWidth, (u + (double)borderSize) / texWidth, v / texHeight, (v + (double)borderSize) / texHeight);
        RenderHelper.draw(posX + width - borderSize, posY, borderSize, borderSize, 0.0, (u + (double)uLength - (double)borderSize) / texWidth, (u + (double)uLength) / texWidth, v / texHeight, (v + (double)borderSize) / texHeight);
        RenderHelper.draw(posX + width - borderSize, posY + height - borderSize, borderSize, borderSize, 0.0, (u + (double)uLength - (double)borderSize) / texWidth, (u + (double)uLength) / texWidth, (v + (double)vLength - (double)borderSize) / texHeight, (v + (double)vLength) / texHeight);
    }

    public static class MousePos {
        int x;
        int y;

        public MousePos(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }

    public static enum ButtonState {
        IDLE,
        HOVER,
        CLICK;

    }
}

