/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.view.element;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementClickable;
import net.minecraft.client.resources.I18n;

public class ElementButton<T extends ElementButton>
extends ElementClickable<T> {
    @Nonnull
    public String text;
    public boolean renderBackground = true;

    public ElementButton(@Nonnull Fragment parent, String s, Consumer<T> callback) {
        super(parent, callback);
        this.text = I18n.func_135052_a((String)s, (Object[])new Object[0]);
    }

    public ElementButton<T> disableBackground() {
        this.renderBackground = false;
        return this;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        super.render(mouseX, mouseY, partialTick);
        if (this.renderBackground) {
            if (this.renderMinecraftStyle()) {
                ElementButton.renderMinecraftStyleButton(this.getLeft(), this.getTop(), this.width, this.height, this.parentFragment.isDragging() && this.parentFragment.getFocused() == this ? Element.ButtonState.CLICK : (this.hover ? Element.ButtonState.HOVER : Element.ButtonState.IDLE));
            } else {
                this.fill(this.getTheme().elementButtonBorder, 0);
                int[] colour = this.parentFragment.isDragging() && this.parentFragment.getFocused() == this ? this.getTheme().elementButtonClick : (this.hover ? this.getTheme().elementButtonBackgroundHover : this.getTheme().elementButtonBackgroundInactive);
                this.fill(colour, 1);
            }
        }
        this.renderText();
    }

    public void renderText() {
        if (!this.text.isEmpty()) {
            String s = this.reString(this.text, this.width - 4);
            float f = (float)this.getLeft() + (float)(this.width - this.getFontRenderer().func_78256_a(s)) / 2.0f;
            float f2 = this.getTop();
            this.getFontRenderer().getClass();
            this.drawString(s, f, f2 + (float)(this.height - 9) / 2.0f + 1.0f);
        }
    }

    @Override
    @Nullable
    public String tooltip(double mouseX, double mouseY) {
        String s;
        if (!this.text.isEmpty() && !(s = this.reString(this.text, this.width - 4)).equals(this.text)) {
            String tooltip = super.tooltip(mouseX, mouseY);
            if (tooltip != null) {
                return this.text + " - " + tooltip;
            }
            return this.text;
        }
        return super.tooltip(mouseX, mouseY);
    }

    @Override
    public void onClickRelease() {
    }

    @Override
    public int getMinWidth() {
        return 14;
    }

    @Override
    public int getMinHeight() {
        return 14;
    }
}

