/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.view.element;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;

public abstract class ElementClickable<T extends ElementClickable>
extends Element {
    @Nonnull
    public Consumer<T> callback;
    public boolean hover;

    public ElementClickable(@Nonnull Fragment parent, Consumer<T> callback) {
        super(parent);
        this.callback = callback;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        this.hover = this.isMouseOver(mouseX, mouseY) || this.parentFragment.getFocused() == this;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        boolean flag = super.mouseReleased(mouseX, mouseY, button);
        this.parentFragment.setFocused(null);
        if (this.isMouseOver(mouseX, mouseY) && button == 0) {
            this.trigger();
        }
        return flag;
    }

    public void trigger() {
        if (this.renderMinecraftStyle()) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
        this.onClickRelease();
        this.callback.accept(this);
    }

    public abstract void onClickRelease();

    public boolean keyPressed(int key, int scancode, int listener) {
        if (key == 32 || key == 257 || key == 335) {
            this.trigger();
            return true;
        }
        return false;
    }

    @Override
    public int getMinecraftFontColour() {
        return this.parentFragment.isDragging() && this.parentFragment.getFocused() == this ? 0xA0A0A0 : (this.hover ? 0xFFFFA0 : 0xE0E0E0);
    }
}

