/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.view.element;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Locale;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementTextField;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;

public class ElementNumberInput
extends ElementTextField {
    public static final int BUTTON_WIDTH = 10;
    public boolean isDouble;
    public Predicate<String> min = s -> true;
    public Predicate<String> max = s -> true;
    public Predicate<String> maxDec = s -> true;
    public int decimals;
    public Predicate<String> finalValidator = s -> true;
    public boolean clickUp;
    public boolean clickDown;

    public ElementNumberInput(@Nonnull Fragment parent, boolean isDouble) {
        super(parent);
        this.isDouble = isDouble;
    }

    public <T extends ElementNumberInput> T setMin(double d) {
        this.min = s -> {
            if (s.isEmpty() || s.equals("-")) {
                return true;
            }
            try {
                double d1 = Double.parseDouble(s);
                return d1 >= d;
            }
            catch (NumberFormatException e) {
                return false;
            }
        };
        return (T)this;
    }

    public <T extends ElementNumberInput> T setMax(double d) {
        this.max = s -> {
            if (s.isEmpty() || s.equals("-")) {
                return true;
            }
            try {
                double d1 = Double.parseDouble(s);
                return d1 <= d;
            }
            catch (NumberFormatException e) {
                return false;
            }
        };
        return (T)this;
    }

    public <T extends ElementNumberInput> T setMaxDec(int i) {
        this.decimals = Math.max(0, i);
        if (i >= 0) {
            this.maxDec = s -> {
                int dot = s.indexOf(".");
                return dot == -1 || dot + 1 + i >= s.length();
            };
        }
        return (T)this;
    }

    @Override
    public void init() {
        super.init();
        this.finalValidator = (this.isDouble ? NUMBERS : INTEGERS).and(this.min).and(this.max).and(this.maxDec);
        this.widget.func_200675_a(this.finalValidator);
    }

    @Override
    public void drawTextBox(int mouseX, int mouseY, float partialTick) {
        if (this.renderMinecraftStyle()) {
            this.widget.func_146185_a(true);
            this.widget.render(mouseX, mouseY, partialTick);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableAlphaTest();
            ElementNumberInput.renderMinecraftStyleButton(this.getRight() - 10, this.getTop(), 10, (int)((double)this.height / 2.0), this.clickUp ? Element.ButtonState.CLICK : (ElementNumberInput.isMouseBetween(mouseX, this.getRight() - 10, this.getRight()) && ElementNumberInput.isMouseBetween(mouseY, this.getTop(), (double)this.getTop() + (double)this.height / 2.0) ? Element.ButtonState.HOVER : Element.ButtonState.IDLE));
            ElementNumberInput.renderMinecraftStyleButton(this.getRight() - 10, this.getTop() + (int)((double)this.height / 2.0), 10, (int)((double)this.height / 2.0), this.clickDown ? Element.ButtonState.CLICK : (ElementNumberInput.isMouseBetween(mouseX, this.getRight() - 10, this.getRight()) && ElementNumberInput.isMouseBetween(mouseY, (double)this.getTop() + (double)this.height / 2.0, this.getBottom()) ? Element.ButtonState.HOVER : Element.ButtonState.IDLE));
            int size = 4;
            ElementNumberInput.bindTexture(Fragment.VANILLA_STATS_ICON);
            RenderHelper.draw(this.getRight() - size - 3, (double)this.getTop() + (double)this.height / 2.0 / 2.0 - (double)size / 2.0, size, size, 0.0, 0.3125, 0.3984375, 0.0234375, 0.109375);
            RenderHelper.draw(this.getRight() - size - 3, (double)this.getTop() + ((double)this.height - 0.5) / 2.0 / 2.0 * 3.0 - (double)size / 2.0, size, size, 0.0, 0.171875, 0.2578125, 0.0234375, 0.109375);
        } else {
            int[] colour = ElementNumberInput.isMouseBetween(mouseX, this.getLeft(), this.getLeft() + this.width - 10) && ElementNumberInput.isMouseBetween(mouseY, this.getTop(), this.getTop() + this.height) ? this.getTheme().elementInputBackgroundHover : this.getTheme().elementInputBackgroundInactive;
            this.fill(this.getTheme().elementInputBorder, 0);
            this.fill(colour, 1);
            this.widget.func_146185_a(false);
            this.widget.render(mouseX, mouseY, partialTick);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            colour = this.clickUp ? this.getTheme().elementInputUpDownClick : (ElementNumberInput.isMouseBetween(mouseX, this.getRight() - 10, this.getRight()) && ElementNumberInput.isMouseBetween(mouseY, this.getTop(), (double)this.getTop() + (double)this.height / 2.0) ? this.getTheme().elementInputUpDownHover : this.getTheme().elementInputBorder);
            RenderHelper.drawColour(colour[0], colour[1], colour[2], 255, this.getRight() - 10, this.getTop(), 10.0, (double)this.height / 2.0, 0.0);
            colour = this.clickDown ? this.getTheme().elementInputUpDownClick : (ElementNumberInput.isMouseBetween(mouseX, this.getRight() - 10, this.getRight()) && ElementNumberInput.isMouseBetween(mouseY, (double)this.getTop() + (double)this.height / 2.0, this.getBottom()) ? this.getTheme().elementInputUpDownHover : this.getTheme().elementInputBorder);
            RenderHelper.drawColour(colour[0], colour[1], colour[2], 255, this.getRight() - 10, (double)this.getTop() + (double)this.height / 2.0, 10.0, (double)this.height / 2.0, 0.0);
            RenderSystem.pushMatrix();
            float scale = 0.5f;
            RenderSystem.scalef((float)scale, (float)scale, (float)scale);
            float f = (float)(this.getRight() - 10 + 4) / scale;
            float f2 = (float)this.getTop() + 2.5f;
            double d = (double)this.height / 2.0 / 2.0;
            this.getFontRenderer().getClass();
            this.drawString("\u25b2", f, (f2 + (float)(d - 9.0 / 2.0)) / scale);
            float f3 = (float)(this.getRight() - 10 + 4) / scale;
            float f4 = (float)this.getTop() + 2.5f;
            double d2 = ((double)this.height - 0.5) / 2.0 / 2.0 * 3.0;
            this.getFontRenderer().getClass();
            this.drawString("\u25bc", f3, (f4 + (float)(d2 - 9.0 / 2.0)) / scale);
            RenderSystem.popMatrix();
        }
    }

    @Override
    public void adjustWidget() {
        if (this.widget != null) {
            if (this.renderMinecraftStyle()) {
                this.widget.x = this.getLeft() + 1;
                this.widget.y = this.getTop() + 1;
                this.widget.setWidth(this.width - 2 - 10);
                this.widget.setHeight(this.height - 2);
            } else {
                this.widget.x = this.getLeft() + 5;
                int n = this.getTop() + 1;
                this.getFontRenderer().getClass();
                this.widget.y = n + (this.height - 9) / 2;
                this.widget.setWidth(this.width - 6 - 10);
                this.widget.setHeight(this.height - 2);
            }
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.setFocused((IGuiEventListener)this.widget);
            this.widget.func_146195_b(true);
            if (button == 1) {
                this.widget.func_146180_a("");
            } else if (button == 2) {
                this.widget.func_146191_b(Minecraft.func_71410_x().field_195559_v.func_197965_a());
            }
            this.widget.mouseClicked(mouseX, mouseY, button);
            if (ElementNumberInput.isMouseBetween(mouseX, this.getRight() - 10, this.getRight()) && ElementNumberInput.isMouseBetween(mouseY, this.getTop(), (double)this.getTop() + (double)this.height / 2.0)) {
                this.clickUp = true;
            }
            if (ElementNumberInput.isMouseBetween(mouseX, this.getRight() - 10, this.getRight()) && ElementNumberInput.isMouseBetween(mouseY, (double)this.getTop() + (double)this.height / 2.0, this.getBottom())) {
                this.clickDown = true;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.clickUp) {
            this.clickUp = false;
            if (ElementNumberInput.isMouseBetween(mouseX, this.getRight() - 10, this.getRight()) && ElementNumberInput.isMouseBetween(mouseY, this.getTop(), (double)this.getTop() + (double)this.height / 2.0)) {
                this.changeValue(true, Screen.hasShiftDown(), Screen.hasControlDown());
                if (this.renderMinecraftStyle()) {
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                }
            }
        }
        if (this.clickDown) {
            this.clickDown = false;
            if (ElementNumberInput.isMouseBetween(mouseX, this.getRight() - 10, this.getRight()) && ElementNumberInput.isMouseBetween(mouseY, (double)this.getTop() + (double)this.height / 2.0, this.getBottom())) {
                this.changeValue(false, Screen.hasShiftDown(), Screen.hasControlDown());
                if (this.renderMinecraftStyle()) {
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                }
            }
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double dist) {
        if (ElementNumberInput.isMouseBetween(mouseX, this.getLeft(), this.getLeft() + this.width - 10) && ElementNumberInput.isMouseBetween(mouseY, this.getTop(), this.getTop() + this.height)) {
            this.changeValue(dist > 0.0, Screen.hasShiftDown(), Screen.hasControlDown());
            return true;
        }
        return false;
    }

    public void changeValue(boolean up, boolean hasShiftDown, boolean hasControlDown) {
        double amp;
        String s = this.widget.func_146179_b();
        if (s.isEmpty()) {
            s = "0";
        }
        double d = amp = this.isDouble ? Math.pow(0.1, Math.max(0, this.decimals - 1)) : 1.0;
        if (hasShiftDown && hasControlDown) {
            amp *= 100.0;
        } else if (hasShiftDown) {
            amp *= 10.0;
        } else if (hasControlDown) {
            amp *= 0.1;
        }
        if (this.isDouble) {
            try {
                double d2 = Double.parseDouble(s);
                String newVal = String.format(Locale.ENGLISH, "%." + Integer.toString(this.decimals) + "f", d2 += (double)(up ? 1 : -1) * amp);
                if (this.finalValidator.test(newVal)) {
                    this.widget.func_146180_a(newVal);
                }
            }
            catch (NumberFormatException d2) {}
        } else {
            amp = Math.max(1.0, amp);
            int i = Integer.parseInt(s);
            String newVal = Integer.toString(i = (int)((double)i + (double)(up ? 1 : -1) * amp));
            if (this.finalValidator.test(newVal)) {
                this.widget.func_146180_a(newVal);
            }
        }
    }

    public int getInt() {
        String s = this.widget.func_146179_b();
        if (s.contains(".")) {
            try {
                return (int)Double.parseDouble(s);
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (!s.isEmpty() && !s.equals("-")) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public double getDouble() {
        String s = this.widget.func_146179_b();
        if (!s.isEmpty() && !s.equals("-")) {
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0.0;
    }

    @Override
    public int getMinWidth() {
        return 20;
    }
}

