/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.view.element;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;

public class ElementScrollBar<T extends ElementScrollBar>
extends Element {
    public final Orientation orientation;
    private float scrollBarSize;
    public Consumer<T> callback;
    public float scrollProg;
    public boolean resizing;
    public Element.MousePos pos;

    public ElementScrollBar(@Nonnull Fragment parent, Orientation orientation, float scrollBarSize) {
        super(parent);
        this.orientation = orientation;
        this.scrollBarSize = scrollBarSize;
    }

    public T setCallback(Consumer<T> callback) {
        this.callback = callback;
        return (T)this;
    }

    public void setScrollBarSize(float f) {
        f = Math.min(f, 1.01f);
        float oldSize = this.scrollBarSize;
        this.scrollBarSize = f;
        float size = (float)(this.orientation == Orientation.VERTICAL ? this.height : this.width) * f;
        if (size < 4.0f) {
            this.scrollBarSize = 4.0f / (float)this.getDistance();
        }
        this.updateSize(oldSize);
    }

    public float getScrollbarSize() {
        return this.scrollBarSize;
    }

    public void setScrollProg(float f) {
        float scroll = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        if (scroll != this.scrollProg) {
            this.scrollProg = scroll;
            if (this.callback != null) {
                this.callback.accept(this);
            }
        }
    }

    private void updateSize(float oldSize) {
        if (this.scrollBarSize > 1.0f) {
            switch (this.orientation) {
                case VERTICAL: {
                    this.width = 0;
                    break;
                }
                case HORIZONTAL: {
                    this.height = 0;
                }
            }
            this.setScrollProg(0.0f);
        } else {
            this.setScrollProg(this.scrollProg / oldSize * this.scrollBarSize);
        }
        if (!this.resizing && (oldSize <= 1.0f && this.scrollBarSize > 1.0f || this.scrollBarSize <= 1.0f && oldSize > 1.0f)) {
            this.resizing = true;
            this.constraint.apply();
            this.parentFragment.resize(this.getWorkspace().getMinecraft(), this.parentFragment.getParentWidth(), this.parentFragment.getParentHeight());
            this.resizing = false;
        }
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        if (this.width <= 0 || this.height <= 0) {
            return;
        }
        int scrollBar = (int)((float)this.getDistance() * this.scrollBarSize);
        int space = this.getDistance() - scrollBar;
        int preSpace = (int)((float)space * this.scrollProg);
        if (this.renderMinecraftStyle()) {
            ElementScrollBar.bindTexture(Fragment.VANILLA_TAB_ITEMS);
            if (this.orientation == Orientation.VERTICAL) {
                int dist;
                int i = this.height - 6;
                int x = this.getTop() + 3;
                while (i > 0) {
                    dist = Math.min(i, 106);
                    RenderHelper.draw(this.getLeft(), x, 14.0, dist, 0.0, 0.6796875, 0.734375, 0.078125, 0.4921875);
                    i -= dist;
                    x += dist;
                }
                RenderHelper.draw(this.getLeft(), this.getTop(), 14.0, 3.0, 0.0, 0.6796875, 0.734375, 0.06640625, 0.078125);
                RenderHelper.draw(this.getLeft(), this.getBottom() - 3, 14.0, 3.0, 0.0, 0.6796875, 0.734375, 0.4921875, 0.50390625);
                ElementScrollBar.bindTexture(Fragment.VANILLA_TABS);
                i = scrollBar - 7 - 2;
                x = this.getTop() + preSpace + 4 + 1;
                while (i > 0) {
                    dist = Math.min(i, 8);
                    RenderHelper.draw(this.getLeft() + 1, x, 12.0, dist, 0.0, 0.90625, 0.953125, 0.015625, (double)(4 + dist) / 256.0);
                    i -= dist;
                    x += dist;
                }
                RenderHelper.draw(this.getLeft() + 1, this.getTop() + preSpace + 1, 12.0, 4.0, 0.0, 0.90625, 0.953125, 0.0, 0.015625);
                RenderHelper.draw(this.getLeft() + 1, this.getTop() + preSpace + scrollBar - 3 - 1, 12.0, 3.0, 0.0, 0.90625, 0.953125, 0.046875, 0.05859375);
            } else {
                int dist;
                int i = this.width - 6;
                int x = this.getLeft() + 3;
                while (i > 0) {
                    dist = Math.min(i, 106);
                    ElementScrollBar.draw(x, this.getTop(), dist, 14.0, 0.0, 0.6796875, 0.734375, 0.078125, 0.4921875);
                    i -= dist;
                    x += dist;
                }
                ElementScrollBar.draw(this.getLeft(), this.getTop(), 3.0, 14.0, 0.0, 0.6796875, 0.734375, 0.06640625, 0.078125);
                ElementScrollBar.draw(this.getRight() - 3, this.getTop(), 3.0, 14.0, 0.0, 0.6796875, 0.734375, 0.4921875, 0.50390625);
                ElementScrollBar.bindTexture(Fragment.VANILLA_TABS);
                i = scrollBar - 7 - 2;
                x = this.getLeft() + preSpace + 4 + 1;
                while (i > 0) {
                    dist = Math.min(i, 8);
                    ElementScrollBar.draw(x, this.getTop() + 1, dist, 12.0, 0.0, 0.90625, 0.953125, 0.015625, (double)(4 + dist) / 256.0);
                    i -= dist;
                    x += dist;
                }
                ElementScrollBar.draw(this.getLeft() + preSpace + 1, this.getTop() + 1, 4.0, 12.0, 0.0, 0.90625, 0.953125, 0.0, 0.015625);
                ElementScrollBar.draw(this.getLeft() + preSpace + scrollBar - 3 - 1, this.getTop() + 1, 3.0, 12.0, 0.0, 0.90625, 0.953125, 0.046875, 0.05859375);
            }
        } else {
            this.fill(this.getTheme().elementTreeScrollBar, 0);
            if (this.orientation == Orientation.VERTICAL) {
                RenderHelper.drawColour(this.getTheme().elementTreeScrollBarBorder[0], this.getTheme().elementTreeScrollBarBorder[1], this.getTheme().elementTreeScrollBarBorder[2], 255, this.getLeft() + 6, this.getTop() + 4, 2.0, this.height - 8, 0.0);
                RenderHelper.drawColour(this.getTheme().elementTreeScrollBarBorder[0], this.getTheme().elementTreeScrollBarBorder[1], this.getTheme().elementTreeScrollBarBorder[2], 255, this.getLeft(), this.getTop() + preSpace, 14.0, scrollBar, 0.0);
                RenderHelper.drawColour(this.getTheme().elementTreeScrollBar[0], this.getTheme().elementTreeScrollBar[1], this.getTheme().elementTreeScrollBar[2], 255, this.getLeft() + 1, this.getTop() + preSpace + 1, 12.0, scrollBar - 2, 0.0);
            } else {
                RenderHelper.drawColour(this.getTheme().elementTreeScrollBarBorder[0], this.getTheme().elementTreeScrollBarBorder[1], this.getTheme().elementTreeScrollBarBorder[2], 255, this.getLeft() + 4, this.getTop() + 6, this.width - 8, 2.0, 0.0);
                RenderHelper.drawColour(this.getTheme().elementTreeScrollBarBorder[0], this.getTheme().elementTreeScrollBarBorder[1], this.getTheme().elementTreeScrollBarBorder[2], 255, this.getLeft() + preSpace, this.getTop(), scrollBar, 14.0, 0.0);
                RenderHelper.drawColour(this.getTheme().elementTreeScrollBar[0], this.getTheme().elementTreeScrollBar[1], this.getTheme().elementTreeScrollBar[2], 255, this.getLeft() + preSpace + 1, this.getTop() + 1, scrollBar - 2, 12.0, 0.0);
            }
        }
    }

    public int getDistance() {
        return this.orientation == Orientation.VERTICAL ? this.height : this.width;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.pos = new Element.MousePos((int)mouseX, (int)mouseY);
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double distX, double distY) {
        if (this.pos != null) {
            int moved = this.orientation == Orientation.VERTICAL ? (int)mouseY - this.pos.y : (int)mouseX - this.pos.x;
            if (moved != 0) {
                this.setScrollProg(this.scrollProg + (float)moved / ((float)this.getDistance() * (1.0f - this.scrollBarSize)));
            }
            this.pos.x = (int)mouseX;
            this.pos.y = (int)mouseY;
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double dist) {
        if (this.isMouseOver(mouseX, mouseY) && this.scrollBarSize < 1.0f) {
            if (Screen.hasShiftDown()) {
                this.setScrollProg((float)dist * -100.0f);
            } else if (Screen.hasControlDown()) {
                this.setScrollProg(this.scrollProg + (float)(dist * -0.01));
            } else {
                this.secondHandScroll(dist);
            }
            return true;
        }
        return false;
    }

    public void secondHandScroll(double dist) {
        this.setScrollProg(this.scrollProg + (float)(dist * -0.1));
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.pos = null;
        super.mouseReleased(mouseX, mouseY, button);
        this.parentFragment.setFocused(null);
        return this.getFocused() != null && this.getFocused().mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean changeFocus(boolean direction) {
        return false;
    }

    @Override
    public int getMinWidth() {
        return this.orientation == Orientation.VERTICAL && this.scrollBarSize < 1.0f ? 14 : 0;
    }

    @Override
    public int getMinHeight() {
        return this.orientation == Orientation.HORIZONTAL && this.scrollBarSize < 1.0f ? 14 : 0;
    }

    @Override
    public int getMaxWidth() {
        return this.orientation == Orientation.VERTICAL && this.scrollBarSize < 1.0f ? 14 : (this.orientation == Orientation.HORIZONTAL ? 10000 : 0);
    }

    @Override
    public int getMaxHeight() {
        return this.orientation == Orientation.HORIZONTAL && this.scrollBarSize < 1.0f ? 14 : (this.orientation == Orientation.VERTICAL ? 10000 : 0);
    }

    public static void draw(double posX, double posY, double width, double height, double zLevel, double u1, double u2, double v1, double v2) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_(posX, posY + height, zLevel).func_225583_a_((float)u2, (float)v1).func_181675_d();
        bufferbuilder.func_225582_a_(posX + width, posY + height, zLevel).func_225583_a_((float)u2, (float)v2).func_181675_d();
        bufferbuilder.func_225582_a_(posX + width, posY, zLevel).func_225583_a_((float)u1, (float)v2).func_181675_d();
        bufferbuilder.func_225582_a_(posX, posY, zLevel).func_225583_a_((float)u1, (float)v1).func_181675_d();
        tessellator.func_78381_a();
    }

    public static enum Orientation {
        VERTICAL,
        HORIZONTAL;

    }
}

