/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.view.element;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementFertile;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementScrollBar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;

public class ElementScrollView
extends ElementFertile {
    public List<Element<?>> elements = new ArrayList();
    @Nullable
    private ElementScrollBar<?> scrollVert;
    @Nullable
    private ElementScrollBar<?> scrollHori;
    public boolean hasInit;

    public ElementScrollView(@Nonnull Fragment parent) {
        super(parent);
    }

    public <T extends ElementScrollView> T setScrollVertical(ElementScrollBar<?> scroll) {
        this.scrollVert = scroll;
        this.scrollVert.setCallback(scr -> this.alignItems());
        return (T)this;
    }

    public <T extends ElementScrollView> T setScrollHorizontal(ElementScrollBar<?> scroll) {
        this.scrollHori = scroll;
        this.scrollHori.setCallback(scr -> this.alignItems());
        return (T)this;
    }

    public Element<?> addElement(Element<?> e) {
        Element<?> anchor = this.elements.isEmpty() ? null : this.elements.get(this.elements.size() - 1);
        this.elements.add(e);
        e.setConstraint(Constraint.sizeOnly(e));
        if (this.hasInit) {
            this.alignItems();
            this.updateScrollBarSizes();
        }
        return e;
    }

    @Override
    public void init() {
        super.init();
        this.hasInit = true;
        this.alignItems();
        this.updateScrollBarSizes();
    }

    @Override
    public void resize(Minecraft mc, int width, int height) {
        super.resize(mc, width, height);
        this.alignItems();
        super.resize(mc, width, height);
        this.alignItems();
        this.updateScrollBarSizes();
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        this.setScissor();
        this.elements.forEach(item -> item.render(mouseX, mouseY, partialTick));
        this.resetScissorToParent();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double dist) {
        if (this.isMouseOver(mouseX, mouseY)) {
            boolean defaultScroll = super.mouseScrolled(mouseX, mouseY, dist);
            if (defaultScroll) {
                return true;
            }
            if (Screen.hasShiftDown()) {
                if (this.scrollHori != null) {
                    this.scrollHori.secondHandScroll(dist);
                    return true;
                }
            } else if (this.scrollVert != null) {
                this.scrollVert.secondHandScroll(dist);
                return true;
            }
        }
        return false;
    }

    public void alignItems() {
        int itemHeight = this.getTotalItemHeight();
        int itemWidth = this.getMinItemWidth();
        int offsetY = 0;
        if (this.scrollVert != null) {
            offsetY = (int)((float)Math.max(0, itemHeight - (this.height - 2)) * this.scrollVert.scrollProg);
        }
        int offsetX = 0;
        if (this.scrollHori != null) {
            offsetX = (int)((float)Math.max(0, itemWidth - (this.width - 2)) * this.scrollHori.scrollProg);
        }
        int currentWidth = 1;
        int currentHeight = 1;
        for (Element<?> item : this.elements) {
            item.posX = currentWidth - offsetX;
            item.posY = currentHeight - offsetY;
            boolean flag = false;
            if (item.width != this.width - 2) {
                item.width = Math.max(itemWidth, this.width - 2);
                flag = true;
            }
            if (item.height != item.getMinHeight()) {
                item.height = item.getMinHeight();
                flag = true;
            }
            if (flag) {
                item.constraint.apply();
            }
            currentHeight += item.getHeight();
        }
    }

    public void updateScrollBarSizes() {
        if (this.scrollVert != null) {
            int itemHeight = this.getTotalItemHeight();
            this.scrollVert.setScrollBarSize((float)this.height / (float)itemHeight);
        }
        if (this.scrollHori != null) {
            int itemWidth = this.getMinItemWidth();
            this.scrollHori.setScrollBarSize((float)this.width / (float)itemWidth);
        }
    }

    public int getTotalItemHeight() {
        int itemHeight = 0;
        for (Element<?> item : this.elements) {
            itemHeight += item.height;
        }
        return itemHeight;
    }

    public int getMinItemWidth() {
        int itemWidth = 0;
        for (Element<?> item : this.elements) {
            if (item.getMinWidth() <= itemWidth) continue;
            itemWidth = item.getMinWidth();
        }
        return itemWidth;
    }

    @Override
    public List<? extends Element<?>> children() {
        return this.elements;
    }

    @Override
    public boolean requireScissor() {
        return true;
    }

    @Override
    public boolean changeFocus(boolean direction) {
        return false;
    }

    @Override
    public int getMinWidth() {
        if (this.scrollHori != null) {
            return 14;
        }
        return super.getMinWidth();
    }

    @Override
    public int getMinHeight() {
        if (this.scrollVert != null) {
            return 14;
        }
        return super.getMinHeight();
    }

    @Override
    public int getBorderSize() {
        return 0;
    }
}

