/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.view.element;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.client.gui.bns.Theme;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.TextFormatting;

public class ElementTextWrapper
extends Element {
    private List<String> text = new ArrayList<String>();
    private List<String> textWrapped = new ArrayList<String>();
    private boolean doNotWrap;
    public int longestLine;
    @Nullable
    public Integer color;
    public static final Random RANDOM = new Random();

    public ElementTextWrapper(@Nonnull Fragment parent) {
        super(parent);
    }

    public <T extends ElementTextWrapper> T setText(List<String> text) {
        this.text.clear();
        this.text.addAll(text);
        return (T)this;
    }

    public <T extends ElementTextWrapper> T setText(String text) {
        this.text.clear();
        this.text.add(text);
        return (T)this;
    }

    public <T extends ElementTextWrapper> T setNoWrap() {
        this.doNotWrap = true;
        return (T)this;
    }

    public <T extends ElementTextWrapper> T setColor(Integer clr) {
        this.color = clr;
        return (T)this;
    }

    public List<String> getText() {
        return this.text;
    }

    @Override
    public void init() {
        super.init();
        if (!this.text.isEmpty() && this.setupText()) {
            this.constraint.apply();
            this.parentFragment.resize(this.getWorkspace().getMinecraft(), this.parentFragment.getParentWidth(), this.parentFragment.getParentHeight());
        }
    }

    @Override
    public void resize(Minecraft mc, int width, int height) {
        super.resize(mc, width, height);
        if (!this.text.isEmpty() && this.setupText()) {
            this.constraint.apply();
            this.parentFragment.resize(this.getWorkspace().getMinecraft(), this.parentFragment.getParentWidth(), this.parentFragment.getParentHeight());
        }
    }

    public boolean setupText() {
        int lines = this.textWrapped.size();
        int tooltipTextWidth = 0;
        for (String textLine : this.text) {
            int textLineWidth = this.getFontRenderer().func_78256_a(textLine);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        this.longestLine = tooltipTextWidth;
        if (this.doNotWrap) {
            this.textWrapped = this.text;
            return this.textWrapped.size() != lines;
        }
        boolean needsWrap = false;
        if (tooltipTextWidth > this.width - 4) {
            tooltipTextWidth = this.width - 4;
            needsWrap = true;
        }
        if (needsWrap) {
            ArrayList<String> wrappedTextLines = new ArrayList<String>();
            for (String textLine : this.text) {
                wrappedTextLines.addAll(this.getFontRenderer().func_78271_c(textLine, tooltipTextWidth));
            }
            this.textWrapped = wrappedTextLines;
        } else {
            this.textWrapped = new ArrayList<String>(this.text);
        }
        return lines != this.textWrapped.size();
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        int textX = this.getLeft() + 2;
        int textY = this.getTop() + 4;
        for (int lineNumber = 0; lineNumber < this.textWrapped.size(); ++lineNumber) {
            String line = this.textWrapped.get(lineNumber);
            this.drawString(line, textX, textY);
            textY += 12;
        }
    }

    @Override
    public void drawString(String s, float posX, float posY) {
        if (this.renderMinecraftStyle()) {
            this.getFontRenderer().func_175063_a(s, posX, posY, this.color != null ? this.color.intValue() : this.getMinecraftFontColour());
        } else {
            this.getFontRenderer().func_211126_b(s, posX, posY, this.color != null ? this.color : Theme.getAsHex(this.getTheme().font));
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }

    @Override
    public boolean changeFocus(boolean direction) {
        return false;
    }

    @Override
    public int getMinWidth() {
        return this.doNotWrap ? this.longestLine : 4;
    }

    @Override
    public int getMinHeight() {
        return this.textWrapped.isEmpty() ? 12 : this.textWrapped.size() * 12 + 4;
    }

    @Override
    public int getMaxWidth() {
        return this.getParentWidth() - 4;
    }

    @Override
    public int getMaxHeight() {
        return this.getMinHeight();
    }

    public static int getRandomColourForName(String s) {
        if (s.equalsIgnoreCase("System")) {
            return 0xFFCC00;
        }
        return Math.abs(s.hashCode()) & 0xFFFFFF;
    }

    public static TextFormatting getRandomTextFormattingColorForName(String s) {
        if (s.equalsIgnoreCase("System")) {
            return TextFormatting.RED;
        }
        ArrayList<TextFormatting> formats = new ArrayList<TextFormatting>();
        for (int i = 1; i < 15; ++i) {
            if (i == 12) continue;
            formats.add(TextFormatting.values()[i]);
        }
        RANDOM.setSeed(Math.abs(s.hashCode()));
        return (TextFormatting)formats.get(RANDOM.nextInt(formats.size()));
    }
}

