/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.model.tabula;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import me.ichun.mods.ichunutil.client.model.tabula.ModelRotationPoint;
import me.ichun.mods.ichunutil.common.module.tabula.project.Project;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class ModelTabula
extends Model {
    public static final RenderType RENDER_MODEL_NO_TEXTURE = RenderType.func_228633_a_((String)"tabula_model_no_texture", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)true, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(RenderState.field_228523_o_).func_228726_a_(RenderState.field_228515_g_).func_228716_a_(RenderState.field_228532_x_).func_228713_a_(RenderState.field_228517_i_).func_228717_a_(RenderState.field_228501_K_).func_228719_a_(RenderState.field_228528_t_).func_228728_a_(false));
    public static final RenderType RENDER_MODEL_FLAT = RenderType.func_228633_a_((String)"tabula_model_flat", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)true, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(RenderState.field_228523_o_).func_228713_a_(RenderState.field_228517_i_).func_228717_a_(RenderState.field_228501_K_).func_228728_a_(false));
    public static final RenderType RENDER_MODEL_COMPASS_FLAT = RenderType.func_228633_a_((String)"tabula_model_compass_flat", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)true, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(new ResourceLocation("tabula", "textures/model/cube.png"), false, false)).func_228713_a_(RenderState.field_228517_i_).func_228717_a_(RenderState.field_228501_K_).func_228728_a_(false));
    @Nonnull
    public final Project project;
    public ArrayList<ModelRendererTabula> models = new ArrayList();
    public HashMap<Project.Part, ModelRendererTabula> partMap = new HashMap();
    public boolean isDirty = true;
    protected boolean selecting;
    private float selectionR = 0.0f;
    private float selectionG = 0.0f;
    private float selectionB = 0.0f;
    protected Project.Part selectedPart;
    protected Project.Part.Box selectedBox;
    protected ModelRotationPoint rotationPoint;

    public ModelTabula(Project project) {
        super(rl -> RENDER_MODEL_NO_TEXTURE);
        this.project = project;
        this.rotationPoint = new ModelRotationPoint();
    }

    public void createParts() {
        this.models.clear();
        this.partMap.clear();
        this.field_78090_t = this.project.texWidth;
        this.field_78089_u = this.project.texHeight;
        this.project.parts.forEach(part -> this.populateModel((Collection<? super ModelRendererTabula>)this.models, (Project.Part)part));
    }

    public void populateModel(Collection<? super ModelRendererTabula> parts, Project.Part part) {
        int[] dims = part.getProjectTextureDims();
        if (!part.matchProject) {
            dims[0] = part.texWidth;
            dims[1] = part.texHeight;
        }
        ModelRendererTabula modelPart = new ModelRendererTabula(this, dims[0], dims[1], part.texOffX, part.texOffY);
        modelPart.field_78800_c = part.rotPX;
        modelPart.field_78797_d = part.rotPY;
        modelPart.field_78798_e = part.rotPZ;
        modelPart.field_78795_f = (float)Math.toRadians(part.rotAX);
        modelPart.field_78796_g = (float)Math.toRadians(part.rotAY);
        modelPart.field_78808_h = (float)Math.toRadians(part.rotAZ);
        modelPart.field_78809_i = part.mirror;
        modelPart.field_78806_j = part.showModel;
        part.boxes.forEach(modelPart::addBox);
        part.children.forEach(part1 -> this.populateModel((Collection<? super ModelRendererTabula>)modelPart.field_78805_m, (Project.Part)part1));
        parts.add(modelPart);
        this.partMap.put(part, modelPart);
    }

    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder iVertexBuilder, int light, int overlay, float r, float g, float b, float alpha) {
        this.preRender();
        this.models.forEach(modelRenderer -> modelRenderer.func_228309_a_(matrixStack, iVertexBuilder, light, overlay, r, g, b, alpha));
    }

    public void render(MatrixStack matrixStack, Project.Part selectedPart, Project.Part.Box selectedBox, boolean hideTexture, float alpha) {
        this.selectedPart = selectedPart;
        this.selectedBox = selectedBox;
        if (selectedPart != null || selectedBox != null) {
            this.render(matrixStack, 0.85f, hideTexture);
            this.selectedPart = null;
            this.selectedBox = null;
            this.render(matrixStack, 0.25f, hideTexture);
        } else {
            this.render(matrixStack, alpha, hideTexture);
        }
    }

    private void render(MatrixStack matrixStack, float alpha, boolean hideTexture) {
        this.preRender();
        this.models.forEach(modelRenderer -> modelRenderer.func_228309_a_(matrixStack, null, hideTexture ? 0 : 0xF000F0, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, alpha));
    }

    public void resetForSelection() {
        this.selectionB = 0.0f;
        this.selectionG = 0.0f;
        this.selectionR = 0.0f;
    }

    public float getSelectionR() {
        if (this.selectionR < 1.0f) {
            this.selectionR += 0.003921569f;
        }
        return this.selectionR;
    }

    public float getSelectionG() {
        if (this.selectionR >= 1.0f && this.selectionG < 1.0f) {
            this.selectionG += 0.003921569f;
        }
        return this.selectionG;
    }

    public float getSelectionB() {
        if (this.selectionG >= 1.0f && this.selectionB < 1.0f) {
            this.selectionB += 0.003921569f;
        }
        return this.selectionB;
    }

    public void renderForSelection(MatrixStack matrixStack) {
        IRenderTypeBuffer.Impl bufferSource = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        IVertexBuilder ivertexbuilder = bufferSource.getBuffer(RENDER_MODEL_FLAT);
        this.preRender();
        this.resetForSelection();
        this.selecting = true;
        this.models.forEach(modelRenderer -> modelRenderer.renderForSelection(matrixStack, ivertexbuilder, 1.0f));
        this.selecting = false;
        bufferSource.func_228461_a_();
    }

    public Project.Part.Box getSelectedBox(int r, int g, int b) {
        for (ModelRendererTabula model : this.models) {
            Project.Part.Box box = model.getSelectedBox(r, g, b);
            if (box == null) continue;
            return box;
        }
        return null;
    }

    public void preRender() {
        if (this.isDirty) {
            this.isDirty = false;
            this.createParts();
        }
    }

    public static class ModelRendererTabula
    extends ModelRenderer {
        @Nonnull
        public final ModelTabula parentModel;
        public HashMap<BoxToBox, int[]> boxes = new HashMap();

        public ModelRendererTabula(ModelTabula parent, int textureWidthIn, int textureHeightIn, int textureOffsetXIn, int textureOffsetYIn) {
            super(textureWidthIn, textureHeightIn, textureOffsetXIn, textureOffsetYIn);
            this.parentModel = parent;
        }

        public void addBox(Project.Part.Box box) {
            int texOffX = this.field_78803_o;
            int texOffY = this.field_78813_p;
            this.func_78784_a(this.field_78803_o + box.texOffX, this.field_78813_p + box.texOffY);
            this.func_228302_a_(box.posX, box.posY, box.posZ, box.dimX, box.dimY, box.dimZ, box.expandX, box.expandY, box.expandZ);
            this.func_78784_a(texOffX, texOffY);
            this.boxes.put(new BoxToBox(box, (ModelRenderer.ModelBox)this.field_78804_l.get(this.field_78804_l.size() - 1)), null);
        }

        public void renderForSelection(MatrixStack matrixStackIn, IVertexBuilder bufferIn, float alpha) {
            super.func_228309_a_(matrixStackIn, bufferIn, 0xF000F0, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, alpha);
        }

        public Project.Part.Box getSelectedBox(int r, int g, int b) {
            for (Map.Entry<BoxToBox, int[]> boxToBoxEntry : this.boxes.entrySet()) {
                int[] value = boxToBoxEntry.getValue();
                if (value == null || value[0] != r || value[1] != g || value[2] != b) continue;
                return boxToBoxEntry.getKey().box;
            }
            for (ModelRenderer childModel : this.field_78805_m) {
                Project.Part.Box box;
                if (!(childModel instanceof ModelRendererTabula) || (box = ((ModelRendererTabula)childModel).getSelectedBox(r, g, b)) == null) continue;
                return box;
            }
            return null;
        }

        public BoxToBox getBoxToBox(ModelRenderer.ModelBox box) {
            for (BoxToBox boxToBox : this.boxes.keySet()) {
                if (boxToBox.modelBox != box) continue;
                return boxToBox;
            }
            return null;
        }

        public void func_228309_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
            if (!(!this.field_78806_j || this.field_78804_l.isEmpty() && this.field_78805_m.isEmpty())) {
                matrixStackIn.func_227860_a_();
                this.func_228307_a_(matrixStackIn);
                if (bufferIn == null) {
                    IRenderTypeBuffer.Impl bufferSource = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
                    RenderType type = RENDER_MODEL_NO_TEXTURE;
                    IVertexBuilder ivertexbuilder = bufferSource.getBuffer(type);
                    if (this.parentModel.selectedPart != null && this.parentModel.partMap.get(this.parentModel.selectedPart) == this) {
                        this.parentModel.rotationPoint.func_225598_a_(matrixStackIn, ivertexbuilder, 0xF000F0, OverlayTexture.field_229196_a_, 0.0f, 0.0f, 1.0f, 1.0f);
                    }
                    if (this.parentModel.project.getTextureBytes() != null && packedLightIn > 0) {
                        type = RenderType.func_228644_e_((ResourceLocation)this.parentModel.project.getNativeImageResourceLocation());
                    }
                    ivertexbuilder = bufferSource.getBuffer(type);
                    this.func_228306_a_(matrixStackIn.func_227866_c_(), ivertexbuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
                    bufferSource.func_228461_a_();
                    for (ModelRenderer modelrenderer : this.field_78805_m) {
                        modelrenderer.func_228309_a_(matrixStackIn, null, packedLightIn, packedOverlayIn, red, green, blue, alpha);
                    }
                } else {
                    this.func_228306_a_(matrixStackIn.func_227866_c_(), bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
                    for (ModelRenderer modelrenderer : this.field_78805_m) {
                        modelrenderer.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
                    }
                }
                matrixStackIn.func_227865_b_();
            }
        }

        public void func_228306_a_(MatrixStack.Entry matrixEntryIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
            if (this.parentModel.selectedPart != null && this.parentModel.partMap.get(this.parentModel.selectedPart) != this) {
                return;
            }
            Matrix4f matrix4f = matrixEntryIn.func_227870_a_();
            Matrix3f matrix3f = matrixEntryIn.func_227872_b_();
            for (ModelRenderer.ModelBox modelBox : this.field_78804_l) {
                BoxToBox box;
                if (this.parentModel.selectedBox != null) {
                    BoxToBox box2 = this.getBoxToBox(modelBox);
                    if (this.parentModel.selectedBox != box2.box) continue;
                }
                float r = red;
                float g = green;
                float b = blue;
                float a = alpha;
                if (this.parentModel.selecting && (box = this.getBoxToBox(modelBox)) != null) {
                    r = MathHelper.func_76131_a((float)this.parentModel.getSelectionR(), (float)0.0f, (float)1.0f);
                    g = MathHelper.func_76131_a((float)this.parentModel.getSelectionG(), (float)0.0f, (float)1.0f);
                    b = MathHelper.func_76131_a((float)this.parentModel.getSelectionB(), (float)0.0f, (float)1.0f);
                    this.boxes.put(box, new int[]{(int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f)});
                }
                for (ModelRenderer.TexturedQuad modelrenderer$texturedquad : modelBox.field_78254_i) {
                    Vector3f vector3f = modelrenderer$texturedquad.field_228312_b_.func_229195_e_();
                    vector3f.func_229188_a_(matrix3f);
                    float f = vector3f.func_195899_a();
                    float f1 = vector3f.func_195900_b();
                    float f2 = vector3f.func_195902_c();
                    for (int i = 0; i < 4; ++i) {
                        ModelRenderer.PositionTextureVertex modelrenderer$positiontexturevertex = modelrenderer$texturedquad.field_78239_a[i];
                        float f3 = modelrenderer$positiontexturevertex.field_78243_a.func_195899_a() / 16.0f;
                        float f4 = modelrenderer$positiontexturevertex.field_78243_a.func_195900_b() / 16.0f;
                        float f5 = modelrenderer$positiontexturevertex.field_78243_a.func_195902_c() / 16.0f;
                        Vector4f vector4f = new Vector4f(f3, f4, f5, 1.0f);
                        vector4f.func_229372_a_(matrix4f);
                        bufferIn.func_225588_a_(vector4f.func_195910_a(), vector4f.func_195913_b(), vector4f.func_195914_c(), r, g, b, a, modelrenderer$positiontexturevertex.field_78241_b, modelrenderer$positiontexturevertex.field_78242_c, packedOverlayIn, packedLightIn, f, f1, f2);
                    }
                }
            }
        }

        public static class BoxToBox {
            public final Project.Part.Box box;
            public final ModelRenderer.ModelBox modelBox;

            public BoxToBox(Project.Part.Box box, ModelRenderer.ModelBox modelBox) {
                this.box = box;
                this.modelBox = modelBox;
            }
        }
    }
}

