/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import cpw.mods.modlauncher.api.INameMappingService;
import java.awt.Color;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.lwjgl.opengl.GL11;

public class RenderHelper {
    public static HashSet<Framebuffer> frameBuffers = new HashSet();

    public static void renderModel(IBakedModel modelIn, ItemStack stack, int combinedLightIn, int combinedOverlayIn, MatrixStack matrixStackIn, IVertexBuilder bufferIn) {
        Random random = new Random();
        long i = 42L;
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            RenderHelper.renderQuads(matrixStackIn, bufferIn, modelIn.func_200117_a((BlockState)null, direction, random), stack, combinedLightIn, combinedOverlayIn);
        }
        random.setSeed(42L);
        RenderHelper.renderQuads(matrixStackIn, bufferIn, modelIn.func_200117_a((BlockState)null, (Direction)null, random), stack, combinedLightIn, combinedOverlayIn);
    }

    private static void renderQuads(MatrixStack matrixStackIn, IVertexBuilder bufferIn, List<BakedQuad> quadsIn, ItemStack itemStackIn, int combinedLightIn, int combinedOverlayIn) {
        boolean flag = !itemStackIn.func_190926_b();
        MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
        for (BakedQuad bakedquad : quadsIn) {
            int i = -1;
            if (flag && bakedquad.func_178212_b()) {
                i = Minecraft.func_71410_x().getItemColors().func_186728_a(itemStackIn, bakedquad.func_178211_c());
            }
            float f = (float)(i >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(i & 0xFF) / 255.0f;
            bufferIn.addVertexData(matrixstack$entry, bakedquad, f, f1, f2, combinedLightIn, combinedOverlayIn, true);
        }
    }

    public static void renderBakedModel(IBakedModel modelIn, ItemStack itemStackIn) {
        RenderHelper.renderBakedModel(modelIn, itemStackIn, null);
    }

    public static void renderBakedModel(IBakedModel modelIn, ItemStack itemStackIn, RenderType renderTypeOverride) {
        RenderHelper.renderBakedModel(modelIn, itemStackIn, renderTypeOverride, new MatrixStack(), (IRenderTypeBuffer)Minecraft.func_71410_x().func_228019_au_().func_228487_b_());
    }

    public static void renderBakedModel(IBakedModel modelIn, ItemStack itemStackIn, RenderType renderTypeOverride, MatrixStack matrixStackIn, IRenderTypeBuffer buffer) {
        boolean flag4;
        Minecraft mc = Minecraft.func_71410_x();
        boolean bl = flag4 = !modelIn.func_230044_c_();
        if (renderTypeOverride != null) {
            RenderSystem.pushMatrix();
            mc.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            mc.func_110434_K().func_229267_b_(AtlasTexture.field_110575_b).func_174937_a(false, false);
            RenderSystem.enableRescaleNormal();
            RenderSystem.enableAlphaTest();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (flag4) {
                net.minecraft.client.renderer.RenderHelper.func_227783_c_();
            }
        }
        if (!itemStackIn.func_190926_b()) {
            matrixStackIn.func_227860_a_();
            if (itemStackIn.func_77973_b() == Items.field_203184_eO) {
                modelIn = mc.func_175599_af().func_175037_a().func_178083_a().func_174953_a(new ModelResourceLocation("minecraft:trident#inventory"));
            }
            modelIn = ForgeHooksClient.handleCameraTransforms((MatrixStack)matrixStackIn, (IBakedModel)modelIn, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.NONE, (boolean)false);
            matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
            if (!modelIn.func_188618_c()) {
                RenderType rendertype = RenderTypeLookup.func_228389_a_((ItemStack)itemStackIn);
                RenderType rendertype1 = renderTypeOverride != null ? renderTypeOverride : (Objects.equals(rendertype, Atlases.func_228784_i_()) ? Atlases.func_228785_j_() : rendertype);
                IVertexBuilder ivertexbuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)buffer, (RenderType)rendertype1, (boolean)true, (boolean)itemStackIn.func_77962_s());
                RenderHelper.renderModel(modelIn, itemStackIn, 0xF000F0, OverlayTexture.field_229196_a_, matrixStackIn, ivertexbuilder);
            } else {
                itemStackIn.func_77973_b().getItemStackTileEntityRenderer().func_228364_a_(itemStackIn, matrixStackIn, buffer, 0xF000F0, OverlayTexture.field_229196_a_);
            }
            matrixStackIn.func_227865_b_();
        }
        if (buffer instanceof IRenderTypeBuffer.Impl) {
            ((IRenderTypeBuffer.Impl)buffer).func_228461_a_();
        }
        if (renderTypeOverride != null) {
            RenderSystem.enableDepthTest();
            if (flag4) {
                net.minecraft.client.renderer.RenderHelper.func_227784_d_();
            }
            RenderSystem.disableAlphaTest();
            RenderSystem.disableRescaleNormal();
            RenderSystem.popMatrix();
        }
    }

    public static TextureAtlasSprite buildTASFromNativeImage(@Nonnull ResourceLocation rl, @Nonnull NativeImage image) {
        return new TextureAtlasSprite(Minecraft.func_71410_x().func_209506_al().func_229356_a_(AtlasTexture.field_110575_b), new TextureAtlasSprite.Info(rl, image.func_195702_a(), image.func_195714_b(), AnimationMetadataSection.field_229300_b_), Minecraft.func_71410_x().field_71474_y.field_151442_I, image.func_195702_a(), image.func_195714_b(), 0, 0, image);
    }

    public static void drawTexture(ResourceLocation resource, double posX, double posY, double width, double height, double zLevel) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resource);
        RenderHelper.draw(posX, posY, width, height, zLevel);
    }

    public static void draw(double posX, double posY, double width, double height, double zLevel) {
        RenderHelper.draw(posX, posY, width, height, zLevel, 0.0, 1.0, 0.0, 1.0);
    }

    public static void draw(double posX, double posY, double width, double height, double zLevel, double u1, double u2, double v1, double v2) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_(posX, posY + height, zLevel).func_225583_a_((float)u1, (float)v2).func_181675_d();
        bufferbuilder.func_225582_a_(posX + width, posY + height, zLevel).func_225583_a_((float)u2, (float)v2).func_181675_d();
        bufferbuilder.func_225582_a_(posX + width, posY, zLevel).func_225583_a_((float)u2, (float)v1).func_181675_d();
        bufferbuilder.func_225582_a_(posX, posY, zLevel).func_225583_a_((float)u1, (float)v1).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawColour(int colour, int alpha, double posX, double posY, double width, double height, double zLevel) {
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour & 0xFF;
        RenderHelper.drawColour(r, g, b, alpha, posX, posY, width, height, zLevel);
    }

    public static void drawColour(int r, int g, int b, int alpha, double posX, double posY, double width, double height, double zLevel) {
        if (width <= 0.0 || height <= 0.0) {
            return;
        }
        RenderSystem.disableTexture();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_225582_a_(posX, posY + height, zLevel).func_225586_a_(r, g, b, alpha).func_181675_d();
        bufferbuilder.func_225582_a_(posX + width, posY + height, zLevel).func_225586_a_(r, g, b, alpha).func_181675_d();
        bufferbuilder.func_225582_a_(posX + width, posY, zLevel).func_225586_a_(r, g, b, alpha).func_181675_d();
        bufferbuilder.func_225582_a_(posX, posY, zLevel).func_225586_a_(r, g, b, alpha).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
    }

    public static void colour(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)1.0f);
    }

    public static void colour(int color, float alpha) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)alpha);
    }

    public static int getRandomColourFromString(String s) {
        Random rand = new Random();
        rand.setSeed(Math.abs(s.hashCode() * 1000));
        int clr = Math.round(1.6777215E7f * rand.nextFloat());
        float[] hsb = new float[3];
        Color.RGBtoHSB(clr >> 16 & 0xFF, clr >> 8 & 0xFF, clr & 0xFF, hsb);
        hsb[2] = 0.65f + 0.25f * hsb[2];
        clr = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
        return clr;
    }

    public static void startGlScissor(int x, int y, int width, int height) {
        Minecraft mc = Minecraft.func_71410_x();
        double scaleW = (double)mc.func_228018_at_().func_198109_k() / (double)mc.func_228018_at_().func_198107_o();
        double scaleH = (double)mc.func_228018_at_().func_198091_l() / (double)mc.func_228018_at_().func_198087_p();
        if (width <= 0 || height <= 0) {
            return;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)Math.floor((double)x * scaleW)), (int)((int)Math.floor((double)mc.func_228018_at_().func_198091_l() - (double)(y + height) * scaleH)), (int)((int)Math.floor((double)(x + width) * scaleW) - (int)Math.floor((double)x * scaleW)), (int)((int)Math.floor((double)mc.func_228018_at_().func_198091_l() - (double)y * scaleH) - (int)Math.floor((double)mc.func_228018_at_().func_198091_l() - (double)(y + height) * scaleH)));
    }

    public static void endGlScissor() {
        GL11.glDisable((int)3089);
    }

    public static void renderTestScissor() {
        Minecraft mc = Minecraft.func_71410_x();
        RenderHelper.startGlScissor(mc.func_228018_at_().func_198107_o() / 2 - 50, mc.func_228018_at_().func_198087_p() / 2 - 50, 100, 100);
        RenderSystem.pushMatrix();
        RenderHelper.drawColour(0xFFFFFF, 255, 0.0, 0.0, mc.func_228018_at_().func_198107_o(), mc.func_228018_at_().func_198087_p(), 0.0);
        RenderSystem.popMatrix();
        RenderHelper.endGlScissor();
    }

    public static void renderTestStencil() {
        Minecraft mc = Minecraft.func_71410_x();
        MainWindow reso = mc.func_228018_at_();
        GL11.glEnable((int)2960);
        GlStateManager.func_227668_a_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GlStateManager.func_227667_a_((boolean)false);
        GL11.glStencilFunc((int)512, (int)1, (int)255);
        GL11.glStencilOp((int)7681, (int)7680, (int)7680);
        GL11.glStencilMask((int)255);
        GlStateManager.func_227658_a_((int)1024, (boolean)Minecraft.field_142025_a);
        RenderHelper.drawColour(0xFFFFFF, 255, 0.0, 0.0, 60.0, 60.0, 0.0);
        GlStateManager.func_227668_a_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_227667_a_((boolean)true);
        GL11.glStencilMask((int)0);
        GL11.glStencilFunc((int)514, (int)0, (int)255);
        GL11.glStencilFunc((int)514, (int)1, (int)255);
        RenderHelper.drawColour(0xFFFFFF, 255, 0.0, 0.0, reso.func_198107_o(), reso.func_198087_p(), 0.0);
        GL11.glDisable((int)2960);
    }

    public static Framebuffer createFrameBuffer() {
        Minecraft mc = Minecraft.func_71410_x();
        Framebuffer render = new Framebuffer(mc.func_228018_at_().func_198109_k(), mc.func_228018_at_().func_198091_l(), true, Minecraft.field_142025_a);
        if (mc.func_147110_a().isStencilEnabled()) {
            render.enableStencil();
        }
        frameBuffers.add(render);
        return render;
    }

    public static void deleteFrameBuffer(Framebuffer buffer) {
        if (buffer.field_147616_f >= 0) {
            buffer.func_147608_a();
        }
        frameBuffers.remove(buffer);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public static <T extends EntityRenderer<?>, V extends Entity> ResourceLocation getEntityTexture(T rend, V ent) {
        return RenderHelper.getEntityTexture(rend, rend.getClass(), ent);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <T extends LivingRenderer<?, ?>, V extends LivingEntity> void invokePreRenderCallback(T rend, V ent, MatrixStack stack, float rendTick) {
        RenderHelper.invokePreRenderCallback(rend, rend.getClass(), ent, stack, rendTick);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private static <T extends EntityRenderer<?>, V extends Entity> ResourceLocation getEntityTexture(T rend, Class clz, V ent) {
        try {
            Method m = clz.getDeclaredMethod(ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.METHOD, (String)"func_110775_a"), Entity.class);
            m.setAccessible(true);
            return (ResourceLocation)m.invoke(rend, ent);
        }
        catch (NoSuchMethodException e) {
            if (clz != EntityRenderer.class) {
                return RenderHelper.getEntityTexture(rend, clz.getSuperclass(), ent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static <T extends LivingRenderer<?, ?>, V extends LivingEntity> void invokePreRenderCallback(T rend, Class clz, V ent, MatrixStack stack, float rendTick) {
        try {
            Method m = clz.getDeclaredMethod(ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.METHOD, (String)"func_225620_a_"), LivingEntity.class, MatrixStack.class, Float.TYPE);
            m.setAccessible(true);
            m.invoke(rend, ent, stack, Float.valueOf(rendTick));
        }
        catch (NoSuchMethodException e) {
            if (clz != LivingRenderer.class) {
                RenderHelper.invokePreRenderCallback(rend, clz.getSuperclass(), ent, stack, rendTick);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

