/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.tracker.entity;

import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.client.tracker.tag.Tag;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT)
public class EntityTracker
extends Entity {
    public HashSet<Tag> field_184236_aF = new HashSet();
    @Nonnull
    public Entity parent;
    public int maxPersistAfterDeath = 0;
    public int timeAfterDeath = 0;
    public int maxTrack = 0;
    public ArrayList<EntityInfo> trackedInfo = new ArrayList();
    public int lastUpdate = -1;

    public EntityTracker(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.func_82142_c(true);
        this.func_184224_h(true);
    }

    public EntityTracker setParent(Entity tracked) {
        this.parent = tracked;
        return this;
    }

    @Nullable
    public <T extends Tag> T getTag(Class<T> clz) {
        for (Tag tag : this.field_184236_aF) {
            if (!clz.isInstance(tag)) continue;
            return (T)tag;
        }
        return null;
    }

    public void addTag(Tag tag) {
        this.field_184236_aF.add(tag);
        tag.init(this);
        this.updateBounds();
    }

    public void removeTag(Class<? extends Tag> clz) {
        this.field_184236_aF.removeIf(clz::isInstance);
        this.updateBounds();
    }

    public void updateBounds() {
        int tracks = 0;
        int deathTicks = 0;
        float w = 0.1f;
        float h = 0.1f;
        boolean ignoreFrustum = false;
        for (Tag tag : this.field_184236_aF) {
            float tagH;
            float tagW;
            if (tag.maxTracks() > tracks) {
                tracks = tag.maxTracks();
            }
            if (tag.maxDeathPersist() > deathTicks) {
                deathTicks = tag.maxDeathPersist();
            }
            if (w > (tagW = tag.width(this))) {
                w = tagW;
            }
            if (h > (tagH = tag.height(this))) {
                h = tagH;
            }
            ignoreFrustum = tag.ignoreFrustumCheck() | ignoreFrustum;
        }
        this.maxTrack = tracks;
        this.maxPersistAfterDeath = deathTicks;
        this.field_213325_aI = EntitySize.func_220314_b((float)w, (float)h);
        this.field_70158_ak = ignoreFrustum;
        this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
    }

    public void func_70071_h_() {
        block6: {
            block4: {
                block5: {
                    super.func_70071_h_();
                    if (Minecraft.func_71410_x().field_71439_g == null) {
                        this.func_70106_y();
                        return;
                    }
                    this.lastUpdate = Minecraft.func_71410_x().field_71439_g.field_70173_aa;
                    if (this.parent.func_70089_S() && this.parent.field_71093_bK.equals(this.field_71093_bK)) break block4;
                    if (this.maxPersistAfterDeath <= 0) break block5;
                    if (this.timeAfterDeath >= this.maxPersistAfterDeath) {
                        this.func_70106_y();
                    }
                    ++this.timeAfterDeath;
                    break block6;
                }
                if (!this.parent.field_70128_L) break block6;
                this.func_70106_y();
                break block6;
            }
            this.func_70107_b(this.parent.func_226277_ct_(), this.parent.func_226278_cu_(), this.parent.func_226281_cx_());
            this.func_70101_b(this.parent.field_70177_z, this.parent.field_70125_A);
            if (this.maxTrack > 0) {
                EntityInfo info = new EntityInfo(this.parent.func_226277_ct_(), this.parent.func_226278_cu_(), this.parent.func_226281_cx_(), this.parent.field_213325_aI.field_220315_a, this.parent.field_213325_aI.field_220316_b, this.parent.field_70177_z, this.parent.field_70125_A, this.parent.func_82150_aj());
                this.trackedInfo.add(0, info);
                this.field_184236_aF.forEach(tag -> tag.addInfo(this, info));
                while (this.trackedInfo.size() > this.maxTrack) {
                    EntityInfo removed = this.trackedInfo.get(this.trackedInfo.size() - 1);
                    this.field_184236_aF.forEach(tag -> tag.removeInfo(this, removed));
                    this.trackedInfo.remove(this.trackedInfo.size() - 1);
                }
            }
        }
        this.field_184236_aF.forEach(tag -> tag.tick(this));
    }

    public boolean func_70112_a(double distance) {
        return this.parent.func_70112_a(distance);
    }

    public float func_70013_c() {
        return this.parent.func_70013_c();
    }

    protected void func_70088_a() {
    }

    public boolean func_184198_c(CompoundNBT compound) {
        return false;
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static class EntityInfo {
        public final double posX;
        public final double posY;
        public final double posZ;
        public final float width;
        public final float height;
        public final float yaw;
        public final float pitch;
        public final boolean invisible;

        public EntityInfo(double posX, double posY, double posZ, float width, float height, float yaw, float pitch, boolean invisible) {
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
            this.width = width;
            this.height = height;
            this.yaw = yaw;
            this.pitch = pitch;
            this.invisible = invisible;
        }
    }
}

