/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.entity.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import cpw.mods.modlauncher.api.INameMappingService;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class EntityHelper {
    public static final UUID UUID_EXAMPLE = UUID.fromString("DEADBEEF-DEAD-BEEF-DEAD-DEADBEEFD00D");
    public static final Map<String, GameProfile> GAME_PROFILE_CACHE = Collections.synchronizedMap(new HashMap());
    private static PlayerProfileCache profileCache;
    private static MinecraftSessionService sessionService;
    private static final GameProfile DUMMY_PROFILE;

    @OnlyIn(value=Dist.CLIENT)
    public static void injectMinecraftPlayerGameProfile() {
        GAME_PROFILE_CACHE.put(Minecraft.func_71410_x().func_110432_I().func_111285_a(), Minecraft.func_71410_x().func_110432_I().func_148256_e());
    }

    public static GameProfile getDummyGameProfile() {
        return DUMMY_PROFILE;
    }

    public static GameProfile getGameProfile(@Nullable UUID uuid, @Nullable String playerName) {
        Property property;
        GameProfile gameprofile;
        if (playerName != null && GAME_PROFILE_CACHE.containsKey(playerName)) {
            return GAME_PROFILE_CACHE.get(playerName);
        }
        if (profileCache == null || sessionService == null) {
            if (FMLEnvironment.dist.isDedicatedServer()) {
                sessionService = ServerLifecycleHooks.getCurrentServer().func_147130_as();
                profileCache = ServerLifecycleHooks.getCurrentServer().func_152358_ax();
            } else {
                EntityHelper.setClientProfileLookupObjects();
            }
        }
        GameProfile gameProfile = gameprofile = uuid != null ? profileCache.func_152652_a(uuid) : profileCache.func_152655_a(playerName);
        if (gameprofile == null) {
            gameprofile = sessionService.fillProfileProperties(new GameProfile(uuid, playerName), true);
        }
        if ((property = (Property)Iterables.getFirst((Iterable)gameprofile.getProperties().get((Object)"textures"), null)) == null) {
            gameprofile = sessionService.fillProfileProperties(gameprofile, true);
        }
        GAME_PROFILE_CACHE.put(gameprofile.getName(), gameprofile);
        return gameprofile;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void setClientProfileLookupObjects() {
        YggdrasilAuthenticationService yggdrasilauthenticationservice = new YggdrasilAuthenticationService(Minecraft.func_71410_x().func_110437_J(), UUID.randomUUID().toString());
        sessionService = yggdrasilauthenticationservice.createMinecraftSessionService();
        GameProfileRepository gameprofilerepository = yggdrasilauthenticationservice.createProfileRepository();
        profileCache = new PlayerProfileCache(gameprofilerepository, new File(Minecraft.func_71410_x().field_71412_D, MinecraftServer.field_152367_a.getName()));
    }

    public static PlayerEntity getClientPlayer() {
        if (FMLEnvironment.dist.isClient()) {
            return EntityHelper.getMinecraftPlayer();
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static PlayerEntity getMinecraftPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void nudgeHand(float mag) {
        Minecraft.func_71410_x().field_71439_g.field_71155_g += mag;
    }

    public static float updateRotation(float oriRot, float intendedRot, float maxChange) {
        float var4 = MathHelper.func_76142_g((float)(intendedRot - oriRot));
        if (var4 > maxChange) {
            var4 = maxChange;
        }
        if (var4 < -maxChange) {
            var4 = -maxChange;
        }
        return oriRot + var4;
    }

    public static int countInInventory(IInventory inv, Item item) {
        int totalCount = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack is = inv.func_70301_a(i);
            if (is.func_190926_b() || is.func_77973_b() != item) continue;
            totalCount += is.func_190916_E();
        }
        return totalCount;
    }

    public static boolean consumeInventoryItem(IInventory inventory, Item item) {
        return EntityHelper.consumeInventoryItem(inventory, item, 1);
    }

    public static boolean consumeInventoryItem(IInventory inventory, Item itemIn, int removeCount) {
        if (removeCount > 0 && EntityHelper.countInInventory(inventory, itemIn) < removeCount) {
            return false;
        }
        if (removeCount != 0) {
            int removed = 0;
            for (int j = inventory.func_70302_i_() - 1; j >= 0; --j) {
                ItemStack itemstack = inventory.func_70301_a(j);
                if (itemstack.func_190926_b() || itemIn != null && itemstack.func_77973_b() != itemIn) continue;
                int removeFromStack = removeCount < 0 ? itemstack.func_190916_E() : Math.min(removeCount - removed, itemstack.func_190916_E());
                removed += removeFromStack;
                itemstack.func_190918_g(removeFromStack);
                if (itemstack.func_190926_b()) {
                    inventory.func_70299_a(j, ItemStack.field_190927_a);
                    inventory.func_70296_d();
                }
                if (removeCount >= 0 && removed < removeCount) continue;
                return true;
            }
        }
        return removeCount == 0;
    }

    public static void putEntityWithinAABB(Entity ent, AxisAlignedBB aabb) {
        double posX = ent.func_226277_ct_();
        double posY = ent.func_226278_cu_();
        double posZ = ent.func_226281_cx_();
        if (ent.func_174813_aQ().field_72336_d > aabb.field_72336_d) {
            posX += aabb.field_72336_d - ent.func_174813_aQ().field_72336_d;
        }
        if (ent.func_174813_aQ().field_72340_a < aabb.field_72340_a) {
            posX += aabb.field_72340_a - ent.func_174813_aQ().field_72340_a;
        }
        if (posY + (double)ent.func_70047_e() > aabb.field_72337_e) {
            posY += aabb.field_72337_e - posY - (double)ent.func_70047_e();
        }
        if (posY < aabb.field_72338_b) {
            posY += aabb.field_72338_b - posY + 0.001;
        }
        if (ent.func_174813_aQ().field_72334_f > aabb.field_72334_f) {
            posZ += aabb.field_72334_f - ent.func_174813_aQ().field_72334_f;
        }
        if (ent.func_174813_aQ().field_72339_c < aabb.field_72339_c) {
            posZ += aabb.field_72339_c - ent.func_174813_aQ().field_72339_c;
        }
        ent.func_70107_b(posX, posY, posZ);
    }

    public static RayTraceResult getEntityLook(Entity ent, double d) {
        return EntityHelper.getEntityLook(ent, d, true);
    }

    public static RayTraceResult getEntityLook(Entity ent, double d, boolean checkEntities) {
        return EntityHelper.getEntityLook(ent, d, checkEntities, 1.0f);
    }

    public static RayTraceResult getEntityLook(Entity ent, double d, boolean checkEntities, float partialTick) {
        return EntityHelper.rayTrace(ent.field_70170_p, ent.func_174824_e(partialTick), ent.func_174824_e(partialTick).func_178787_e(ent.func_70676_i(partialTick).func_216372_d(d, d, d)), ent, checkEntities, RayTraceContext.BlockMode.COLLIDER, b -> true, RayTraceContext.FluidMode.NONE, e -> true);
    }

    public static RayTraceResult rayTrace(World world, Vec3d origin, Vec3d dest, @Nonnull Entity exception, boolean checkEntityCollision, RayTraceContext.BlockMode blockMode, Predicate<BlockInfo> blockFilter, RayTraceContext.FluidMode fluidMode, Predicate<Entity> filter) {
        RayTraceResult raytraceresult = (RayTraceResult)IBlockReader.func_217300_a((RayTraceContext)new RayTraceContext(origin, dest, blockMode, fluidMode, exception), (context, pos) -> {
            BlockState blockstate = world.func_180495_p(pos);
            if (blockFilter.test(new BlockInfo((IWorldReader)world, blockstate, (BlockPos)pos))) {
                IFluidState ifluidstate = world.func_204610_c(pos);
                Vec3d vec3d = context.func_222253_b();
                Vec3d vec3d1 = context.func_222250_a();
                VoxelShape voxelshape = context.func_222251_a(blockstate, (IBlockReader)world, pos);
                BlockRayTraceResult blockraytraceresult = world.func_217296_a(vec3d, vec3d1, pos, voxelshape, blockstate);
                VoxelShape voxelshape1 = context.func_222252_a(ifluidstate, (IBlockReader)world, pos);
                BlockRayTraceResult blockraytraceresult1 = voxelshape1.func_212433_a(vec3d, vec3d1, pos);
                double d0 = blockraytraceresult == null ? Double.MAX_VALUE : context.func_222253_b().func_72436_e(blockraytraceresult.func_216347_e());
                double d1 = blockraytraceresult1 == null ? Double.MAX_VALUE : context.func_222253_b().func_72436_e(blockraytraceresult1.func_216347_e());
                return d0 <= d1 ? blockraytraceresult : blockraytraceresult1;
            }
            return null;
        }, context -> {
            Vec3d vec3d = context.func_222253_b().func_178788_d(context.func_222250_a());
            return BlockRayTraceResult.func_216352_a((Vec3d)context.func_222250_a(), (Direction)Direction.func_210769_a((double)vec3d.field_72450_a, (double)vec3d.field_72448_b, (double)vec3d.field_72449_c), (BlockPos)new BlockPos(context.func_222250_a()));
        });
        if (checkEntityCollision) {
            AxisAlignedBB aabb;
            EntityRayTraceResult raytraceresult1;
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
                dest = raytraceresult.func_216347_e();
            }
            if ((raytraceresult1 = ProjectileHelper.func_221271_a((World)world, (Entity)exception, (Vec3d)origin, (Vec3d)dest, (AxisAlignedBB)(aabb = new AxisAlignedBB(origin, dest).func_186662_g(1.0)), filter)) != null) {
                raytraceresult = raytraceresult1;
            }
        }
        return raytraceresult;
    }

    private static Set<Entity> getEntityAndMount(Entity rider) {
        Entity entity = rider.func_184187_bx();
        return entity != null ? ImmutableSet.of((Object)rider, (Object)entity) : ImmutableSet.of((Object)rider);
    }

    public static void faceEntity(Entity facer, Entity faced, float maxYaw, float maxPitch) {
        EntityHelper.faceLocation(facer, faced.func_226277_ct_(), faced instanceof LivingEntity ? faced.func_226278_cu_() + (double)faced.func_70047_e() : (faced.func_174813_aQ().field_72338_b + faced.func_174813_aQ().field_72337_e) / 2.0, faced.func_226281_cx_(), maxYaw, maxPitch);
    }

    public static void faceLocation(Entity facer, double posX, double posY, double posZ, float maxYaw, float maxPitch) {
        double d0 = posX - facer.func_226277_ct_();
        double d1 = posZ - facer.func_226281_cx_();
        double d2 = posY - (facer.func_226278_cu_() + (double)facer.func_70047_e());
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        float f2 = (float)(Math.atan2(d1, d0) * 180.0 / Math.PI) - 90.0f;
        float f3 = (float)(-(Math.atan2(d2, d3) * 180.0 / Math.PI));
        facer.field_70125_A = EntityHelper.updateRotation(facer.field_70125_A, f3, maxPitch);
        facer.field_70177_z = EntityHelper.updateRotation(facer.field_70177_z, f2, maxYaw);
    }

    public static Vec3d getVectorForRotation(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float f1 = -yaw * ((float)Math.PI / 180);
        float f2 = MathHelper.func_76134_b((float)f1);
        float f3 = MathHelper.func_76126_a((float)f1);
        float f4 = MathHelper.func_76134_b((float)f);
        float f5 = MathHelper.func_76126_a((float)f);
        return new Vec3d((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    public static Vec3d getVectorRenderYawOffset(float renderYawOffset) {
        return EntityHelper.getVectorForRotation(0.0f, renderYawOffset);
    }

    public static void playSound(@Nonnull Entity ent, SoundEvent soundEvent, SoundCategory soundCategory, float volume, float pitch) {
        ent.func_130014_f_().func_184148_a((PlayerEntity)(ent.func_130014_f_().field_72995_K ? EntityHelper.getClientPlayer() : null), ent.func_226277_ct_(), ent.func_226278_cu_() + (double)ent.func_70047_e(), ent.func_226281_cx_(), soundEvent, soundCategory, volume, pitch);
    }

    public static boolean destroyBlocksInAABB(Entity ent, AxisAlignedBB aabb, Predicate<BlockInfo> blockFilter) {
        int i = MathHelper.func_76128_c((double)aabb.field_72340_a);
        int j = MathHelper.func_76128_c((double)aabb.field_72338_b);
        int k = MathHelper.func_76128_c((double)aabb.field_72339_c);
        int l = MathHelper.func_76128_c((double)aabb.field_72336_d);
        int i1 = MathHelper.func_76128_c((double)aabb.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)aabb.field_72334_f);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    BlockState blockstate = ent.field_70170_p.func_180495_p(blockpos);
                    if (blockstate.isAir((IBlockReader)ent.field_70170_p, blockpos) || blockstate.func_185904_a() == Material.field_151581_o) continue;
                    if (ForgeEventFactory.getMobGriefingEvent((World)ent.field_70170_p, (Entity)ent) && blockstate.canEntityDestroy((IBlockReader)ent.field_70170_p, blockpos, ent) && (!(ent instanceof LivingEntity) || ForgeEventFactory.onEntityDestroyBlock((LivingEntity)((LivingEntity)ent), (BlockPos)blockpos, (BlockState)blockstate)) && blockFilter.test(new BlockInfo((IWorldReader)ent.field_70170_p, blockstate, blockpos))) {
                        flag1 = ent.field_70170_p.func_217377_a(blockpos, false) || flag1;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (flag1) {
            BlockPos blockpos1 = new BlockPos(i + ent.field_70170_p.field_73012_v.nextInt(l - i + 1), j + ent.field_70170_p.field_73012_v.nextInt(i1 - j + 1), k + ent.field_70170_p.field_73012_v.nextInt(j1 - k + 1));
            ent.field_70170_p.func_217379_c(2008, blockpos1, 0);
        }
        return flag;
    }

    public static CompoundNBT getPlayerPersistentData(@Nonnull PlayerEntity player, @Nullable String name) {
        CompoundNBT persistedTag = player.getPersistentData().func_74775_l("PlayerPersisted");
        player.getPersistentData().func_218657_a("PlayerPersisted", (INBT)persistedTag);
        if (name == null) {
            return persistedTag;
        }
        CompoundNBT specificTag = persistedTag.func_74775_l(name);
        persistedTag.func_218657_a(name, (INBT)specificTag);
        return specificTag;
    }

    public static boolean isFakePlayer(@Nonnull ServerPlayerEntity player) {
        return player instanceof FakePlayer || player.field_71135_a == null;
    }

    public static <T extends LivingEntity> SoundEvent getHurtSound(T ent, DamageSource source) {
        return EntityHelper.getHurtSound(ent, ent.getClass(), source);
    }

    public static <T extends LivingEntity> SoundEvent getDeathSound(T ent) {
        return EntityHelper.getDeathSound(ent, ent.getClass());
    }

    public static <T extends LivingEntity> float getSoundVolume(T ent) {
        return EntityHelper.getSoundVolume(ent, ent.getClass());
    }

    public static <T extends LivingEntity> float getSoundPitch(T ent) {
        return EntityHelper.getSoundPitch(ent, ent.getClass());
    }

    public static <T extends LivingEntity> void onChangedPotionEffect(T ent, EffectInstance effect, boolean reapply) {
        EntityHelper.onChangedPotionEffect(ent, ent.getClass(), effect, reapply);
    }

    private static <T extends LivingEntity> SoundEvent getHurtSound(T ent, Class<?> clz, DamageSource source) {
        try {
            Method m = clz.getDeclaredMethod(ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.METHOD, (String)"func_184601_bQ"), DamageSource.class);
            m.setAccessible(true);
            return (SoundEvent)m.invoke(ent, source);
        }
        catch (NoSuchMethodException e) {
            if (clz != LivingEntity.class) {
                return EntityHelper.getHurtSound(ent, clz.getSuperclass(), source);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return SoundEvents.field_187543_bD;
    }

    private static <T extends LivingEntity> SoundEvent getDeathSound(T ent, Class<?> clz) {
        try {
            Method m = clz.getDeclaredMethod(ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.METHOD, (String)"func_184615_bR"), new Class[0]);
            m.setAccessible(true);
            return (SoundEvent)m.invoke(ent, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            if (clz != LivingEntity.class) {
                return EntityHelper.getDeathSound(ent, clz.getSuperclass());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return SoundEvents.field_187661_by;
    }

    private static <T extends LivingEntity> float getSoundVolume(T ent, Class<?> clz) {
        try {
            Method m = clz.getDeclaredMethod(ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.METHOD, (String)"func_70599_aP"), new Class[0]);
            m.setAccessible(true);
            return ((Float)m.invoke(ent, new Object[0])).floatValue();
        }
        catch (NoSuchMethodException e) {
            if (clz != LivingEntity.class) {
                return EntityHelper.getSoundVolume(ent, clz.getSuperclass());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return 1.0f;
    }

    private static <T extends LivingEntity> float getSoundPitch(T ent, Class<?> clz) {
        try {
            Method m = clz.getDeclaredMethod(ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.METHOD, (String)"func_70647_i"), new Class[0]);
            m.setAccessible(true);
            return ((Float)m.invoke(ent, new Object[0])).floatValue();
        }
        catch (NoSuchMethodException e) {
            if (clz != LivingEntity.class) {
                return EntityHelper.getSoundPitch(ent, clz.getSuperclass());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return ent.func_70631_g_() ? (ent.func_70681_au().nextFloat() - ent.func_70681_au().nextFloat()) * 0.2f + 1.5f : (ent.func_70681_au().nextFloat() - ent.func_70681_au().nextFloat()) * 0.2f + 1.0f;
    }

    private static <T extends LivingEntity> void onChangedPotionEffect(T ent, Class<?> clz, EffectInstance effect, boolean reapply) {
        try {
            Method m = clz.getDeclaredMethod(ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.METHOD, (String)"func_70695_b"), EffectInstance.class, Boolean.TYPE);
            m.setAccessible(true);
            m.invoke(ent, effect, reapply);
            return;
        }
        catch (NoSuchMethodException e) {
            if (clz != LivingEntity.class) {
                EntityHelper.onChangedPotionEffect(ent, clz.getSuperclass(), effect, reapply);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static {
        DUMMY_PROFILE = new GameProfile(UUID_EXAMPLE, "ForgeDev");
    }

    public static class BlockInfo {
        public final IWorldReader world;
        public final BlockState state;
        public final BlockPos pos;

        public BlockInfo(IWorldReader world, BlockState state, BlockPos pos) {
            this.world = world;
            this.state = state;
            this.pos = pos;
        }
    }
}

