/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.module.tabula.formats;

import java.io.File;
import java.util.HashMap;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.module.tabula.formats.types.Importer;
import me.ichun.mods.ichunutil.common.module.tabula.formats.types.ImporterTabula;
import me.ichun.mods.ichunutil.common.module.tabula.project.Project;
import org.apache.commons.io.FilenameUtils;

public class ImportList {
    public static final ImporterTabula IMPORTER_TABULA = new ImporterTabula();
    public static final HashMap<String, Importer> COMPATIBLE_FORMATS = new HashMap<String, Importer>(){
        {
            this.put("tcn", IMPORTER_TABULA);
            this.put("tc2", IMPORTER_TABULA);
            this.put("tbl", IMPORTER_TABULA);
        }
    };

    public static boolean isFileSupported(File file) {
        return !file.isDirectory() && COMPATIBLE_FORMATS.containsKey(FilenameUtils.getExtension((String)file.getName()));
    }

    public static Project createProjectFromFile(File file) {
        if (COMPATIBLE_FORMATS.containsKey(FilenameUtils.getExtension((String)file.getName()))) {
            Importer importer = COMPATIBLE_FORMATS.get(FilenameUtils.getExtension((String)file.getName()));
            try {
                Project project = importer.createProject(file);
                if (project != null) {
                    project.projVersion = importer.getProjectVersion();
                    project.load();
                    return project;
                }
            }
            catch (Exception e) {
                iChunUtil.LOGGER.warn("Error creating Project for format {} for file {} by importer {}", (Object)FilenameUtils.getExtension((String)file.getName()), (Object)file.getAbsolutePath(), (Object)importer);
            }
        } else {
            iChunUtil.LOGGER.warn("Error creating Project for file {}. No importer assigned.", (Object)file.getAbsolutePath());
        }
        return null;
    }

    public static boolean registerImporter(String format, Importer importer) {
        if (COMPATIBLE_FORMATS.containsKey(format)) {
            iChunUtil.LOGGER.warn("Format {} has already been registered with {}. Unable to register with importer {}", (Object)format, (Object)COMPATIBLE_FORMATS.get(format), (Object)importer);
            return false;
        }
        iChunUtil.LOGGER.info("Registered importer {} with format {}", (Object)importer, (Object)format);
        COMPATIBLE_FORMATS.put(format, importer);
        return true;
    }
}

