/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.module.tabula.project;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.client.model.tabula.ModelTabula;
import me.ichun.mods.ichunutil.client.render.NativeImageTexture;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.module.tabula.project.Identifiable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.RandomStringUtils;

public class Project
extends Identifiable<Project> {
    public static final int IDENTIFIER_LENGTH = 20;
    public static final int PROJ_VERSION = 5;
    public static final Gson SIMPLE_GSON = new GsonBuilder().disableHtmlEscaping().create();
    @Nullable
    public transient File saveFile;
    public transient boolean isDirty;
    public transient boolean tampered;
    public transient boolean isOldTabula;
    private transient byte[] textureBytes;
    @OnlyIn(value=Dist.CLIENT)
    public transient NativeImageTexture nativeImageTexture;
    @OnlyIn(value=Dist.CLIENT)
    private transient ModelTabula model;
    public String author = "";
    public int projVersion = 5;
    public ArrayList<String> notes = new ArrayList();
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public float scaleZ = 1.0f;
    public int texWidth = 64;
    public int texHeight = 32;
    public String textureFile = null;
    public String textureFileMd5 = null;
    public ArrayList<Part> parts = new ArrayList();
    public int partCountProjectLife = 0;

    @Override
    public Identifiable<?> getById(String id) {
        for (Part part : this.parts) {
            Identifiable<?> ident = part.getById(id);
            if (ident == null) continue;
            return ident;
        }
        return this.identifier.equals(id) ? this : null;
    }

    @Override
    public String getJsonWithoutChildren() {
        ArrayList<Part> parts = this.parts;
        this.parts = null;
        String json = SIMPLE_GSON.toJson((Object)this);
        this.parts = parts;
        return json;
    }

    @Override
    public void adoptChildren() {
        for (Part part : this.parts) {
            part.parent = this;
            part.adoptChildren();
        }
    }

    @Override
    public void disown(Identifiable<?> child) {
        if (!this.parts.remove(child)) {
            for (Part part : this.parts) {
                part.disown(child);
            }
        } else {
            child.parent = null;
        }
    }

    @Override
    public void adopt(Identifiable<?> child) {
        if (child instanceof Part) {
            this.parts.add((Part)child);
            child.parent = this;
        }
    }

    @Override
    public boolean rearrange(Identifiable<?> before, Identifiable<?> child) {
        boolean arranged = false;
        while (before.parent != null && before.parent != this) {
            if (before.parent.rearrange(before, child)) {
                arranged = true;
                break;
            }
            before = before.parent;
        }
        if (before.rearrange(before, child)) {
            arranged = true;
        }
        if (before == child) {
            return true;
        }
        if (!arranged && child instanceof Part && this.parts.contains(child) && this.parts.remove(child)) {
            if (before == this) {
                this.parts.add(0, (Part)child);
            } else {
                for (int i = 0; i < this.parts.size(); ++i) {
                    if (this.parts.get(i) != before) continue;
                    this.parts.add(i + 1, (Part)child);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void witnessProtectionProgramme() {
        this.identifier = RandomStringUtils.randomAscii((int)20);
        this.parts.forEach(Identifiable::witnessProtectionProgramme);
    }

    @Override
    public Project clone() {
        Project project = (Project)SIMPLE_GSON.fromJson(SIMPLE_GSON.toJson((Object)this), Project.class);
        project.adoptChildren();
        return project;
    }

    public void transferTransients(Project project) {
        project.isDirty = true;
        project.saveFile = this.saveFile;
        project.tampered = this.tampered;
        project.isOldTabula = this.isOldTabula;
        project.textureBytes = this.textureBytes;
        project.nativeImageTexture = this.nativeImageTexture;
    }

    public boolean save(@Nonnull File saveFile) {
        return Project.saveProject(this, saveFile);
    }

    @Override
    public Project getProject() {
        return this;
    }

    @Override
    public Project markDirty() {
        this.isDirty = true;
        if (FMLEnvironment.dist.isClient()) {
            this.updateModel();
        }
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void destroy() {
        this.setImageBytes(null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateModel() {
        if (this.model != null) {
            this.model.isDirty = true;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ModelTabula getModel() {
        if (this.model == null) {
            this.model = new ModelTabula(this);
        }
        return this.model;
    }

    public void importProject(@Nonnull Project project, boolean texture) {
        if (texture && project.getTextureBytes() != null) {
            this.setImageBytes(project.getTextureBytes());
        }
        this.parts.addAll(project.parts);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setImageBytes(byte[] bytes) {
        if (this.nativeImageTexture != null) {
            Minecraft.func_71410_x().func_110434_K().func_147645_c(this.nativeImageTexture.getResourceLocation());
            this.nativeImageTexture = null;
        }
        this.textureBytes = bytes;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getNativeImageResourceLocation() {
        if (this.textureBytes != null) {
            if (this.nativeImageTexture == null) {
                try (NativeImage image = NativeImage.func_195713_a((InputStream)new ByteArrayInputStream(this.textureBytes));){
                    this.nativeImageTexture = new NativeImageTexture(image);
                    Minecraft.func_71410_x().func_110434_K().func_229263_a_(this.nativeImageTexture.getResourceLocation(), (Texture)this.nativeImageTexture);
                }
                catch (IOException e) {
                    iChunUtil.LOGGER.error("Failed to read NativeImage for project: " + this.name);
                    e.printStackTrace();
                }
            }
            return this.nativeImageTexture.getResourceLocation();
        }
        return null;
    }

    public byte[] getTextureBytes() {
        return this.textureBytes;
    }

    public ArrayList<Part.Box> getAllBoxes() {
        ArrayList<Part.Box> boxes = new ArrayList<Part.Box>();
        for (Part part : this.parts) {
            part.addAllBoxes(boxes);
        }
        return boxes;
    }

    public ArrayList<Part> getAllParts() {
        ArrayList<Part> parts = new ArrayList<Part>(this.parts);
        for (Part part : this.parts) {
            part.addAllParts(parts);
        }
        return parts;
    }

    public void load() {
        this.repair();
        this.adoptChildren();
    }

    public void repair() {
        while (this.projVersion < 5) {
            ++this.projVersion;
        }
    }

    public static boolean saveProject(Project project, File file) {
        try {
            file.getParentFile().mkdirs();
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(file));
            out.setLevel(9);
            out.putNextEntry(new ZipEntry("model.json"));
            byte[] data = SIMPLE_GSON.toJson((Object)project).getBytes();
            out.write(data, 0, data.length);
            out.closeEntry();
            if (project.textureBytes != null) {
                out.putNextEntry(new ZipEntry("texture.png"));
                out.write(project.textureBytes, 0, project.textureBytes.length);
                out.closeEntry();
            }
            out.close();
            project.saveFile = file;
            project.isDirty = false;
            return true;
        }
        catch (Exception e) {
            iChunUtil.LOGGER.error("Failed to save model: {}", (Object)(project.name + " - " + project.author));
            e.printStackTrace();
            return false;
        }
    }

    public void addPart(Identifiable<?> parent, Part part) {
        if (parent instanceof Part) {
            part.parent = parent;
            ((Part)parent).children.add(part);
        } else if (parent instanceof Part.Box) {
            this.addPart(parent.parent, part);
        } else {
            part.parent = this;
            this.parts.add(part);
        }
    }

    public void addBox(Identifiable<?> parent, Part.Box box) {
        if (parent instanceof Part) {
            box.parent = parent;
            ((Part)parent).boxes.add(box);
        } else if (parent instanceof Part.Box) {
            this.addBox(parent.parent, box);
        } else {
            Part part = new Part(this, ++this.partCountProjectLife);
            part.boxes.clear();
            this.parts.add(part);
            this.addBox(part, box);
        }
    }

    public void delete(Identifiable<?> child) {
        Identifiable<?> parent = child.parent;
        if (parent instanceof Project) {
            ((Project)parent).parts.remove(child);
        } else if (parent instanceof Part) {
            ((Part)parent).boxes.remove(child);
            ((Part)parent).children.remove(child);
        }
    }

    public static class Part
    extends Identifiable<Part> {
        public ArrayList<String> notes = new ArrayList();
        public int texWidth = 64;
        public int texHeight = 32;
        public boolean matchProject = true;
        public int texOffX;
        public int texOffY;
        public float rotPX;
        public float rotPY;
        public float rotPZ;
        public float rotAX;
        public float rotAY;
        public float rotAZ;
        public boolean mirror;
        public boolean showModel = true;
        public ArrayList<Box> boxes = new ArrayList();
        public ArrayList<Part> children = new ArrayList();

        public Part(Identifiable<?> parent, int count) {
            this.parent = parent;
            this.boxes.add(new Box(this));
            this.name = "part" + count;
        }

        @Override
        public Identifiable<?> getById(String id) {
            Identifiable<?> ident;
            for (Box box : this.boxes) {
                ident = box.getById(id);
                if (ident == null) continue;
                return ident;
            }
            for (Part part : this.children) {
                ident = part.getById(id);
                if (ident == null) continue;
                return ident;
            }
            return this.identifier.equals(id) ? this : null;
        }

        @Override
        public String getJsonWithoutChildren() {
            ArrayList<Box> boxes = this.boxes;
            ArrayList<Part> children = this.children;
            this.boxes = null;
            this.children = null;
            String json = SIMPLE_GSON.toJson((Object)this);
            this.boxes = boxes;
            this.children = children;
            return json;
        }

        @Override
        public void adoptChildren() {
            for (Box box : this.boxes) {
                box.parent = this;
                box.adoptChildren();
            }
            for (Part part : this.children) {
                part.parent = this;
                part.adoptChildren();
            }
        }

        @Override
        public void disown(Identifiable<?> child) {
            if (!(this.boxes.remove(child) | this.children.remove(child))) {
                for (Part part : this.children) {
                    part.disown(child);
                }
            } else {
                child.parent = null;
            }
        }

        @Override
        public void adopt(Identifiable<?> child) {
            if (child instanceof Part) {
                this.children.add((Part)child);
                child.parent = this;
            } else if (child instanceof Box) {
                this.boxes.add((Box)child);
                child.parent = this;
            }
        }

        @Override
        public boolean rearrange(Identifiable<?> before, Identifiable<?> child) {
            if (before == child) {
                return true;
            }
            if (child instanceof Part && this.children.contains(child) && this.children.remove(child)) {
                if (before == this) {
                    this.children.add(0, (Part)child);
                } else {
                    for (int i = 0; i < this.children.size(); ++i) {
                        if (this.children.get(i) != before) continue;
                        this.children.add(i + 1, (Part)child);
                    }
                }
                return true;
            }
            if (child instanceof Box && this.boxes.contains(child) && this.boxes.remove(child)) {
                if (before == this) {
                    this.boxes.add(0, (Box)child);
                } else {
                    for (int i = 0; i < this.boxes.size(); ++i) {
                        if (this.boxes.get(i) != before) continue;
                        this.boxes.add(i + 1, (Box)child);
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public void witnessProtectionProgramme() {
            this.identifier = RandomStringUtils.randomAscii((int)20);
            this.boxes.forEach(Identifiable::witnessProtectionProgramme);
            this.children.forEach(Identifiable::witnessProtectionProgramme);
        }

        @Override
        public Part clone() {
            Part part = (Part)SIMPLE_GSON.fromJson(SIMPLE_GSON.toJson((Object)this), Part.class);
            part.adoptChildren();
            return part;
        }

        public int[] getProjectTextureDims() {
            if (this.parent instanceof Part) {
                return ((Part)this.parent).getProjectTextureDims();
            }
            if (this.parent instanceof Project) {
                return new int[]{((Project)this.parent).texWidth, ((Project)this.parent).texHeight};
            }
            iChunUtil.LOGGER.error("We can't find out parent's texture dimensions, we have an orphaned Part. Uh oh! Their name is {} and their identifier is {}", (Object)this.name, (Object)this.identifier);
            return new int[]{this.texWidth, this.texHeight};
        }

        public void addAllBoxes(ArrayList<Box> boxes) {
            boxes.addAll(this.boxes);
            for (Part child : this.children) {
                child.addAllBoxes(boxes);
            }
        }

        public void addAllParts(ArrayList<Part> parts) {
            parts.addAll(this.children);
            for (Part child : this.children) {
                child.addAllParts(parts);
            }
        }

        public void resetPositions() {
            this.rotPZ = 0.0f;
            this.rotPY = 0.0f;
            this.rotPX = 0.0f;
            this.children.forEach(Part::resetPositions);
        }

        public static class Box
        extends Identifiable<Box> {
            public float posX;
            public float posY;
            public float posZ;
            public float dimX = 1.0f;
            public float dimY = 1.0f;
            public float dimZ = 1.0f;
            public float expandX;
            public float expandY;
            public float expandZ;
            public int texOffX;
            public int texOffY;

            public Box(Identifiable<?> parent) {
                this.parent = parent;
                this.name = "Box";
            }

            @Override
            public Identifiable<?> getById(String id) {
                return this.identifier.equals(id) ? this : null;
            }

            @Override
            public String getJsonWithoutChildren() {
                return SIMPLE_GSON.toJson((Object)this);
            }

            @Override
            public void adoptChildren() {
            }

            @Override
            public void disown(Identifiable<?> child) {
            }

            @Override
            public void adopt(Identifiable<?> child) {
            }

            @Override
            public boolean rearrange(Identifiable<?> before, Identifiable<?> child) {
                return false;
            }

            @Override
            public void witnessProtectionProgramme() {
                this.identifier = RandomStringUtils.randomAscii((int)20);
            }

            @Override
            public Box clone() {
                Box box = (Box)SIMPLE_GSON.fromJson(SIMPLE_GSON.toJson((Object)this), Box.class);
                box.adoptChildren();
                return box;
            }
        }
    }
}

