/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.core;

import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import me.ichun.mods.ichunutil.client.core.ResourceHelper;
import me.ichun.mods.ichunutil.client.gui.bns.Theme;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrainable;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementDropdownContextMenu;
import me.ichun.mods.ichunutil.common.config.ConfigBase;
import me.ichun.mods.ichunutil.common.config.annotations.CategoryDivider;
import me.ichun.mods.ichunutil.common.config.annotations.Prop;
import net.minecraftforge.fml.config.ModConfig;

public class ConfigClient
extends ConfigBase {
    @CategoryDivider(name="bns")
    @Prop
    public boolean guiStyleMinecraft = false;
    @Prop(min=0.0, max=50.0)
    public int guiDockPadding = 0;
    @Prop(min=0.0)
    public int guiTooltipCooldown = 20;
    @Prop(min=1.0)
    public int guiDockBorder = 8;
    @Prop(min=1.0)
    public int guiDoubleClickSpeed = 10;
    @Prop(guiElementOverride="iChunUtil:guiDefaultTheme")
    public String guiDefaultTheme = "default";
    @CategoryDivider(name="clientOnly")
    @Prop
    public boolean easterEgg = true;
    @Prop
    public boolean buttonOptionsShiftOpensMods = true;
    @CategoryDivider(name="headTracking")
    @Prop(min=0.0, max=2.0)
    public int aggressiveHeadTracking = 1;
    @Prop
    public boolean horseEasterEgg = true;

    @Override
    public <T extends ConfigBase> T init() {
        GUI_ELEMENT_OVERRIDES.put("iChunUtil:guiDefaultTheme", (value, item) -> {
            Object o;
            Field field = value.value.field;
            field.setAccessible(true);
            try {
                o = field.get(value.value.parent);
            }
            catch (IllegalAccessException e) {
                return;
            }
            ArrayList<File> files = new ArrayList<File>();
            File[] themes = ResourceHelper.getThemesDir().toFile().listFiles();
            if (themes != null) {
                for (File file : themes) {
                    if (file.isDirectory() || !file.getName().endsWith(".json")) continue;
                    files.add(file);
                }
            }
            Collections.sort(files);
            ElementDropdownContextMenu input = new ElementDropdownContextMenu((Fragment)item, o.toString(), (List<?>)files, (menu, listItem) -> {
                if (listItem.selected) {
                    ElementDropdownContextMenu contextMenu = (ElementDropdownContextMenu)menu;
                    File file = (File)listItem.getObject();
                    contextMenu.text = file.getName().substring(0, file.getName().length() - 5);
                    try {
                        FileInputStream con = new FileInputStream(file);
                        String data = new String(ByteStreams.toByteArray((InputStream)con));
                        ((InputStream)con).close();
                        Theme theme = (Theme)new Gson().fromJson(data, Theme.class);
                        if (theme != null) {
                            field.set(value.value.parent, contextMenu.text);
                            Theme.loadTheme(theme);
                        }
                    }
                    catch (IOException | IllegalAccessException exception) {
                        // empty catch block
                    }
                }
            }).setNameProvider(o1 -> ((File)o1).getName().substring(0, ((File)o1).getName().length() - 5));
            input.setSize(80, 14);
            input.setConstraint(new Constraint(input).top((IConstrainable)item, Constraint.Property.Type.TOP, 3).bottom((IConstrainable)item, Constraint.Property.Type.BOTTOM, 3).right((IConstrainable)item, Constraint.Property.Type.RIGHT, 8));
            item.addElement(input);
        });
        return super.init();
    }

    @Override
    public void onConfigLoaded() {
        File file = new File(ResourceHelper.getThemesDir().toFile(), this.guiDefaultTheme + ".json");
        if (file.exists()) {
            try {
                FileInputStream con = new FileInputStream(file);
                String data = new String(ByteStreams.toByteArray((InputStream)con));
                ((InputStream)con).close();
                Theme theme = (Theme)new Gson().fromJson(data, Theme.class);
                if (theme != null) {
                    Theme.loadTheme(theme);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    @Nonnull
    public String getModId() {
        return "ichunutil";
    }

    @Override
    @Nonnull
    public String getConfigName() {
        return "iChunUtil";
    }

    @Override
    @Nonnull
    public ModConfig.Type getConfigType() {
        return ModConfig.Type.CLIENT;
    }
}

