/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.constraint;

import javax.annotation.Nonnull;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrainable;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrained;
import net.minecraft.util.Direction;

public class Constraint {
    public static final Constraint NONE = new Constraint(null);
    protected final IConstrained parent;
    private Property left;
    private Property right;
    private Property top;
    private Property bottom;

    public Constraint(IConstrained parent) {
        this.parent = parent;
        this.top = this.bottom = Property.NONE;
        this.right = this.bottom;
        this.left = this.bottom;
    }

    public Constraint left(IConstrainable c, Property.Type type, int i) {
        this.left = c == null ? Property.NONE : new Property(c, Property.Type.LEFT, type, i);
        return this;
    }

    public Constraint right(IConstrainable c, Property.Type type, int i) {
        this.right = c == null ? Property.NONE : new Property(c, Property.Type.RIGHT, type, i);
        return this;
    }

    public Constraint top(IConstrainable c, Property.Type type, int i) {
        this.top = c == null ? Property.NONE : new Property(c, Property.Type.TOP, type, i);
        return this;
    }

    public Constraint bottom(IConstrainable c, Property.Type type, int i) {
        this.bottom = c == null ? Property.NONE : new Property(c, Property.Type.BOTTOM, type, i);
        return this;
    }

    public Constraint type(Property.Type link, IConstrainable c, Property.Type type, int i) {
        switch (link) {
            case LEFT: {
                return this.left(c, type, i);
            }
            case RIGHT: {
                return this.right(c, type, i);
            }
            case TOP: {
                return this.top(c, type, i);
            }
            case BOTTOM: {
                return this.bottom(c, type, i);
            }
        }
        return this;
    }

    public Property get(Property.Type type) {
        switch (type) {
            case LEFT: {
                return this.left;
            }
            case RIGHT: {
                return this.right;
            }
            case TOP: {
                return this.top;
            }
        }
        return this.bottom;
    }

    public boolean hasLeft() {
        return this.left != Property.NONE;
    }

    public boolean hasRight() {
        return this.right != Property.NONE;
    }

    public boolean hasTop() {
        return this.top != Property.NONE;
    }

    public boolean hasBottom() {
        return this.bottom != Property.NONE;
    }

    public static Constraint matchParent(@Nonnull IConstrained c1, @Nonnull IConstrainable c, int i) {
        return new Constraint(c1).left(c, Property.Type.LEFT, i).right(c, Property.Type.RIGHT, i).top(c, Property.Type.TOP, i).bottom(c, Property.Type.BOTTOM, i);
    }

    public static Constraint sizeOnly(@Nonnull IConstrained c) {
        return new Constraint(c){

            @Override
            public void apply() {
                this.parent.contractX(this.parent.getMaxWidth());
                this.parent.contractY(this.parent.getMaxHeight());
                this.parent.expandX(this.parent.getMinWidth());
                this.parent.expandY(this.parent.getMinHeight());
            }
        };
    }

    public void apply() {
        if (this.parent != null) {
            IConstrainable attachment;
            this.parent.contractX(this.parent.getMaxWidth());
            this.parent.contractY(this.parent.getMaxHeight());
            this.parent.expandX(this.parent.getMinWidth());
            this.parent.expandY(this.parent.getMinHeight());
            if (!(this.left.apply(this) | this.right.apply(this))) {
                if (this.hasTop() || this.hasBottom()) {
                    attachment = this.hasTop() ? this.top.reference : this.bottom.reference;
                    this.parent.setLeft(attachment.getLeft() + (attachment.getRight() - attachment.getLeft() - this.parent.getWidth()) / 2);
                } else {
                    this.parent.setPosX((this.parent.getParentWidth() - this.parent.getWidth()) / 2);
                }
            }
            if (!(this.top.apply(this) | this.bottom.apply(this))) {
                if (this.hasLeft() || this.hasRight()) {
                    attachment = this.hasLeft() ? this.left.reference : this.right.reference;
                    this.parent.setTop(attachment.getTop() + (attachment.getBottom() - attachment.getTop() - this.parent.getHeight()) / 2);
                } else {
                    this.parent.setPosY((this.parent.getParentHeight() - this.parent.getHeight()) / 2);
                }
            }
            this.parent.contractX(this.parent.getMaxWidth());
            this.parent.contractY(this.parent.getMaxHeight());
            this.parent.expandX(this.parent.getMinWidth());
            this.parent.expandY(this.parent.getMinHeight());
        }
    }

    public static class Property {
        public static final Property NONE = new Property(null, null, null, 0){

            @Override
            public boolean apply(Constraint c) {
                return false;
            }
        };
        private IConstrainable reference;
        private Type self;
        private Type type;
        private int dist;

        public Property(IConstrainable reference, Type self, Type type, int dist) {
            this.reference = reference;
            this.self = self;
            this.type = type;
            this.dist = dist;
        }

        public boolean apply(Constraint c) {
            switch (this.self) {
                case LEFT: {
                    c.parent.setLeft(this.type.get(this.reference) + this.dist);
                    if (c.hasRight()) {
                        c.right.apply(c);
                    }
                    return true;
                }
                case RIGHT: {
                    if (c.hasLeft()) {
                        c.parent.setRight(this.type.get(this.reference) - this.dist);
                    } else {
                        c.parent.setLeft(this.type.get(this.reference) - this.dist - c.parent.getWidth());
                    }
                    return true;
                }
                case TOP: {
                    c.parent.setTop(this.type.get(this.reference) + this.dist);
                    if (c.hasBottom()) {
                        c.bottom.apply(c);
                    }
                    return true;
                }
                case BOTTOM: {
                    if (c.hasTop()) {
                        c.parent.setBottom(this.type.get(this.reference) - this.dist);
                    } else {
                        c.parent.setTop(this.type.get(this.reference) - this.dist - c.parent.getHeight());
                    }
                    return true;
                }
            }
            return false;
        }

        public IConstrainable getReference() {
            return this.reference;
        }

        public Type getType() {
            return this.type;
        }

        public int getDist() {
            return this.dist;
        }

        public static enum Type {
            LEFT,
            RIGHT,
            TOP,
            BOTTOM;


            public int get(IConstrainable reference) {
                switch (this) {
                    case LEFT: {
                        return reference.getLeft();
                    }
                    case RIGHT: {
                        return reference.getRight();
                    }
                    case TOP: {
                        return reference.getTop();
                    }
                    case BOTTOM: {
                        return reference.getBottom();
                    }
                }
                return -1;
            }

            public Type getOpposite() {
                switch (this) {
                    case LEFT: {
                        return RIGHT;
                    }
                    case RIGHT: {
                        return LEFT;
                    }
                    case TOP: {
                        return BOTTOM;
                    }
                }
                return TOP;
            }

            public Direction.Axis getAxis() {
                switch (this) {
                    case LEFT: 
                    case RIGHT: {
                        return Direction.Axis.X;
                    }
                    case TOP: 
                    case BOTTOM: {
                        return Direction.Axis.Y;
                    }
                }
                return Direction.Axis.Z;
            }
        }
    }
}

