/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.view.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.client.gui.bns.Theme;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementClickable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;

public class ElementToggle<T extends ElementToggle>
extends ElementClickable<T> {
    public String text;
    public boolean toggleState;

    public ElementToggle(@Nonnull Fragment parent, @Nonnull String s, Consumer<T> callback) {
        super(parent, callback);
        this.text = I18n.func_135052_a((String)s, (Object[])new Object[0]);
    }

    public <T extends ElementToggle<?>> T setToggled(boolean flag) {
        this.toggleState = flag;
        return (T)this;
    }

    @Override
    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTick) {
        super.func_230430_a_(stack, mouseX, mouseY, partialTick);
        if (this.renderMinecraftStyle()) {
            ElementToggle.renderMinecraftStyleButton(stack, this.getLeft(), this.getTop(), this.width, this.height, this.parentFragment.func_231041_ay__() && this.parentFragment.func_241217_q_() == this ? Element.ButtonState.CLICK : (this.hover ? Element.ButtonState.HOVER : Element.ButtonState.IDLE));
        } else {
            this.fill(stack, this.getTheme().elementButtonBorder, 0);
            int[] colour = this.parentFragment.func_231041_ay__() && this.parentFragment.func_241217_q_() == this ? this.getTheme().elementButtonClick : (this.toggleState && this.hover ? this.getTheme().elementButtonToggleHover : (this.hover ? this.getTheme().elementButtonBackgroundHover : (this.toggleState ? this.getTheme().elementButtonToggle : this.getTheme().elementButtonBackgroundInactive)));
            this.fill(stack, colour, 1);
        }
        this.renderText(stack);
    }

    public void renderText(MatrixStack stack) {
        if (!this.text.isEmpty()) {
            String s = this.reString(this.text, this.width - 4);
            if (this.renderMinecraftStyle()) {
                FontRenderer fontRenderer = this.getFontRenderer();
                float f = (float)this.getLeft() + (float)(this.width - this.getFontRenderer().func_78256_a(s)) / 2.0f;
                float f2 = this.getTop();
                this.getFontRenderer().getClass();
                fontRenderer.func_238405_a_(stack, s, f, f2 + (float)(this.height - 9) / 2.0f + 1.0f, this.getMinecraftFontColour());
            } else {
                FontRenderer fontRenderer = this.getFontRenderer();
                float f = (float)this.getLeft() + (float)(this.width - this.getFontRenderer().func_78256_a(s)) / 2.0f;
                float f3 = this.getTop();
                this.getFontRenderer().getClass();
                fontRenderer.func_238421_b_(stack, s, f, f3 + (float)(this.height - 9) / 2.0f + 1.0f, Theme.getAsHex(this.toggleState ? this.getTheme().font : this.getTheme().fontDim));
            }
        }
    }

    @Override
    @Nullable
    public String tooltip(double mouseX, double mouseY) {
        String s;
        if (!this.text.isEmpty() && !(s = this.reString(this.text, this.width - 4)).equals(this.text)) {
            String tooltip = super.tooltip(mouseX, mouseY);
            if (tooltip != null) {
                return this.text + " - " + tooltip;
            }
            return this.text;
        }
        return super.tooltip(mouseX, mouseY);
    }

    @Override
    public void onClickRelease() {
        this.toggleState = !this.toggleState;
    }

    @Override
    public int getMinWidth() {
        return 14;
    }

    @Override
    public int getMinHeight() {
        return 14;
    }
}

