/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.head.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import me.ichun.mods.ichunutil.client.head.HeadBase;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.WitherModel;
import net.minecraft.entity.boss.WitherEntity;

public class HeadWither
extends HeadBase<WitherEntity> {
    public float[] headJointSideHeadLeft = new float[]{-0.625f, -0.25f, 0.0f};
    public float[] headJointSideHeadRight = new float[]{0.5f, -0.25f, 0.0f};
    public float[] eyeOffsetSideHead = new float[]{0.0625f, 0.125f, 0.25f};
    public float halfInterpupillaryDistanceSideHead = 0.15625f;
    public float eyeScaleSideHead = 0.75f;

    public HeadWither() {
        this.headJoint = new float[]{0.0f, 0.0f, 0.0f};
        this.eyeOffset = new float[]{0.0f, 0.0f, 0.25f};
        this.halfInterpupillaryDistance = 0.125f;
        this.eyeScale = 1.0f;
    }

    @Override
    public int getEyeCount(WitherEntity living) {
        return 6;
    }

    @Override
    public float getEyeScale(WitherEntity living, MatrixStack stack, float partialTick, int eye) {
        if (eye > 1) {
            return this.eyeScaleSideHead;
        }
        return this.eyeScale;
    }

    @Override
    public float getHeadYaw(WitherEntity living, MatrixStack stack, float partialTick, int eye) {
        if (eye <= 1) {
            return super.getHeadYaw(living, stack, partialTick, eye);
        }
        return living.func_82207_a(eye <= 3 ? 1 : 0) - (living.field_70760_ar + (living.field_70761_aq - living.field_70760_ar) * partialTick);
    }

    @Override
    public float getHeadPitch(WitherEntity living, MatrixStack stack, float partialTick, int eye) {
        if (eye <= 1) {
            return super.getHeadPitch(living, stack, partialTick, eye);
        }
        return living.func_82210_r(eye <= 3 ? 1 : 0);
    }

    @Override
    public float getEyeSideOffset(WitherEntity living, MatrixStack stack, float partialTick, int eye) {
        if (eye <= 1) {
            return eye % 2 == 0 ? this.halfInterpupillaryDistance : -this.halfInterpupillaryDistance;
        }
        return eye % 2 == 0 ? this.halfInterpupillaryDistanceSideHead : -this.halfInterpupillaryDistanceSideHead;
    }

    @Override
    public float[] getEyeOffsetFromJoint(WitherEntity living, MatrixStack stack, float partialTick, int eye) {
        if (eye <= 1) {
            return this.eyeOffset;
        }
        return this.eyeOffsetSideHead;
    }

    @Override
    public float[] getHeadJointOffset(WitherEntity living, MatrixStack stack, float partialTick, int eye) {
        if (eye <= 1) {
            return super.getHeadJointOffset(living, stack, partialTick, eye);
        }
        if (eye <= 3) {
            return this.headJointSideHeadLeft;
        }
        return this.headJointSideHeadRight;
    }

    @Override
    protected void setHeadModelFromRenderer(LivingRenderer renderer) {
        EntityModel model = renderer.func_217764_d();
        if (model instanceof WitherModel) {
            this.headModel = ((WitherModel)model).field_82904_b;
        }
    }
}

