/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

import minecrafttransportsimulator.systems.SFXSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.APartEngine;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;

public final class VehicleSound {
    private final EntityVehicleE_Powered vehicle;
    private final APart optionalPart;
    private final EntityPlayer player;
    private final SoundTypes soundType;
    private Vec3d playerPos;
    private Vec3d sourcePos;

    public VehicleSound(EntityVehicleE_Powered vehicle, APart optionalPart, SoundTypes soundType) {
        this.vehicle = vehicle;
        this.optionalPart = optionalPart;
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.soundType = soundType;
        this.playerPos = new Vec3d(this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v);
        this.sourcePos = optionalPart != null ? optionalPart.partPos : vehicle.func_174791_d();
    }

    public float getPosX() {
        return (float)(this.optionalPart != null ? this.optionalPart.partPos.field_72450_a : this.vehicle.field_70165_t);
    }

    public float getPosY() {
        return (float)(this.optionalPart != null ? this.optionalPart.partPos.field_72448_b : this.vehicle.field_70163_u);
    }

    public float getPosZ() {
        return (float)(this.optionalPart != null ? this.optionalPart.partPos.field_72449_c : this.vehicle.field_70161_v);
    }

    public float getMotX() {
        return (float)(this.vehicle.field_70159_w * this.vehicle.speedFactor);
    }

    public float getMotY() {
        return (float)(this.vehicle.field_70181_x * this.vehicle.speedFactor);
    }

    public float getMotZ() {
        return (float)(this.vehicle.field_70179_y * this.vehicle.speedFactor);
    }

    public float getVolume() {
        if (this.isSoundActive()) {
            if (this.vehicle.equals(this.player.func_184187_bx())) {
                return SFXSystem.isPlayerInsideEnclosedVehicle() ? 0.5f : 1.0f;
            }
            this.playerPos = new Vec3d(this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v);
            this.sourcePos = this.optionalPart != null ? this.optionalPart.partPos : this.vehicle.func_174791_d();
            return (float)((double)this.getCurrentVolume() / this.playerPos.func_72438_d(this.sourcePos) * (double)(SFXSystem.isPlayerInsideEnclosedVehicle() ? 0.5f : 1.0f));
        }
        return 0.0f;
    }

    public float getPitch() {
        if (this.vehicle.equals(this.player.func_184187_bx())) {
            return this.getCurrentPitch();
        }
        this.sourcePos = this.optionalPart != null ? this.optionalPart.partPos : this.vehicle.func_174791_d();
        this.playerPos = new Vec3d(this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v);
        double soundVelocity = this.playerPos.func_72438_d(this.sourcePos) - this.playerPos.func_72441_c(this.player.field_70159_w, this.player.field_70181_x, this.player.field_70179_y).func_72438_d(this.sourcePos.func_72441_c(this.vehicle.field_70159_w, this.vehicle.field_70181_x, this.vehicle.field_70179_y));
        return (float)((double)this.getCurrentPitch() * (1.0 + soundVelocity / 10.0));
    }

    public String getSoundName() {
        switch (this.soundType) {
            case ENGINE: {
                return this.optionalPart.partName + "_running";
            }
            case HORN: {
                return this.vehicle.pack.motorized.hornSound;
            }
            case SIREN: {
                return this.vehicle.pack.motorized.sirenSound;
            }
        }
        return "";
    }

    public String getSoundUniqueName() {
        return this.vehicle.func_145782_y() + "_" + (this.optionalPart != null ? this.getSoundName() + String.valueOf(this.optionalPart.offset.field_72450_a) + String.valueOf(this.optionalPart.offset.field_72448_b) + String.valueOf(this.optionalPart.offset.field_72449_c) : this.getSoundName());
    }

    public boolean isSoundSourceActive() {
        return this.vehicle.field_70128_L ? false : (this.optionalPart != null ? this.optionalPart.isValid() : true);
    }

    public boolean isSoundActive() {
        switch (this.soundType) {
            case ENGINE: {
                return ((APartEngine)this.optionalPart).state.running || ((APartEngine)this.optionalPart).internalFuel > 0;
            }
            case HORN: {
                return this.vehicle.hornOn;
            }
            case SIREN: {
                return this.vehicle.sirenOn;
            }
        }
        return true;
    }

    private float getCurrentVolume() {
        switch (this.soundType) {
            case ENGINE: {
                return (float)(30.0 * ((APartEngine)this.optionalPart).RPM / 2000.0);
            }
            case HORN: {
                return 5.0f;
            }
            case SIREN: {
                return 10.0f;
            }
        }
        return 1.0f;
    }

    private float getCurrentPitch() {
        switch (this.soundType) {
            case ENGINE: {
                return (float)(((APartEngine)this.optionalPart).RPM / (double)((float)this.optionalPart.pack.engine.maxRPM / 2.0f));
            }
        }
        return 1.0f;
    }

    public static enum SoundTypes {
        ENGINE,
        HORN,
        SIREN;

    }
}

