/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.core;

import javax.annotation.Nullable;
import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.blocks.core.TileEntityBase;
import minecrafttransportsimulator.packets.general.PacketChat;
import minecrafttransportsimulator.packets.tileentities.PacketFuelPumpConnection;
import minecrafttransportsimulator.packets.tileentities.PacketFuelPumpFillDrain;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityFuelPump
extends TileEntityBase
implements IFluidTank,
IFluidHandler,
ITickable {
    private EntityVehicleE_Powered connectedVehicle;
    public int totalTransfered;
    private FluidTankInfo tankInfo = emptyTankInfo;
    private static final FluidTankInfo emptyTankInfo = new FluidTankInfo(null, 15000);

    public void func_73660_a() {
        if (this.connectedVehicle != null) {
            if (this.connectedVehicle.field_70128_L) {
                this.setConnectedVehicle(null);
                return;
            }
            if ((double)this.connectedVehicle.pack.motorized.fuelCapacity - this.connectedVehicle.fuel >= 10.0) {
                if (this.tankInfo.fluid != null) {
                    int fuelToFill = Math.min(this.tankInfo.fluid.amount, 10);
                    this.tankInfo.fluid.amount -= fuelToFill;
                    this.connectedVehicle.fuel += (double)fuelToFill;
                    this.totalTransfered += fuelToFill;
                    if (this.tankInfo.fluid.amount == 0) {
                        this.setConnectedVehicle(null);
                        this.tankInfo = emptyTankInfo;
                        if (!this.field_145850_b.field_72995_K) {
                            MTS.MTSNet.sendToAllAround((IMessage)new PacketChat("interact.fuelpump.empty"), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 16.0));
                        }
                    }
                } else {
                    this.setConnectedVehicle(null);
                    if (!this.field_145850_b.field_72995_K) {
                        MTS.MTSNet.sendToAllAround((IMessage)new PacketChat("interact.fuelpump.empty"), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 16.0));
                    }
                }
            } else {
                this.setConnectedVehicle(null);
                if (!this.field_145850_b.field_72995_K) {
                    MTS.MTSNet.sendToAllAround((IMessage)new PacketChat("interact.fuelpump.complete"), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 16.0));
                }
            }
        }
    }

    public void setFluid(Fluid fluid) {
        this.tankInfo = new FluidTankInfo(new FluidStack(fluid, 0), TileEntityFuelPump.emptyTankInfo.capacity);
    }

    public EntityVehicleE_Powered getConnectedVehicle() {
        return this.connectedVehicle;
    }

    public void setConnectedVehicle(EntityVehicleE_Powered vehicle) {
        if (vehicle == null) {
            this.connectedVehicle = null;
        } else {
            this.connectedVehicle = vehicle;
            this.totalTransfered = 0;
        }
        if (!this.field_145850_b.field_72995_K) {
            MTS.MTSNet.sendToAll((IMessage)new PacketFuelPumpConnection(this, this.connectedVehicle != null ? this.connectedVehicle.func_145782_y() : -1, this.tankInfo.fluid != null ? this.tankInfo.fluid.amount : 0, this.totalTransfered));
        }
    }

    public IFluidTankProperties[] getTankProperties() {
        return FluidTankProperties.convert((FluidTankInfo[])new FluidTankInfo[]{this.tankInfo});
    }

    public FluidStack getFluid() {
        return this.tankInfo.fluid;
    }

    public int getFluidAmount() {
        return this.tankInfo.fluid.amount;
    }

    public int getCapacity() {
        return this.tankInfo.capacity;
    }

    public FluidTankInfo getInfo() {
        return this.tankInfo;
    }

    public int fill(FluidStack stack, boolean doFill) {
        if (this.tankInfo.fluid == null || stack.isFluidEqual(this.tankInfo.fluid)) {
            double fuelFactor = ConfigSystem.getFuelValue(FluidRegistry.getFluidName((Fluid)stack.getFluid()));
            int amountAbleToFill = this.tankInfo.capacity - (this.tankInfo.fluid != null ? this.tankInfo.fluid.amount : 0);
            int amountToFill = (int)Math.min((double)amountAbleToFill, (double)stack.amount * fuelFactor);
            if (doFill) {
                if (this.tankInfo.fluid == null) {
                    this.setFluid(stack.getFluid());
                }
                this.tankInfo.fluid.amount += amountToFill;
                FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidFillingEvent(this.tankInfo.fluid, this.field_145850_b, this.func_174877_v(), (IFluidTank)this, amountToFill));
                MTS.MTSNet.sendToAll((IMessage)new PacketFuelPumpFillDrain(this, new FluidStack(this.tankInfo.fluid, amountToFill)));
            }
            return amountToFill;
        }
        return 0;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidStack drain(FluidStack stack, boolean doDrain) {
        return null;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (facing != null) {
            if (facing.equals((Object)EnumFacing.DOWN)) {
                return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
            }
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing != null) {
            if (facing.equals((Object)EnumFacing.DOWN) && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)((Object)this);
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.totalTransfered = tagCompound.func_74762_e("totalTransfered");
        this.tankInfo = !tagCompound.func_74764_b("Empty") ? new FluidTankInfo(FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound), TileEntityFuelPump.emptyTankInfo.capacity) : emptyTankInfo;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("totalTransfered", this.totalTransfered);
        if (this.tankInfo.fluid != null) {
            this.tankInfo.fluid.writeToNBT(tagCompound);
        } else {
            tagCompound.func_74778_a("Empty", "");
        }
        return tagCompound;
    }
}

