/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.pole;

import java.util.List;
import javax.annotation.Nullable;
import minecrafttransportsimulator.dataclasses.MTSRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPoleNormal
extends Block {
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    private final AxisAlignedBB CENTER_AABB;
    private final AxisAlignedBB UP_AABB;
    private final AxisAlignedBB DOWN_AABB;
    private final AxisAlignedBB NORTH_AABB;
    private final AxisAlignedBB EAST_AABB;
    private final AxisAlignedBB SOUTH_AABB;
    private final AxisAlignedBB WEST_AABB;

    public BlockPoleNormal(float poleRadius) {
        super(Material.field_151576_e);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149647_a(MTSRegistry.coreTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
        this.CENTER_AABB = new AxisAlignedBB((double)(0.5f - poleRadius), (double)(0.5f - poleRadius), (double)(0.5f - poleRadius), (double)(0.5f + poleRadius), (double)(0.5f + poleRadius), (double)(0.5f + poleRadius));
        this.UP_AABB = new AxisAlignedBB((double)(0.5f - poleRadius), (double)(0.5f + poleRadius), (double)(0.5f - poleRadius), (double)(0.5f + poleRadius), 1.0, (double)(0.5f + poleRadius));
        this.DOWN_AABB = new AxisAlignedBB((double)(0.5f - poleRadius), 0.0, (double)(0.5f - poleRadius), (double)(0.5f + poleRadius), (double)(0.5f - poleRadius), (double)(0.5f + poleRadius));
        this.NORTH_AABB = new AxisAlignedBB((double)(0.5f - poleRadius), (double)(0.5f - poleRadius), 0.0, (double)(0.5f + poleRadius), (double)(0.5f + poleRadius), (double)(0.5f - poleRadius));
        this.EAST_AABB = new AxisAlignedBB((double)(0.5f + poleRadius), (double)(0.5f - poleRadius), (double)(0.5f - poleRadius), 1.0, (double)(0.5f + poleRadius), (double)(0.5f + poleRadius));
        this.SOUTH_AABB = new AxisAlignedBB((double)(0.5f - poleRadius), (double)(0.5f - poleRadius), (double)(0.5f + poleRadius), (double)(0.5f + poleRadius), (double)(0.5f + poleRadius), 1.0);
        this.WEST_AABB = new AxisAlignedBB(0.0, (double)(0.5f - poleRadius), (double)(0.5f - poleRadius), (double)(0.5f - poleRadius), (double)(0.5f + poleRadius), (double)(0.5f + poleRadius));
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity) {
        state = state.func_185899_b((IBlockAccess)world, pos);
        BlockPoleNormal.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.CENTER_AABB);
        if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
            BlockPoleNormal.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.UP_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            BlockPoleNormal.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.DOWN_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            BlockPoleNormal.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.NORTH_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            BlockPoleNormal.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.EAST_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            BlockPoleNormal.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.SOUTH_AABB);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            BlockPoleNormal.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.WEST_AABB);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess access, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            state = this.setStatesFor(state, access, pos, facing);
        }
        return state;
    }

    public boolean canConnectOnSide(IBlockAccess access, BlockPos pos, EnumFacing side) {
        return true;
    }

    protected IBlockState setStatesFor(IBlockState state, IBlockAccess access, BlockPos pos, EnumFacing facing) {
        IBlockState offsetState = access.func_180495_p(pos.func_177972_a(facing));
        Block block = offsetState.func_177230_c();
        boolean connected = block instanceof BlockPoleNormal ? ((BlockPoleNormal)block).canConnectOnSide(access, pos.func_177972_a(facing), facing.func_176734_d()) && this.canConnectOnSide(access, pos, facing) : false;
        switch (facing) {
            case UP: {
                return state.func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(connected));
            }
            case DOWN: {
                return state.func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(connected));
            }
            case NORTH: {
                return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(connected));
            }
            case EAST: {
                return state.func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(connected));
            }
            case SOUTH: {
                return state.func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(connected));
            }
            case WEST: {
                return state.func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(connected));
            }
        }
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{UP, DOWN, NORTH, EAST, SOUTH, WEST});
    }
}

