/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.ControlSystem;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;

public class GUIConfig
extends GuiScreen {
    private static final ResourceLocation background = new ResourceLocation("mts", "textures/guis/wide_blank.png");
    private boolean changedThisTick;
    private int guiLeft;
    private int guiTop;
    private GuiButton configScreenButton;
    private GuiButton controlScreenButton;
    private boolean configuringControls = true;
    private Map<GuiButton, ConfigButtons> configButtons = new HashMap<GuiButton, ConfigButtons>();
    private String vehicleConfiguring = "";
    private Map<GuiButton, String> vehicleSelectionButtons = new HashMap<GuiButton, String>();
    private GuiButton finishKeyboardBindingsButton;
    private boolean configuringKeyboard;
    private Map<ControlSystem.ControlsKeyboard, GuiTextField> keyboardBoxes = new HashMap<ControlSystem.ControlsKeyboard, GuiTextField>();
    private Map<GuiButton, Controller> joystickSelectionButtons = new HashMap<GuiButton, Controller>();
    private int scrollSpot = 0;
    private Controller joystick;
    private GuiButton componentListUpButton;
    private GuiButton componentListDownButton;
    private GuiButton deadzone_moreButton;
    private GuiButton deadzone_lessButton;
    private List<GuiButton> joystickComponentSelectionButtons = new ArrayList<GuiButton>();
    private boolean isDigital;
    private int joystickComponentId = -1;
    private GuiButton cancelAssignmentButton;
    private GuiButton clearAssignmentButton;
    private Map<GuiButton, ControlSystem.ControlsJoystick> digitalAssignButtons = new HashMap<GuiButton, ControlSystem.ControlsJoystick>();
    private Map<GuiButton, ControlSystem.ControlsJoystick> analogAssignButtons = new HashMap<GuiButton, ControlSystem.ControlsJoystick>();
    private boolean calibrating;
    private ControlSystem.ControlsJoystick controlCalibrating;
    private GuiButton confirmBoundsButton;
    private GuiButton invertAxisButton;
    private GuiTextField axisMinBoundsTextBox;
    private GuiTextField axisMaxBoundsTextBox;

    public GUIConfig() {
        this.field_146291_p = true;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - 256) / 2;
        this.guiTop = (this.field_146295_m - 192) / 2;
        this.initHeaderButtons();
        this.initConfigButtons();
        this.initVehicleSelectionButtons();
        this.initJoystickSelecionButtons();
        this.initJoystickComponentSelecionButtons();
        this.initAssignmentButtons();
    }

    public void func_73863_a(int mouseX, int mouseY, float renderPartialTicks) {
        this.changedThisTick = false;
        for (GuiTextField box : this.keyboardBoxes.values()) {
            box.func_146184_c(false);
        }
        for (GuiButton button : this.field_146292_n) {
            button.field_146124_l = false;
        }
        this.field_146297_k.func_110434_K().func_110577_a(background);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, 256, 192);
        this.configScreenButton.field_146124_l = this.configuringControls;
        this.controlScreenButton.field_146124_l = !this.configScreenButton.field_146124_l;
        this.configScreenButton.func_146112_a(this.field_146297_k, mouseX, mouseY);
        this.controlScreenButton.func_146112_a(this.field_146297_k, mouseX, mouseY);
        if (this.configuringControls) {
            if (this.vehicleConfiguring.isEmpty()) {
                this.drawVehicleSelectionScreen(mouseX, mouseY, renderPartialTicks);
            } else if (this.configuringKeyboard) {
                this.drawKeyboardScreen(mouseX, mouseY, renderPartialTicks);
            } else if (this.joystick == null) {
                this.drawJoystickSelectionScreen(mouseX, mouseY, renderPartialTicks);
            } else if (this.joystickComponentId == -1) {
                this.drawJoystickComponentSelectionScreen(mouseX, mouseY, renderPartialTicks);
            } else if (this.isDigital) {
                this.drawDigitalAssignmentScreen(mouseX, mouseY, renderPartialTicks);
            } else if (!this.calibrating) {
                this.drawAnalogAssignmentScreen(mouseX, mouseY, renderPartialTicks);
            } else {
                this.drawAnalogCalibrationScreen(mouseX, mouseY, renderPartialTicks);
            }
        } else {
            this.drawConfigScreen(mouseX, mouseY, renderPartialTicks);
        }
    }

    protected void func_146284_a(GuiButton buttonClicked) {
        try {
            super.func_146284_a(buttonClicked);
            if (!this.changedThisTick) {
                this.changedThisTick = true;
                if (buttonClicked.equals(this.configScreenButton)) {
                    this.configuringControls = false;
                    this.vehicleConfiguring = "";
                } else if (buttonClicked.equals(this.controlScreenButton)) {
                    this.configuringControls = true;
                } else if (this.configButtons.containsKey(buttonClicked)) {
                    ConfigSystem.setClientConfig(this.configButtons.get(buttonClicked).configName, Boolean.valueOf(buttonClicked.field_146126_j) == false);
                    buttonClicked.field_146126_j = String.valueOf(ConfigSystem.getBooleanConfig(this.configButtons.get(buttonClicked).configName));
                } else if (this.vehicleSelectionButtons.containsKey(buttonClicked)) {
                    String lookupString = this.vehicleSelectionButtons.get(buttonClicked);
                    this.vehicleConfiguring = lookupString.substring(0, lookupString.indexOf(46));
                    this.configuringKeyboard = lookupString.contains("keyboard");
                    this.initKeyboardBoxes();
                } else if (buttonClicked.equals(this.finishKeyboardBindingsButton)) {
                    this.vehicleConfiguring = "";
                } else if (this.joystickSelectionButtons.containsKey(buttonClicked)) {
                    this.joystick = this.joystickSelectionButtons.get(buttonClicked);
                    this.scrollSpot = 0;
                } else if (buttonClicked.equals(this.componentListUpButton)) {
                    this.scrollSpot -= 9;
                } else if (buttonClicked.equals(this.componentListDownButton)) {
                    this.scrollSpot += 9;
                } else if (buttonClicked.equals(this.deadzone_lessButton)) {
                    ConfigSystem.setClientConfig("JoystickDeadZone", Float.valueOf((float)((int)(ConfigSystem.getDoubleConfig("JoystickDeadZone") * 100.0) - 1) / 100.0f));
                } else if (buttonClicked.equals(this.deadzone_moreButton)) {
                    ConfigSystem.setClientConfig("JoystickDeadZone", Float.valueOf((float)((int)(ConfigSystem.getDoubleConfig("JoystickDeadZone") * 100.0) + 1) / 100.0f));
                } else if (this.joystickComponentSelectionButtons.contains(buttonClicked)) {
                    this.joystickComponentId = this.joystickComponentSelectionButtons.indexOf(buttonClicked) + this.scrollSpot;
                    boolean bl = this.isDigital = !this.joystick.getComponents()[this.joystickComponentId].isAnalog();
                    if (this.isDigital) {
                        this.initDigitalAssignmentButtons();
                    } else {
                        this.initAnalogAssignmentButtons();
                    }
                } else if (this.digitalAssignButtons.containsKey(buttonClicked)) {
                    ControlSystem.setControlJoystick(this.digitalAssignButtons.get(buttonClicked), this.joystick.getName(), this.joystickComponentId);
                    this.joystickComponentId = -1;
                } else if (this.analogAssignButtons.containsKey(buttonClicked)) {
                    this.controlCalibrating = this.analogAssignButtons.get(buttonClicked);
                    this.initAnalogCalibrationScreen();
                } else if (buttonClicked.equals(this.confirmBoundsButton)) {
                    boolean isInverted = this.invertAxisButton.field_146126_j.contains(I18n.func_135052_a((String)"gui.config.joystick.invert", (Object[])new Object[0]));
                    ControlSystem.setAxisJoystick(this.controlCalibrating, this.joystick.getName(), this.joystickComponentId, Double.valueOf(this.axisMinBoundsTextBox.func_146179_b()), Double.valueOf(this.axisMaxBoundsTextBox.func_146179_b()), isInverted);
                    this.joystickComponentId = -1;
                } else if (buttonClicked.equals(this.invertAxisButton)) {
                    this.invertAxisButton.field_146126_j = this.invertAxisButton.field_146126_j.contains(I18n.func_135052_a((String)"gui.config.joystick.invert", (Object[])new Object[0])) ? I18n.func_135052_a((String)"gui.config.joystick.axismode", (Object[])new Object[0]) + I18n.func_135052_a((String)"gui.config.joystick.normal", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.config.joystick.axismode", (Object[])new Object[0]) + I18n.func_135052_a((String)"gui.config.joystick.invert", (Object[])new Object[0]);
                } else if (buttonClicked.equals(this.cancelAssignmentButton)) {
                    this.joystickComponentId = -1;
                } else if (buttonClicked.equals(this.clearAssignmentButton)) {
                    for (ControlSystem.ControlsJoystick joystickControl : ControlSystem.ControlsJoystick.values()) {
                        if (!joystickControl.getCurrentJoystick().equals(this.joystick.getName()) || joystickControl.getCurrentButton() != this.joystickComponentId || !joystickControl.name().toLowerCase().contains(this.vehicleConfiguring)) continue;
                        ControlSystem.clearControlJoystick(joystickControl);
                        break;
                    }
                    this.joystickComponentId = -1;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        if (!this.changedThisTick) {
            for (GuiTextField box : this.keyboardBoxes.values()) {
                if (!box.func_146176_q()) continue;
                box.func_146192_a(x, y, button);
            }
        }
    }

    protected void func_73869_a(char key, int bytecode) throws IOException {
        super.func_73869_a(key, bytecode);
        if (bytecode != 1) {
            for (ControlSystem.ControlsKeyboard keyboardControl : this.keyboardBoxes.keySet()) {
                GuiTextField box = this.keyboardBoxes.get((Object)keyboardControl);
                if (!box.func_146206_l()) continue;
                box.func_146180_a(Keyboard.getKeyName((int)bytecode));
                ControlSystem.setKeyboardKey(keyboardControl, bytecode);
                box.func_146195_b(false);
            }
        }
    }

    private void drawConfigScreen(int mouseX, int mouseY, float renderPartialTicks) {
        for (GuiButton button : this.configButtons.keySet()) {
            button.field_146124_l = true;
            button.func_146112_a(this.field_146297_k, mouseX, mouseY);
            this.field_146289_q.func_175063_a(this.configButtons.get(button).formattedName, (float)(this.guiLeft + 10), (float)(button.field_146129_i + 5), Color.WHITE.getRGB());
        }
        for (GuiButton button : this.configButtons.keySet()) {
            if (!button.func_146115_a()) continue;
            this.drawHoveringText(Arrays.asList(this.configButtons.get(button).mouseoverText), mouseX, mouseY, this.field_146289_q);
        }
    }

    private void drawVehicleSelectionScreen(int mouseX, int mouseY, float renderPartialTicks) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.config.controls.title", (Object[])new Object[0]), this.guiLeft + 10, this.guiTop + 10, Color.BLACK.getRGB());
        for (GuiButton button : this.vehicleSelectionButtons.keySet()) {
            button.field_146124_l = true;
            button.func_146112_a(this.field_146297_k, mouseX, mouseY);
        }
        if (!ControlSystem.isJoystickSupportEnabled()) {
            this.field_146289_q.func_78279_b(I18n.func_135052_a((String)"gui.config.joystick.error", (Object[])new Object[0]), this.guiLeft + 10, this.guiTop + 120, 240, Color.BLACK.getRGB());
        }
    }

    private void drawKeyboardScreen(int mouseX, int mouseY, float renderPartialTicks) {
        for (ControlSystem.ControlsKeyboard keyboardControl : this.keyboardBoxes.keySet()) {
            GuiTextField box = this.keyboardBoxes.get((Object)keyboardControl);
            if (box.func_146206_l()) {
                box.func_146180_a("");
            } else if (keyboardControl.getCurrentButton().length() < 5) {
                box.func_146180_a(keyboardControl.getCurrentButton());
            } else {
                box.func_146180_a(keyboardControl.getCurrentButton().substring(0, 5));
            }
            if (!keyboardControl.name().contains(this.vehicleConfiguring.toUpperCase())) continue;
            box.func_146184_c(true);
            box.func_146194_f();
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)keyboardControl.buttonName, (Object[])new Object[0]) + ":", box.field_146209_f - 70, box.field_146210_g + 2, Color.BLACK.getRGB());
        }
        int offset = 0;
        for (ControlSystem.ControlsKeyboardDynamic dynamicControl : ControlSystem.ControlsKeyboardDynamic.values()) {
            if (!dynamicControl.name().contains(this.vehicleConfiguring.toUpperCase())) continue;
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)dynamicControl.buttonName, (Object[])new Object[0]) + ": " + dynamicControl.modControl.getCurrentButton() + " + " + dynamicControl.mainControl.getCurrentButton(), this.guiLeft + 10, this.guiTop + 115 + offset, Color.BLACK.getRGB());
            offset = (byte)(offset + 11);
        }
        this.finishKeyboardBindingsButton.field_146124_l = true;
        this.finishKeyboardBindingsButton.func_146112_a(this.field_146297_k, mouseX, mouseY);
    }

    private void drawJoystickSelectionScreen(int mouseX, int mouseY, float renderPartialTicks) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.config.joystick.select", (Object[])new Object[0]), this.guiLeft + 10, this.guiTop + 10, Color.BLACK.getRGB());
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.config.joystick.name", (Object[])new Object[0]), this.guiLeft + 10, this.guiTop + 25, Color.BLACK.getRGB());
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.config.joystick.type", (Object[])new Object[0]), this.guiLeft + 140, this.guiTop + 25, Color.BLACK.getRGB());
        for (GuiButton button : this.joystickSelectionButtons.keySet()) {
            button.field_146124_l = true;
            button.func_146112_a(this.field_146297_k, mouseX, mouseY);
            this.field_146289_q.func_78276_b(this.joystickSelectionButtons.get(button).getName().substring(0, this.joystickSelectionButtons.get(button).getName().length() > 20 ? 20 : this.joystickSelectionButtons.get(button).getName().length()), this.guiLeft + 10, button.field_146129_i + 5, Color.WHITE.getRGB());
            this.field_146289_q.func_78276_b(this.joystickSelectionButtons.get(button).getType().toString(), this.guiLeft + 140, button.field_146129_i + 5, Color.WHITE.getRGB());
        }
    }

    private void drawJoystickComponentSelectionScreen(int mouseX, int mouseY, float renderPartialTicks) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.config.joystick.mapping", (Object[])new Object[0]), this.guiLeft + 10, this.guiTop + 10, Color.BLACK.getRGB());
        GUIConfig.func_73734_a((int)(this.guiLeft + 120), (int)(this.guiTop + 5), (int)(this.guiLeft + 220), (int)(this.guiTop + 25), (int)Color.BLACK.getRGB());
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.config.joystick.deadzone", (Object[])new Object[0]), this.guiLeft + 125, this.guiTop + 10, Color.WHITE.getRGB());
        this.field_146289_q.func_78276_b(String.valueOf(ConfigSystem.getDoubleConfig("JoystickDeadZone")), this.guiLeft + 190, this.guiTop + 10, Color.WHITE.getRGB());
        this.field_146289_q.func_78276_b("#", this.guiLeft + 10, this.guiTop + 30, Color.BLACK.getRGB());
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.config.joystick.name", (Object[])new Object[0]), this.guiLeft + 25, this.guiTop + 30, Color.BLACK.getRGB());
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.config.joystick.state", (Object[])new Object[0]), this.guiLeft + 100, this.guiTop + 30, Color.BLACK.getRGB());
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.config.joystick.assignment", (Object[])new Object[0]), this.guiLeft + 150, this.guiTop + 30, Color.BLACK.getRGB());
        for (int i = 0; i < 9 && i < this.joystick.getComponents().length && i + this.scrollSpot < this.joystick.getComponents().length; ++i) {
            this.joystickComponentSelectionButtons.get((int)i).field_146124_l = true;
            this.joystickComponentSelectionButtons.get(i).func_146112_a(this.field_146297_k, mouseX, mouseY);
            this.field_146289_q.func_78276_b(String.valueOf(i + this.scrollSpot + 1), this.guiLeft + 10, this.guiTop + 44 + 15 * i, Color.WHITE.getRGB());
            this.field_146289_q.func_78276_b(this.joystick.getComponents()[i + this.scrollSpot].getName().substring(0, this.joystick.getComponents()[i + this.scrollSpot].getName().length() > 15 ? 15 : this.joystick.getComponents()[i + this.scrollSpot].getName().length()), this.guiLeft + 25, this.guiTop + 44 + 15 * i, Color.WHITE.getRGB());
            for (ControlSystem.ControlsJoystick joystickControl : ControlSystem.ControlsJoystick.values()) {
                if (!joystickControl.getCurrentJoystick().equals(this.joystick.getName()) || joystickControl.getCurrentButton() != i + this.scrollSpot || !joystickControl.name().toLowerCase().contains(this.vehicleConfiguring)) continue;
                this.field_146289_q.func_78276_b(I18n.func_135052_a((String)joystickControl.buttonName, (Object[])new Object[0]), this.guiLeft + 140, this.guiTop + 44 + 15 * i, Color.WHITE.getRGB());
            }
            this.joystick.poll();
            float pollData = this.joystick.getComponents()[i + this.scrollSpot].getPollData();
            if (this.joystick.getComponents()[i + this.scrollSpot].isAnalog()) {
                GUIConfig.func_73734_a((int)(this.guiLeft + 95), (int)(this.guiTop + 53 + 15 * i), (int)(this.guiLeft + 135), (int)(this.guiTop + 43 + 15 * i), (int)Color.BLACK.getRGB());
                if (!((double)Math.abs(pollData) > ConfigSystem.getDoubleConfig("JoystickDeadZone"))) continue;
                if (pollData > 0.0f) {
                    GUIConfig.func_73734_a((int)(this.guiLeft + 115), (int)(this.guiTop + 53 + 15 * i), (int)((int)((float)(this.guiLeft + 115) + pollData * 20.0f)), (int)(this.guiTop + 43 + 15 * i), (int)Color.RED.getRGB());
                    continue;
                }
                GUIConfig.func_73734_a((int)((int)((float)(this.guiLeft + 115) + pollData * 20.0f)), (int)(this.guiTop + 53 + 15 * i), (int)(this.guiLeft + 115), (int)(this.guiTop + 43 + 15 * i), (int)Color.RED.getRGB());
                continue;
            }
            if (pollData == 0.0f) {
                GUIConfig.func_73734_a((int)(this.guiLeft + 110), (int)(this.guiTop + 53 + 15 * i), (int)(this.guiLeft + 120), (int)(this.guiTop + 43 + 15 * i), (int)Color.BLACK.getRGB());
                continue;
            }
            if (pollData == 1.0f) {
                GUIConfig.func_73734_a((int)(this.guiLeft + 110), (int)(this.guiTop + 53 + 15 * i), (int)(this.guiLeft + 120), (int)(this.guiTop + 43 + 15 * i), (int)Color.RED.getRGB());
                continue;
            }
            GUIConfig.func_73734_a((int)(this.guiLeft + 110), (int)(this.guiTop + 53 + 15 * i), (int)(this.guiLeft + 120), (int)(this.guiTop + 43 + 15 * i), (int)Color.YELLOW.getRGB());
        }
        this.deadzone_moreButton.field_146124_l = ConfigSystem.getDoubleConfig("JoystickDeadZone") < 1.0;
        this.deadzone_lessButton.field_146124_l = ConfigSystem.getDoubleConfig("JoystickDeadZone") > 0.0;
        this.componentListUpButton.field_146124_l = this.scrollSpot - 9 >= 0;
        this.componentListDownButton.field_146124_l = this.scrollSpot + 9 < this.joystick.getComponents().length;
        this.deadzone_moreButton.func_146112_a(this.field_146297_k, mouseX, mouseY);
        this.deadzone_lessButton.func_146112_a(this.field_146297_k, mouseX, mouseY);
        this.componentListUpButton.func_146112_a(this.field_146297_k, mouseX, mouseY);
        this.componentListDownButton.func_146112_a(this.field_146297_k, mouseX, mouseY);
    }

    private void drawDigitalAssignmentScreen(int mouseX, int mouseY, float renderPartialTicks) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.config.joystick.choosemap", (Object[])new Object[0]), this.guiLeft + 10, this.guiTop + 10, Color.BLACK.getRGB());
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.config.joystick.selectdigital", (Object[])new Object[0]), this.guiLeft + 10, this.guiTop + 20, Color.BLACK.getRGB());
        for (GuiButton button : this.digitalAssignButtons.keySet()) {
            button.field_146124_l = true;
            button.func_146112_a(this.field_146297_k, mouseX, mouseY);
        }
        for (ControlSystem.ControlsJoystick joystickControl : ControlSystem.ControlsJoystick.values()) {
            if (!joystickControl.getCurrentJoystick().equals(this.joystick.getName()) || joystickControl.getCurrentButton() != this.joystickComponentId || !joystickControl.name().toLowerCase().contains(this.vehicleConfiguring)) continue;
            this.clearAssignmentButton.field_146124_l = true;
            break;
        }
        this.cancelAssignmentButton.field_146124_l = true;
        this.cancelAssignmentButton.func_146112_a(this.field_146297_k, mouseX, mouseY);
        this.clearAssignmentButton.func_146112_a(this.field_146297_k, mouseX, mouseY);
    }

    private void drawAnalogAssignmentScreen(int mouseX, int mouseY, float renderPartialTicks) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.config.joystick.choosemap", (Object[])new Object[0]), this.guiLeft + 10, this.guiTop + 10, Color.BLACK.getRGB());
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.config.joystick.selectanalog", (Object[])new Object[0]), this.guiLeft + 10, this.guiTop + 20, Color.BLACK.getRGB());
        for (GuiButton button : this.analogAssignButtons.keySet()) {
            button.field_146124_l = true;
            button.func_146112_a(this.field_146297_k, mouseX, mouseY);
        }
        for (ControlSystem.ControlsJoystick joystickControl : ControlSystem.ControlsJoystick.values()) {
            if (!joystickControl.getCurrentJoystick().equals(this.joystick.getName()) || joystickControl.getCurrentButton() != this.joystickComponentId || !joystickControl.name().toLowerCase().contains(this.vehicleConfiguring)) continue;
            this.clearAssignmentButton.field_146124_l = true;
            break;
        }
        this.cancelAssignmentButton.field_146124_l = true;
        this.cancelAssignmentButton.func_146112_a(this.field_146297_k, mouseX, mouseY);
        this.clearAssignmentButton.func_146112_a(this.field_146297_k, mouseX, mouseY);
    }

    private void drawAnalogCalibrationScreen(int mouseX, int mouseY, float renderPartialTicks) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.config.joystick.calibrate1", (Object[])new Object[0]), this.guiLeft + 10, this.guiTop + 10, Color.BLACK.getRGB());
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.config.joystick.calibrate2", (Object[])new Object[0]), this.guiLeft + 10, this.guiTop + 20, Color.BLACK.getRGB());
        this.joystick.poll();
        float pollData = this.joystick.getComponents()[this.joystickComponentId].getPollData();
        if (pollData < 0.0f) {
            this.axisMinBoundsTextBox.func_146180_a(String.valueOf(Math.min(Double.valueOf(this.axisMinBoundsTextBox.func_146179_b()), (double)pollData)));
        } else {
            this.axisMaxBoundsTextBox.func_146180_a(String.valueOf(Math.max(Double.valueOf(this.axisMaxBoundsTextBox.func_146179_b()), (double)pollData)));
        }
        this.axisMinBoundsTextBox.func_146194_f();
        this.axisMaxBoundsTextBox.func_146194_f();
        this.confirmBoundsButton.field_146124_l = true;
        this.cancelAssignmentButton.field_146124_l = true;
        this.invertAxisButton.field_146124_l = true;
        this.confirmBoundsButton.func_146112_a(this.field_146297_k, mouseX, mouseY);
        this.cancelAssignmentButton.func_146112_a(this.field_146297_k, mouseX, mouseY);
        this.invertAxisButton.func_146112_a(this.field_146297_k, mouseX, mouseY);
    }

    private void initHeaderButtons() {
        this.configScreenButton = new GuiButton(0, this.guiLeft + 0, this.guiTop - 20, 128, 20, I18n.func_135052_a((String)"gui.config.header.config", (Object[])new Object[0]));
        this.controlScreenButton = new GuiButton(0, this.guiLeft + 128, this.guiTop - 20, 128, 20, I18n.func_135052_a((String)"gui.config.header.controls", (Object[])new Object[0]));
        this.configScreenButton.field_146124_l = true;
        this.controlScreenButton.field_146124_l = false;
        this.field_146292_n.add(this.configScreenButton);
        this.field_146292_n.add(this.controlScreenButton);
    }

    private void initConfigButtons() {
        int line = 0;
        int xOffset = 140;
        for (ConfigButtons buttonEnum : ConfigButtons.values()) {
            GuiButton button = new GuiButton(0, this.guiLeft + xOffset, this.guiTop + 10 + line++ * 20, 60, 20, String.valueOf(ConfigSystem.getBooleanConfig(buttonEnum.configName)));
            button.field_146124_l = false;
            this.configButtons.put(button, buttonEnum);
            this.field_146292_n.add(button);
        }
    }

    private void initVehicleSelectionButtons() {
        int numTypes = 0;
        ArrayList<String> vehicleTypes = new ArrayList<String>();
        for (ControlSystem.ControlsKeyboard keyboardControl : ControlSystem.ControlsKeyboard.values()) {
            String vehicleType = keyboardControl.name().substring(0, keyboardControl.name().indexOf(95)).toLowerCase();
            if (vehicleTypes.contains(vehicleType)) continue;
            vehicleTypes.add(vehicleType);
            GuiButton buttonKeyboard = new GuiButton(0, this.guiLeft + 10, this.guiTop + 30 + 20 * numTypes, 118, 20, I18n.func_135052_a((String)("gui.config.controls." + vehicleType + ".keyboard"), (Object[])new Object[0]));
            buttonKeyboard.field_146124_l = false;
            this.vehicleSelectionButtons.put(buttonKeyboard, vehicleType + ".keyboard");
            this.field_146292_n.add(buttonKeyboard);
            if (ControlSystem.isJoystickSupportEnabled()) {
                GuiButton buttonJoystick = new GuiButton(0, this.guiLeft + 128, this.guiTop + 30 + 20 * numTypes, 118, 20, I18n.func_135052_a((String)("gui.config.controls." + vehicleType + ".joystick"), (Object[])new Object[0]));
                buttonJoystick.field_146124_l = false;
                this.vehicleSelectionButtons.put(buttonJoystick, vehicleType + ".joystick");
                this.field_146292_n.add(buttonJoystick);
            }
            numTypes = (byte)(numTypes + 1);
        }
    }

    private void initKeyboardBoxes() {
        this.keyboardBoxes.clear();
        int verticalOffset = 10;
        int horizontalOffset = 80;
        for (ControlSystem.ControlsKeyboard keyboardControl : ControlSystem.ControlsKeyboard.values()) {
            if (!keyboardControl.name().toLowerCase().contains(this.vehicleConfiguring)) continue;
            GuiTextField box = new GuiTextField(0, this.field_146289_q, this.guiLeft + horizontalOffset, this.guiTop + verticalOffset, 40, 10);
            this.keyboardBoxes.put(keyboardControl, box);
            if ((verticalOffset += 11) <= 98) continue;
            verticalOffset = 10;
            horizontalOffset += 120;
        }
        this.finishKeyboardBindingsButton = new GuiButton(0, this.guiLeft + 180, this.guiTop + 140, 50, 20, I18n.func_135052_a((String)"gui.config.controls.confirm", (Object[])new Object[0]));
        this.field_146292_n.add(this.finishKeyboardBindingsButton);
    }

    private void initJoystickSelecionButtons() {
        for (Controller joystick : ControllerEnvironment.getDefaultEnvironment().getControllers()) {
            if (joystick.getType() == null || joystick.getName() == null || joystick.getType().equals(Controller.Type.MOUSE) || joystick.getType().equals(Controller.Type.KEYBOARD) || joystick.getComponents().length == 0) continue;
            GuiButton button = new GuiButton(0, this.guiLeft + 5, this.guiTop + 40 + 15 * this.joystickSelectionButtons.size(), 240, 15, "");
            this.joystickSelectionButtons.put(button, joystick);
            this.field_146292_n.add(button);
        }
    }

    private void initJoystickComponentSelecionButtons() {
        for (int i = 0; i < 9; ++i) {
            GuiButton button = new GuiButton(0, this.guiLeft + 5, this.guiTop + 40 + 15 * i, 215, 15, "");
            this.joystickComponentSelectionButtons.add(button);
            this.field_146292_n.add(button);
        }
        this.componentListUpButton = new GuiButton(0, this.guiLeft + 225, this.guiTop + 40, 20, 20, "/\\");
        this.field_146292_n.add(this.componentListUpButton);
        this.componentListDownButton = new GuiButton(0, this.guiLeft + 225, this.guiTop + 155, 20, 20, "\\/");
        this.field_146292_n.add(this.componentListDownButton);
        this.deadzone_lessButton = new GuiButton(0, this.guiLeft + 100, this.guiTop + 5, 20, 20, "<");
        this.field_146292_n.add(this.deadzone_lessButton);
        this.deadzone_moreButton = new GuiButton(0, this.guiLeft + 220, this.guiTop + 5, 20, 20, ">");
        this.field_146292_n.add(this.deadzone_moreButton);
    }

    private void initAssignmentButtons() {
        this.cancelAssignmentButton = new GuiButton(0, this.guiLeft + 125, this.guiTop + 160, 100, 20, I18n.func_135052_a((String)"gui.config.joystick.cancel", (Object[])new Object[0]));
        this.field_146292_n.add(this.cancelAssignmentButton);
        this.clearAssignmentButton = new GuiButton(0, this.guiLeft + 25, this.guiTop + 160, 100, 20, I18n.func_135052_a((String)"gui.config.joystick.clear", (Object[])new Object[0]));
        this.field_146292_n.add(this.clearAssignmentButton);
    }

    private void initDigitalAssignmentButtons() {
        this.field_146292_n.removeAll(this.digitalAssignButtons.keySet());
        this.digitalAssignButtons.clear();
        int leftOffset = 0;
        int topOffset = 0;
        for (ControlSystem.ControlsJoystick joystickControl : ControlSystem.ControlsJoystick.values()) {
            if (joystickControl.name().toLowerCase().contains(this.vehicleConfiguring) && !joystickControl.isAxis) {
                GuiButton button = new GuiButton(0, this.guiLeft + 8 + leftOffset, this.guiTop + 30 + topOffset, 80, 15, I18n.func_135052_a((String)joystickControl.buttonName, (Object[])new Object[0]));
                this.digitalAssignButtons.put(button, joystickControl);
                this.field_146292_n.add(button);
                topOffset = (byte)(topOffset + 15);
            }
            if (topOffset != 120) continue;
            topOffset = 0;
            leftOffset = (short)(leftOffset + 80);
        }
    }

    private void initAnalogAssignmentButtons() {
        this.field_146292_n.removeAll(this.analogAssignButtons.keySet());
        this.analogAssignButtons.clear();
        this.calibrating = false;
        int topOffset = 0;
        for (ControlSystem.ControlsJoystick joystickControl : ControlSystem.ControlsJoystick.values()) {
            if (!joystickControl.name().toLowerCase().contains(this.vehicleConfiguring) || !joystickControl.isAxis) continue;
            GuiButton button = new GuiButton(0, this.guiLeft + 85, this.guiTop + 40 + topOffset, 80, 20, I18n.func_135052_a((String)joystickControl.buttonName, (Object[])new Object[0]));
            this.analogAssignButtons.put(button, joystickControl);
            this.field_146292_n.add(button);
            topOffset = (byte)(topOffset + 20);
        }
    }

    private void initAnalogCalibrationScreen() {
        this.calibrating = true;
        this.confirmBoundsButton = new GuiButton(0, this.guiLeft + 25, this.guiTop + 160, 100, 20, I18n.func_135052_a((String)"gui.config.joystick.confirm", (Object[])new Object[0]));
        this.field_146292_n.add(this.confirmBoundsButton);
        this.invertAxisButton = new GuiButton(0, this.guiLeft + 50, this.guiTop + 120, 150, 20, I18n.func_135052_a((String)"gui.config.joystick.axismode", (Object[])new Object[0]) + I18n.func_135052_a((String)"gui.config.joystick.normal", (Object[])new Object[0]));
        this.field_146292_n.add(this.invertAxisButton);
        this.axisMinBoundsTextBox = new GuiTextField(0, this.field_146289_q, this.guiLeft + 50, this.guiTop + 90, 150, 15);
        this.axisMaxBoundsTextBox = new GuiTextField(0, this.field_146289_q, this.guiLeft + 50, this.guiTop + 60, 150, 15);
        this.axisMinBoundsTextBox.func_146184_c(false);
        this.axisMaxBoundsTextBox.func_146184_c(false);
        this.axisMinBoundsTextBox.func_146180_a("0.0");
        this.axisMaxBoundsTextBox.func_146180_a("0.0");
    }

    private static enum ConfigButtons {
        SEA_LEVEL_OFFSET("SeaLevelOffset", "Sea Level Offset", new String[]{"Does altimeter display 0", "at average sea level", "instead of Y=0?"}),
        MOUSE_YOKE("MouseYoke", "Mouse Yoke", new String[]{"Enable Mouse Yoke?", "Prevents looking around unless unlocked.", "Think MCHeli controls."}),
        INNER_WINDOWS("InnerWindows", "Inner Windows", new String[]{"Render the insides of windows on vehicles?"}),
        KEYBOARD_OVERRIDE("KeyboardOverride", "Keyboard Override", new String[]{"Should keyboard controls be overriden", "when a joystick control is mapped?", "Leave true to free up the keyboard", "while using a joysick."});

        private final String configName;
        private final String formattedName;
        private final String[] mouseoverText;

        private ConfigButtons(String configName, String formattedName, String[] mouseoverText) {
            this.configName = configName;
            this.formattedName = formattedName;
            this.mouseoverText = mouseoverText;
        }
    }
}

