/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.blocks.core.BlockBench;
import minecrafttransportsimulator.dataclasses.MTSRegistry;
import minecrafttransportsimulator.dataclasses.PackVehicleObject;
import minecrafttransportsimulator.packets.general.PacketPlayerCrafting;
import minecrafttransportsimulator.systems.OBJParserSystem;
import minecrafttransportsimulator.systems.PackParserSystem;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GUIPartBench
extends GuiScreen {
    private static final ResourceLocation background = new ResourceLocation("mts", "textures/guis/crafting.png");
    private static final Map<String, String[]> lastOpenedItem = new HashMap<String, String[]>();
    private final List<String> partTypes;
    private final EntityPlayer player;
    private final boolean isForVehicles;
    private final boolean isForInstruments;
    private final Map<String, ? extends Item> itemMap;
    private GuiButton leftPackButton;
    private GuiButton rightPackButton;
    private GuiButton leftPartButton;
    private GuiButton rightPartButton;
    private GuiButton leftColorButton;
    private GuiButton rightColorButton;
    private GuiButton startButton;
    private int guiLeft;
    private int guiTop;
    private String packName = "";
    private String prevPackName = "";
    private String nextPackName = "";
    private String partName = "";
    private String prevPartName = "";
    private String nextPartName = "";
    private String colorName = "";
    private String prevColorName = "";
    private String nextColorName = "";
    private final Map<String, Integer> partDisplayLists = new HashMap<String, Integer>();
    private final Map<String, Float> partScalingFactors = new HashMap<String, Float>();
    private final Map<String, ResourceLocation> textureMap = new HashMap<String, ResourceLocation>();

    public GUIPartBench(BlockBench bench, EntityPlayer player) {
        this.partTypes = bench.partTypes;
        this.player = player;
        this.isForVehicles = this.partTypes.contains("plane") || this.partTypes.contains("car");
        this.isForInstruments = this.partTypes.contains("instrument");
        Map<String, Item> map = this.isForVehicles ? MTSRegistry.vehicleItemMap : (this.itemMap = this.isForInstruments ? MTSRegistry.instrumentItemMap : MTSRegistry.partItemMap);
        if (lastOpenedItem.containsKey(bench.partTypes.get(0))) {
            this.packName = lastOpenedItem.get(bench.partTypes.get(0))[0];
            this.partName = lastOpenedItem.get(bench.partTypes.get(0))[1];
        }
        this.updatePartNames();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = this.isForVehicles ? (this.field_146294_l - 356) / 2 : (this.field_146294_l - 256) / 2;
        this.guiTop = (this.field_146295_m - 220) / 2;
        this.leftPackButton = new GuiButton(0, this.guiLeft + 10, this.guiTop + 5, 20, 20, "<");
        this.field_146292_n.add(this.leftPackButton);
        this.rightPackButton = new GuiButton(0, this.guiLeft + 226, this.guiTop + 5, 20, 20, ">");
        this.field_146292_n.add(this.rightPackButton);
        this.leftPartButton = new GuiButton(0, this.guiLeft + 10, this.guiTop + 25, 20, 20, "<");
        this.field_146292_n.add(this.leftPartButton);
        this.rightPartButton = new GuiButton(0, this.guiLeft + 226, this.guiTop + 25, 20, 20, ">");
        this.field_146292_n.add(this.rightPartButton);
        if (this.isForVehicles) {
            this.leftColorButton = new GuiButton(0, this.guiLeft + 280, this.guiTop + 25, 20, 20, "<");
            this.field_146292_n.add(this.leftColorButton);
            this.rightColorButton = new GuiButton(0, this.guiLeft + 300, this.guiTop + 25, 20, 20, ">");
            this.field_146292_n.add(this.rightColorButton);
        }
        this.startButton = new GuiButton(0, this.guiLeft + 188, this.guiTop + 170, 20, 20, "");
        this.field_146292_n.add(this.startButton);
    }

    /*
     * WARNING - void declaration
     */
    public void func_73863_a(int mouseX, int mouseY, float renderPartialTicks) {
        super.func_73863_a(mouseX, mouseY, renderPartialTicks);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(background);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, 256, 201);
        if (this.isForVehicles) {
            this.func_73729_b(this.guiLeft + 250, this.guiTop, 144, 0, 111, 201);
        }
        if (this.startButton.field_146124_l) {
            this.func_73729_b(this.guiLeft + 140, this.guiTop + 173, 0, 201, 44, 16);
        }
        this.drawCenteredString(!this.packName.isEmpty() ? I18n.func_135052_a((String)("itemGroup." + this.packName), (Object[])new Object[0]) : "", this.guiLeft + 130, this.guiTop + 10);
        this.drawCenteredString(!this.partName.isEmpty() ? I18n.func_135052_a((String)(this.itemMap.get(this.partName).func_77658_a() + ".name"), (Object[])new Object[0]) : "", this.guiLeft + 130, this.guiTop + 30);
        if (this.isForVehicles) {
            this.drawCenteredString(I18n.func_135052_a((String)"gui.vehicle_bench.color", (Object[])new Object[0]), this.guiLeft + 300, this.guiTop + 10);
        }
        this.startButton.field_146124_l = PacketPlayerCrafting.doesPlayerHaveMaterials(this.player, this.partName);
        this.leftPackButton.field_146124_l = !this.prevPackName.isEmpty();
        boolean bl = this.rightPackButton.field_146124_l = !this.nextPackName.isEmpty();
        if (this.isForVehicles) {
            this.leftPartButton.field_146124_l = !this.prevPartName.isEmpty();
            this.rightPartButton.field_146124_l = !this.nextPartName.isEmpty();
            this.leftColorButton.field_146124_l = !this.prevColorName.isEmpty();
            this.rightColorButton.field_146124_l = !this.nextColorName.isEmpty();
        } else {
            this.leftPartButton.field_146124_l = !this.prevPartName.isEmpty();
            this.rightPartButton.field_146124_l = !this.nextPartName.isEmpty();
        }
        for (Object obj : this.field_146292_n) {
            ((GuiButton)obj).func_146112_a(this.field_146297_k, mouseX, mouseY);
        }
        GUIPartBench.func_73734_a((int)(this.guiLeft + 190), (int)(this.guiTop + 188), (int)(this.guiLeft + 206), (int)(this.guiTop + 172), (int)(this.startButton.field_146124_l ? Color.GREEN.getRGB() : Color.RED.getRGB()));
        if (this.partName.isEmpty()) {
            return;
        }
        if (this.isForVehicles) {
            this.renderVehicleInfoText();
        } else if (!this.isForInstruments) {
            this.renderPartInfoText();
        } else {
            this.renderInstrumentInfoText();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74520_c();
        int stackOffset = 9;
        for (ItemStack itemStack : PackParserSystem.getMaterials(this.partName)) {
            ItemStack renderedStack = new ItemStack(itemStack.func_77973_b(), itemStack.field_77994_a, itemStack.func_77960_j() == Integer.MAX_VALUE ? 0 : itemStack.func_77960_j());
            this.field_146296_j.func_180450_b(renderedStack, this.guiLeft + stackOffset, this.guiTop + 172);
            this.field_146296_j.func_175030_a(this.field_146289_q, renderedStack, this.guiLeft + stackOffset, this.guiTop + 172);
            stackOffset += 18;
        }
        stackOffset = 9;
        int itemTooltipBounds = 16;
        for (ItemStack craftingStack : PackParserSystem.getMaterials(this.partName)) {
            if (mouseX > this.guiLeft + stackOffset && mouseX < this.guiLeft + stackOffset + itemTooltipBounds && mouseY > this.guiTop + 172 && mouseY < this.guiTop + 172 + itemTooltipBounds) {
                ItemStack renderedStack = new ItemStack(craftingStack.func_77973_b(), craftingStack.field_77994_a, craftingStack.func_77960_j() == Integer.MAX_VALUE ? 0 : craftingStack.func_77960_j());
                this.func_146285_a(renderedStack, this.guiLeft + stackOffset, this.guiTop + 172);
            }
            stackOffset += 18;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.isForInstruments) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)this.guiLeft + 172.5f), (float)((float)this.guiTop + 82.5f), (float)0.0f);
            GL11.glScalef((float)3.0f, (float)3.0f, (float)3.0f);
            this.field_146296_j.func_180450_b(new ItemStack(this.itemMap.get(this.partName)), 0, 0);
            GL11.glPopMatrix();
            return;
        }
        if (!this.partDisplayLists.containsKey(this.partName)) {
            if (this.isForVehicles) {
                String string = PackParserSystem.getVehicleJSONName(this.partName);
                for (String parsedItemName : this.partDisplayLists.keySet()) {
                    if (!PackParserSystem.getVehicleJSONName(parsedItemName).equals(string)) continue;
                    this.partDisplayLists.put(this.partName, this.partDisplayLists.get(parsedItemName));
                    this.partScalingFactors.put(this.partName, this.partScalingFactors.get(parsedItemName));
                    break;
                }
                if (!this.partDisplayLists.containsKey(this.partName)) {
                    this.parseModel(this.partName.substring(0, this.partName.indexOf(58)), "objmodels/vehicles/" + string + ".obj");
                }
            } else if (PackParserSystem.getPartPack((String)this.partName).general.modelName != null) {
                this.parseModel(this.partName.substring(0, this.partName.indexOf(58)), "objmodels/parts/" + PackParserSystem.getPartPack((String)this.partName).general.modelName + ".obj");
            } else {
                this.parseModel(this.partName.substring(0, this.partName.indexOf(58)), "objmodels/parts/" + this.partName.substring(this.partName.indexOf(58) + 1) + ".obj");
            }
        }
        if (!this.textureMap.containsKey(this.partName)) {
            void var6_14;
            if (this.isForVehicles) {
                ResourceLocation resourceLocation = new ResourceLocation(this.partName.substring(0, this.partName.indexOf(58)), "textures/vehicles/" + this.partName.substring(this.partName.indexOf(58) + 1) + ".png");
            } else {
                ResourceLocation resourceLocation = new ResourceLocation(this.partName.substring(0, this.partName.indexOf(58)), "textures/parts/" + this.partName.substring(this.partName.indexOf(58) + 1) + ".png");
            }
            this.textureMap.put(this.partName, (ResourceLocation)var6_14);
        }
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        this.field_146297_k.func_110434_K().func_110577_a(this.textureMap.get(this.partName));
        GL11.glTranslatef((float)(this.guiLeft + 190), (float)(this.guiTop + 110), (float)100.0f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)35.264f, (float)1.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(-this.player.field_70170_p.func_82737_E() * 2L), (float)0.0f, (float)1.0f, (float)0.0f);
        float f = 30.0f * this.partScalingFactors.get(this.partName).floatValue();
        GL11.glScalef((float)f, (float)f, (float)f);
        GL11.glCallList((int)this.partDisplayLists.get(this.partName));
        GL11.glPopMatrix();
    }

    private void renderVehicleInfoText() {
        PackVehicleObject pack = PackParserSystem.getVehiclePack(this.partName);
        int controllers = 0;
        int passengers = 0;
        int cargo = 0;
        int mixed = 0;
        float minFuelConsumption = 99.0f;
        float maxFuelConsumption = 0.0f;
        float minWheelSize = 99.0f;
        float maxWheelSize = 0.0f;
        for (PackVehicleObject.PackPart part : pack.parts) {
            if (part.isController) {
                controllers = (byte)(controllers + 1);
                continue;
            }
            boolean canAcceptSeat = false;
            boolean canAcceptChest = false;
            if (part.types.contains("seat")) {
                canAcceptSeat = true;
            }
            if (part.types.contains("crate")) {
                canAcceptChest = true;
            }
            if (canAcceptSeat && !canAcceptChest) {
                passengers = (byte)(passengers + 1);
            } else if (canAcceptChest && !canAcceptSeat) {
                cargo = (byte)(cargo + 1);
            } else if (canAcceptChest && canAcceptSeat) {
                mixed = (byte)(mixed + 1);
            }
            for (String partNameEntry : part.types) {
                if (!partNameEntry.startsWith("engine")) continue;
                minFuelConsumption = Math.min(part.minValue, minFuelConsumption);
                maxFuelConsumption = Math.max(part.maxValue, maxFuelConsumption);
                break;
            }
            if (!part.types.contains("wheel")) continue;
            minWheelSize = Math.min(part.minValue, minWheelSize);
            maxWheelSize = Math.max(part.maxValue, maxWheelSize);
        }
        if (minFuelConsumption == 99.0f) {
            minFuelConsumption = 0.0f;
            maxFuelConsumption = 99.0f;
        }
        if (minWheelSize == 99.0f) {
            minWheelSize = 0.0f;
            maxWheelSize = 99.0f;
        }
        ArrayList<String> headerLines = new ArrayList<String>();
        headerLines.add(I18n.func_135052_a((String)"gui.vehicle_bench.type", (Object[])new Object[0]) + ":");
        headerLines.add(I18n.func_135052_a((String)"gui.vehicle_bench.weight", (Object[])new Object[0]) + ":");
        headerLines.add(I18n.func_135052_a((String)"gui.vehicle_bench.fuel", (Object[])new Object[0]) + ":");
        headerLines.add(I18n.func_135052_a((String)"gui.vehicle_bench.controllers", (Object[])new Object[0]) + ":");
        headerLines.add(I18n.func_135052_a((String)"gui.vehicle_bench.passengers", (Object[])new Object[0]) + ":");
        headerLines.add(I18n.func_135052_a((String)"gui.vehicle_bench.cargo", (Object[])new Object[0]) + ":");
        headerLines.add(I18n.func_135052_a((String)"gui.vehicle_bench.mixed", (Object[])new Object[0]) + ":");
        headerLines.add(I18n.func_135052_a((String)"gui.vehicle_bench.engine", (Object[])new Object[0]) + ":");
        headerLines.add(I18n.func_135052_a((String)"gui.vehicle_bench.wheel", (Object[])new Object[0]) + ":");
        int lineOffset = 55;
        for (String line : headerLines) {
            this.field_146297_k.field_71466_p.func_175063_a(line, (float)(this.guiLeft + 10), (float)(this.guiTop + lineOffset), Color.WHITE.getRGB());
            lineOffset += 10;
        }
        ArrayList<String> descriptiveLines = new ArrayList<String>();
        descriptiveLines.add(String.valueOf(pack.general.type));
        descriptiveLines.add(String.valueOf(pack.general.emptyMass));
        descriptiveLines.add(String.valueOf(pack.motorized.fuelCapacity));
        descriptiveLines.add(String.valueOf(controllers));
        descriptiveLines.add(String.valueOf(passengers));
        descriptiveLines.add(String.valueOf(cargo));
        descriptiveLines.add(String.valueOf(mixed));
        descriptiveLines.add(String.valueOf(minFuelConsumption) + "-" + String.valueOf(maxFuelConsumption));
        descriptiveLines.add(String.valueOf(minWheelSize) + "-" + String.valueOf(maxWheelSize));
        lineOffset = 55;
        for (String line : descriptiveLines) {
            this.field_146297_k.field_71466_p.func_175063_a(line, (float)(this.guiLeft + 90), (float)(this.guiTop + lineOffset), Color.WHITE.getRGB());
            lineOffset += 10;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.guiLeft + 255), (float)(this.guiTop + 55), (float)0.0f);
        GL11.glScalef((float)0.8f, (float)0.8f, (float)0.8f);
        this.field_146289_q.func_78279_b(I18n.func_135052_a((String)("description." + this.partName.substring(0, this.partName.indexOf(58)) + "." + PackParserSystem.getVehicleJSONName(this.partName)), (Object[])new Object[0]), 0, 0, 120, Color.WHITE.getRGB());
        GL11.glPopMatrix();
    }

    private void renderPartInfoText() {
        ItemStack tempStack = new ItemStack(this.itemMap.get(this.partName));
        tempStack.func_77982_d(new NBTTagCompound());
        ArrayList descriptiveLines = new ArrayList();
        tempStack.func_77973_b().func_77624_a(tempStack, this.player, descriptiveLines, false);
        int lineOffset = 55;
        for (String line : descriptiveLines) {
            this.field_146297_k.field_71466_p.func_175063_a(line, (float)(this.guiLeft + 10), (float)(this.guiTop + lineOffset), Color.WHITE.getRGB());
            lineOffset += 10;
        }
    }

    private void renderInstrumentInfoText() {
        this.field_146289_q.func_78279_b(I18n.func_135052_a((String)(this.itemMap.get(this.partName).func_77658_a() + ".description"), (Object[])new Object[0]), this.guiLeft + 10, this.guiTop + 55, 120, Color.WHITE.getRGB());
    }

    private void parseModel(String partPack, String partModelLocation) {
        float minX = 999.0f;
        float maxX = -999.0f;
        float minY = 999.0f;
        float maxY = -999.0f;
        float minZ = 999.0f;
        float maxZ = -999.0f;
        Map<String, Float[][]> parsedModel = OBJParserSystem.parseOBJModel(partPack, partModelLocation);
        int displayListIndex = GL11.glGenLists((int)1);
        GL11.glNewList((int)displayListIndex, (int)4864);
        GL11.glBegin((int)4);
        for (Map.Entry<String, Float[][]> entry : parsedModel.entrySet()) {
            for (Float[] vertex : entry.getValue()) {
                GL11.glTexCoord2f((float)vertex[3].floatValue(), (float)vertex[4].floatValue());
                GL11.glNormal3f((float)vertex[5].floatValue(), (float)vertex[6].floatValue(), (float)vertex[7].floatValue());
                GL11.glVertex3f((float)(-vertex[0].floatValue()), (float)vertex[1].floatValue(), (float)vertex[2].floatValue());
                minX = Math.min(minX, vertex[0].floatValue());
                maxX = Math.max(maxX, vertex[0].floatValue());
                minY = Math.min(minY, vertex[1].floatValue());
                maxY = Math.max(maxY, vertex[1].floatValue());
                minZ = Math.min(minZ, vertex[2].floatValue());
                maxZ = Math.max(maxZ, vertex[2].floatValue());
            }
        }
        float globalMax = Math.max(Math.max(maxX - minX, maxY - minY), maxZ - minZ);
        this.partScalingFactors.put(this.partName, Float.valueOf((double)globalMax > 1.5 ? 1.5f / globalMax : 1.0f));
        GL11.glEnd();
        GL11.glEndList();
        this.partDisplayLists.put(this.partName, displayListIndex);
    }

    protected void func_146284_a(GuiButton buttonClicked) throws IOException {
        super.func_146284_a(buttonClicked);
        if (buttonClicked.equals(this.startButton)) {
            MTS.proxy.playSound(this.player.func_174791_d(), "mts:bench_running", 1.0f, 1.0f);
            MTS.MTSNet.sendToServer((IMessage)new PacketPlayerCrafting(this.player, this.partName));
            this.field_146297_k.field_71439_g.func_71053_j();
            return;
        }
        if (buttonClicked.equals(this.leftPackButton)) {
            this.packName = this.prevPackName;
            this.partName = "";
        } else if (buttonClicked.equals(this.rightPackButton)) {
            this.packName = this.nextPackName;
            this.partName = "";
        } else if (buttonClicked.equals(this.leftPartButton)) {
            this.partName = this.prevPartName;
        } else if (buttonClicked.equals(this.rightPartButton)) {
            this.partName = this.nextPartName;
        } else if (buttonClicked.equals(this.leftColorButton)) {
            this.partName = this.prevColorName;
        } else if (buttonClicked.equals(this.rightColorButton)) {
            this.partName = this.nextColorName;
        }
        this.updatePartNames();
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i > 0 && this.rightPartButton.field_146124_l) {
            this.func_146284_a(this.rightPartButton);
        } else if (i < 0 && this.leftPartButton.field_146124_l) {
            this.func_146284_a(this.leftPartButton);
        }
    }

    public void func_146281_b() {
        for (int displayListID : this.partDisplayLists.values()) {
            GL11.glDeleteLists((int)displayListID, (int)1);
        }
        lastOpenedItem.put(this.partTypes.get(0), new String[]{this.packName, this.partName});
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            super.func_73869_a('0', 1);
        }
    }

    private void drawCenteredString(String stringToDraw, int x, int y) {
        this.field_146297_k.field_71466_p.func_78276_b(stringToDraw, x - this.field_146297_k.field_71466_p.func_78256_a(stringToDraw) / 2, y, 0x404040);
    }

    private void updatePartNames() {
        this.prevPackName = "";
        this.nextPackName = "";
        this.prevPartName = "";
        this.nextPartName = "";
        this.prevColorName = "";
        this.nextColorName = "";
        boolean passedPack = false;
        boolean passedPart = false;
        boolean passedColor = false;
        for (String partItemName : this.itemMap.keySet()) {
            boolean isValid = this.isForVehicles ? this.partTypes.contains(PackParserSystem.getVehiclePack((String)partItemName).general.type) : (!this.isForInstruments ? this.partTypes.contains(PackParserSystem.getPartPack((String)partItemName).general.type) : true);
            if (!isValid) continue;
            if (this.packName.isEmpty()) {
                this.packName = partItemName.substring(0, partItemName.indexOf(58));
            } else if (!passedPack && !partItemName.startsWith(this.packName)) {
                this.prevPackName = partItemName.substring(0, partItemName.indexOf(58));
            }
            if (partItemName.startsWith(this.packName)) {
                passedPack = true;
                if (this.isForVehicles) {
                    if (this.partName.isEmpty()) {
                        this.partName = partItemName;
                        passedPart = true;
                        continue;
                    }
                    if (this.partName.equals(partItemName)) {
                        passedPart = true;
                        continue;
                    }
                    if (!passedPart) {
                        if (PackParserSystem.getVehicleJSONName(this.partName).equals(PackParserSystem.getVehicleJSONName(partItemName))) {
                            this.prevColorName = partItemName;
                            continue;
                        }
                        if (!this.prevPartName.isEmpty() && PackParserSystem.getVehicleJSONName(this.prevPartName).equals(PackParserSystem.getVehicleJSONName(partItemName))) continue;
                        this.prevPartName = partItemName;
                        continue;
                    }
                    if (!this.nextPartName.isEmpty()) continue;
                    if (PackParserSystem.getVehicleJSONName(this.partName).equals(PackParserSystem.getVehicleJSONName(partItemName))) {
                        if (!this.nextColorName.isEmpty()) continue;
                        this.nextColorName = partItemName;
                        continue;
                    }
                    this.nextPartName = partItemName;
                    continue;
                }
                if (this.partName.isEmpty()) {
                    this.partName = partItemName;
                    passedPart = true;
                    continue;
                }
                if (this.partName.equals(partItemName)) {
                    passedPart = true;
                    continue;
                }
                if (!passedPart) {
                    this.prevPartName = partItemName;
                    continue;
                }
                if (!this.nextPartName.isEmpty()) continue;
                this.nextPartName = partItemName;
                continue;
            }
            if (!this.nextPackName.isEmpty() || !passedPack) continue;
            this.nextPackName = partItemName.substring(0, partItemName.indexOf(58));
            return;
        }
    }
}

