/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.blocks.core.TileEntityTrafficSignalController;
import minecrafttransportsimulator.dataclasses.MTSRegistry;
import minecrafttransportsimulator.packets.tileentities.PacketTrafficSignalControllerChange;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GUITrafficSignalController
extends GuiScreen {
    private static final ResourceLocation background = new ResourceLocation("mts", "textures/guis/wide_blank.png");
    private int guiLeft;
    private int guiTop;
    private boolean orientedOnX = false;
    private boolean triggerMode = false;
    private final List<BlockPos> trafficSignalLocations = new ArrayList<BlockPos>();
    private final List<GuiTextField> textList = new ArrayList<GuiTextField>();
    private GuiButton scanButton;
    private GuiButton orientationButton;
    private GuiButton modeButton;
    private GuiButton confirmButton;
    private GuiTextField scanDistanceText;
    private GuiTextField greenMainTimeText;
    private GuiTextField greenCrossTimeText;
    private GuiTextField yellowTimeText;
    private GuiTextField allRedTimeText;
    private final TileEntityTrafficSignalController signalController;

    public GUITrafficSignalController(TileEntityTrafficSignalController clicked) {
        this.signalController = clicked;
        this.field_146291_p = true;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - 256) / 2;
        this.guiTop = (this.field_146295_m - 192) / 2;
        this.scanButton = new GuiButton(0, this.guiLeft + 25, this.guiTop + 30, 200, 20, I18n.func_135052_a((String)"gui.trafficsignalcontroller.scan", (Object[])new Object[0]));
        this.field_146292_n.add(this.scanButton);
        this.orientationButton = new GuiButton(0, this.guiLeft + 125, this.guiTop + 75, 100, 20, "");
        this.field_146292_n.add(this.orientationButton);
        this.modeButton = new GuiButton(0, this.guiLeft + 125, this.guiTop + 95, 100, 20, "");
        this.field_146292_n.add(this.modeButton);
        this.confirmButton = new GuiButton(0, this.guiLeft + 25, this.guiTop + 165, 80, 20, I18n.func_135052_a((String)"gui.trafficsignalcontroller.confirm", (Object[])new Object[0]));
        this.field_146292_n.add(this.confirmButton);
        this.scanDistanceText = new GuiTextField(0, this.field_146289_q, this.guiLeft + 180, this.guiTop + 15, 40, 10);
        this.textList.add(this.scanDistanceText);
        this.scanDistanceText.func_146180_a("25");
        this.scanDistanceText.func_146203_f(2);
        this.greenMainTimeText = new GuiTextField(0, this.field_146289_q, this.guiLeft + 180, this.guiTop + 120, 40, 10);
        this.textList.add(this.greenMainTimeText);
        this.greenMainTimeText.func_146180_a("20");
        this.greenMainTimeText.func_146203_f(3);
        this.greenCrossTimeText = new GuiTextField(0, this.field_146289_q, this.guiLeft + 180, this.guiTop + 130, 40, 10);
        this.textList.add(this.greenCrossTimeText);
        this.greenCrossTimeText.func_146180_a("10");
        this.greenCrossTimeText.func_146203_f(3);
        this.yellowTimeText = new GuiTextField(0, this.field_146289_q, this.guiLeft + 180, this.guiTop + 140, 40, 10);
        this.textList.add(this.yellowTimeText);
        this.yellowTimeText.func_146180_a("2");
        this.yellowTimeText.func_146203_f(1);
        this.allRedTimeText = new GuiTextField(0, this.field_146289_q, this.guiLeft + 180, this.guiTop + 150, 40, 10);
        this.textList.add(this.allRedTimeText);
        this.allRedTimeText.func_146180_a("1");
        this.allRedTimeText.func_146203_f(1);
    }

    public void func_73863_a(int mouseX, int mouseY, float renderPartialTicks) {
        this.field_146297_k.func_110434_K().func_110577_a(background);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, 256, 192);
        this.scanButton.field_146124_l = true;
        this.scanButton.func_146112_a(this.field_146297_k, mouseX, mouseY);
        this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"gui.trafficsignalcontroller.scandistance", (Object[])new Object[0]), (float)(this.guiLeft + 30), (float)(this.guiTop + 15), Color.WHITE.getRGB());
        this.scanDistanceText.func_146189_e(true);
        this.scanDistanceText.func_146194_f();
        this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"gui.trafficsignalcontroller.scanfound", (Object[])new Object[0]), (float)(this.guiLeft + 30), (float)(this.guiTop + 60), Color.WHITE.getRGB());
        RenderHelper.func_74520_c();
        this.field_146296_j.func_180450_b(new ItemStack(MTSRegistry.trafficSignal), this.guiLeft + 120, this.guiTop + 55);
        this.field_146289_q.func_78276_b(" X " + this.trafficSignalLocations.size(), this.guiLeft + 135, this.guiTop + 60, this.trafficSignalLocations.isEmpty() ? Color.RED.getRGB() : Color.WHITE.getRGB());
        if (!this.trafficSignalLocations.isEmpty()) {
            this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"gui.trafficsignalcontroller.primary", (Object[])new Object[0]), (float)(this.guiLeft + 30), (float)(this.guiTop + 80), Color.WHITE.getRGB());
            this.orientationButton.field_146124_l = true;
            this.orientationButton.field_146126_j = this.orientedOnX ? "X" : "Z";
            this.orientationButton.func_146112_a(this.field_146297_k, mouseX, mouseY);
            this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"gui.trafficsignalcontroller.signalmode", (Object[])new Object[0]), (float)(this.guiLeft + 30), (float)(this.guiTop + 100), Color.WHITE.getRGB());
            this.modeButton.field_146124_l = true;
            this.modeButton.field_146126_j = I18n.func_135052_a((String)("gui.trafficsignalcontroller." + (this.triggerMode ? "modetrigger" : "modetime")), (Object[])new Object[0]);
            this.modeButton.func_146112_a(this.field_146297_k, mouseX, mouseY);
            if (!this.triggerMode) {
                this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"gui.trafficsignalcontroller.greenmaintime", (Object[])new Object[0]), (float)(this.guiLeft + 30), (float)(this.guiTop + 120), Color.WHITE.getRGB());
                this.greenMainTimeText.func_146189_e(true);
                this.greenMainTimeText.func_146194_f();
            } else {
                this.greenMainTimeText.func_146189_e(false);
            }
            this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"gui.trafficsignalcontroller.greencrosstime", (Object[])new Object[0]), (float)(this.guiLeft + 30), (float)(this.guiTop + 130), Color.WHITE.getRGB());
            this.greenCrossTimeText.func_146189_e(true);
            this.greenCrossTimeText.func_146194_f();
            this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"gui.trafficsignalcontroller.yellowtime", (Object[])new Object[0]), (float)(this.guiLeft + 30), (float)(this.guiTop + 140), Color.WHITE.getRGB());
            this.yellowTimeText.func_146189_e(true);
            this.yellowTimeText.func_146194_f();
            this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"gui.trafficsignalcontroller.allredtime", (Object[])new Object[0]), (float)(this.guiLeft + 30), (float)(this.guiTop + 150), Color.WHITE.getRGB());
            this.allRedTimeText.func_146189_e(true);
            this.allRedTimeText.func_146194_f();
            this.confirmButton.field_146124_l = true;
            this.confirmButton.func_146112_a(this.field_146297_k, mouseX, mouseY);
        } else {
            this.orientationButton.field_146124_l = false;
            this.modeButton.field_146124_l = false;
            this.greenMainTimeText.func_146189_e(false);
            this.greenCrossTimeText.func_146189_e(false);
            this.yellowTimeText.func_146189_e(false);
            this.allRedTimeText.func_146189_e(false);
            this.confirmButton.field_146124_l = false;
        }
    }

    protected void func_146284_a(GuiButton buttonClicked) throws IOException {
        super.func_146284_a(buttonClicked);
        if (buttonClicked.equals(this.scanButton)) {
            this.trafficSignalLocations.clear();
            int scanDistance = Integer.valueOf(this.scanDistanceText.func_146179_b());
            for (int i = this.signalController.func_174877_v().func_177958_n() - scanDistance; i <= this.signalController.func_174877_v().func_177958_n() + scanDistance; ++i) {
                for (int j = this.signalController.func_174877_v().func_177956_o() - scanDistance; j <= this.signalController.func_174877_v().func_177956_o() + scanDistance; ++j) {
                    for (int k = this.signalController.func_174877_v().func_177952_p() - scanDistance; k <= this.signalController.func_174877_v().func_177952_p() + scanDistance; ++k) {
                        BlockPos pos = new BlockPos(i, j, k);
                        Block block = this.signalController.func_145831_w().func_180495_p(pos).func_177230_c();
                        if (!block.equals(MTSRegistry.trafficSignal)) continue;
                        this.trafficSignalLocations.add(pos);
                    }
                }
            }
        } else if (buttonClicked.equals(this.orientationButton)) {
            this.orientedOnX = !this.orientedOnX;
        } else if (buttonClicked.equals(this.modeButton)) {
            this.triggerMode = !this.triggerMode;
        } else if (buttonClicked.equals(this.confirmButton)) {
            this.signalController.orientedOnX = this.orientedOnX;
            this.signalController.triggerMode = this.triggerMode;
            this.signalController.greenMainTime = Integer.valueOf(this.greenMainTimeText.func_146179_b()) * 20;
            this.signalController.greenCrossTime = Integer.valueOf(this.greenCrossTimeText.func_146179_b()) * 20;
            this.signalController.yellowTime = Integer.valueOf(this.yellowTimeText.func_146179_b()) * 20;
            this.signalController.allRedTime = Integer.valueOf(this.allRedTimeText.func_146179_b()) * 20;
            this.signalController.trafficSignalLocations.clear();
            this.signalController.trafficSignalLocations.addAll(this.trafficSignalLocations);
            MTS.MTSNet.sendToServer((IMessage)new PacketTrafficSignalControllerChange(this.signalController));
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        for (GuiTextField box : this.textList) {
            if (!box.func_146176_q()) continue;
            box.func_146192_a(x, y, button);
        }
    }

    protected void func_73869_a(char key, int bytecode) throws IOException {
        super.func_73869_a(key, bytecode);
        if (bytecode != 1 && bytecode >= 2 && bytecode <= 11 || bytecode == 14 || bytecode == 211) {
            for (GuiTextField box : this.textList) {
                if (!box.func_146206_l()) continue;
                box.func_146201_a(key, bytecode);
            }
        } else if (bytecode == 18) {
            super.func_73869_a(key, 1);
        }
    }
}

