/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.core;

import java.lang.reflect.Constructor;
import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.baseclasses.VehicleAxisAlignedBB;
import minecrafttransportsimulator.dataclasses.MTSRegistry;
import minecrafttransportsimulator.dataclasses.PackVehicleObject;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import minecrafttransportsimulator.vehicles.parts.APart;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemVehicle
extends Item {
    public final String vehicleName;

    public ItemVehicle(String vehicleName) {
        this.vehicleName = vehicleName;
        this.func_77655_b(vehicleName.replace(":", "."));
        this.func_77637_a(MTSRegistry.packTabs.get(vehicleName.substring(0, vehicleName.indexOf(58))));
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldStack;
        if (!world.field_72995_K && player.func_184586_b(hand) != null && (heldStack = player.func_184586_b(hand)).func_77973_b() != null) {
            pos = pos.func_177984_a();
            String vehicleToSpawnName = ((ItemVehicle)heldStack.func_77973_b()).vehicleName;
            try {
                Class<? extends EntityVehicleE_Powered> vehicleClass = PackParserSystem.getVehicleClass(vehicleToSpawnName);
                Constructor<? extends EntityVehicleE_Powered> construct = vehicleClass.getConstructor(World.class, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, String.class);
                EntityVehicleE_Powered newVehicle = construct.newInstance(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), Float.valueOf(player.field_70177_z), vehicleToSpawnName);
                if (heldStack.func_77942_o()) {
                    byte i;
                    NBTTagCompound tagCompound = heldStack.func_77978_p();
                    newVehicle.func_184221_a(tagCompound.func_186857_a("UUID"));
                    NBTTagList partTagList = tagCompound.func_150295_c("Parts", 10);
                    for (i = 0; i < partTagList.func_74745_c(); i = (byte)((byte)(i + 1))) {
                        try {
                            NBTTagCompound partTag = partTagList.func_150305_b((int)i);
                            PackVehicleObject.PackPart packPart = newVehicle.getPackDefForLocation(partTag.func_74769_h("offsetX"), partTag.func_74769_h("offsetY"), partTag.func_74769_h("offsetZ"));
                            Class<? extends APart> partClass = PackParserSystem.getPartPartClass(partTag.func_74779_i("partName"));
                            Constructor<? extends APart> partConstruct = partClass.getConstructor(EntityVehicleE_Powered.class, PackVehicleObject.PackPart.class, String.class, NBTTagCompound.class);
                            APart savedPart = partConstruct.newInstance(new Object[]{newVehicle, packPart, partTag.func_74779_i("partName"), partTag});
                            newVehicle.addPart(savedPart, true);
                            continue;
                        }
                        catch (Exception e) {
                            MTS.MTSLog.error("ERROR IN LOADING PART FROM NBT!");
                            e.printStackTrace();
                        }
                    }
                    newVehicle.locked = tagCompound.func_74767_n("locked");
                    newVehicle.brokenWindows = tagCompound.func_74771_c("brokenWindows");
                    newVehicle.ownerName = tagCompound.func_74779_i("ownerName");
                    newVehicle.displayText = tagCompound.func_74779_i("displayText");
                    newVehicle.parkingBrakeOn = tagCompound.func_74767_n("parkingBrakeOn");
                    newVehicle.fuel = tagCompound.func_74769_h("fuel");
                    newVehicle.electricPower = tagCompound.func_74769_h("electricPower");
                    for (i = 0; i < newVehicle.pack.motorized.instruments.size(); i = (byte)((byte)(i + 1))) {
                        String instrumentInSlot;
                        EntityVehicleE_Powered.VehicleInstrument instrument;
                        if (!tagCompound.func_74764_b("instrumentInSlot" + i) || (instrument = new EntityVehicleE_Powered.VehicleInstrument(instrumentInSlot = tagCompound.func_74779_i("instrumentInSlot" + i))) == null || !instrument.pack.general.validVehicles.contains(newVehicle.pack.general.type)) continue;
                        newVehicle.setInstrumentInSlot(i, instrumentInSlot);
                    }
                }
                double minHeight = 0.0;
                for (PackVehicleObject.PackCollisionBox collisionBox : newVehicle.pack.collision) {
                    minHeight = Math.min((double)(collisionBox.pos[1] - collisionBox.height / 2.0f), minHeight);
                }
                for (APart part : newVehicle.getVehicleParts()) {
                    minHeight = Math.min(part.offset.field_72450_a - (double)(part.getHeight() / 2.0f), minHeight);
                }
                newVehicle.field_70163_u += -minHeight;
                for (VehicleAxisAlignedBB coreBox : newVehicle.getCurrentCollisionBoxes()) {
                    if (!world.func_184143_b((AxisAlignedBB)coreBox)) continue;
                    newVehicle.func_70106_y();
                    return EnumActionResult.FAIL;
                }
                world.func_72838_d((Entity)newVehicle);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_174925_a(heldStack.func_77973_b(), heldStack.func_77952_i(), 1, heldStack.func_77978_p());
                }
                return EnumActionResult.SUCCESS;
            }
            catch (Exception e) {
                MTS.MTSLog.error("ERROR SPAWING VEHICLE ENTITY!");
                e.printStackTrace();
            }
        }
        return EnumActionResult.FAIL;
    }
}

