/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.parts;

import java.util.List;
import minecrafttransportsimulator.dataclasses.PackPartObject;
import minecrafttransportsimulator.items.parts.AItemPartEngine;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.vehicles.parts.APartEngine;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ItemPartEngineCar
extends AItemPartEngine {
    public ItemPartEngineCar(String partName) {
        super(partName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltipLines, boolean p_77624_4_) {
        NBTTagCompound stackTag = stack.func_77978_p();
        PackPartObject pack = PackParserSystem.getPartPack(((ItemPartEngineCar)stack.func_77973_b()).partName);
        if (stackTag != null && stackTag.func_74767_n("isCreative")) {
            tooltipLines.add(TextFormatting.DARK_PURPLE + I18n.func_135052_a((String)"info.item.engine.creative", (Object[])new Object[0]));
        }
        tooltipLines.add(I18n.func_135052_a((String)"info.item.engine.maxrpm", (Object[])new Object[0]) + pack.engine.maxRPM);
        tooltipLines.add(I18n.func_135052_a((String)"info.item.engine.maxsaferpm", (Object[])new Object[0]) + APartEngine.getSafeRPMFromMax(pack.engine.maxRPM));
        tooltipLines.add(I18n.func_135052_a((String)"info.item.engine.fuelconsumption", (Object[])new Object[0]) + pack.engine.fuelConsumption);
        tooltipLines.add(I18n.func_135052_a((String)"info.item.engine.hours", (Object[])new Object[0]) + (stackTag != null ? (double)Math.round(stackTag.func_74769_h("hours") * 100.0) / 100.0 : 0.0));
        tooltipLines.add(pack.engine.isAutomatic ? I18n.func_135052_a((String)"info.item.engine.automatic", (Object[])new Object[0]) : I18n.func_135052_a((String)"info.item.engine.manual", (Object[])new Object[0]));
        tooltipLines.add(I18n.func_135052_a((String)"info.item.engine.gearratios", (Object[])new Object[0]));
        for (int i = 0; i < pack.engine.gearRatios.length; i = (int)((byte)(i + 3))) {
            String gearRatios = String.valueOf(pack.engine.gearRatios[i]);
            if (i + 1 < pack.engine.gearRatios.length) {
                gearRatios = gearRatios + ",   " + String.valueOf(pack.engine.gearRatios[i + 1]);
            }
            if (i + 2 < pack.engine.gearRatios.length) {
                gearRatios = gearRatios + ",   " + String.valueOf(pack.engine.gearRatios[i + 2]);
            }
            tooltipLines.add(gearRatios);
        }
        if (stackTag != null) {
            if (stackTag.func_74767_n("oilLeak")) {
                tooltipLines.add(TextFormatting.RED + I18n.func_135052_a((String)"info.item.engine.oilleak", (Object[])new Object[0]));
            }
            if (stackTag.func_74767_n("fuelLeak")) {
                tooltipLines.add(TextFormatting.RED + I18n.func_135052_a((String)"info.item.engine.fuelleak", (Object[])new Object[0]));
            }
            if (stackTag.func_74767_n("brokenStarter")) {
                tooltipLines.add(TextFormatting.RED + I18n.func_135052_a((String)"info.item.engine.brokenstarter", (Object[])new Object[0]));
            }
        }
    }
}

