/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.parts;

import java.util.List;
import minecrafttransportsimulator.dataclasses.PackPartObject;
import minecrafttransportsimulator.dataclasses.PackVehicleObject;
import minecrafttransportsimulator.items.parts.AItemPart;
import minecrafttransportsimulator.systems.PackParserSystem;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPartPropeller
extends AItemPart {
    public ItemPartPropeller(String partName) {
        super(partName);
    }

    @Override
    public boolean isPartValidForPackDef(PackVehicleObject.PackPart packPart) {
        float propellerDiameter = PackParserSystem.getPartPack((String)this.partName).propeller.diameter;
        return packPart.minValue <= propellerDiameter && packPart.maxValue >= propellerDiameter ? super.isPartValidForPackDef(packPart) : false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltipLines, boolean p_77624_4_) {
        PackPartObject pack = PackParserSystem.getPartPack(((ItemPartPropeller)stack.func_77973_b()).partName);
        tooltipLines.add(I18n.func_135052_a((String)(pack.propeller.isDynamicPitch ? "info.item.propeller.dynamicPitch" : "info.item.propeller.staticPitch"), (Object[])new Object[0]));
        tooltipLines.add(I18n.func_135052_a((String)"info.item.propeller.numberBlades", (Object[])new Object[0]) + pack.propeller.numberBlades);
        tooltipLines.add(I18n.func_135052_a((String)"info.item.propeller.pitch", (Object[])new Object[0]) + pack.propeller.pitch);
        tooltipLines.add(I18n.func_135052_a((String)"info.item.propeller.diameter", (Object[])new Object[0]) + pack.propeller.diameter);
        tooltipLines.add(I18n.func_135052_a((String)"info.item.propeller.maxrpm", (Object[])new Object[0]) + Math.round(20417.4 / (0.07979645340118074 * (double)pack.propeller.diameter)));
        if (stack.func_77942_o()) {
            tooltipLines.add(I18n.func_135052_a((String)"info.item.propeller.health", (Object[])new Object[0]) + ((float)pack.propeller.startingHealth - stack.func_77978_p().func_74760_g("damage")));
        } else {
            tooltipLines.add(I18n.func_135052_a((String)"info.item.propeller.health", (Object[])new Object[0]) + pack.propeller.startingHealth);
        }
    }
}

