/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.control;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Plane;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class AileronPacket
implements IMessage {
    private int id;
    private byte packetType;
    private short aileronData;

    public AileronPacket() {
    }

    public AileronPacket(int id, boolean increment, short aileronCooldown) {
        this.id = id;
        this.aileronData = aileronCooldown;
        this.packetType = (byte)(increment ? 1 : -1);
    }

    public AileronPacket(int id, short aileronAngle) {
        this.id = id;
        this.aileronData = aileronAngle;
        this.packetType = 0;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.packetType = buf.readByte();
        this.aileronData = buf.readShort();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeByte((int)this.packetType);
        buf.writeShort((int)this.aileronData);
    }

    public static class Handler
    implements IMessageHandler<AileronPacket, IMessage> {
        public IMessage onMessage(final AileronPacket message, final MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(new Runnable(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    EntityVehicleF_Plane thisEntity;
                    if (ctx.side.isServer()) {
                        thisEntity = (EntityVehicleF_Plane)ctx.getServerHandler().field_147369_b.field_70170_p.func_73045_a(message.id);
                    } else {
                        if (Minecraft.func_71410_x().field_71441_e == null) {
                            return;
                        }
                        thisEntity = (EntityVehicleF_Plane)Minecraft.func_71410_x().field_71441_e.func_73045_a(message.id);
                    }
                    if (thisEntity == null) return;
                    if (message.packetType == 1) {
                        thisEntity.aileronCooldown = message.aileronData;
                        if (thisEntity.aileronAngle + 6 > 250) return;
                        thisEntity.aileronAngle = (short)(thisEntity.aileronAngle + 6);
                    } else if (message.packetType == -1) {
                        thisEntity.aileronCooldown = message.aileronData;
                        if (thisEntity.aileronAngle - 6 < -250) return;
                        thisEntity.aileronAngle = (short)(thisEntity.aileronAngle - 6);
                    } else {
                        thisEntity.aileronAngle = message.aileronData;
                        thisEntity.aileronCooldown = Short.MAX_VALUE;
                    }
                    if (!ctx.side.isServer()) return;
                    MTS.MTSNet.sendToAll((IMessage)message);
                }
            });
            return null;
        }
    }
}

