/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.general;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.dataclasses.DamageSources;
import minecrafttransportsimulator.dataclasses.PackPartObject;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleB_Existing;
import net.minecraft.block.SoundType;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketBulletHit
implements IMessage {
    private double x;
    private double y;
    private double z;
    private double velocity;
    private String bulletName;
    private int playerID;
    private int entitiyHitID;

    public PacketBulletHit() {
    }

    public PacketBulletHit(double x, double y, double z, double velocity, String bulletName, int playerID, int entitiyHitID) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.velocity = velocity;
        this.bulletName = bulletName;
        this.playerID = playerID;
        this.entitiyHitID = entitiyHitID;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.velocity = buf.readDouble();
        this.bulletName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.playerID = buf.readInt();
        this.entitiyHitID = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.velocity);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.bulletName);
        buf.writeInt(this.playerID);
        buf.writeInt(this.entitiyHitID);
    }

    public static class Handler
    implements IMessageHandler<PacketBulletHit, IMessage> {
        public IMessage onMessage(final PacketBulletHit message, final MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    if (ctx.side.isServer()) {
                        PackPartObject.PartBulletConfig bulletPackData = PackParserSystem.getPartPack((String)((PacketBulletHit)message).bulletName).bullet;
                        Entity entityAttacking = ctx.getServerHandler().field_147369_b.field_70170_p.func_73045_a(message.playerID);
                        if (bulletPackData.type.equals("explosive")) {
                            ctx.getServerHandler().field_147369_b.field_70170_p.func_72885_a(entityAttacking, message.x, message.y, message.z, 12.0f, false, true);
                        } else if (message.entitiyHitID != -1) {
                            Entity entityHit = ctx.getServerHandler().field_147369_b.field_70170_p.func_73045_a(message.entitiyHitID);
                            if (entityHit != null && entityAttacking != null) {
                                float damage = (float)(Math.pow(message.velocity / 1000.0, 2.0) * (double)bulletPackData.diameter / 10.0 * ConfigSystem.getDoubleConfig("BulletDamageFactor"));
                                if (entityHit instanceof EntityVehicleB_Existing) {
                                    ((EntityVehicleB_Existing)entityHit).attackManuallyAtPosition(message.x, message.y, message.z, new DamageSources.DamageSourceBullet(entityAttacking, bulletPackData.type), damage);
                                } else {
                                    entityHit.func_70097_a((DamageSource)new DamageSources.DamageSourceBullet(entityAttacking, bulletPackData.type), damage);
                                    if (bulletPackData.type.equals("incendiary")) {
                                        entityHit.func_70015_d(5);
                                    }
                                }
                            }
                        } else {
                            BlockPos hitPos = new BlockPos(message.x, message.y, message.z);
                            float hardness = ctx.getServerHandler().field_147369_b.field_70170_p.func_180495_p(hitPos).func_185887_b(ctx.getServerHandler().field_147369_b.field_70170_p, hitPos);
                            if ((double)hardness <= 0.3 && (double)hardness <= Math.random() * 0.3 + 0.3 * (double)bulletPackData.diameter / 20.0) {
                                ctx.getServerHandler().field_147369_b.field_70170_p.func_175655_b(hitPos, true);
                            } else {
                                MTS.MTSNet.sendToAll((IMessage)message);
                            }
                        }
                    } else {
                        BlockPos hitPos = new BlockPos(message.x, message.y, message.z);
                        SoundType soundType = Minecraft.func_71410_x().field_71441_e.func_180495_p(hitPos).func_177230_c().getSoundType(Minecraft.func_71410_x().field_71441_e.func_180495_p(hitPos), (World)Minecraft.func_71410_x().field_71441_e, hitPos, null);
                        Minecraft.func_71410_x().field_71441_e.func_184148_a(null, message.x, message.y, message.z, soundType.func_185845_c(), SoundCategory.BLOCKS, soundType.func_185843_a(), soundType.func_185847_b());
                    }
                }
            });
            return null;
        }
    }
}

