/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.general;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.dataclasses.MTSRegistry;
import minecrafttransportsimulator.systems.PackParserSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketPlayerCrafting
implements IMessage {
    private int playerID;
    private String selectedItem;

    public PacketPlayerCrafting() {
    }

    public PacketPlayerCrafting(EntityPlayer player, String selectedItem) {
        this.playerID = player.func_145782_y();
        this.selectedItem = selectedItem;
    }

    public void fromBytes(ByteBuf buf) {
        this.playerID = buf.readInt();
        this.selectedItem = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.playerID);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.selectedItem);
    }

    protected static EntityPlayer getPlayer(PacketPlayerCrafting message, MessageContext ctx) {
        if (message.playerID != -1) {
            if (ctx.side.isServer()) {
                return (EntityPlayer)ctx.getServerHandler().field_147369_b.field_70170_p.func_73045_a(message.playerID);
            }
            return (EntityPlayer)Minecraft.func_71410_x().field_71441_e.func_73045_a(message.playerID);
        }
        return null;
    }

    public static boolean doesPlayerHaveMaterials(EntityPlayer player, String partToCraft) {
        if (!player.field_71075_bZ.field_75098_d) {
            for (ItemStack materialStack : PackParserSystem.getMaterials(partToCraft)) {
                int requiredMaterialCount = materialStack.field_77994_a;
                for (ItemStack stack : player.field_71071_by.field_70462_a) {
                    if (stack == null) continue;
                    if (materialStack.func_77952_i() == Integer.MAX_VALUE) {
                        if (!materialStack.func_77973_b().equals(stack.func_77973_b())) continue;
                        requiredMaterialCount -= stack.field_77994_a;
                        continue;
                    }
                    if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)materialStack)) continue;
                    requiredMaterialCount -= stack.field_77994_a;
                }
                if (requiredMaterialCount <= 0) continue;
                return false;
            }
        }
        return true;
    }

    protected static void removeMaterials(EntityPlayer player, String partToCraft) {
        if (!player.field_71075_bZ.field_75098_d) {
            for (ItemStack materialStack : PackParserSystem.getMaterials(partToCraft)) {
                player.field_71071_by.func_174925_a(materialStack.func_77973_b(), materialStack.func_77960_j() == Integer.MAX_VALUE ? -1 : materialStack.func_77960_j(), materialStack.field_77994_a, null);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<PacketPlayerCrafting, IMessage> {
        public IMessage onMessage(final PacketPlayerCrafting message, final MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityPlayer player = PacketPlayerCrafting.getPlayer(message, ctx);
                    if (player != null && PacketPlayerCrafting.doesPlayerHaveMaterials(player, message.selectedItem)) {
                        PacketPlayerCrafting.removeMaterials(player, message.selectedItem);
                        ItemStack stack = MTSRegistry.vehicleItemMap.containsKey(message.selectedItem) ? new ItemStack((Item)MTSRegistry.vehicleItemMap.get(message.selectedItem)) : (MTSRegistry.partItemMap.containsKey(message.selectedItem) ? new ItemStack((Item)MTSRegistry.partItemMap.get(message.selectedItem)) : new ItemStack((Item)MTSRegistry.instrumentItemMap.get(message.selectedItem)));
                        player.func_130014_f_().func_72838_d((Entity)new EntityItem(player.func_130014_f_(), player.field_70165_t, player.field_70163_u, player.field_70161_v, stack));
                    }
                }
            });
            return null;
        }
    }
}

