/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.parts;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.packets.parts.APacketPart;
import minecrafttransportsimulator.vehicles.main.EntityVehicleA_Base;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.APartEngine;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketPartEngineLinked
extends APacketPart {
    private int linkedId;
    private double linkedX;
    private double linkedY;
    private double linkedZ;

    public PacketPartEngineLinked() {
    }

    public PacketPartEngineLinked(APartEngine engine, APartEngine engineLinked) {
        super(engine);
        this.linkedId = engineLinked.vehicle.func_145782_y();
        this.linkedX = engineLinked.offset.field_72450_a;
        this.linkedY = engineLinked.offset.field_72448_b;
        this.linkedZ = engineLinked.offset.field_72449_c;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.linkedId = buf.readInt();
        this.linkedX = buf.readDouble();
        this.linkedY = buf.readDouble();
        this.linkedZ = buf.readDouble();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.linkedId);
        buf.writeDouble(this.linkedX);
        buf.writeDouble(this.linkedY);
        buf.writeDouble(this.linkedZ);
    }

    public static class Handler
    implements IMessageHandler<PacketPartEngineLinked, IMessage> {
        public IMessage onMessage(final PacketPartEngineLinked message, final MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    APartEngine engine = (APartEngine)APacketPart.getVehiclePartFromMessage(message, ctx);
                    EntityVehicleA_Base linkedVehicle = (EntityVehicleA_Base)Minecraft.func_71410_x().field_71441_e.func_73045_a(message.linkedId);
                    APartEngine linkedEngine = null;
                    if (linkedVehicle != null) {
                        for (APart part : linkedVehicle.getVehicleParts()) {
                            if (part.offset.field_72450_a != message.linkedX || part.offset.field_72448_b != message.linkedY || part.offset.field_72449_c != message.linkedZ) continue;
                            linkedEngine = (APartEngine)part;
                        }
                    }
                    if (engine != null && linkedEngine != null) {
                        engine.linkedEngine = linkedEngine;
                        linkedEngine.linkedEngine = engine;
                    }
                }
            });
            return null;
        }
    }
}

