/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.parts;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.dataclasses.PackPartObject;
import minecrafttransportsimulator.packets.parts.APacketPart;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.vehicles.parts.APartGun;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketPartGunReload
extends APacketPart {
    private String bulletReloaded;

    public PacketPartGunReload() {
    }

    public PacketPartGunReload(APartGun gun, String bulletReloaded) {
        super(gun);
        this.bulletReloaded = bulletReloaded;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.bulletReloaded = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.bulletReloaded);
    }

    public static class Handler
    implements IMessageHandler<PacketPartGunReload, IMessage> {
        public IMessage onMessage(final PacketPartGunReload message, final MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    APartGun gun = (APartGun)APacketPart.getVehiclePartFromMessage(message, ctx);
                    if (gun != null) {
                        PackPartObject.PartBulletConfig bulletPack = PackParserSystem.getPartPack((String)((PacketPartGunReload)message).bulletReloaded).bullet;
                        gun.loadedBullet = message.bulletReloaded;
                        gun.bulletsLeft += bulletPack.quantity;
                        gun.reloadTimeRemaining = gun.pack.gun.reloadTime;
                        gun.reloading = true;
                        MTS.proxy.playSound(Minecraft.func_71410_x().field_71439_g.func_174791_d(), gun.partName + "_reloading", 1.0f, 1.0f);
                    }
                }
            });
            return null;
        }
    }
}

