/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.tileentities;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.blocks.core.TileEntityFuelPump;
import minecrafttransportsimulator.packets.tileentities.APacketTileEntity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketFuelPumpFillDrain
extends APacketTileEntity {
    private FluidStack stack;

    public PacketFuelPumpFillDrain() {
    }

    public PacketFuelPumpFillDrain(TileEntityFuelPump tile, FluidStack stack) {
        super(tile);
        this.stack = stack;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)ByteBufUtils.readTag((ByteBuf)buf));
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.stack.writeToNBT(new NBTTagCompound()));
    }

    public static class Handler
    implements IMessageHandler<PacketFuelPumpFillDrain, IMessage> {
        public IMessage onMessage(final PacketFuelPumpFillDrain message, final MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    TileEntityFuelPump pump = (TileEntityFuelPump)APacketTileEntity.getTileEntity(message, ctx);
                    if (pump != null) {
                        if (pump.getFluid() == null) {
                            pump.setFluid(message.stack.getFluid());
                        }
                        pump.getFluid().amount += ((PacketFuelPumpFillDrain)message).stack.amount;
                    }
                }
            });
            return null;
        }
    }
}

