/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.tileentities;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.blocks.pole.TileEntityPoleSign;
import minecrafttransportsimulator.packets.tileentities.APacketTileEntity;
import minecrafttransportsimulator.systems.PackParserSystem;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSignChange
extends APacketTileEntity {
    private String definition;
    private List<String> text = new ArrayList<String>();

    public PacketSignChange() {
    }

    public PacketSignChange(TileEntityPoleSign tile, String definition, List<String> text) {
        super(tile);
        this.definition = definition;
        this.text = text;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.definition = ByteBufUtils.readUTF8String((ByteBuf)buf);
        if (PackParserSystem.getSign((String)this.definition).general.textLines != null) {
            for (int i = 0; i < PackParserSystem.getSign((String)this.definition).general.textLines.length; i = (int)((byte)(i + 1))) {
                this.text.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
        }
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.definition);
        if (PackParserSystem.getSign((String)this.definition).general.textLines != null) {
            for (int i = 0; i < PackParserSystem.getSign((String)this.definition).general.textLines.length; i = (int)((byte)(i + 1))) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.text.get(i));
            }
        }
    }

    public static class Handler
    implements IMessageHandler<PacketSignChange, IMessage> {
        public IMessage onMessage(final PacketSignChange message, final MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    TileEntityPoleSign decor = (TileEntityPoleSign)APacketTileEntity.getTileEntity(message, ctx);
                    if (decor != null) {
                        decor.definition = message.definition;
                        decor.text = message.text;
                        if (ctx.side.isServer()) {
                            MTS.MTSNet.sendToAll((IMessage)message);
                        }
                    }
                }
            });
            return null;
        }
    }
}

