/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.vehicles;

import io.netty.buffer.ByteBuf;
import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.dataclasses.MTSRegistry;
import minecrafttransportsimulator.packets.vehicles.APacketVehicle;
import minecrafttransportsimulator.packets.vehicles.APacketVehiclePlayer;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketVehicleInstruments
extends APacketVehiclePlayer {
    private byte slotToChange;
    private String instrumentToChangeTo;

    public PacketVehicleInstruments() {
    }

    public PacketVehicleInstruments(EntityVehicleE_Powered vehicle, EntityPlayer player, byte slotToChange, String instrumentToChangeTo) {
        super(vehicle, player);
        this.slotToChange = slotToChange;
        this.instrumentToChangeTo = instrumentToChangeTo;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.slotToChange = buf.readByte();
        this.instrumentToChangeTo = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeByte((int)this.slotToChange);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.instrumentToChangeTo);
    }

    public static class Handler
    implements IMessageHandler<PacketVehicleInstruments, IMessage> {
        public IMessage onMessage(final PacketVehicleInstruments message, final MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityVehicleE_Powered vehicle = (EntityVehicleE_Powered)APacketVehicle.getVehicle(message, ctx);
                    EntityPlayer player = APacketVehiclePlayer.getPlayer(message, ctx);
                    if (vehicle != null && player != null) {
                        if (!player.field_71075_bZ.field_75098_d && ctx.side.isServer() && vehicle.getInstrumentInfoInSlot(message.slotToChange) != null && !player.field_71071_by.func_70441_a(new ItemStack((Item)MTSRegistry.instrumentItemMap.get(vehicle.getInstrumentInfoInSlot((byte)((PacketVehicleInstruments)message).slotToChange).name)))) {
                            return;
                        }
                        if (!player.field_71075_bZ.field_75098_d && ctx.side.isServer() && !message.instrumentToChangeTo.isEmpty()) {
                            if (player.field_71071_by.func_70431_c(new ItemStack((Item)MTSRegistry.instrumentItemMap.get(message.instrumentToChangeTo)))) {
                                player.field_71071_by.func_174925_a((Item)MTSRegistry.instrumentItemMap.get(message.instrumentToChangeTo), -1, 1, null);
                            } else {
                                return;
                            }
                        }
                        vehicle.setInstrumentInSlot(message.slotToChange, message.instrumentToChangeTo);
                        if (ctx.side.isServer()) {
                            MTS.MTSNet.sendToAll((IMessage)message);
                        }
                    }
                }
            });
            return null;
        }
    }
}

