/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering;

import minecrafttransportsimulator.dataclasses.MTSControls;
import minecrafttransportsimulator.rendering.RenderInstruments;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Plane;
import org.lwjgl.opengl.GL11;

public final class RenderControls
extends RenderInstruments {
    public static void drawControl(EntityVehicleE_Powered vehicle, MTSControls.Controls control, boolean hud) {
        textureManager.func_110577_a(controlsTexture);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        switch (control) {
            case PARKING_BRAKE: {
                RenderControls.drawParkingBrake((EntityVehicleF_Plane)vehicle, hud);
                break;
            }
            case AIRCRAFT_THROTTLE: {
                RenderControls.drawAircraftThrottle((EntityVehicleF_Plane)vehicle, hud);
                break;
            }
            case AIRCRAFT_FLAPS: {
                RenderControls.drawFlapIndicator((EntityVehicleF_Plane)vehicle, hud);
            }
        }
    }

    private static void drawParkingBrake(EntityVehicleF_Plane plane, boolean hud) {
        byte offset = (byte)(plane.parkingBrakeOn || plane.brakeOn ? -10 : 6);
        byte rotation = (byte)(plane.parkingBrakeOn || plane.brakeOn ? -90 : 0);
        if (!hud) {
            RenderControls.renderSquareUV(10.5f, 10.5f, 0.0f, 0.75f, 0.875f, 0.875f, 1.0f);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)1.75f, (float)offset);
            RenderControls.renderSquareUV(3.5f, 0.0f, 20.0f, 0.640625f, 0.734375f, 0.890625f, 0.984375f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)1.75f, (float)1.75f, (float)0.0f);
            RenderControls.renderSquareUV(3.5f, 0.0f, 20.0f, 0.640625f, 0.734375f, 0.890625f, 0.984375f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)1.75f, (float)1.75f, (float)0.0f);
            RenderControls.renderSquareUV(3.5f, 0.0f, 20.0f, 0.640625f, 0.734375f, 0.890625f, 0.984375f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)1.75f, (float)1.75f, (float)0.0f);
            RenderControls.renderSquareUV(3.5f, 0.0f, 20.0f, 0.640625f, 0.734375f, 0.890625f, 0.984375f);
            GL11.glPopMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(offset - 10));
            GL11.glRotatef((float)rotation, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)7.0f, (float)0.0f, (float)0.0f);
            RenderControls.renderSquareUV(35.0f, 10.0f, 0.0f, 0.2578125f, 0.3671875f, 0.921875f, 0.953125f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.01f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            RenderControls.drawScaledString("BRAKE", -15, -4, 0.5f);
        } else {
            RenderControls.renderSquareUV(10.5f, 10.5f, 0.0f, 0.75f, 0.875f, 0.875f, 1.0f);
            if (plane.parkingBrakeOn || plane.brakeOn) {
                GL11.glTranslatef((float)0.0f, (float)10.0f, (float)0.0f);
                RenderControls.renderSquareUV(3.5f, 20.0f, 0.0f, 0.640625f, 0.734375f, 0.890625f, 0.984375f);
                GL11.glRotatef((float)(-rotation), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)7.0f, (float)0.0f, (float)0.0f);
                RenderControls.renderSquareUV(35.0f, 10.0f, 0.0f, 0.2578125f, 0.3671875f, 0.921875f, 0.953125f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                RenderControls.drawScaledString("BRAKE", -15, -4, 0.5f);
            } else {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)7.0f, (float)-2.0f, (float)0.0f);
                RenderControls.renderSquareUV(35.0f, 10.0f, 0.0f, 0.2578125f, 0.3671875f, 0.921875f, 0.953125f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                RenderControls.drawScaledString("BRAKE", -15, -4, 0.5f);
            }
        }
    }

    private static void drawAircraftThrottle(EntityVehicleF_Plane plane, boolean hud) {
        RenderControls.renderSquareUV(10.5f, 10.5f, 0.0f, 0.75f, 0.875f, 0.875f, 1.0f);
        float offset = 3.0f - (10.0f - (float)plane.throttle / 10.0f);
        if (!hud) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)1.75f, (float)offset);
            RenderControls.renderSquareUV(3.5f, 0.0f, 20.0f, 0.640625f, 0.734375f, 0.890625f, 0.984375f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)1.75f, (float)1.75f, (float)0.0f);
            RenderControls.renderSquareUV(3.5f, 0.0f, 20.0f, 0.640625f, 0.734375f, 0.890625f, 0.984375f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)1.75f, (float)1.75f, (float)0.0f);
            RenderControls.renderSquareUV(3.5f, 0.0f, 20.0f, 0.640625f, 0.734375f, 0.890625f, 0.984375f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)1.75f, (float)1.75f, (float)0.0f);
            RenderControls.renderSquareUV(3.5f, 0.0f, 20.0f, 0.640625f, 0.734375f, 0.890625f, 0.984375f);
            GL11.glPopMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(offset - 10.0f));
            RenderControls.renderSquareUV(14.0f, 14.0f, 0.0f, 0.75f, 0.875f, 0.875f, 1.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            RenderControls.renderSquareUV(14.0f, 14.0f, 0.0f, 0.75f, 0.875f, 0.875f, 1.0f);
        } else {
            GL11.glTranslated((double)0.0, (double)(5.0f - offset / 2.0f), (double)0.0);
            RenderControls.renderSquareUV(3.5f, 10.0f - offset, 0.0f, 0.640625f, 0.734375f, 0.890625f, 0.984375f);
            GL11.glTranslated((double)0.0, (double)(-offset / 2.0f), (double)0.0);
            RenderControls.renderSquareUV(14.0f, 14.0f, 0.0f, 0.75f, 0.875f, 0.875f, 1.0f);
        }
    }

    private static void drawFlapIndicator(EntityVehicleF_Plane plane, boolean hud) {
        if (!hud) {
            RenderControls.renderSquareUV(23.0f, 30.0f, 0.0f, 0.515625f, 0.609375f, 0.875f, 1.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.01f);
        } else {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            RenderControls.renderSquareUV(23.0f, 30.0f, 0.0f, 0.515625f, 0.609375f, 0.875f, 1.0f);
        }
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderControls.drawScaledString("FLAPS", -15, -15, 0.5f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderControls.drawScaledString("0", 8, -15, 0.5f);
        RenderControls.drawScaledString("35", 8, 10, 0.5f);
        GL11.glRotatef((float)-180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)0.0f, (float)(7 - plane.flapDesiredAngle / 25), (float)0.0f);
        textureManager.func_110577_a(controlsTexture);
        if (!hud) {
            GL11.glTranslatef((float)1.875f, (float)0.5f, (float)-3.75f);
            RenderControls.renderSquareUV(7.5f, 0.0f, 7.0f, 0.421875f, 0.453125f, 0.921875f, 0.953125f);
            GL11.glTranslatef((float)3.75f, (float)-0.5f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            RenderControls.renderSquareUV(1.0f, 0.0f, 7.0f, 0.421875f, 0.453125f, 0.921875f, 0.953125f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)3.75f, (float)0.5f, (float)0.0f);
            RenderControls.renderSquareUV(7.5f, 0.0f, 7.0f, 0.421875f, 0.453125f, 0.921875f, 0.953125f);
            GL11.glTranslatef((float)3.75f, (float)-0.5f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            RenderControls.renderSquareUV(1.0f, 0.0f, 7.0f, 0.421875f, 0.453125f, 0.921875f, 0.953125f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)3.75f, (float)0.0f, (float)-3.5f);
            RenderControls.renderSquareUV(7.0f, 1.0f, 0.0f, 0.421875f, 0.453125f, 0.921875f, 0.953125f);
        } else {
            GL11.glTranslatef((float)1.875f, (float)-1.875f, (float)0.0f);
            RenderControls.renderSquareUV(7.5f, 7.0f, 0.0f, 0.421875f, 0.453125f, 0.921875f, 0.953125f);
        }
    }
}

