/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.VehicleAxisAlignedBB;
import minecrafttransportsimulator.dataclasses.MTSControls;
import minecrafttransportsimulator.dataclasses.PackPartObject;
import minecrafttransportsimulator.dataclasses.PackVehicleObject;
import minecrafttransportsimulator.items.parts.AItemPart;
import minecrafttransportsimulator.rendering.RenderControls;
import minecrafttransportsimulator.rendering.RenderInstruments;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.OBJParserSystem;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.systems.RotationSystem;
import minecrafttransportsimulator.systems.SFXSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Plane;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.APartEngine;
import minecrafttransportsimulator.vehicles.parts.PartEngineCar;
import minecrafttransportsimulator.vehicles.parts.PartGroundDeviceTread;
import minecrafttransportsimulator.vehicles.parts.PartPropeller;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public final class RenderVehicle
extends Render<EntityVehicleE_Powered> {
    private static final Minecraft minecraft = Minecraft.func_71410_x();
    private static final Map<String, Integer> vehicleDisplayLists = new HashMap<String, Integer>();
    private static final Map<String, List<RotatablePart>> vehicleRotatableLists = new HashMap<String, List<RotatablePart>>();
    private static final Map<String, List<TranslatablePart>> vehicleTranslatableLists = new HashMap<String, List<TranslatablePart>>();
    private static final Map<String, List<LightPart>> vehicleLightLists = new HashMap<String, List<LightPart>>();
    private static final Map<String, List<WindowPart>> vehicleWindowLists = new HashMap<String, List<WindowPart>>();
    private static final Map<ResourceLocation, Integer> partDisplayLists = new HashMap<ResourceLocation, Integer>();
    private static final Map<ResourceLocation, List<RotatablePart>> partRotatableLists = new HashMap<ResourceLocation, List<RotatablePart>>();
    private static final Map<ResourceLocation, List<LightPart>> partLightLists = new HashMap<ResourceLocation, List<LightPart>>();
    private static final Map<ResourceLocation, List<Float[]>> treadDeltas = new HashMap<ResourceLocation, List<Float[]>>();
    private static final Map<String, ResourceLocation> textureMap = new HashMap<String, ResourceLocation>();
    private static final Map<EntityVehicleE_Powered, Byte> lastRenderPass = new HashMap<EntityVehicleE_Powered, Byte>();
    private static final Map<EntityVehicleE_Powered, Long> lastRenderTick = new HashMap<EntityVehicleE_Powered, Long>();
    private static final Map<EntityVehicleE_Powered, Float> lastRenderPartial = new HashMap<EntityVehicleE_Powered, Float>();
    private static final ResourceLocation vanillaGlassTexture = new ResourceLocation("minecraft", "textures/blocks/glass.png");
    private static final ResourceLocation lensFlareTexture = new ResourceLocation("mts", "textures/rendering/lensflare.png");
    private static final ResourceLocation lightTexture = new ResourceLocation("mts", "textures/rendering/light.png");
    private static final ResourceLocation lightBeamTexture = new ResourceLocation("mts", "textures/rendering/lightbeam.png");

    public RenderVehicle(RenderManager renderManager) {
        super(renderManager);
    }

    public static void clearCaches() {
        for (Integer index : vehicleDisplayLists.values()) {
            GL11.glDeleteLists((int)index, (int)1);
        }
        vehicleDisplayLists.clear();
        vehicleRotatableLists.clear();
        vehicleTranslatableLists.clear();
        vehicleLightLists.clear();
        vehicleWindowLists.clear();
        for (Integer index : partDisplayLists.values()) {
            GL11.glDeleteLists((int)index, (int)1);
        }
        partDisplayLists.clear();
        partRotatableLists.clear();
        partLightLists.clear();
        treadDeltas.clear();
    }

    public static ResourceLocation getTextureForVehicle(EntityVehicleE_Powered entity) {
        return textureMap.get(entity.vehicleName);
    }

    protected ResourceLocation getEntityTexture(EntityVehicleE_Powered entity) {
        return null;
    }

    public void doRender(EntityVehicleE_Powered vehicle, double x, double y, double z, float entityYaw, float partialTicks) {
        boolean didRender = false;
        if (vehicle.pack != null) {
            if (lastRenderPass.containsKey((Object)vehicle) && lastRenderTick.get((Object)vehicle).longValue() == vehicle.field_70170_p.func_82737_E() && lastRenderPartial.get((Object)vehicle).floatValue() == partialTicks && lastRenderPass.get((Object)vehicle) != -1 && MinecraftForgeClient.getRenderPass() == -1) {
                RenderVehicle.render(vehicle, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, partialTicks, true);
                didRender = true;
            }
            if (!didRender) {
                RenderVehicle.render(vehicle, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, partialTicks, false);
            }
            lastRenderPass.put(vehicle, (byte)MinecraftForgeClient.getRenderPass());
            lastRenderTick.put(vehicle, vehicle.field_70170_p.func_82737_E());
            lastRenderPartial.put(vehicle, Float.valueOf(partialTicks));
        }
    }

    public static boolean doesVehicleHaveLight(EntityVehicleE_Powered vehicle, EntityVehicleE_Powered.LightTypes light) {
        for (LightPart lightPart : vehicleLightLists.get(vehicle.vehicleJSONName)) {
            if (!lightPart.type.equals((Object)light)) continue;
            return true;
        }
        return false;
    }

    private static void render(EntityVehicleE_Powered vehicle, EntityPlayer playerRendering, float partialTicks, boolean wasRenderedPrior) {
        Entity renderViewEntity = minecraft.func_175606_aa();
        double playerX = renderViewEntity.field_70142_S + (renderViewEntity.field_70165_t - renderViewEntity.field_70142_S) * (double)partialTicks;
        double playerY = renderViewEntity.field_70137_T + (renderViewEntity.field_70163_u - renderViewEntity.field_70137_T) * (double)partialTicks;
        double playerZ = renderViewEntity.field_70136_U + (renderViewEntity.field_70161_v - renderViewEntity.field_70136_U) * (double)partialTicks;
        double thisX = vehicle.field_70142_S + (vehicle.field_70165_t - vehicle.field_70142_S) * (double)partialTicks;
        double thisY = vehicle.field_70137_T + (vehicle.field_70163_u - vehicle.field_70137_T) * (double)partialTicks;
        double thisZ = vehicle.field_70136_U + (vehicle.field_70161_v - vehicle.field_70136_U) * (double)partialTicks;
        double rotateYaw = (double)(-vehicle.field_70177_z) + (double)(vehicle.field_70177_z - vehicle.field_70126_B) * (double)(1.0f - partialTicks);
        double rotatePitch = (double)vehicle.field_70125_A - (double)(vehicle.field_70125_A - vehicle.field_70127_C) * (double)(1.0f - partialTicks);
        double rotateRoll = (double)vehicle.rotationRoll - (double)(vehicle.rotationRoll - vehicle.prevRotationRoll) * (double)(1.0f - partialTicks);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(thisX - playerX), (double)(thisY - playerY), (double)(thisZ - playerZ));
        int lightVar = vehicle.func_70070_b(partialTicks);
        RenderVehicle.minecraft.field_71460_t.func_180436_i();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(lightVar % 65536), (float)(lightVar / 65536));
        RenderHelper.func_74519_b();
        if (!textureMap.containsKey(vehicle.vehicleName)) {
            textureMap.put(vehicle.vehicleName, new ResourceLocation(vehicle.vehicleName.substring(0, vehicle.vehicleName.indexOf(58)), "textures/vehicles/" + vehicle.vehicleName.substring(vehicle.vehicleName.indexOf(58) + 1) + ".png"));
        }
        minecraft.func_110434_K().func_110577_a(textureMap.get(vehicle.vehicleName));
        if (MinecraftForgeClient.getRenderPass() != 1 && !wasRenderedPrior) {
            GL11.glPushMatrix();
            GL11.glShadeModel((int)7425);
            GL11.glRotated((double)rotateYaw, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)rotatePitch, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)rotateRoll, (double)0.0, (double)0.0, (double)1.0);
            RenderVehicle.renderMainModel(vehicle, partialTicks);
            RenderVehicle.renderParts(vehicle, partialTicks);
            GL11.glEnable((int)2977);
            RenderVehicle.renderWindows(vehicle, partialTicks);
            RenderVehicle.renderTextMarkings(vehicle);
            RenderVehicle.renderInstrumentsAndControls(vehicle);
            GL11.glDisable((int)2977);
            if (Minecraft.func_71410_x().func_175598_ae().func_178634_b()) {
                RenderVehicle.renderBoundingBoxes(vehicle);
            }
            GL11.glShadeModel((int)7424);
            GL11.glPopMatrix();
        }
        if (MinecraftForgeClient.getRenderPass() != 1 && !wasRenderedPrior) {
            for (Entity passenger : vehicle.func_184188_bt()) {
                if (RenderVehicle.minecraft.field_71439_g.equals((Object)passenger) && RenderVehicle.minecraft.field_71474_y.field_74320_O == 0 || !(passenger.field_70163_u > (double)passenger.field_70170_p.func_72800_K())) continue;
                GL11.glPushMatrix();
                GL11.glTranslated((double)(passenger.field_70165_t - vehicle.field_70165_t), (double)(passenger.field_70163_u - vehicle.field_70163_u), (double)(passenger.field_70161_v - vehicle.field_70161_v));
                Minecraft.func_71410_x().func_175598_ae().func_188388_a(passenger, partialTicks, false);
                GL11.glPopMatrix();
            }
        }
        if (vehicleLightLists.get(vehicle.vehicleJSONName) != null) {
            float sunLight = vehicle.field_70170_p.func_72971_b(0.0f) * vehicle.field_70170_p.func_175724_o(vehicle.func_180425_c());
            float blockLight = (float)vehicle.field_70170_p.func_175705_a(EnumSkyBlock.BLOCK, vehicle.func_180425_c()) / 15.0f;
            float electricFactor = (float)Math.min(vehicle.electricPower > 2.0 ? (vehicle.electricPower - 2.0) / 6.0 : 0.0, 1.0);
            float lightBrightness = Math.min((1.0f - Math.max(sunLight, blockLight)) * electricFactor, 1.0f);
            GL11.glPushMatrix();
            GL11.glEnable((int)2977);
            GL11.glRotated((double)rotateYaw, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)rotatePitch, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)rotateRoll, (double)0.0, (double)0.0, (double)1.0);
            RenderVehicle.renderLights(vehicle, sunLight, blockLight, lightBrightness, electricFactor, wasRenderedPrior, partialTicks);
            GL11.glDisable((int)2977);
            GL11.glPopMatrix();
            RenderVehicle.minecraft.field_71460_t.func_180436_i();
            GL11.glEnable((int)2896);
            GL11.glEnable((int)3553);
            GL11.glDepthMask((boolean)true);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (MinecraftForgeClient.getRenderPass() != 0) {
            RenderVehicle.renderPartBoxes(vehicle);
        }
        if (MinecraftForgeClient.getRenderPass() == -1) {
            RenderHelper.func_74518_a();
            RenderVehicle.minecraft.field_71460_t.func_175072_h();
        } else {
            RenderHelper.func_74519_b();
            RenderVehicle.minecraft.field_71460_t.func_180436_i();
        }
        GL11.glPopMatrix();
        if (!wasRenderedPrior) {
            SFXSystem.updateVehicleSounds(vehicle, partialTicks);
            for (APart part : vehicle.getVehicleParts()) {
                if (!(part instanceof SFXSystem.FXPart)) continue;
                SFXSystem.doFX((SFXSystem.FXPart)((Object)part), vehicle.field_70170_p);
            }
        }
    }

    private static void renderMainModel(EntityVehicleE_Powered vehicle, float partialTicks) {
        GL11.glPushMatrix();
        if (vehicleDisplayLists.containsKey(vehicle.vehicleJSONName)) {
            GL11.glCallList((int)vehicleDisplayLists.get(vehicle.vehicleJSONName));
            for (RotatablePart rotatable : vehicleRotatableLists.get(vehicle.vehicleJSONName)) {
                if (rotatable.name.contains("window")) continue;
                GL11.glPushMatrix();
                if (rotatable.name.contains("%")) {
                    for (TranslatablePart translatable : vehicleTranslatableLists.get(vehicle.vehicleJSONName)) {
                        if (!translatable.name.equals(rotatable.name)) continue;
                        RenderVehicle.translateModelObject(vehicle, translatable, partialTicks);
                        break;
                    }
                }
                RenderVehicle.rotateModelObject(vehicle, rotatable, partialTicks);
                GL11.glBegin((int)4);
                for (Float[] vertex : rotatable.vertices) {
                    GL11.glTexCoord2f((float)vertex[3].floatValue(), (float)vertex[4].floatValue());
                    GL11.glNormal3f((float)vertex[5].floatValue(), (float)vertex[6].floatValue(), (float)vertex[7].floatValue());
                    GL11.glVertex3f((float)vertex[0].floatValue(), (float)vertex[1].floatValue(), (float)vertex[2].floatValue());
                }
                GL11.glEnd();
                GL11.glPopMatrix();
            }
            for (TranslatablePart translatable : vehicleTranslatableLists.get(vehicle.vehicleJSONName)) {
                if (translatable.name.contains("window") || translatable.name.contains("$")) continue;
                GL11.glPushMatrix();
                RenderVehicle.translateModelObject(vehicle, translatable, partialTicks);
                GL11.glBegin((int)4);
                for (Float[] vertex : translatable.vertices) {
                    GL11.glTexCoord2f((float)vertex[3].floatValue(), (float)vertex[4].floatValue());
                    GL11.glNormal3f((float)vertex[5].floatValue(), (float)vertex[6].floatValue(), (float)vertex[7].floatValue());
                    GL11.glVertex3f((float)vertex[0].floatValue(), (float)vertex[1].floatValue(), (float)vertex[2].floatValue());
                }
                GL11.glEnd();
                GL11.glPopMatrix();
            }
        } else {
            ArrayList<RotatablePart> rotatableParts = new ArrayList<RotatablePart>();
            ArrayList<TranslatablePart> translatableParts = new ArrayList<TranslatablePart>();
            ArrayList<LightPart> lightParts = new ArrayList<LightPart>();
            ArrayList<WindowPart> windows = new ArrayList<WindowPart>();
            Map<String, Float[][]> parsedModel = OBJParserSystem.parseOBJModel(vehicle.vehicleName.substring(0, vehicle.vehicleName.indexOf(58)), "objmodels/vehicles/" + vehicle.vehicleJSONName + ".obj");
            int displayListIndex = GL11.glGenLists((int)1);
            GL11.glNewList((int)displayListIndex, (int)4864);
            GL11.glBegin((int)4);
            for (Map.Entry<String, Float[][]> entry : parsedModel.entrySet()) {
                boolean shouldShapeBeInDL = true;
                if (entry.getKey().contains("$")) {
                    rotatableParts.add(new RotatablePart(entry.getKey(), entry.getValue(), vehicle.pack.rendering.rotatableModelObjects));
                    shouldShapeBeInDL = false;
                }
                if (entry.getKey().contains("%")) {
                    translatableParts.add(new TranslatablePart(entry.getKey(), entry.getValue(), vehicle.pack.rendering.translatableModelObjects));
                    shouldShapeBeInDL = false;
                }
                if (entry.getKey().contains("&")) {
                    lightParts.add(new LightPart(entry.getKey(), entry.getValue()));
                }
                if (entry.getKey().toLowerCase().contains("window")) {
                    windows.add(new WindowPart(entry.getKey(), entry.getValue()));
                    shouldShapeBeInDL = false;
                }
                if (!shouldShapeBeInDL) continue;
                for (Float[] vertex : entry.getValue()) {
                    GL11.glTexCoord2f((float)vertex[3].floatValue(), (float)vertex[4].floatValue());
                    GL11.glNormal3f((float)vertex[5].floatValue(), (float)vertex[6].floatValue(), (float)vertex[7].floatValue());
                    GL11.glVertex3f((float)vertex[0].floatValue(), (float)vertex[1].floatValue(), (float)vertex[2].floatValue());
                }
            }
            GL11.glEnd();
            GL11.glEndList();
            vehicleRotatableLists.put(vehicle.vehicleJSONName, rotatableParts);
            vehicleTranslatableLists.put(vehicle.vehicleJSONName, translatableParts);
            vehicleLightLists.put(vehicle.vehicleJSONName, lightParts);
            vehicleWindowLists.put(vehicle.vehicleJSONName, windows);
            vehicleDisplayLists.put(vehicle.vehicleJSONName, displayListIndex);
        }
        GL11.glPopMatrix();
    }

    private static void rotateModelObject(EntityVehicleE_Powered vehicle, RotatablePart rotatable, float partialTicks) {
        for (int i = 0; i < rotatable.rotationVariables.length; i = (int)((byte)(i + 1))) {
            float rotation = RenderVehicle.getRotationAngleForModelVariable(vehicle, rotatable.rotationVariables[i], partialTicks);
            if (rotation == 0.0f) continue;
            GL11.glTranslated((double)((RotatablePart)rotatable).rotationPoints[i].field_72450_a, (double)((RotatablePart)rotatable).rotationPoints[i].field_72448_b, (double)((RotatablePart)rotatable).rotationPoints[i].field_72449_c);
            GL11.glRotated((double)(rotation * rotatable.rotationMagnitudes[i]), (double)((RotatablePart)rotatable).rotationAxis[i].field_72450_a, (double)((RotatablePart)rotatable).rotationAxis[i].field_72448_b, (double)((RotatablePart)rotatable).rotationAxis[i].field_72449_c);
            GL11.glTranslated((double)(-((RotatablePart)rotatable).rotationPoints[i].field_72450_a), (double)(-((RotatablePart)rotatable).rotationPoints[i].field_72448_b), (double)(-((RotatablePart)rotatable).rotationPoints[i].field_72449_c));
        }
    }

    private static float getRotationAngleForModelVariable(EntityVehicleE_Powered vehicle, String variable, float partialTicks) {
        switch (variable) {
            case "cycle": {
                return vehicle.field_70170_p.func_82737_E() % 20L;
            }
            case "door": {
                return vehicle.parkingBrakeOn && vehicle.velocity == 0.0 && !vehicle.locked ? 60.0f : 0.0f;
            }
            case "hood": {
                return vehicle.getEngineByNumber((byte)0) == null ? 60.0f : 0.0f;
            }
            case "throttle": {
                return (float)vehicle.throttle / 4.0f;
            }
            case "brake": {
                return vehicle.brakeOn ? 25.0f : 0.0f;
            }
            case "p_brake": {
                return vehicle.parkingBrakeOn ? 30.0f : 0.0f;
            }
            case "horn": {
                return vehicle.hornOn ? 30.0f : 0.0f;
            }
            case "gearshift": {
                return vehicle.getEngineByNumber((byte)0) != null ? ((PartEngineCar)vehicle.getEngineByNumber((byte)0)).getGearshiftRotation() : 0.0f;
            }
            case "engine": {
                return (float)(vehicle.getEngineByNumber((byte)0) != null ? vehicle.getEngineByNumber((byte)0).getEngineRotation(partialTicks) : 0.0);
            }
            case "driveshaft": {
                return RenderVehicle.getDriveshaftValue(vehicle, partialTicks);
            }
            case "driveshaft_sin": {
                return (float)(1.0 + Math.cos(Math.toRadians(RenderVehicle.getDriveshaftValue(vehicle, partialTicks) + 180.0f))) / 2.0f;
            }
            case "driveshaft_sin_offset": {
                return (float)Math.sin(Math.toRadians(RenderVehicle.getDriveshaftValue(vehicle, partialTicks) + 180.0f));
            }
            case "steeringwheel": {
                return vehicle.getSteerAngle();
            }
            case "aileron": {
                return (float)((EntityVehicleF_Plane)vehicle).aileronAngle / 10.0f;
            }
            case "elevator": {
                return (float)((EntityVehicleF_Plane)vehicle).elevatorAngle / 10.0f;
            }
            case "rudder": {
                return (float)((EntityVehicleF_Plane)vehicle).rudderAngle / 10.0f;
            }
            case "flap": {
                return (float)((EntityVehicleF_Plane)vehicle).flapCurrentAngle / 10.0f;
            }
            case "trim_aileron": {
                return (float)((EntityVehicleF_Plane)vehicle).aileronTrim / 10.0f;
            }
            case "trim_elevator": {
                return (float)((EntityVehicleF_Plane)vehicle).elevatorTrim / 10.0f;
            }
            case "trim_rudder": {
                return (float)((EntityVehicleF_Plane)vehicle).rudderTrim / 10.0f;
            }
            case "reverser": {
                return (float)((EntityVehicleF_Plane)vehicle).reversePercent / 1.0f;
            }
        }
        byte index = (byte)(Byte.valueOf(variable.substring(variable.lastIndexOf(95) + 1)) - 1);
        switch (variable.substring(0, variable.lastIndexOf(95))) {
            case "magneto": {
                return vehicle.getEngineByNumber(index) != null ? (float)(vehicle.getEngineByNumber((byte)index).state.magnetoOn ? 30 : 0) : 0.0f;
            }
            case "starter": {
                return vehicle.getEngineByNumber(index) != null ? (float)(vehicle.getEngineByNumber((byte)index).state.esOn ? 30 : 0) : 0.0f;
            }
        }
        return 0.0f;
    }

    private static void translateModelObject(EntityVehicleE_Powered vehicle, TranslatablePart translatable, float partialTicks) {
        for (int i = 0; i < translatable.translationVariables.length; i = (int)((byte)(i + 1))) {
            float translation = RenderVehicle.getTranslationLengthForModelVariable(vehicle, translatable.translationVariables[i], partialTicks);
            if (translation == 0.0f) continue;
            float translationMagnitude = translation * translatable.translationMagnitudes[i];
            GL11.glTranslated((double)((double)translationMagnitude * ((TranslatablePart)translatable).translationAxis[i].field_72450_a), (double)((double)translationMagnitude * ((TranslatablePart)translatable).translationAxis[i].field_72448_b), (double)((double)translationMagnitude * ((TranslatablePart)translatable).translationAxis[i].field_72449_c));
        }
    }

    private static float getTranslationLengthForModelVariable(EntityVehicleE_Powered vehicle, String variable, float partialTicks) {
        switch (variable) {
            case "door": {
                return vehicle.parkingBrakeOn && vehicle.velocity == 0.0 && !vehicle.locked ? 1.0f : 0.0f;
            }
            case "throttle": {
                return (float)vehicle.throttle / 100.0f;
            }
            case "brake": {
                return vehicle.brakeOn ? 1.0f : 0.0f;
            }
            case "p_brake": {
                return vehicle.parkingBrakeOn ? 1.0f : 0.0f;
            }
            case "horn": {
                return vehicle.hornOn ? 1.0f : 0.0f;
            }
            case "gearshift": {
                return vehicle.getEngineByNumber((byte)0) != null ? ((PartEngineCar)vehicle.getEngineByNumber((byte)0)).getGearshiftRotation() / 5.0f : 0.0f;
            }
            case "engine_sin": {
                return (float)(vehicle.getEngineByNumber((byte)0) != null ? (1.0 + Math.cos(Math.toRadians(vehicle.getEngineByNumber((byte)0).getEngineRotation(partialTicks) + 180.0))) / 2.0 : 0.0);
            }
            case "driveshaft_sin": {
                return (float)(1.0 + Math.cos(Math.toRadians(RenderVehicle.getDriveshaftValue(vehicle, partialTicks) + 180.0f))) / 2.0f;
            }
            case "driveshaft_sin_offset": {
                return (float)Math.sin(Math.toRadians(RenderVehicle.getDriveshaftValue(vehicle, partialTicks)));
            }
            case "steeringwheel": {
                return vehicle.getSteerAngle() / 35.0f;
            }
            case "aileron": {
                return (float)((EntityVehicleF_Plane)vehicle).aileronAngle / 350.0f;
            }
            case "elevator": {
                return (float)((EntityVehicleF_Plane)vehicle).elevatorAngle / 350.0f;
            }
            case "rudder": {
                return (float)((EntityVehicleF_Plane)vehicle).rudderAngle / 350.0f;
            }
            case "flap": {
                return (float)((EntityVehicleF_Plane)vehicle).flapCurrentAngle / 350.0f;
            }
            case "trim_aileron": {
                return (float)((EntityVehicleF_Plane)vehicle).aileronTrim / 350.0f;
            }
            case "trim_elevator": {
                return (float)((EntityVehicleF_Plane)vehicle).elevatorTrim / 350.0f;
            }
            case "trim_rudder": {
                return (float)((EntityVehicleF_Plane)vehicle).rudderTrim / 350.0f;
            }
            case "reverser": {
                return (float)((EntityVehicleF_Plane)vehicle).reversePercent / 100.0f;
            }
        }
        byte index = (byte)(Byte.valueOf(variable.substring(variable.lastIndexOf(95) + 1)) - 1);
        switch (variable.substring(0, variable.lastIndexOf(95))) {
            case "magneto": {
                return vehicle.getEngineByNumber(index) != null ? (float)(vehicle.getEngineByNumber((byte)index).state.magnetoOn ? 1 : 0) : 0.0f;
            }
            case "starter": {
                return vehicle.getEngineByNumber(index) != null ? (float)(vehicle.getEngineByNumber((byte)index).state.esOn ? 1 : 0) : 0.0f;
            }
        }
        return 0.0f;
    }

    private static float getDriveshaftValue(EntityVehicleE_Powered vehicle, float partialTicks) {
        if (vehicle.getEngineByNumber((byte)0) != null) {
            return (float)(vehicle.getEngineByNumber((byte)0).getDriveshaftRotation(partialTicks) % 360.0);
        }
        return 0.0f;
    }

    private static void renderParts(EntityVehicleE_Powered vehicle, float partialTicks) {
        for (APart part : vehicle.getVehicleParts()) {
            ResourceLocation partModelLocation = part.getModelLocation();
            if (partModelLocation == null) continue;
            if (!partDisplayLists.containsKey(partModelLocation)) {
                ArrayList<RotatablePart> rotatableParts = new ArrayList<RotatablePart>();
                ArrayList<LightPart> lightParts = new ArrayList<LightPart>();
                Map<String, Float[][]> parsedModel = OBJParserSystem.parseOBJModel(partModelLocation.func_110624_b(), partModelLocation.func_110623_a());
                int displayListIndex = GL11.glGenLists((int)1);
                GL11.glNewList((int)displayListIndex, (int)4864);
                GL11.glBegin((int)4);
                for (Map.Entry<String, Float[][]> entry : parsedModel.entrySet()) {
                    boolean shouldShapeBeInDL = true;
                    if (entry.getKey().contains("$")) {
                        rotatableParts.add(new RotatablePart(entry.getKey(), entry.getValue(), part.pack.rendering.rotatableModelObjects));
                        shouldShapeBeInDL = false;
                    }
                    if (entry.getKey().contains("&")) {
                        lightParts.add(new LightPart(entry.getKey(), entry.getValue()));
                    }
                    if (!shouldShapeBeInDL) continue;
                    for (Float[] vertex : entry.getValue()) {
                        GL11.glTexCoord2f((float)vertex[3].floatValue(), (float)vertex[4].floatValue());
                        GL11.glNormal3f((float)vertex[5].floatValue(), (float)vertex[6].floatValue(), (float)vertex[7].floatValue());
                        GL11.glVertex3f((float)vertex[0].floatValue(), (float)vertex[1].floatValue(), (float)vertex[2].floatValue());
                    }
                }
                GL11.glEnd();
                GL11.glEndList();
                partDisplayLists.put(partModelLocation, displayListIndex);
                partRotatableLists.put(partModelLocation, rotatableParts);
                partLightLists.put(partModelLocation, lightParts);
                continue;
            }
            if (!textureMap.containsKey(part.partName)) {
                textureMap.put(part.partName, part.getTextureLocation());
            }
            Vec3d actionRotation = part.getActionRotation(partialTicks);
            GL11.glPushMatrix();
            GL11.glTranslated((double)part.offset.field_72450_a, (double)part.offset.field_72448_b, (double)part.offset.field_72449_c);
            RenderVehicle.rotatePart(part, actionRotation, true);
            minecraft.func_110434_K().func_110577_a(textureMap.get(part.partName));
            if (part instanceof PartGroundDeviceTread) {
                RenderVehicle.doTreadRender((PartGroundDeviceTread)part, partialTicks, partDisplayLists.get(partModelLocation));
            } else {
                GL11.glCallList((int)partDisplayLists.get(partModelLocation));
            }
            for (RotatablePart rotatable : partRotatableLists.get(partModelLocation)) {
                GL11.glPushMatrix();
                RenderVehicle.rotatePartObject(part, rotatable, partialTicks);
                GL11.glBegin((int)4);
                for (Float[] vertex : rotatable.vertices) {
                    GL11.glTexCoord2f((float)vertex[3].floatValue(), (float)vertex[4].floatValue());
                    GL11.glNormal3f((float)vertex[5].floatValue(), (float)vertex[6].floatValue(), (float)vertex[7].floatValue());
                    GL11.glVertex3f((float)vertex[0].floatValue(), (float)vertex[1].floatValue(), (float)vertex[2].floatValue());
                }
                GL11.glEnd();
                GL11.glPopMatrix();
            }
            GL11.glCullFace((int)1029);
            GL11.glPopMatrix();
        }
    }

    private static void rotatePartObject(APart part, RotatablePart rotatable, float partialTicks) {
        for (int i = 0; i < rotatable.rotationVariables.length; i = (int)((byte)(i + 1))) {
            float rotation = RenderVehicle.getRotationAngleForPartVariable(part, rotatable.rotationVariables[i], partialTicks);
            if (rotation == 0.0f) continue;
            GL11.glTranslated((double)((RotatablePart)rotatable).rotationPoints[i].field_72450_a, (double)((RotatablePart)rotatable).rotationPoints[i].field_72448_b, (double)((RotatablePart)rotatable).rotationPoints[i].field_72449_c);
            GL11.glRotated((double)(rotation * rotatable.rotationMagnitudes[i]), (double)((RotatablePart)rotatable).rotationAxis[i].field_72450_a, (double)((RotatablePart)rotatable).rotationAxis[i].field_72448_b, (double)((RotatablePart)rotatable).rotationAxis[i].field_72449_c);
            GL11.glTranslated((double)(-((RotatablePart)rotatable).rotationPoints[i].field_72450_a), (double)(-((RotatablePart)rotatable).rotationPoints[i].field_72448_b), (double)(-((RotatablePart)rotatable).rotationPoints[i].field_72449_c));
        }
    }

    private static float getRotationAngleForPartVariable(APart part, String variable, float partialTicks) {
        Object engine;
        if (part instanceof APartEngine) {
            engine = (APartEngine)part;
            switch (variable) {
                case "engine": {
                    return (float)((APartEngine)engine).getEngineRotation(partialTicks);
                }
                case "driveshaft": {
                    return (float)((APartEngine)engine).getDriveshaftRotation(partialTicks);
                }
            }
        } else if (part instanceof PartPropeller && variable.equals("propellerpitch")) {
            return (float)Math.toDegrees(Math.atan((double)((PartPropeller)part).currentPitch / ((double)((PartPropeller)part).pack.propeller.diameter * 0.75 * Math.PI)));
        }
        switch (variable) {
            case "door": {
                return part.vehicle.parkingBrakeOn && part.vehicle.velocity == 0.0 && !part.vehicle.locked ? 60.0f : 0.0f;
            }
            case "steeringwheel": {
                return part.vehicle.getSteerAngle();
            }
        }
        engine = (APartEngine)(part.parentPart instanceof APartEngine ? part.parentPart : part.vehicle.getEngineByNumber((byte)0));
        switch (variable) {
            case "engine": {
                return (float)(engine != null ? ((APartEngine)engine).getEngineRotation(partialTicks) : 0.0);
            }
            case "driveshaft": {
                return (float)(engine != null ? ((APartEngine)engine).getDriveshaftRotation(partialTicks) : 0.0);
            }
            case "hood": {
                return engine == null ? 60.0f : 0.0f;
            }
        }
        return 0.0f;
    }

    private static void rotatePart(APart part, Vec3d actionRotation, boolean cullface) {
        if (part.turnsWithSteer) {
            if (part.offset.field_72449_c >= 0.0) {
                GL11.glRotatef((float)part.vehicle.getSteerAngle(), (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                GL11.glRotatef((float)(-part.vehicle.getSteerAngle()), (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        if (part.offset.field_72450_a < 0.0 && !part.overrideMirror || part.offset.field_72450_a > 0.0 && part.overrideMirror) {
            GL11.glScalef((float)-1.0f, (float)1.0f, (float)1.0f);
            if (cullface) {
                GL11.glCullFace((int)1028);
            }
        }
        GL11.glRotated((double)part.partRotation.field_72450_a, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)part.partRotation.field_72448_b, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)part.partRotation.field_72449_c, (double)0.0, (double)0.0, (double)1.0);
        GL11.glRotated((double)actionRotation.field_72450_a, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)actionRotation.field_72448_b, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)actionRotation.field_72449_c, (double)0.0, (double)0.0, (double)1.0);
    }

    private static void doTreadRender(PartGroundDeviceTread treadPart, float partialTicks, int displayListIndex) {
        List<Float[]> deltas = treadDeltas.get(treadPart.getModelLocation());
        if (deltas == null) {
            float totalDistance = 0.0f;
            float lastY = treadPart.pack.tread.yPoints[0];
            float lastZ = treadPart.pack.tread.zPoints[0];
            for (int i = 1; i < treadPart.pack.tread.yPoints.length; i = (int)((byte)(i + 1))) {
                totalDistance = (float)((double)totalDistance + Math.hypot(treadPart.pack.tread.yPoints[i] - lastY, treadPart.pack.tread.yPoints[i] - lastZ));
                lastY = treadPart.pack.tread.yPoints[i];
                lastZ = treadPart.pack.tread.zPoints[i];
            }
            deltas = new ArrayList<Float[]>();
            float spacing = treadPart.pack.tread.spacing;
            int pointIndex = 0;
            float currentY = treadPart.pack.tread.yPoints[pointIndex];
            float currentZ = treadPart.pack.tread.zPoints[pointIndex];
            float nextY = treadPart.pack.tread.yPoints[pointIndex + 1];
            float nextZ = treadPart.pack.tread.zPoints[pointIndex + 1];
            float deltaYBeforeSegment = 0.0f;
            float deltaZBeforeSegment = 0.0f;
            float deltaBeforeSegment = 0.0f;
            float segmentDeltaY = nextY - currentY;
            float segmentDeltaZ = nextZ - currentZ;
            float segmentDeltaTotal = (float)Math.hypot(segmentDeltaY, segmentDeltaZ);
            float angle = treadPart.pack.tread.angles[pointIndex];
            float currentAngle = 0.0f;
            while (totalDistance > 0.0f) {
                while (deltaBeforeSegment + segmentDeltaTotal < spacing) {
                    if ((pointIndex = (int)((byte)(pointIndex + 1))) + 1 == treadPart.pack.tread.yPoints.length) {
                        float angleToAdd;
                        currentY = treadPart.pack.tread.yPoints[pointIndex];
                        currentZ = treadPart.pack.tread.zPoints[pointIndex];
                        nextY = treadPart.pack.tread.yPoints[0];
                        nextZ = treadPart.pack.tread.zPoints[0];
                        for (angleToAdd = treadPart.pack.tread.angles[0] - treadPart.pack.tread.angles[pointIndex]; angleToAdd < 0.0f; angleToAdd += 360.0f) {
                        }
                        angle += angleToAdd;
                    } else {
                        if (pointIndex + 1 > treadPart.pack.tread.yPoints.length) break;
                        currentY = treadPart.pack.tread.yPoints[pointIndex];
                        currentZ = treadPart.pack.tread.zPoints[pointIndex];
                        nextY = treadPart.pack.tread.yPoints[pointIndex + 1];
                        nextZ = treadPart.pack.tread.zPoints[pointIndex + 1];
                        angle += treadPart.pack.tread.angles[pointIndex] - treadPart.pack.tread.angles[pointIndex - 1];
                    }
                    deltaBeforeSegment += segmentDeltaTotal;
                    deltaYBeforeSegment += segmentDeltaY;
                    deltaZBeforeSegment += segmentDeltaZ;
                    segmentDeltaY = nextY - currentY;
                    segmentDeltaZ = nextZ - currentZ;
                    segmentDeltaTotal = (float)Math.hypot(segmentDeltaY, segmentDeltaZ);
                }
                if (deltaBeforeSegment + segmentDeltaTotal >= spacing) {
                    float segmentPercentage = (spacing - deltaBeforeSegment) / segmentDeltaTotal;
                    float segmentY = deltaYBeforeSegment + segmentDeltaY * segmentPercentage;
                    float segmentZ = deltaZBeforeSegment + segmentDeltaZ * segmentPercentage;
                    float correctedZ = (float)(Math.cos(Math.toRadians(currentAngle += angle)) * (double)segmentZ - Math.sin(Math.toRadians(currentAngle)) * (double)segmentY);
                    float correctedY = (float)(Math.sin(Math.toRadians(currentAngle)) * (double)segmentZ + Math.cos(Math.toRadians(currentAngle)) * (double)segmentY);
                    deltas.add(new Float[]{Float.valueOf(correctedY), Float.valueOf(correctedZ), Float.valueOf(angle)});
                    totalDistance -= spacing;
                    segmentDeltaTotal -= spacing;
                    segmentDeltaY -= segmentDeltaY * segmentPercentage;
                    segmentDeltaZ -= segmentDeltaZ * segmentPercentage;
                    deltaBeforeSegment = 0.0f;
                    deltaYBeforeSegment = 0.0f;
                    deltaZBeforeSegment = 0.0f;
                    angle = 0.0f;
                    continue;
                }
                if (deltaBeforeSegment + segmentDeltaTotal > spacing / 2.0f) {
                    deltas.add(deltas.get(deltas.size() - 1));
                }
                totalDistance = 0.0f;
            }
            treadDeltas.put(treadPart.getModelLocation(), deltas);
        }
        float treadMovementPercentage = (float)((double)((treadPart.angularPosition + treadPart.angularVelocity * partialTicks) * treadPart.getHeight()) / Math.PI % (double)treadPart.pack.tread.spacing / (double)treadPart.pack.tread.spacing);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)treadPart.pack.tread.yPoints[0], (float)treadPart.pack.tread.zPoints[0]);
        for (Float[] point : deltas) {
            if (point[2].floatValue() != 0.0f) {
                GL11.glRotatef((float)point[2].floatValue(), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)(point[0].floatValue() * treadMovementPercentage), (float)(point[1].floatValue() * treadMovementPercentage));
                GL11.glRotatef((float)(-point[2].floatValue() * (1.0f - treadMovementPercentage)), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glCallList((int)displayListIndex);
                GL11.glRotatef((float)(point[2].floatValue() * (1.0f - treadMovementPercentage)), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)(point[0].floatValue() * (1.0f - treadMovementPercentage)), (float)(point[1].floatValue() * (1.0f - treadMovementPercentage)));
                continue;
            }
            GL11.glTranslatef((float)0.0f, (float)(point[0].floatValue() * treadMovementPercentage), (float)(point[1].floatValue() * treadMovementPercentage));
            GL11.glCallList((int)displayListIndex);
            GL11.glTranslatef((float)0.0f, (float)(point[0].floatValue() * (1.0f - treadMovementPercentage)), (float)(point[1].floatValue() * (1.0f - treadMovementPercentage)));
        }
        GL11.glPopMatrix();
    }

    private static void renderWindows(EntityVehicleE_Powered vehicle, float partialTicks) {
        minecraft.func_110434_K().func_110577_a(vanillaGlassTexture);
        for (int i = 0; i < vehicleWindowLists.get(vehicle.vehicleJSONName).size(); i = (int)((byte)(i + 1))) {
            if (i < vehicle.brokenWindows) continue;
            GL11.glPushMatrix();
            WindowPart window = vehicleWindowLists.get(vehicle.vehicleJSONName).get(i);
            for (RotatablePart rotatable : vehicleRotatableLists.get(vehicle.vehicleJSONName)) {
                if (!rotatable.name.equals(window.name)) continue;
                RenderVehicle.rotateModelObject(vehicle, rotatable, partialTicks);
            }
            GL11.glBegin((int)4);
            for (Float[] vertex : window.vertices) {
                GL11.glTexCoord2f((float)vertex[3].floatValue(), (float)vertex[4].floatValue());
                GL11.glNormal3f((float)vertex[5].floatValue(), (float)vertex[6].floatValue(), (float)vertex[7].floatValue());
                GL11.glVertex3f((float)vertex[0].floatValue(), (float)vertex[1].floatValue(), (float)vertex[2].floatValue());
            }
            if (ConfigSystem.getBooleanConfig("InnerWindows")) {
                for (int j = window.vertices.length - 1; j >= 0; --j) {
                    Float[] vertex = window.vertices[j];
                    GL11.glTexCoord2f((float)vertex[3].floatValue(), (float)vertex[4].floatValue());
                    GL11.glNormal3f((float)vertex[5].floatValue(), (float)vertex[6].floatValue(), (float)vertex[7].floatValue());
                    GL11.glVertex3f((float)vertex[0].floatValue(), (float)vertex[1].floatValue(), (float)vertex[2].floatValue());
                }
            }
            GL11.glEnd();
            GL11.glPopMatrix();
        }
    }

    private static void renderTextMarkings(EntityVehicleE_Powered vehicle) {
        if (vehicle.pack.rendering.textLighted && RenderInstruments.lightsOn(vehicle)) {
            GL11.glDisable((int)2896);
            RenderVehicle.minecraft.field_71460_t.func_175072_h();
        }
        for (PackVehicleObject.PackDisplayText text : vehicle.pack.rendering.textMarkings) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)text.pos[0], (float)text.pos[1], (float)text.pos[2]);
            GL11.glScalef((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GL11.glRotatef((float)text.rot[0], (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(text.rot[1] + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(text.rot[2] + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glScalef((float)text.scale, (float)text.scale, (float)text.scale);
            RenderHelper.func_74518_a();
            RenderVehicle.minecraft.field_71466_p.func_78276_b(vehicle.displayText, -RenderVehicle.minecraft.field_71466_p.func_78256_a(vehicle.displayText) / 2, 0, Color.decode(text.color).getRGB());
            GL11.glPopMatrix();
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74519_b();
        if (vehicle.pack.rendering.textLighted) {
            GL11.glEnable((int)2896);
            RenderVehicle.minecraft.field_71460_t.func_180436_i();
        }
    }

    /*
     * Could not resolve type clashes
     */
    private static void renderLights(EntityVehicleE_Powered vehicle, float sunLight, float blockLight, float lightBrightness, float electricFactor, boolean wasRenderedPrior, float partialTicks) {
        List<LightPart> vehicleLights = vehicleLightLists.get(vehicle.vehicleJSONName);
        HashMap<Integer, APart> lightIndexToParts = new HashMap<Integer, APart>();
        ArrayList<LightPart> allLights = new ArrayList<LightPart>();
        allLights.addAll(vehicleLights);
        for (APart part : vehicle.getVehicleParts()) {
            if (!partLightLists.containsKey(part.getModelLocation())) continue;
            for (LightPart partLight : partLightLists.get(part.getModelLocation())) {
                lightIndexToParts.put(allLights.size(), part);
                allLights.add(partLight);
            }
        }
        for (int lightIndex = 0; lightIndex < allLights.size(); ++lightIndex) {
            LightPart light = (LightPart)allLights.get(lightIndex);
            boolean lightSwitchOn = vehicle.isLightOn(light.type);
            boolean lightActuallyOn = lightSwitchOn && (light.flashBits >> vehicle.field_70173_aa % 20 & 1) > 0;
            boolean overrideCaseBrightness = lightBrightness > Math.max(sunLight, blockLight) && lightActuallyOn;
            GL11.glPushMatrix();
            if (vehicleLights.contains(light)) {
                for (Object rotatable : vehicleRotatableLists.get(vehicle.vehicleJSONName)) {
                    if (!((RotatablePart)rotatable).name.equals(light.name)) continue;
                    RenderVehicle.rotateModelObject(vehicle, (RotatablePart)rotatable, partialTicks);
                }
            } else {
                Object rotatable;
                Float[][] part = (Float[][])lightIndexToParts.get(lightIndex);
                GL11.glTranslated((double)part.offset.field_72450_a, (double)part.offset.field_72448_b, (double)part.offset.field_72449_c);
                RenderVehicle.rotatePart((APart)part, part.getActionRotation(partialTicks), false);
                rotatable = partRotatableLists.get(part.getModelLocation()).iterator();
                while (rotatable.hasNext()) {
                    RotatablePart rotatable2 = (RotatablePart)rotatable.next();
                    if (!rotatable2.name.equals(light.name)) continue;
                    RenderVehicle.rotatePartObject((APart)part, rotatable2, partialTicks);
                }
            }
            if (MinecraftForgeClient.getRenderPass() != 1 && !wasRenderedPrior) {
                GL11.glPushMatrix();
                if (overrideCaseBrightness) {
                    GL11.glDisable((int)2896);
                    RenderVehicle.minecraft.field_71460_t.func_175072_h();
                } else {
                    GL11.glEnable((int)2896);
                    RenderVehicle.minecraft.field_71460_t.func_180436_i();
                }
                GL11.glDisable((int)3042);
                if (light.renderCover) {
                    minecraft.func_110434_K().func_110577_a(vanillaGlassTexture);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glBegin((int)4);
                    for (Float[] vertex : light.vertices) {
                        GL11.glTexCoord2f((float)vertex[3].floatValue(), (float)vertex[4].floatValue());
                        GL11.glNormal3f((float)vertex[5].floatValue(), (float)vertex[6].floatValue(), (float)vertex[7].floatValue());
                        GL11.glVertex3f((float)(vertex[0].floatValue() + vertex[5].floatValue() * 3.0E-4f), (float)(vertex[1].floatValue() + vertex[6].floatValue() * 3.0E-4f), (float)(vertex[2].floatValue() + vertex[7].floatValue() * 3.0E-4f));
                    }
                    GL11.glEnd();
                }
                if (lightActuallyOn && light.renderColor) {
                    GL11.glDisable((int)2896);
                    GL11.glEnable((int)3042);
                    minecraft.func_110434_K().func_110577_a(lightTexture);
                    GL11.glColor4f((float)((float)light.color.getRed() / 255.0f), (float)((float)light.color.getGreen() / 255.0f), (float)((float)light.color.getBlue() / 255.0f), (float)electricFactor);
                    GL11.glBegin((int)4);
                    for (Float[] vertex : light.vertices) {
                        GL11.glTexCoord2f((float)vertex[3].floatValue(), (float)vertex[4].floatValue());
                        GL11.glNormal3f((float)vertex[5].floatValue(), (float)vertex[6].floatValue(), (float)vertex[7].floatValue());
                        GL11.glVertex3f((float)(vertex[0].floatValue() + vertex[5].floatValue() * 1.0E-4f), (float)(vertex[1].floatValue() + vertex[6].floatValue() * 1.0E-4f), (float)(vertex[2].floatValue() + vertex[7].floatValue() * 1.0E-4f));
                    }
                    GL11.glEnd();
                    GL11.glDisable((int)3042);
                    GL11.glEnable((int)2896);
                }
                GL11.glPopMatrix();
            }
            if (lightActuallyOn && lightBrightness > 0.0f && MinecraftForgeClient.getRenderPass() != 0 && !wasRenderedPrior && light.renderFlare) {
                for (int i = 0; i < light.centerPoints.length; i = (int)((byte)(i + 1))) {
                    GL11.glPushMatrix();
                    GL11.glEnable((int)3042);
                    GL11.glDisable((int)2896);
                    RenderVehicle.minecraft.field_71460_t.func_175072_h();
                    minecraft.func_110434_K().func_110577_a(lensFlareTexture);
                    GL11.glColor4f((float)((float)light.color.getRed() / 255.0f), (float)((float)light.color.getGreen() / 255.0f), (float)((float)light.color.getBlue() / 255.0f), (float)lightBrightness);
                    GL11.glBegin((int)4);
                    for (int j = 0; j < 6; j = (int)((byte)(j + 1))) {
                        Float[] vertex = light.vertices[(short)i * 6 + j];
                        GL11.glTexCoord2f((float)vertex[3].floatValue(), (float)vertex[4].floatValue());
                        GL11.glNormal3f((float)vertex[5].floatValue(), (float)vertex[6].floatValue(), (float)vertex[7].floatValue());
                        GL11.glVertex3d((double)((double)(vertex[0].floatValue() + vertex[5].floatValue() * 2.0E-4f) + ((double)vertex[0].floatValue() - ((LightPart)light).centerPoints[i].field_72450_a) * (double)(2.0f + light.size[i].floatValue() * 0.25f)), (double)((double)(vertex[1].floatValue() + vertex[6].floatValue() * 2.0E-4f) + ((double)vertex[1].floatValue() - ((LightPart)light).centerPoints[i].field_72448_b) * (double)(2.0f + light.size[i].floatValue() * 0.25f)), (double)((double)(vertex[2].floatValue() + vertex[7].floatValue() * 2.0E-4f) + ((double)vertex[2].floatValue() - ((LightPart)light).centerPoints[i].field_72449_c) * (double)(2.0f + light.size[i].floatValue() * 0.25f)));
                    }
                    GL11.glEnd();
                    GL11.glPopMatrix();
                }
            }
            if (lightActuallyOn && lightBrightness > 0.0f && ((LightPart)light).type.hasBeam && MinecraftForgeClient.getRenderPass() == -1) {
                GL11.glPushMatrix();
                GL11.glDisable((int)2896);
                GL11.glEnable((int)3042);
                RenderVehicle.minecraft.field_71460_t.func_175072_h();
                minecraft.func_110434_K().func_110577_a(lightBeamTexture);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(vehicle.electricPower > 4.0 ? 1.0f : 0.0f, lightBrightness / 2.0f));
                GL11.glDepthMask((boolean)false);
                GL11.glBlendFunc((int)774, (int)770);
                for (int i = 0; i < light.centerPoints.length; i = (int)((byte)(i + 1))) {
                    GL11.glPushMatrix();
                    GL11.glTranslated((double)(((LightPart)light).centerPoints[i].field_72450_a - (double)(light.vertices[i * 6][5].floatValue() * 0.15f)), (double)(((LightPart)light).centerPoints[i].field_72448_b - (double)(light.vertices[i * 6][6].floatValue() * 0.15f)), (double)(((LightPart)light).centerPoints[i].field_72449_c - (double)(light.vertices[i * 6][7].floatValue() * 0.15f)));
                    GL11.glRotatef((float)((float)Math.toDegrees(Math.atan2(light.vertices[i * 6][6].floatValue(), light.vertices[i * 6][5].floatValue()))), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)((float)Math.toDegrees(Math.acos(light.vertices[i * 6][7].floatValue()))), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glDepthMask((boolean)false);
                    for (int j = 0; j <= 2; j = (int)((byte)(j + 1))) {
                        RenderVehicle.drawLightCone(light.size[i].floatValue(), false);
                    }
                    RenderVehicle.drawLightCone(light.size[i].floatValue(), true);
                    GL11.glPopMatrix();
                }
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glDepthMask((boolean)true);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)2896);
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
        }
    }

    private static void drawLightCone(double radius, boolean reverse) {
        GL11.glBegin((int)6);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
        if (reverse) {
            float theta = 0.0f;
            while ((double)theta < 6.383185307179586) {
                GL11.glTexCoord2f((float)theta, (float)1.0f);
                GL11.glVertex3d((double)(radius * Math.cos(theta)), (double)(radius * Math.sin(theta)), (double)(radius * 3.0));
                theta = (float)((double)theta + 0.15707963267948966);
            }
        } else {
            float theta = (float)Math.PI * 2;
            while ((double)theta >= -0.1) {
                GL11.glTexCoord2f((float)theta, (float)1.0f);
                GL11.glVertex3d((double)(radius * Math.cos(theta)), (double)(radius * Math.sin(theta)), (double)(radius * 3.0));
                theta = (float)((double)theta - 0.15707963267948966);
            }
        }
        GL11.glEnd();
    }

    private static void renderInstrumentsAndControls(EntityVehicleE_Powered vehicle) {
        byte i;
        GL11.glPushMatrix();
        for (i = 0; i < vehicle.pack.motorized.instruments.size(); i = (byte)(i + 1)) {
            PackVehicleObject.PackInstrument packInstrument = vehicle.pack.motorized.instruments.get(i);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)packInstrument.pos[0], (float)packInstrument.pos[1], (float)packInstrument.pos[2]);
            GL11.glRotatef((float)packInstrument.rot[0], (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)packInstrument.rot[1], (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)packInstrument.rot[2], (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glScalef((float)(packInstrument.scale / 16.0f), (float)(packInstrument.scale / 16.0f), (float)(packInstrument.scale / 16.0f));
            EntityVehicleE_Powered.VehicleInstrument instrument = vehicle.getInstrumentInfoInSlot(i);
            if (instrument != null) {
                RenderInstruments.drawInstrument(vehicle, instrument, false, packInstrument.optionalEngineNumber);
            }
            GL11.glPopMatrix();
        }
        for (i = 0; i < vehicle.pack.motorized.controls.size(); i = (byte)((byte)(i + 1))) {
            PackVehicleObject.PackControl packControl = vehicle.pack.motorized.controls.get(i);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)packControl.pos[0], (float)packControl.pos[1], (float)packControl.pos[2]);
            GL11.glScalef((float)0.00390625f, (float)0.00390625f, (float)0.00390625f);
            for (MTSControls.Controls control : MTSControls.Controls.values()) {
                if (!control.name().toLowerCase().equals(packControl.controlName)) continue;
                RenderControls.drawControl(vehicle, control, false);
            }
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    private static void renderBoundingBoxes(EntityVehicleE_Powered vehicle) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glLineWidth((float)3.0f);
        for (VehicleAxisAlignedBB box : vehicle.getCurrentCollisionBoxes()) {
            GL11.glBegin((int)1);
            GL11.glVertex3d((double)(box.rel.field_72450_a - (double)(box.width / 2.0f)), (double)(box.rel.field_72448_b - (double)(box.height / 2.0f)), (double)(box.rel.field_72449_c - (double)(box.width / 2.0f)));
            GL11.glVertex3d((double)(box.rel.field_72450_a + (double)(box.width / 2.0f)), (double)(box.rel.field_72448_b - (double)(box.height / 2.0f)), (double)(box.rel.field_72449_c - (double)(box.width / 2.0f)));
            GL11.glVertex3d((double)(box.rel.field_72450_a - (double)(box.width / 2.0f)), (double)(box.rel.field_72448_b - (double)(box.height / 2.0f)), (double)(box.rel.field_72449_c + (double)(box.width / 2.0f)));
            GL11.glVertex3d((double)(box.rel.field_72450_a + (double)(box.width / 2.0f)), (double)(box.rel.field_72448_b - (double)(box.height / 2.0f)), (double)(box.rel.field_72449_c + (double)(box.width / 2.0f)));
            GL11.glVertex3d((double)(box.rel.field_72450_a - (double)(box.width / 2.0f)), (double)(box.rel.field_72448_b + (double)(box.height / 2.0f)), (double)(box.rel.field_72449_c - (double)(box.width / 2.0f)));
            GL11.glVertex3d((double)(box.rel.field_72450_a + (double)(box.width / 2.0f)), (double)(box.rel.field_72448_b + (double)(box.height / 2.0f)), (double)(box.rel.field_72449_c - (double)(box.width / 2.0f)));
            GL11.glVertex3d((double)(box.rel.field_72450_a - (double)(box.width / 2.0f)), (double)(box.rel.field_72448_b + (double)(box.height / 2.0f)), (double)(box.rel.field_72449_c + (double)(box.width / 2.0f)));
            GL11.glVertex3d((double)(box.rel.field_72450_a + (double)(box.width / 2.0f)), (double)(box.rel.field_72448_b + (double)(box.height / 2.0f)), (double)(box.rel.field_72449_c + (double)(box.width / 2.0f)));
            GL11.glVertex3d((double)(box.rel.field_72450_a - (double)(box.width / 2.0f)), (double)(box.rel.field_72448_b - (double)(box.height / 2.0f)), (double)(box.rel.field_72449_c - (double)(box.width / 2.0f)));
            GL11.glVertex3d((double)(box.rel.field_72450_a - (double)(box.width / 2.0f)), (double)(box.rel.field_72448_b - (double)(box.height / 2.0f)), (double)(box.rel.field_72449_c + (double)(box.width / 2.0f)));
            GL11.glVertex3d((double)(box.rel.field_72450_a + (double)(box.width / 2.0f)), (double)(box.rel.field_72448_b - (double)(box.height / 2.0f)), (double)(box.rel.field_72449_c - (double)(box.width / 2.0f)));
            GL11.glVertex3d((double)(box.rel.field_72450_a + (double)(box.width / 2.0f)), (double)(box.rel.field_72448_b - (double)(box.height / 2.0f)), (double)(box.rel.field_72449_c + (double)(box.width / 2.0f)));
            GL11.glVertex3d((double)(box.rel.field_72450_a - (double)(box.width / 2.0f)), (double)(box.rel.field_72448_b + (double)(box.height / 2.0f)), (double)(box.rel.field_72449_c - (double)(box.width / 2.0f)));
            GL11.glVertex3d((double)(box.rel.field_72450_a - (double)(box.width / 2.0f)), (double)(box.rel.field_72448_b + (double)(box.height / 2.0f)), (double)(box.rel.field_72449_c + (double)(box.width / 2.0f)));
            GL11.glVertex3d((double)(box.rel.field_72450_a + (double)(box.width / 2.0f)), (double)(box.rel.field_72448_b + (double)(box.height / 2.0f)), (double)(box.rel.field_72449_c - (double)(box.width / 2.0f)));
            GL11.glVertex3d((double)(box.rel.field_72450_a + (double)(box.width / 2.0f)), (double)(box.rel.field_72448_b + (double)(box.height / 2.0f)), (double)(box.rel.field_72449_c + (double)(box.width / 2.0f)));
            GL11.glVertex3d((double)(box.rel.field_72450_a - (double)(box.width / 2.0f)), (double)(box.rel.field_72448_b - (double)(box.height / 2.0f)), (double)(box.rel.field_72449_c - (double)(box.width / 2.0f)));
            GL11.glVertex3d((double)(box.rel.field_72450_a - (double)(box.width / 2.0f)), (double)(box.rel.field_72448_b + (double)(box.height / 2.0f)), (double)(box.rel.field_72449_c - (double)(box.width / 2.0f)));
            GL11.glVertex3d((double)(box.rel.field_72450_a + (double)(box.width / 2.0f)), (double)(box.rel.field_72448_b - (double)(box.height / 2.0f)), (double)(box.rel.field_72449_c - (double)(box.width / 2.0f)));
            GL11.glVertex3d((double)(box.rel.field_72450_a + (double)(box.width / 2.0f)), (double)(box.rel.field_72448_b + (double)(box.height / 2.0f)), (double)(box.rel.field_72449_c - (double)(box.width / 2.0f)));
            GL11.glVertex3d((double)(box.rel.field_72450_a - (double)(box.width / 2.0f)), (double)(box.rel.field_72448_b - (double)(box.height / 2.0f)), (double)(box.rel.field_72449_c + (double)(box.width / 2.0f)));
            GL11.glVertex3d((double)(box.rel.field_72450_a - (double)(box.width / 2.0f)), (double)(box.rel.field_72448_b + (double)(box.height / 2.0f)), (double)(box.rel.field_72449_c + (double)(box.width / 2.0f)));
            GL11.glVertex3d((double)(box.rel.field_72450_a + (double)(box.width / 2.0f)), (double)(box.rel.field_72448_b - (double)(box.height / 2.0f)), (double)(box.rel.field_72449_c + (double)(box.width / 2.0f)));
            GL11.glVertex3d((double)(box.rel.field_72450_a + (double)(box.width / 2.0f)), (double)(box.rel.field_72448_b + (double)(box.height / 2.0f)), (double)(box.rel.field_72449_c + (double)(box.width / 2.0f)));
            GL11.glEnd();
        }
        GL11.glLineWidth((float)1.0f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    private static void renderPartBoxes(EntityVehicleE_Powered vehicle) {
        EntityPlayerSP player = RenderVehicle.minecraft.field_71439_g;
        ItemStack heldStack = player.func_184614_ca();
        if (heldStack != null && heldStack.func_77973_b() instanceof AItemPart) {
            AItemPart heldItem = (AItemPart)heldStack.func_77973_b();
            for (Map.Entry<Vec3d, PackVehicleObject.PackPart> packPartEntry : vehicle.getAllPossiblePackParts().entrySet()) {
                boolean isPresent = false;
                boolean isHoldingPart = false;
                boolean isPartValid = false;
                if (vehicle.getPartAtLocation(packPartEntry.getKey().field_72450_a, packPartEntry.getKey().field_72448_b, packPartEntry.getKey().field_72449_c) != null) {
                    isPresent = true;
                }
                PackPartObject heldItemPack = PackParserSystem.getPartPack(heldItem.partName);
                if (packPartEntry.getValue().types.contains(PackParserSystem.getPartPack((String)heldItem.partName).general.type)) {
                    isHoldingPart = true;
                    if (heldItem.isPartValidForPackDef(packPartEntry.getValue())) {
                        isPartValid = true;
                    }
                }
                if (isPresent || !isHoldingPart) continue;
                Vec3d offset = RotationSystem.getRotatedPoint(packPartEntry.getKey(), vehicle.field_70125_A, vehicle.field_70177_z, vehicle.rotationRoll);
                AxisAlignedBB box = packPartEntry.getValue().types.contains("custom") && heldItemPack.general.type.equals("custom") ? new AxisAlignedBB((double)((float)offset.field_72450_a - heldItemPack.custom.width / 2.0f), (double)((float)offset.field_72448_b - heldItemPack.custom.height / 2.0f), (double)((float)offset.field_72449_c - heldItemPack.custom.width / 2.0f), (double)((float)offset.field_72450_a + heldItemPack.custom.width / 2.0f), (double)((float)offset.field_72448_b + heldItemPack.custom.height / 2.0f), (double)((float)offset.field_72449_c + heldItemPack.custom.width / 2.0f)) : new AxisAlignedBB((double)((float)offset.field_72450_a - 0.375f), (double)((float)offset.field_72448_b - 0.5f), (double)((float)offset.field_72449_c - 0.375f), (double)((float)offset.field_72450_a + 0.375f), (double)((float)offset.field_72448_b + 1.25f), (double)((float)offset.field_72449_c + 0.375f));
                GL11.glPushMatrix();
                GL11.glDisable((int)3553);
                GL11.glDisable((int)2896);
                GL11.glEnable((int)3042);
                if (isPartValid) {
                    GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)0.25f);
                } else {
                    GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.25f);
                }
                GL11.glBegin((int)7);
                GL11.glVertex3d((double)box.field_72336_d, (double)box.field_72337_e, (double)box.field_72334_f);
                GL11.glVertex3d((double)box.field_72340_a, (double)box.field_72337_e, (double)box.field_72334_f);
                GL11.glVertex3d((double)box.field_72340_a, (double)box.field_72338_b, (double)box.field_72334_f);
                GL11.glVertex3d((double)box.field_72336_d, (double)box.field_72338_b, (double)box.field_72334_f);
                GL11.glVertex3d((double)box.field_72336_d, (double)box.field_72337_e, (double)box.field_72339_c);
                GL11.glVertex3d((double)box.field_72336_d, (double)box.field_72337_e, (double)box.field_72334_f);
                GL11.glVertex3d((double)box.field_72336_d, (double)box.field_72338_b, (double)box.field_72334_f);
                GL11.glVertex3d((double)box.field_72336_d, (double)box.field_72338_b, (double)box.field_72339_c);
                GL11.glVertex3d((double)box.field_72336_d, (double)box.field_72338_b, (double)box.field_72339_c);
                GL11.glVertex3d((double)box.field_72340_a, (double)box.field_72338_b, (double)box.field_72339_c);
                GL11.glVertex3d((double)box.field_72340_a, (double)box.field_72337_e, (double)box.field_72339_c);
                GL11.glVertex3d((double)box.field_72336_d, (double)box.field_72337_e, (double)box.field_72339_c);
                GL11.glVertex3d((double)box.field_72340_a, (double)box.field_72338_b, (double)box.field_72339_c);
                GL11.glVertex3d((double)box.field_72340_a, (double)box.field_72338_b, (double)box.field_72334_f);
                GL11.glVertex3d((double)box.field_72340_a, (double)box.field_72337_e, (double)box.field_72334_f);
                GL11.glVertex3d((double)box.field_72340_a, (double)box.field_72337_e, (double)box.field_72339_c);
                GL11.glVertex3d((double)box.field_72336_d, (double)box.field_72337_e, (double)box.field_72334_f);
                GL11.glVertex3d((double)box.field_72336_d, (double)box.field_72337_e, (double)box.field_72339_c);
                GL11.glVertex3d((double)box.field_72340_a, (double)box.field_72337_e, (double)box.field_72339_c);
                GL11.glVertex3d((double)box.field_72340_a, (double)box.field_72337_e, (double)box.field_72334_f);
                GL11.glVertex3d((double)box.field_72340_a, (double)box.field_72338_b, (double)box.field_72334_f);
                GL11.glVertex3d((double)box.field_72340_a, (double)box.field_72338_b, (double)box.field_72339_c);
                GL11.glVertex3d((double)box.field_72336_d, (double)box.field_72338_b, (double)box.field_72339_c);
                GL11.glVertex3d((double)box.field_72336_d, (double)box.field_72338_b, (double)box.field_72334_f);
                GL11.glEnd();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)2896);
                GL11.glEnable((int)3553);
                GL11.glPopMatrix();
            }
        }
    }

    private static final class LightPart {
        private final String name;
        private final EntityVehicleE_Powered.LightTypes type;
        private final Float[][] vertices;
        private final Vec3d[] centerPoints;
        private final Float[] size;
        private final Color color;
        private final int flashBits;
        private final boolean renderFlare;
        private final boolean renderColor;
        private final boolean renderCover;

        private LightPart(String name, Float[][] masterVertices) {
            this.name = name.toLowerCase();
            this.type = this.getTypeFromName(name);
            this.vertices = new Float[masterVertices.length][];
            this.centerPoints = new Vec3d[masterVertices.length / 6];
            this.size = new Float[masterVertices.length / 6];
            for (int i = 0; i < this.centerPoints.length; i = (int)((short)(i + 1))) {
                double minX = 999.0;
                double maxX = -999.0;
                double minY = 999.0;
                double maxY = -999.0;
                double minZ = 999.0;
                double maxZ = -999.0;
                for (int j = 0; j < 6; j = (int)((byte)(j + 1))) {
                    Float[] masterVertex = masterVertices[i * 6 + j];
                    minX = Math.min((double)masterVertex[0].floatValue(), minX);
                    maxX = Math.max((double)masterVertex[0].floatValue(), maxX);
                    minY = Math.min((double)masterVertex[1].floatValue(), minY);
                    maxY = Math.max((double)masterVertex[1].floatValue(), maxY);
                    minZ = Math.min((double)masterVertex[2].floatValue(), minZ);
                    maxZ = Math.max((double)masterVertex[2].floatValue(), maxZ);
                    Float[] newVertex = new Float[masterVertex.length];
                    newVertex[0] = masterVertex[0];
                    newVertex[1] = masterVertex[1];
                    newVertex[2] = masterVertex[2];
                    switch (j) {
                        case 0: {
                            newVertex[3] = Float.valueOf(0.0f);
                            newVertex[4] = Float.valueOf(0.0f);
                            break;
                        }
                        case 1: {
                            newVertex[3] = Float.valueOf(0.0f);
                            newVertex[4] = Float.valueOf(1.0f);
                            break;
                        }
                        case 2: {
                            newVertex[3] = Float.valueOf(1.0f);
                            newVertex[4] = Float.valueOf(1.0f);
                            break;
                        }
                        case 3: {
                            newVertex[3] = Float.valueOf(1.0f);
                            newVertex[4] = Float.valueOf(1.0f);
                            break;
                        }
                        case 4: {
                            newVertex[3] = Float.valueOf(1.0f);
                            newVertex[4] = Float.valueOf(0.0f);
                            break;
                        }
                        case 5: {
                            newVertex[3] = Float.valueOf(0.0f);
                            newVertex[4] = Float.valueOf(0.0f);
                        }
                    }
                    newVertex[5] = masterVertex[5];
                    newVertex[6] = masterVertex[6];
                    newVertex[7] = masterVertex[7];
                    this.vertices[i * 6 + j] = newVertex;
                }
                this.centerPoints[i] = new Vec3d(minX + (maxX - minX) / 2.0, minY + (maxY - minY) / 2.0, minZ + (maxZ - minZ) / 2.0);
                this.size[i] = Float.valueOf((float)Math.max(Math.max(maxX - minX, maxZ - minZ), maxY - minY) * 32.0f);
            }
            this.color = Color.decode("0x" + name.substring(name.indexOf(95) + 1, name.indexOf(95) + 7));
            this.flashBits = Integer.decode("0x" + name.substring(name.indexOf(95, name.indexOf(95) + 7) + 1, name.lastIndexOf(95)));
            this.renderFlare = Integer.valueOf(name.substring(name.length() - 3, name.length() - 2)) > 0;
            this.renderColor = Integer.valueOf(name.substring(name.length() - 2, name.length() - 1)) > 0;
            this.renderCover = Integer.valueOf(name.substring(name.length() - 1)) > 0;
        }

        private EntityVehicleE_Powered.LightTypes getTypeFromName(String lightName) {
            for (EntityVehicleE_Powered.LightTypes light : EntityVehicleE_Powered.LightTypes.values()) {
                if (!lightName.toLowerCase().contains(light.name().toLowerCase())) continue;
                return light;
            }
            return null;
        }
    }

    private static final class WindowPart {
        private final String name;
        private final Float[][] vertices;

        private WindowPart(String name, Float[][] vertices) {
            this.name = name.toLowerCase();
            this.vertices = vertices;
        }
    }

    private static final class TranslatablePart {
        private final String name;
        private final Float[][] vertices;
        private final Vec3d[] translationAxis;
        private final float[] translationMagnitudes;
        private final String[] translationVariables;

        private TranslatablePart(String name, Float[][] vertices, List<PackVehicleObject.PackTranslatableModelObject> translatableModelObjects) {
            this.name = name.toLowerCase();
            this.vertices = vertices;
            Vec3d[] translationAxisTemp = TranslatablePart.getRotationAxis(name, translatableModelObjects);
            this.translationAxis = new Vec3d[translationAxisTemp.length];
            this.translationMagnitudes = new float[translationAxisTemp.length];
            for (int i = 0; i < translationAxisTemp.length; i = (int)((byte)(i + 1))) {
                this.translationAxis[i] = translationAxisTemp[i].func_72432_b();
                this.translationMagnitudes[i] = (float)translationAxisTemp[i].func_72433_c();
            }
            this.translationVariables = TranslatablePart.getRotationVariables(name, translatableModelObjects);
        }

        private static Vec3d[] getRotationAxis(String name, List<PackVehicleObject.PackTranslatableModelObject> translatableModelObjects) {
            ArrayList<Vec3d> translationAxis = new ArrayList<Vec3d>();
            for (PackVehicleObject.PackTranslatableModelObject translatable : translatableModelObjects) {
                if (!translatable.partName.equals(name) || translatable.translationAxis == null) continue;
                translationAxis.add(new Vec3d((double)translatable.translationAxis[0], (double)translatable.translationAxis[1], (double)translatable.translationAxis[2]));
            }
            return translationAxis.toArray(new Vec3d[translationAxis.size()]);
        }

        private static String[] getRotationVariables(String name, List<PackVehicleObject.PackTranslatableModelObject> translatableModelObjects) {
            ArrayList<String> translationVariables = new ArrayList<String>();
            for (PackVehicleObject.PackTranslatableModelObject translatable : translatableModelObjects) {
                if (!translatable.partName.equals(name) || translatable.partName == null) continue;
                translationVariables.add(translatable.translationVariable.toLowerCase());
            }
            return translationVariables.toArray(new String[translationVariables.size()]);
        }
    }

    private static final class RotatablePart {
        private final String name;
        private final Float[][] vertices;
        private final Vec3d[] rotationPoints;
        private final Vec3d[] rotationAxis;
        private final float[] rotationMagnitudes;
        private final String[] rotationVariables;

        private RotatablePart(String name, Float[][] vertices, List<PackVehicleObject.PackRotatableModelObject> rotatableModelObjects) {
            this.name = name.toLowerCase();
            this.vertices = vertices;
            this.rotationPoints = RotatablePart.getRotationPoints(name, rotatableModelObjects);
            Vec3d[] rotationAxisTemp = RotatablePart.getRotationAxis(name, rotatableModelObjects);
            this.rotationAxis = new Vec3d[rotationAxisTemp.length];
            this.rotationMagnitudes = new float[rotationAxisTemp.length];
            for (int i = 0; i < rotationAxisTemp.length; i = (int)((byte)(i + 1))) {
                this.rotationAxis[i] = rotationAxisTemp[i].func_72432_b();
                this.rotationMagnitudes[i] = (float)rotationAxisTemp[i].func_72433_c();
            }
            this.rotationVariables = RotatablePart.getRotationVariables(name, rotatableModelObjects);
        }

        private static Vec3d[] getRotationPoints(String name, List<PackVehicleObject.PackRotatableModelObject> rotatableModelObjects) {
            ArrayList<Vec3d> rotationPoints = new ArrayList<Vec3d>();
            for (PackVehicleObject.PackRotatableModelObject rotatable : rotatableModelObjects) {
                if (!rotatable.partName.equals(name) || rotatable.rotationPoint == null) continue;
                rotationPoints.add(new Vec3d((double)rotatable.rotationPoint[0], (double)rotatable.rotationPoint[1], (double)rotatable.rotationPoint[2]));
            }
            return rotationPoints.toArray(new Vec3d[rotationPoints.size()]);
        }

        private static Vec3d[] getRotationAxis(String name, List<PackVehicleObject.PackRotatableModelObject> rotatableModelObjects) {
            ArrayList<Vec3d> rotationAxis = new ArrayList<Vec3d>();
            for (PackVehicleObject.PackRotatableModelObject rotatable : rotatableModelObjects) {
                if (!rotatable.partName.equals(name) || rotatable.rotationAxis == null) continue;
                rotationAxis.add(new Vec3d((double)rotatable.rotationAxis[0], (double)rotatable.rotationAxis[1], (double)rotatable.rotationAxis[2]));
            }
            return rotationAxis.toArray(new Vec3d[rotationAxis.size()]);
        }

        private static String[] getRotationVariables(String name, List<PackVehicleObject.PackRotatableModelObject> rotatableModelObjects) {
            ArrayList<String> rotationVariables = new ArrayList<String>();
            for (PackVehicleObject.PackRotatableModelObject rotatable : rotatableModelObjects) {
                if (!rotatable.partName.equals(name) || rotatable.partName == null) continue;
                rotationVariables.add(rotatable.rotationVariable.toLowerCase());
            }
            return rotationVariables.toArray(new String[rotationVariables.size()]);
        }
    }
}

