/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.blockrenders;

import java.util.HashMap;
import java.util.Map;
import minecrafttransportsimulator.blocks.core.TileEntityDecor;
import minecrafttransportsimulator.systems.OBJParserSystem;
import minecrafttransportsimulator.systems.PackParserSystem;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderDecor
extends TileEntitySpecialRenderer<TileEntityDecor> {
    private static final ResourceLocation defaultSignTexture = new ResourceLocation("mts", "textures/blocks/trafficsign.png");
    private static final Map<String, Integer> displayListMap = new HashMap<String, Integer>();
    private static final Map<String, ResourceLocation> textureMap = new HashMap<String, ResourceLocation>();

    public void renderTileEntityAt(TileEntityDecor decor, double x, double y, double z, float partialTicks, int destroyStage) {
        super.func_180535_a((TileEntity)decor, x, y, z, partialTicks, destroyStage);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
        if (decor.rotation != 0) {
            GL11.glRotatef((float)(-90.0f * (float)decor.rotation), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (!displayListMap.containsKey(decor.decorName)) {
            if (PackParserSystem.getDecor(decor.decorName) == null) {
                this.func_147499_a(defaultSignTexture);
                GL11.glTexCoord2f((float)0.0f, (float)0.0f);
                GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glVertex3f((float)-0.5f, (float)0.0f, (float)0.5f);
                GL11.glTexCoord2f((float)0.0f, (float)0.5f);
                GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glVertex3f((float)-0.5f, (float)0.0f, (float)-0.5f);
                GL11.glTexCoord2f((float)1.0f, (float)0.5f);
                GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glVertex3f((float)0.5f, (float)0.0f, (float)-0.5f);
                GL11.glTexCoord2f((float)1.0f, (float)0.0f);
                GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glVertex3f((float)0.5f, (float)0.0f, (float)0.5f);
                GL11.glPopMatrix();
                return;
            }
            Map<String, Float[][]> parsedModel = OBJParserSystem.parseOBJModel(decor.decorName.substring(0, decor.decorName.indexOf(58)), "objmodels/decors/" + decor.decorName.substring(decor.decorName.indexOf(58) + 1) + ".obj");
            int displayListIndex = GL11.glGenLists((int)1);
            GL11.glNewList((int)displayListIndex, (int)4864);
            GL11.glBegin((int)4);
            for (Map.Entry<String, Float[][]> entry : parsedModel.entrySet()) {
                for (Float[] vertex : entry.getValue()) {
                    GL11.glTexCoord2f((float)vertex[3].floatValue(), (float)vertex[4].floatValue());
                    GL11.glNormal3f((float)vertex[5].floatValue(), (float)vertex[6].floatValue(), (float)vertex[7].floatValue());
                    GL11.glVertex3f((float)vertex[0].floatValue(), (float)vertex[1].floatValue(), (float)vertex[2].floatValue());
                }
            }
            GL11.glEnd();
            GL11.glEndList();
            displayListMap.put(decor.decorName, displayListIndex);
            textureMap.put(decor.decorName, new ResourceLocation(decor.decorName.substring(0, decor.decorName.indexOf(58)), "textures/decors/" + decor.decorName.substring(decor.decorName.indexOf(58) + 1) + ".png"));
        }
        this.func_147499_a(textureMap.get(decor.decorName));
        GL11.glCallList((int)displayListMap.get(decor.decorName));
        GL11.glPopMatrix();
    }
}

