/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.rendering.blockrenders;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import minecrafttransportsimulator.blocks.pole.TileEntityPoleSign;
import minecrafttransportsimulator.dataclasses.PackSignObject;
import minecrafttransportsimulator.systems.PackParserSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3i;
import org.lwjgl.opengl.GL11;

public class RenderPoleSign
extends TileEntitySpecialRenderer<TileEntityPoleSign> {
    private static final ResourceLocation defaultSignTexture = new ResourceLocation("mts", "textures/blocks/trafficsign.png");
    private static final Map<String, ResourceLocation> textureMap = new HashMap<String, ResourceLocation>();
    private static final Map<String, FontRenderer> fontMap = new HashMap<String, FontRenderer>();

    public void renderTileEntityAt(TileEntityPoleSign sign, double x, double y, double z, float partialTicks, int destroyStage) {
        super.func_180535_a((TileEntity)sign, x, y, z, partialTicks, destroyStage);
        Vec3i facingVec = EnumFacing.field_82609_l[sign.rotation].func_176730_m();
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        if (facingVec.func_177958_n() == 1) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (facingVec.func_177958_n() == -1) {
            GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (facingVec.func_177952_p() == -1) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0635f);
        if (sign.definition.isEmpty()) {
            this.func_147499_a(defaultSignTexture);
        } else {
            if (!textureMap.containsKey(sign.definition)) {
                textureMap.put(sign.definition, new ResourceLocation(sign.definition.substring(0, sign.definition.indexOf(58)), "textures/signs/" + sign.definition.substring(sign.definition.indexOf(58) + 1) + ".png"));
            }
            this.func_147499_a(textureMap.get(sign.definition));
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)-0.5f, (float)0.5f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.5f);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)-0.5f, (float)-0.5f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)0.5f);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)0.5f, (float)-0.5f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)0.5f, (float)0.5f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)0.5f);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
        GL11.glVertex3f((float)0.5f, (float)0.5f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
        GL11.glVertex3f((float)0.5f, (float)-0.5f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
        GL11.glVertex3f((float)-0.5f, (float)-0.5f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)0.5f);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
        GL11.glVertex3f((float)-0.5f, (float)0.5f, (float)0.0f);
        GL11.glEnd();
        PackSignObject pack = PackParserSystem.getSign(sign.definition);
        if (pack != null && pack.general.textLines != null) {
            if (!fontMap.containsKey(pack.general.font)) {
                if (pack.general.font.equals("default")) {
                    fontMap.put(pack.general.font, Minecraft.func_71410_x().field_71466_p);
                } else {
                    String fontName = pack.general.font;
                    ResourceLocation fontLocation = new ResourceLocation(fontName.substring(0, fontName.indexOf(58)), "textures/fonts/" + fontName.substring(fontName.indexOf(58) + 1) + ".png");
                    fontMap.put(pack.general.font, new FontRenderer(Minecraft.func_71410_x().field_71474_y, fontLocation, Minecraft.func_71410_x().field_71446_o, false));
                }
            }
            FontRenderer currentFont = fontMap.get(pack.general.font);
            for (int i = 0; i < pack.general.textLines.length; i = (int)((byte)(i + 1))) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(pack.general.textLines[i].xPos - 0.5f), (float)(pack.general.textLines[i].yPos - 0.5f), (float)0.01f);
                GL11.glScalef((float)(pack.general.textLines[i].scale / 16.0f), (float)(pack.general.textLines[i].scale / 16.0f), (float)(pack.general.textLines[i].scale / 16.0f));
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                currentFont.func_78276_b(sign.text.get(i), -currentFont.func_78256_a(sign.text.get(i)) / 2, 0, Color.decode(pack.general.textLines[i].color).getRGB());
                GL11.glPopMatrix();
            }
        }
        GL11.glPopMatrix();
    }
}

