/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.systems;

import java.util.Map;
import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.baseclasses.VehicleAxisAlignedBB;
import minecrafttransportsimulator.dataclasses.MTSRegistry;
import minecrafttransportsimulator.dataclasses.PackPartObject;
import minecrafttransportsimulator.dataclasses.PackVehicleObject;
import minecrafttransportsimulator.guis.GUIConfig;
import minecrafttransportsimulator.guis.GUIPackMissing;
import minecrafttransportsimulator.items.parts.AItemPart;
import minecrafttransportsimulator.packets.general.PacketPackReload;
import minecrafttransportsimulator.packets.parts.PacketPartInteraction;
import minecrafttransportsimulator.packets.vehicles.PacketVehicleAttacked;
import minecrafttransportsimulator.packets.vehicles.PacketVehicleKey;
import minecrafttransportsimulator.packets.vehicles.PacketVehicleNameTag;
import minecrafttransportsimulator.packets.vehicles.PacketVehicleServerPartAddition;
import minecrafttransportsimulator.packets.vehicles.PacketVehicleWindowFix;
import minecrafttransportsimulator.rendering.RenderHUD;
import minecrafttransportsimulator.rendering.RenderVehicle;
import minecrafttransportsimulator.systems.CameraSystem;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.ControlSystem;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.systems.RotationSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleA_Base;
import minecrafttransportsimulator.vehicles.main.EntityVehicleB_Existing;
import minecrafttransportsimulator.vehicles.main.EntityVehicleC_Colliding;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartSeat;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(value={Side.CLIENT})
@SideOnly(value=Side.CLIENT)
public final class ClientEventSystem {
    private static final Minecraft minecraft = Minecraft.func_71410_x();
    private static int defaultRenderDistance;
    private static int currentRenderDistance;
    private static int renderReductionHeight;

    @SubscribeEvent
    public static void on(PlayerInteractEvent.RightClickItem event) {
        if (event.getWorld().field_72995_K) {
            for (Entity entity : ClientEventSystem.minecraft.field_71441_e.field_72996_f) {
                if (!(entity instanceof EntityVehicleC_Colliding)) continue;
                EntityVehicleC_Colliding vehicle = (EntityVehicleC_Colliding)entity;
                EntityPlayer player = event.getEntityPlayer();
                APart hitPart = vehicle.getHitPart((Entity)player);
                if (hitPart != null && hitPart.interactPart(player)) {
                    MTS.MTSNet.sendToServer((IMessage)new PacketPartInteraction(hitPart, player.func_145782_y()));
                    return;
                }
                if (vehicle.equals(player.func_184187_bx()) && player.func_184586_b(event.getHand()) != null && !MTSRegistry.key.equals(player.func_184586_b(event.getHand()).func_77973_b())) {
                    return;
                }
                if (event.getItemStack().func_77973_b() instanceof AItemPart && vehicle.pack != null) {
                    Vec3d lookVec = player.func_70676_i(1.0f);
                    Vec3d clickedVec = player.func_174791_d().func_72441_c(0.0, (double)entity.func_70047_e(), 0.0);
                    PackPartObject heldItemPack = PackParserSystem.getPartPack(((AItemPart)event.getItemStack().func_77973_b()).partName);
                    for (float f = 1.0f; f < 4.0f; f += 0.1f) {
                        for (Map.Entry<Vec3d, PackVehicleObject.PackPart> packPartEntry : vehicle.getAllPossiblePackParts().entrySet()) {
                            VehicleAxisAlignedBB partBox;
                            Vec3d offset;
                            if (packPartEntry.getValue().types.contains("custom") && heldItemPack.general.type.equals("custom")) {
                                offset = RotationSystem.getRotatedPoint(packPartEntry.getKey(), vehicle.field_70125_A, vehicle.field_70177_z, vehicle.rotationRoll);
                                partBox = new VehicleAxisAlignedBB(vehicle.func_174791_d().func_178787_e(offset), packPartEntry.getKey(), heldItemPack.custom.width, heldItemPack.custom.height, false);
                            } else {
                                offset = RotationSystem.getRotatedPoint(packPartEntry.getKey().func_72441_c(0.0, 0.25, 0.0), vehicle.field_70125_A, vehicle.field_70177_z, vehicle.rotationRoll);
                                partBox = new VehicleAxisAlignedBB(vehicle.func_174791_d().func_178787_e(offset), packPartEntry.getKey().func_72441_c(0.0, 0.5, 0.0), 0.75f, 1.75f, false);
                            }
                            if (!partBox.func_72318_a(clickedVec) || !packPartEntry.getValue().types.contains(heldItemPack.general.type)) continue;
                            if (vehicle.getPartAtLocation(packPartEntry.getKey().field_72450_a, packPartEntry.getKey().field_72448_b, packPartEntry.getKey().field_72449_c) != null) {
                                return;
                            }
                            MTS.MTSNet.sendToServer((IMessage)new PacketVehicleServerPartAddition(vehicle, packPartEntry.getKey().field_72450_a, packPartEntry.getKey().field_72448_b, packPartEntry.getKey().field_72449_c, player));
                            return;
                        }
                        clickedVec = clickedVec.func_72441_c(lookVec.field_72450_a * (double)0.1f, lookVec.field_72448_b * (double)0.1f, lookVec.field_72449_c * (double)0.1f);
                    }
                    continue;
                }
                if (!vehicle.wasVehicleClicked((Entity)player)) continue;
                if (event.getItemStack().func_77973_b().equals(MTSRegistry.wrench)) {
                    MTS.proxy.openGUI((Object)vehicle, player);
                    continue;
                }
                if (event.getItemStack().func_77973_b().equals(MTSRegistry.key)) {
                    MTS.MTSNet.sendToServer((IMessage)new PacketVehicleKey(vehicle, player));
                    continue;
                }
                if (event.getItemStack().func_77973_b().equals(Items.field_151057_cb)) {
                    MTS.MTSNet.sendToServer((IMessage)new PacketVehicleNameTag(vehicle, player));
                    continue;
                }
                if (!event.getItemStack().func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150410_aZ))) continue;
                MTS.MTSNet.sendToServer((IMessage)new PacketVehicleWindowFix(vehicle, player));
            }
        }
    }

    @SubscribeEvent
    public static void on(AttackEntityEvent event) {
        if (event.getEntityPlayer().field_70170_p.field_72995_K && event.getTarget() instanceof EntityVehicleC_Colliding) {
            MTS.MTSNet.sendToServer((IMessage)new PacketVehicleAttacked((EntityVehicleB_Existing)event.getTarget(), event.getEntityPlayer()));
            event.getEntityPlayer().func_184185_a(SoundEvents.field_187724_dU, 1.0f, 1.0f);
        }
        if (event.getTarget() instanceof EntityVehicleC_Colliding) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void on(TickEvent.RenderTickEvent event) {
        TickEvent.Phase cfr_ignored_0 = event.phase;
        if (event.phase.equals((Object)TickEvent.Phase.START) && ClientEventSystem.minecraft.field_71439_g != null && ClientEventSystem.minecraft.field_71439_g.func_184187_bx() instanceof EntityVehicleC_Colliding && ClientEventSystem.minecraft.field_71474_y.field_74320_O != 0) {
            CameraSystem.runCustomCamera(event.renderTickTime);
        }
    }

    @SubscribeEvent
    public static void on(TickEvent.ClientTickEvent event) {
        if (ClientEventSystem.minecraft.field_71441_e != null && event.phase.equals((Object)TickEvent.Phase.END) && ClientEventSystem.minecraft.field_71439_g.func_184187_bx() instanceof EntityVehicleC_Colliding) {
            EntityVehicleE_Powered vehicle;
            if (!Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146241_e() && ClientEventSystem.minecraft.field_71439_g.func_184187_bx() instanceof EntityVehicleE_Powered && (vehicle = (EntityVehicleE_Powered)ClientEventSystem.minecraft.field_71439_g.func_184187_bx()).getSeatForRider((Entity)ClientEventSystem.minecraft.field_71439_g) != null) {
                ControlSystem.controlVehicle(vehicle, vehicle.getSeatForRider((Entity)ClientEventSystem.minecraft.field_71439_g).isController);
            }
            if (!minecraft.func_147113_T()) {
                CameraSystem.updatePlayerYawAndPitch((EntityPlayer)ClientEventSystem.minecraft.field_71439_g, (EntityVehicleB_Existing)ClientEventSystem.minecraft.field_71439_g.func_184187_bx());
            }
        }
    }

    @SubscribeEvent
    public static void on(TickEvent.PlayerTickEvent event) {
        if (event.side.isServer()) {
            TickEvent.Phase cfr_ignored_0 = event.phase;
            if (event.phase.equals((Object)TickEvent.Phase.END)) {
                EntityPlayerMP serverPlayer = (EntityPlayerMP)event.player;
                if (((WorldServer)serverPlayer.field_70170_p).func_73046_m().func_71264_H()) {
                    if (defaultRenderDistance == 0) {
                        currentRenderDistance = defaultRenderDistance = ((WorldServer)serverPlayer.field_70170_p).func_73046_m().func_184103_al().func_72395_o();
                        renderReductionHeight = ConfigSystem.getIntegerConfig("RenderReductionHeight");
                    }
                    if (serverPlayer.field_70163_u > (double)renderReductionHeight && currentRenderDistance != 1) {
                        currentRenderDistance = 1;
                        ((WorldServer)serverPlayer.field_70170_p).func_184164_w().func_152622_a(1);
                    } else if (serverPlayer.field_70163_u < (double)(renderReductionHeight - 10) && currentRenderDistance == 1) {
                        currentRenderDistance = defaultRenderDistance;
                        ((WorldServer)serverPlayer.field_70170_p).func_184164_w().func_152622_a(defaultRenderDistance);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void on(EntityViewRenderEvent.CameraSetup event) {
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 && event.getEntity().func_184187_bx() instanceof EntityVehicleC_Colliding) {
            EntityVehicleC_Colliding vehicle = (EntityVehicleC_Colliding)event.getEntity().func_184187_bx();
            event.setRoll((float)((double)vehicle.rotationRoll + (double)(vehicle.rotationRoll - vehicle.prevRotationRoll) * event.getRenderPartialTicks()));
        }
    }

    @SubscribeEvent
    public static void on(RenderWorldLastEvent event) {
        for (Entity entity : ClientEventSystem.minecraft.field_71441_e.field_72996_f) {
            if (!(entity instanceof EntityVehicleE_Powered)) continue;
            minecraft.func_175598_ae().func_78713_a(entity).func_76986_a(entity, 0.0, 0.0, 0.0, 0.0f, event.getPartialTicks());
        }
    }

    @SubscribeEvent
    public static void on(RenderPlayerEvent.Pre event) {
        if (event.getEntityPlayer().func_184187_bx() instanceof EntityVehicleC_Colliding) {
            PartSeat seat;
            GL11.glPushMatrix();
            EntityVehicleC_Colliding vehicle = (EntityVehicleC_Colliding)event.getEntityPlayer().func_184187_bx();
            if (vehicle.pack != null && (seat = vehicle.getSeatForRider((Entity)event.getEntityPlayer())) != null) {
                Vec3d placementRotation = seat.partRotation;
                event.getEntityPlayer().field_70761_aq = (float)((double)vehicle.field_70177_z + placementRotation.field_72448_b);
                event.getEntityPlayer().field_70759_as = vehicle.field_70125_A > 90.0f || vehicle.field_70125_A < -90.0f ? event.getEntityPlayer().field_70177_z * -1.0f : event.getEntityPlayer().field_70177_z;
                if (!event.getEntityPlayer().equals((Object)ClientEventSystem.minecraft.field_71439_g)) {
                    EntityPlayerSP masterPlayer = Minecraft.func_71410_x().field_71439_g;
                    EntityPlayer renderedPlayer = event.getEntityPlayer();
                    float playerDistanceX = (float)(renderedPlayer.field_70165_t - masterPlayer.field_70165_t);
                    float playerDistanceY = (float)(renderedPlayer.field_70163_u - masterPlayer.field_70163_u);
                    float playerDistanceZ = (float)(renderedPlayer.field_70161_v - masterPlayer.field_70161_v);
                    GL11.glTranslatef((float)playerDistanceX, (float)playerDistanceY, (float)playerDistanceZ);
                    GL11.glTranslated((double)0.0, (double)masterPlayer.func_70047_e(), (double)0.0);
                    GL11.glRotated((double)((double)vehicle.field_70125_A + placementRotation.field_72450_a), (double)Math.cos(vehicle.field_70177_z * ((float)Math.PI / 180)), (double)0.0, (double)Math.sin(vehicle.field_70177_z * ((float)Math.PI / 180)));
                    GL11.glRotated((double)((double)vehicle.rotationRoll + placementRotation.field_72449_c), (double)(-Math.sin(vehicle.field_70177_z * ((float)Math.PI / 180))), (double)0.0, (double)Math.cos(vehicle.field_70177_z * ((float)Math.PI / 180)));
                    GL11.glTranslated((double)0.0, (double)(-masterPlayer.func_70047_e()), (double)0.0);
                    GL11.glTranslatef((float)(-playerDistanceX), (float)(-playerDistanceY), (float)(-playerDistanceZ));
                } else {
                    GL11.glTranslated((double)0.0, (double)event.getEntityPlayer().func_70047_e(), (double)0.0);
                    GL11.glRotated((double)((double)vehicle.field_70125_A + placementRotation.field_72450_a), (double)Math.cos(vehicle.field_70177_z * ((float)Math.PI / 180)), (double)0.0, (double)Math.sin(vehicle.field_70177_z * ((float)Math.PI / 180)));
                    GL11.glRotated((double)((double)vehicle.rotationRoll + placementRotation.field_72449_c), (double)(-Math.sin(vehicle.field_70177_z * ((float)Math.PI / 180))), (double)0.0, (double)Math.cos(vehicle.field_70177_z * ((float)Math.PI / 180)));
                    GL11.glTranslated((double)0.0, (double)(-event.getEntityPlayer().func_70047_e()), (double)0.0);
                }
            }
        }
    }

    @SubscribeEvent
    public static void on(RenderPlayerEvent.Post event) {
        if (event.getEntityPlayer().func_184187_bx() instanceof EntityVehicleC_Colliding) {
            GL11.glPopMatrix();
        }
    }

    @SubscribeEvent
    public static void on(RenderGameOverlayEvent.Pre event) {
        if (ClientEventSystem.minecraft.field_71439_g.func_184187_bx() instanceof EntityVehicleC_Colliding) {
            EntityVehicleE_Powered vehicle;
            if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.HOTBAR)) {
                event.setCanceled(true);
            } else if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.CHAT) && ClientEventSystem.minecraft.field_71439_g.func_184187_bx() instanceof EntityVehicleE_Powered && (vehicle = (EntityVehicleE_Powered)ClientEventSystem.minecraft.field_71439_g.func_184187_bx()).getSeatForRider((Entity)ClientEventSystem.minecraft.field_71439_g) != null && vehicle.getSeatForRider((Entity)ClientEventSystem.minecraft.field_71439_g).isController && (ClientEventSystem.minecraft.field_71474_y.field_74320_O == 0 || CameraSystem.hudMode == 1) && !CameraSystem.disableHUD) {
                GL11.glPushMatrix();
                GL11.glScalef((float)(1.0f * (float)event.getResolution().func_78326_a() / 854.0f), (float)(1.0f * (float)event.getResolution().func_78328_b() / 480.0f), (float)0.0f);
                RenderHUD.drawMainHUD(vehicle, false);
                GL11.glPopMatrix();
            }
        }
    }

    @SubscribeEvent
    public static void on(GuiScreenEvent.DrawScreenEvent.Post event) {
        GuiContainerCreative creativeScreen;
        if (PackParserSystem.getAllVehiclePackNames().isEmpty() && event.getGui() instanceof GuiContainerCreative && CreativeTabs.field_78032_a[(creativeScreen = (GuiContainerCreative)event.getGui()).func_147056_g()].equals((Object)MTSRegistry.coreTab)) {
            FMLCommonHandler.instance().showGuiScreen((Object)new GUIPackMissing());
        }
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.KeyInputEvent event) {
        if (ControlSystem.isMasterControlButttonPressed()) {
            if (ConfigSystem.getBooleanConfig("DevMode") && minecraft.func_71356_B()) {
                PackParserSystem.reloadPackData();
                RenderVehicle.clearCaches();
                minecraft.func_110436_a();
                for (Entity entity : ClientEventSystem.minecraft.func_71410_x().field_71441_e.field_72996_f) {
                    if (!(entity instanceof EntityVehicleA_Base)) continue;
                    EntityVehicleA_Base vehicle = (EntityVehicleA_Base)entity;
                    vehicle.pack = PackParserSystem.getVehiclePack(vehicle.vehicleName);
                }
                MTS.MTSNet.sendToServer((IMessage)new PacketPackReload());
            }
            if (ClientEventSystem.minecraft.field_71462_r == null) {
                FMLCommonHandler.instance().showGuiScreen((Object)new GUIConfig());
            }
        }
    }
}

