/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.systems;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class OBJParserSystem {
    public static Map<String, Float[][]> parseOBJModel(String packID, String modelLocation) {
        try {
            HashMap<String, Float[][]> partMap = new HashMap<String, Float[][]>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(OBJParserSystem.class.getResourceAsStream("/assets/" + packID + "/" + modelLocation)));
            String partName = null;
            ArrayList<Float[]> vertexList = new ArrayList<Float[]>();
            ArrayList<Float[]> normalList = new ArrayList<Float[]>();
            ArrayList<Float[]> textureList = new ArrayList<Float[]>();
            ArrayList<String> faceList = new ArrayList<String>();
            while (reader.ready()) {
                Float[] coords;
                String line = reader.readLine();
                if (line.isEmpty()) continue;
                if (line.startsWith("o")) {
                    if (partName != null) {
                        partMap.put(partName, OBJParserSystem.compileVertexArray(vertexList, normalList, textureList, faceList, partName.toLowerCase().contains("window")));
                        vertexList.clear();
                        normalList.clear();
                        textureList.clear();
                        faceList.clear();
                    }
                    partName = line.trim().substring(2, line.length());
                }
                if (partName == null) continue;
                if (line.startsWith("v ")) {
                    coords = new Float[3];
                    line = line.trim().substring(2, line.trim().length()).trim();
                    coords[0] = Float.valueOf(line.substring(0, line.indexOf(32)));
                    coords[1] = Float.valueOf(line.substring(line.indexOf(32) + 1, line.lastIndexOf(32)));
                    coords[2] = Float.valueOf(line.substring(line.lastIndexOf(32) + 1, line.length()));
                    vertexList.add(coords);
                    continue;
                }
                if (line.startsWith("vt ")) {
                    coords = new Float[2];
                    line = line.trim().substring(3, line.trim().length()).trim();
                    int space = line.indexOf(32);
                    int vertexEnd = line.lastIndexOf(32) == space ? line.length() : line.lastIndexOf(32);
                    coords[0] = Float.valueOf(line.substring(0, space));
                    coords[1] = Float.valueOf(1.0f - Float.valueOf(line.substring(space + 1, vertexEnd)).floatValue());
                    textureList.add(coords);
                    continue;
                }
                if (line.startsWith("vn ")) {
                    coords = new Float[3];
                    line = line.trim().substring(2, line.trim().length()).trim();
                    coords[0] = Float.valueOf(line.substring(0, line.indexOf(32)));
                    coords[1] = Float.valueOf(line.substring(line.indexOf(32) + 1, line.lastIndexOf(32)));
                    coords[2] = Float.valueOf(line.substring(line.lastIndexOf(32) + 1, line.length()));
                    normalList.add(coords);
                    continue;
                }
                if (!line.startsWith("f ")) continue;
                faceList.add(line.trim().substring(2, line.trim().length()));
            }
            partMap.put(partName, OBJParserSystem.compileVertexArray(vertexList, normalList, textureList, faceList, partName.toLowerCase().contains("window")));
            reader.close();
            return partMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Could not resolve type clashes
     */
    private static Float[][] compileVertexArray(List<Float[]> vertexList, List<Float[]> normalList, List<Float[]> textureList, List<String> faceList, boolean isWindow) {
        ArrayList<Object> faceValues = new ArrayList<Object>();
        for (String faceString : faceList) {
            for (int i = 0; i < 3; i = (int)((byte)(i + 1))) {
                String faceDef;
                int defEnd = faceString.indexOf(32);
                if (defEnd != -1) {
                    faceDef = faceString.substring(0, defEnd);
                    faceString = faceString.substring(defEnd + 1);
                } else {
                    faceDef = faceString;
                    faceString = "";
                }
                int firstSlash = faceDef.indexOf(47);
                int secondSlash = faceDef.lastIndexOf(47);
                int vertexNumber = Integer.valueOf(faceDef.substring(0, firstSlash)) - 1;
                int textureNumber = Integer.valueOf(faceDef.substring(firstSlash + 1, secondSlash)) - 1;
                int normalNumber = Integer.valueOf(faceDef.substring(secondSlash + 1)) - 1;
                faceValues.add(new Integer[]{vertexNumber, textureNumber, normalNumber});
            }
            if (faceString.isEmpty()) continue;
            int defEnd = faceString.indexOf(32);
            if (defEnd != -1) {
                faceString = faceString.substring(0, defEnd);
            }
            faceValues.add(faceValues.get(faceValues.size() - 1));
            int firstSlash = faceString.indexOf(47);
            int secondSlash = faceString.lastIndexOf(47);
            int vertexNumber = Integer.valueOf(faceString.substring(0, firstSlash)) - 1;
            int textureNumber = Integer.valueOf(faceString.substring(firstSlash + 1, secondSlash)) - 1;
            int normalNumber = Integer.valueOf(faceString.substring(secondSlash + 1)) - 1;
            faceValues.add(new Integer[]{vertexNumber, textureNumber, normalNumber});
            faceValues.add(faceValues.get(faceValues.size() - 5));
        }
        int vertexOffset = Integer.MAX_VALUE;
        int textureOffset = Integer.MAX_VALUE;
        int normalOffset = Integer.MAX_VALUE;
        for (Integer[] face : faceValues) {
            vertexOffset = Math.min(vertexOffset, face[0]);
            textureOffset = Math.min(textureOffset, face[1]);
            normalOffset = Math.min(normalOffset, face[2]);
        }
        ArrayList<Float[]> vertexArray = new ArrayList<Float[]>();
        for (Integer[] face : faceValues) {
            vertexArray.add(vertexList.get(face[0] - vertexOffset));
        }
        ArrayList<Float[]> textureArray = new ArrayList<Float[]>();
        if (isWindow) {
            for (int i = 0; i < faceValues.size(); i += 3) {
                textureArray.add(new Float[]{Float.valueOf(0.0f), Float.valueOf(1.0f)});
                textureArray.add(new Float[]{Float.valueOf(1.0f), Float.valueOf(1.0f)});
                textureArray.add(new Float[]{Float.valueOf(1.0f), Float.valueOf(0.0f)});
                if (vertexArray.size() > 3) {
                    textureArray.add(new Float[]{Float.valueOf(1.0f), Float.valueOf(0.0f)});
                    textureArray.add(new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f)});
                    textureArray.add(new Float[]{Float.valueOf(0.0f), Float.valueOf(1.0f)});
                    continue;
                }
                break;
            }
        } else {
            for (Integer[] face : faceValues) {
                textureArray.add(textureList.get(face[1] - textureOffset));
            }
        }
        ArrayList<Float[]> normalArray = new ArrayList<Float[]>();
        for (Integer[] face : faceValues) {
            normalArray.add(normalList.get(face[2] - normalOffset));
        }
        ArrayList<Float[]> compiledArray = new ArrayList<Float[]>();
        for (int i = 0; i < vertexArray.size(); ++i) {
            compiledArray.add(new Float[]{((Float[])vertexArray.get(i))[0], ((Float[])vertexArray.get(i))[1], ((Float[])vertexArray.get(i))[2], ((Float[])textureArray.get(i))[0], ((Float[])textureArray.get(i))[1], ((Float[])normalArray.get(i))[0], ((Float[])normalArray.get(i))[1], ((Float[])normalArray.get(i))[2]});
        }
        return (Float[][])compiledArray.toArray((T[])new Float[compiledArray.size()][8]);
    }
}

