/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.systems;

import com.google.gson.Gson;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.dataclasses.CreativeTabPack;
import minecrafttransportsimulator.dataclasses.MTSRegistry;
import minecrafttransportsimulator.dataclasses.PackDecorObject;
import minecrafttransportsimulator.dataclasses.PackInstrumentObject;
import minecrafttransportsimulator.dataclasses.PackPartObject;
import minecrafttransportsimulator.dataclasses.PackSignObject;
import minecrafttransportsimulator.dataclasses.PackVehicleObject;
import minecrafttransportsimulator.items.parts.AItemPart;
import minecrafttransportsimulator.items.parts.ItemPartBarrel;
import minecrafttransportsimulator.items.parts.ItemPartBullet;
import minecrafttransportsimulator.items.parts.ItemPartCrate;
import minecrafttransportsimulator.items.parts.ItemPartCustom;
import minecrafttransportsimulator.items.parts.ItemPartEngineAircraft;
import minecrafttransportsimulator.items.parts.ItemPartEngineCar;
import minecrafttransportsimulator.items.parts.ItemPartEngineJet;
import minecrafttransportsimulator.items.parts.ItemPartGroundDevicePontoon;
import minecrafttransportsimulator.items.parts.ItemPartGroundDeviceSkid;
import minecrafttransportsimulator.items.parts.ItemPartGroundDeviceTread;
import minecrafttransportsimulator.items.parts.ItemPartGroundDeviceWheel;
import minecrafttransportsimulator.items.parts.ItemPartGun;
import minecrafttransportsimulator.items.parts.ItemPartPropeller;
import minecrafttransportsimulator.items.parts.ItemPartSeat;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Car;
import minecrafttransportsimulator.vehicles.main.EntityVehicleF_Plane;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartBarrel;
import minecrafttransportsimulator.vehicles.parts.PartCrate;
import minecrafttransportsimulator.vehicles.parts.PartCustom;
import minecrafttransportsimulator.vehicles.parts.PartEngineAircraft;
import minecrafttransportsimulator.vehicles.parts.PartEngineCar;
import minecrafttransportsimulator.vehicles.parts.PartEngineJet;
import minecrafttransportsimulator.vehicles.parts.PartGroundDevicePontoon;
import minecrafttransportsimulator.vehicles.parts.PartGroundDeviceSkid;
import minecrafttransportsimulator.vehicles.parts.PartGroundDeviceTread;
import minecrafttransportsimulator.vehicles.parts.PartGroundDeviceWheel;
import minecrafttransportsimulator.vehicles.parts.PartGunFixed;
import minecrafttransportsimulator.vehicles.parts.PartPropeller;
import minecrafttransportsimulator.vehicles.parts.PartSeat;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public final class PackParserSystem {
    private static final Map<String, PackVehicleObject> vehiclePackMap = new LinkedHashMap<String, PackVehicleObject>();
    private static final Map<String, String> vehicleJSONMap = new HashMap<String, String>();
    private static final Map<String, PackPartObject> partPackMap = new LinkedHashMap<String, PackPartObject>();
    private static final Map<String, PackInstrumentObject> partInstrumentMap = new LinkedHashMap<String, PackInstrumentObject>();
    private static final Map<String, PackSignObject> signPackMap = new LinkedHashMap<String, PackSignObject>();
    private static final Map<String, PackDecorObject> decorPackMap = new LinkedHashMap<String, PackDecorObject>();
    private static final Map<String, String[]> craftingItemMap = new HashMap<String, String[]>();
    private static final List<String> logList = new ArrayList<String>();

    public static String[] getValidPackContentNames() {
        return new String[]{"vehicle", "part", "instrument", "sign", "decor"};
    }

    public static void addVehicleDefinition(InputStreamReader jsonReader, String jsonFileName, String modID) {
        try {
            PackVehicleObject pack = (PackVehicleObject)new Gson().fromJson((Reader)jsonReader, PackVehicleObject.class);
            for (PackVehicleObject.PackFileDefinitions definition : pack.definitions) {
                if (definition == null) continue;
                String vehicleName = modID + ":" + jsonFileName + definition.subName;
                vehiclePackMap.put(vehicleName, pack);
                vehicleJSONMap.put(vehicleName, jsonFileName);
                if (!MTSRegistry.packTabs.containsKey(modID)) {
                    MTSRegistry.packTabs.put(modID, new CreativeTabPack(modID));
                }
                ArrayList<String> materials = new ArrayList<String>();
                for (String material : pack.general.materials) {
                    materials.add(material);
                }
                for (String material : definition.extraMaterials) {
                    materials.add(material);
                }
                craftingItemMap.put(vehicleName, materials.toArray(new String[materials.size()]));
            }
        }
        catch (Exception e) {
            logList.add("AN ERROR WAS ENCOUNTERED WHEN TRY TO PARSE: " + modID + ":" + jsonFileName);
            logList.add(e.getMessage());
        }
    }

    public static void addPartDefinition(InputStreamReader jsonReader, String jsonFileName, String modID) {
        try {
            PackPartObject pack = (PackPartObject)new Gson().fromJson((Reader)jsonReader, PackPartObject.class);
            String partName = modID + ":" + jsonFileName;
            partPackMap.put(partName, pack);
            if (!MTSRegistry.packTabs.containsKey(modID)) {
                MTSRegistry.packTabs.put(modID, new CreativeTabPack(modID));
            }
            craftingItemMap.put(partName, pack.general.materials);
        }
        catch (Exception e) {
            logList.add("AN ERROR WAS ENCOUNTERED WHEN TRY TO PARSE: " + modID + ":" + jsonFileName);
            logList.add(e.getMessage());
        }
    }

    public static void addInstrumentDefinition(InputStreamReader jsonReader, String jsonFileName, String modID) {
        try {
            PackInstrumentObject pack = (PackInstrumentObject)new Gson().fromJson((Reader)jsonReader, PackInstrumentObject.class);
            String instrumentName = modID + ":" + jsonFileName;
            partInstrumentMap.put(instrumentName, pack);
            craftingItemMap.put(instrumentName, pack.general.materials);
        }
        catch (Exception e) {
            logList.add("AN ERROR WAS ENCOUNTERED WHEN TRY TO PARSE: " + modID + ":" + jsonFileName);
            logList.add(e.getMessage());
        }
    }

    public static void addSignDefinition(InputStreamReader jsonReader, String jsonFileName, String modID) {
        try {
            PackSignObject pack = (PackSignObject)new Gson().fromJson((Reader)jsonReader, PackSignObject.class);
            String signName = modID + ":" + jsonFileName;
            signPackMap.put(signName, pack);
        }
        catch (Exception e) {
            logList.add("AN ERROR WAS ENCOUNTERED WHEN TRY TO PARSE: " + modID + ":" + jsonFileName);
            logList.add(e.getMessage());
        }
    }

    public static void addDecorDefinition(InputStreamReader jsonReader, String jsonFileName, String modID) {
        try {
            PackDecorObject pack = (PackDecorObject)new Gson().fromJson((Reader)jsonReader, PackDecorObject.class);
            String decorName = modID + ":" + jsonFileName;
            decorPackMap.put(decorName, pack);
            craftingItemMap.put(decorName, pack.general.materials);
        }
        catch (Exception e) {
            logList.add("AN ERROR WAS ENCOUNTERED WHEN TRY TO PARSE: " + modID + ":" + jsonFileName);
            logList.add(e.getMessage());
        }
    }

    public static void outputLog() {
        for (String logLine : logList) {
            MTS.MTSLog.error(logLine);
        }
        logList.clear();
    }

    public static void reloadPackData() {
        try {
            ResourceLocation jsonResource;
            ArrayList<String> jsonFilesToReload = new ArrayList<String>();
            for (Map.Entry<String, String> vehicleJSONEntry : vehicleJSONMap.entrySet()) {
                jsonFilesToReload.add(vehicleJSONEntry.getKey().substring(0, vehicleJSONEntry.getKey().indexOf(58) + 1) + vehicleJSONEntry.getValue());
            }
            for (String jsonFile : jsonFilesToReload) {
                jsonResource = new ResourceLocation(jsonFile.substring(0, jsonFile.indexOf(58)), "jsondefs/vehicles/" + jsonFile.substring(jsonFile.indexOf(58) + 1) + ".json");
                PackParserSystem.addVehicleDefinition(new InputStreamReader(Minecraft.func_71410_x().func_110442_L().func_110536_a(jsonResource).func_110527_b()), jsonFile.substring(jsonFile.indexOf(58) + 1), jsonFile.substring(0, jsonFile.indexOf(58)));
            }
            jsonFilesToReload.clear();
            for (String partJSONFile : partPackMap.keySet()) {
                jsonFilesToReload.add(partJSONFile);
            }
            for (String jsonFile : jsonFilesToReload) {
                jsonResource = new ResourceLocation(jsonFile.substring(0, jsonFile.indexOf(58)), "jsondefs/parts/" + jsonFile.substring(jsonFile.indexOf(58) + 1) + ".json");
                PackParserSystem.addPartDefinition(new InputStreamReader(Minecraft.func_71410_x().func_110442_L().func_110536_a(jsonResource).func_110527_b()), jsonFile.substring(jsonFile.indexOf(58) + 1), jsonFile.substring(0, jsonFile.indexOf(58)));
            }
            jsonFilesToReload.clear();
            for (String instrumentJSONFile : partInstrumentMap.keySet()) {
                jsonFilesToReload.add(instrumentJSONFile);
            }
            for (String jsonFile : jsonFilesToReload) {
                jsonResource = new ResourceLocation(jsonFile.substring(0, jsonFile.indexOf(58)), "jsondefs/instruments/" + jsonFile.substring(jsonFile.indexOf(58) + 1) + ".json");
                PackParserSystem.addInstrumentDefinition(new InputStreamReader(Minecraft.func_71410_x().func_110442_L().func_110536_a(jsonResource).func_110527_b()), jsonFile.substring(jsonFile.indexOf(58) + 1), jsonFile.substring(0, jsonFile.indexOf(58)));
            }
            jsonFilesToReload.clear();
            for (String signJSONFile : signPackMap.keySet()) {
                jsonFilesToReload.add(signJSONFile);
            }
            for (String jsonFile : jsonFilesToReload) {
                jsonResource = new ResourceLocation(jsonFile.substring(0, jsonFile.indexOf(58)), "jsondefs/signs/" + jsonFile.substring(jsonFile.indexOf(58) + 1) + ".json");
                PackParserSystem.addSignDefinition(new InputStreamReader(Minecraft.func_71410_x().func_110442_L().func_110536_a(jsonResource).func_110527_b()), jsonFile.substring(jsonFile.indexOf(58) + 1), jsonFile.substring(0, jsonFile.indexOf(58)));
            }
            jsonFilesToReload.clear();
            for (String decorJSONFile : decorPackMap.keySet()) {
                jsonFilesToReload.add(decorJSONFile);
            }
            for (String jsonFile : jsonFilesToReload) {
                jsonResource = new ResourceLocation(jsonFile.substring(0, jsonFile.indexOf(58)), "jsondefs/decors/" + jsonFile.substring(jsonFile.indexOf(58) + 1) + ".json");
                PackParserSystem.addDecorDefinition(new InputStreamReader(Minecraft.func_71410_x().func_110442_L().func_110536_a(jsonResource).func_110527_b()), jsonFile.substring(jsonFile.indexOf(58) + 1), jsonFile.substring(0, jsonFile.indexOf(58)));
            }
        }
        catch (Exception e) {
            logList.add("AN I/O ERROR WAS ENCOUNTERED WHEN TRYING TO RELOAD PACK DATA");
            e.printStackTrace();
        }
        PackParserSystem.outputLog();
    }

    public static List<ItemStack> getMaterials(String componentName) {
        ArrayList<ItemStack> materialList = new ArrayList<ItemStack>();
        for (String itemText : craftingItemMap.get(componentName)) {
            int itemQty = Integer.valueOf(itemText.substring(itemText.lastIndexOf(58) + 1));
            itemText = itemText.substring(0, itemText.lastIndexOf(58));
            int itemMetadata = Integer.valueOf(itemText.substring(itemText.lastIndexOf(58) + 1));
            itemText = itemText.substring(0, itemText.lastIndexOf(58));
            materialList.add(new ItemStack(Item.func_111206_d((String)itemText), itemQty, itemMetadata == -1 ? Integer.MAX_VALUE : itemMetadata));
        }
        return materialList;
    }

    public static PackVehicleObject getVehiclePack(String name) {
        return vehiclePackMap.get(name);
    }

    public static Set<String> getAllVehiclePackNames() {
        return vehiclePackMap.keySet();
    }

    public static String getVehicleJSONName(String name) {
        return vehicleJSONMap.get(name);
    }

    public static Class<? extends EntityVehicleE_Powered> getVehicleClass(String vehicleName) {
        switch (PackParserSystem.getVehiclePack((String)vehicleName).general.type) {
            case "car": {
                return EntityVehicleF_Car.class;
            }
            case "plane": {
                return EntityVehicleF_Plane.class;
            }
        }
        return null;
    }

    public static PackPartObject getPartPack(String name) {
        return partPackMap.get(name);
    }

    public static Set<String> getAllPartPackNames() {
        return partPackMap.keySet();
    }

    public static PackInstrumentObject getInstrument(String name) {
        return partInstrumentMap.get(name);
    }

    public static Set<String> getAllInstruments() {
        return partInstrumentMap.keySet();
    }

    public static PackSignObject getSign(String name) {
        return signPackMap.get(name);
    }

    public static Set<String> getAllSigns() {
        return signPackMap.keySet();
    }

    public static PackDecorObject getDecor(String name) {
        return decorPackMap.get(name);
    }

    public static Set<String> getAllDecor() {
        return decorPackMap.keySet();
    }

    public static Class<? extends APart> getPartPartClass(String partName) {
        switch (PackParserSystem.getPartPack((String)partName).general.type) {
            case "crate": {
                return PartCrate.class;
            }
            case "barrel": {
                return PartBarrel.class;
            }
            case "engine_aircraft": {
                return PartEngineAircraft.class;
            }
            case "engine_jet": {
                return PartEngineJet.class;
            }
            case "engine_car": {
                return PartEngineCar.class;
            }
            case "wheel": {
                return PartGroundDeviceWheel.class;
            }
            case "skid": {
                return PartGroundDeviceSkid.class;
            }
            case "pontoon": {
                return PartGroundDevicePontoon.class;
            }
            case "tread": {
                return PartGroundDeviceTread.class;
            }
            case "propeller": {
                return PartPropeller.class;
            }
            case "seat": {
                return PartSeat.class;
            }
            case "gun_fixed": {
                return PartGunFixed.class;
            }
            case "custom": {
                return PartCustom.class;
            }
        }
        return null;
    }

    public static Class<? extends AItemPart> getPartItemClass(String partName) {
        switch (PackParserSystem.getPartPack((String)partName).general.type) {
            case "crate": {
                return ItemPartCrate.class;
            }
            case "barrel": {
                return ItemPartBarrel.class;
            }
            case "engine_aircraft": {
                return ItemPartEngineAircraft.class;
            }
            case "engine_jet": {
                return ItemPartEngineJet.class;
            }
            case "engine_car": {
                return ItemPartEngineCar.class;
            }
            case "wheel": {
                return ItemPartGroundDeviceWheel.class;
            }
            case "skid": {
                return ItemPartGroundDeviceSkid.class;
            }
            case "pontoon": {
                return ItemPartGroundDevicePontoon.class;
            }
            case "tread": {
                return ItemPartGroundDeviceTread.class;
            }
            case "propeller": {
                return ItemPartPropeller.class;
            }
            case "seat": {
                return ItemPartSeat.class;
            }
            case "gun_fixed": {
                return ItemPartGun.class;
            }
            case "bullet": {
                return ItemPartBullet.class;
            }
            case "custom": {
                return ItemPartCustom.class;
            }
        }
        return null;
    }
}

