/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.systems;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.baseclasses.VehicleSound;
import minecrafttransportsimulator.vehicles.main.EntityVehicleD_Moving;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import minecrafttransportsimulator.vehicles.parts.APartEngine;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.ParticleDrip;
import net.minecraft.client.particle.ParticleSmokeNormal;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import paulscode.sound.SoundSystem;

@Mod.EventBusSubscriber(value={Side.CLIENT})
@SideOnly(value=Side.CLIENT)
public final class SFXSystem {
    private static final String[] soundManagerNames = new String[]{"sndManager", "field_147694_f"};
    private static final String[] soundSystemNames = new String[]{"sndSystem", "field_148620_e"};
    private static final String[] soundSystemURLNames = new String[]{"getURLForSoundResource", "func_148612_a"};
    private static final List<String> playingSounds = new ArrayList<String>();
    private static SoundSystem mcSoundSystem;
    private static Method getURLMethod;

    private static void initSoundSystemHooks() {
        Exception lastException = null;
        SoundHandler soundHandler = Minecraft.func_71410_x().func_147118_V();
        SoundManager mcSoundManager = null;
        for (String soundManagerName : soundManagerNames) {
            try {
                Field soundManagerField = SoundHandler.class.getDeclaredField(soundManagerName);
                soundManagerField.setAccessible(true);
                mcSoundManager = (SoundManager)soundManagerField.get(soundHandler);
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (mcSoundManager == null) {
            MTS.MTSLog.fatal("ERROR IN SOUND SYSTEM REFLECTION!  COULD NOT FIND SOUNDMANAGER!");
            throw new RuntimeException(lastException);
        }
        for (String soundSystemName : soundSystemNames) {
            try {
                Field soundSystemField = SoundManager.class.getDeclaredField(soundSystemName);
                soundSystemField.setAccessible(true);
                mcSoundSystem = (SoundSystem)soundSystemField.get(mcSoundManager);
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (mcSoundSystem == null) {
            MTS.MTSLog.fatal("ERROR IN SOUND SYSTEM REFLECTION!  COULD NOT FIND SOUNDSYSTEM!");
            throw new RuntimeException(lastException);
        }
        for (String soundSystemURLName : soundSystemURLNames) {
            try {
                getURLMethod = SoundManager.class.getDeclaredMethod(soundSystemURLName, ResourceLocation.class);
                getURLMethod.setAccessible(true);
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (getURLMethod == null) {
            MTS.MTSLog.fatal("ERROR IN SOUND SYSTEM REFLECTION!  COULD NOT FIND URLMETHOD!");
            throw new RuntimeException(lastException);
        }
    }

    @SubscribeEvent
    public static void on(SoundLoadEvent event) {
        mcSoundSystem = null;
        playingSounds.clear();
    }

    @SubscribeEvent
    public static void on(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            for (String soundID : playingSounds) {
                if (!mcSoundSystem.playing(soundID)) continue;
                mcSoundSystem.stop(soundID);
            }
            playingSounds.clear();
        }
    }

    @SubscribeEvent
    public static void on(RenderWorldLastEvent event) {
        Iterator<String> soundIterator = playingSounds.iterator();
        while (soundIterator.hasNext()) {
            String soundID = soundIterator.next();
            int entityID = Integer.valueOf(soundID.substring(0, soundID.indexOf(95)));
            if (Minecraft.func_71410_x().field_71441_e.func_73045_a(entityID) != null) continue;
            mcSoundSystem.stop(soundID);
            soundIterator.remove();
        }
    }

    public static boolean isPlayerInsideEnclosedVehicle() {
        if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_184187_bx() instanceof EntityVehicleD_Moving) {
            return !((EntityVehicleD_Moving)Minecraft.func_71410_x().field_71439_g.func_184187_bx()).pack.general.openTop && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0;
        }
        return false;
    }

    public static void playSound(Vec3d soundPosition, String soundName, float volume, float pitch) {
        if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71441_e.field_72995_K) {
            if (mcSoundSystem == null) {
                SFXSystem.initSoundSystemHooks();
            }
            volume = SFXSystem.isPlayerInsideEnclosedVehicle() ? volume * 0.5f : volume;
            double soundDistance = Minecraft.func_71410_x().field_71439_g.func_174791_d().func_72438_d(soundPosition);
            try {
                ResourceLocation soundFileLocation = new ResourceLocation(soundName);
                soundFileLocation = new ResourceLocation(soundFileLocation.func_110624_b(), "sounds/" + soundFileLocation.func_110623_a() + ".ogg");
                URL soundURL = (URL)getURLMethod.invoke(null, soundFileLocation);
                String soundTempName = mcSoundSystem.quickPlay(false, soundURL, soundFileLocation.toString(), false, (float)soundPosition.field_72450_a, (float)soundPosition.field_72448_b, (float)soundPosition.field_72449_c, 2, 16.0f);
                mcSoundSystem.setVolume(soundTempName, volume);
                mcSoundSystem.setPitch(soundTempName, pitch);
            }
            catch (Exception e) {
                MTS.MTSLog.error("COULD NOT PLAY VEHICLE SOUND:" + soundName);
                throw new RuntimeException(e);
            }
        }
    }

    public static void updateVehicleSounds(EntityVehicleE_Powered vehicle, float partialTicks) {
        if (mcSoundSystem == null) {
            SFXSystem.initSoundSystemHooks();
        }
        if (vehicle.soundsNeedInit) {
            vehicle.initSounds();
            vehicle.soundsNeedInit = false;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        for (VehicleSound sound : vehicle.getSounds()) {
            String soundID = sound.getSoundUniqueName();
            if (sound.isSoundSourceActive() && sound.isSoundActive()) {
                if (!playingSounds.contains(soundID) && !Minecraft.func_71410_x().func_147113_T()) {
                    try {
                        ResourceLocation soundFileLocation = new ResourceLocation(sound.getSoundName());
                        soundFileLocation = new ResourceLocation(soundFileLocation.func_110624_b(), "sounds/" + soundFileLocation.func_110623_a() + ".ogg");
                        URL soundURL = (URL)getURLMethod.invoke(null, soundFileLocation);
                        mcSoundSystem.newSource(false, soundID, soundURL, soundFileLocation.toString(), true, sound.getPosX(), sound.getPosY(), sound.getPosZ(), 2, 16.0f);
                        mcSoundSystem.play(soundID);
                        playingSounds.add(soundID);
                    }
                    catch (Exception e) {
                        MTS.MTSLog.error("COULD NOT PLAY LOOPING VEHICLE SOUND:" + sound.getSoundName());
                        throw new RuntimeException(e);
                    }
                }
                if (!playingSounds.contains(soundID)) continue;
                mcSoundSystem.setVolume(soundID, sound.getVolume());
                mcSoundSystem.setPitch(soundID, sound.getPitch());
                mcSoundSystem.setPosition(soundID, sound.getPosX() + sound.getMotX() * partialTicks, sound.getPosY() + sound.getMotY() * partialTicks, sound.getPosZ() + sound.getMotZ() * partialTicks);
                if (Minecraft.func_71410_x().func_147113_T()) {
                    mcSoundSystem.pause(soundID);
                    continue;
                }
                mcSoundSystem.play(soundID);
                continue;
            }
            if (!mcSoundSystem.playing(soundID)) continue;
            mcSoundSystem.stop(soundID);
            playingSounds.remove(soundID);
        }
    }

    public static void stopVehicleSounds(EntityVehicleE_Powered vehicle) {
        vehicle.func_70106_y();
        for (VehicleSound sound : vehicle.getSounds()) {
            String soundID = sound.getSoundUniqueName();
            if (!playingSounds.contains(soundID)) continue;
            mcSoundSystem.stop(soundID);
            playingSounds.remove(soundID);
        }
    }

    public static void addVehicleEngineSound(EntityVehicleE_Powered vehicle, APartEngine engine) {
        if (vehicle.field_70170_p.field_72995_K) {
            vehicle.addSound(VehicleSound.SoundTypes.ENGINE, engine);
        }
    }

    public static void doFX(FXPart part, World world) {
        if (world.field_72995_K) {
            part.spawnParticles();
        }
    }

    public static interface FXPart {
        @SideOnly(value=Side.CLIENT)
        public void spawnParticles();
    }

    public static class WhiteSmokeFX
    extends ParticleSmokeNormal {
        public WhiteSmokeFX(World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
            super(world, posX, posY, posZ, motionX, motionY, motionZ, 1.0f);
        }

        public void func_189213_a() {
            super.func_189213_a();
            this.func_70538_b(1.0f, 1.0f, 1.0f);
        }
    }

    public static class FuelDropParticleFX
    extends ParticleDrip {
        public FuelDropParticleFX(World world, double posX, double posY, double posZ) {
            super(world, posX, posY, posZ, Material.field_151587_i);
        }
    }

    public static class OilDropParticleFX
    extends ParticleDrip {
        public OilDropParticleFX(World world, double posX, double posY, double posZ) {
            super(world, posX, posY, posZ, Material.field_151587_i);
        }

        public void func_189213_a() {
            super.func_189213_a();
            this.func_70538_b(0.0f, 0.0f, 0.0f);
        }
    }
}

