/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.main;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.dataclasses.PackVehicleObject;
import minecrafttransportsimulator.packets.vehicles.PacketVehicleClientInit;
import minecrafttransportsimulator.packets.vehicles.PacketVehicleClientPartRemoval;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import minecrafttransportsimulator.vehicles.parts.APart;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityVehicleA_Base
extends Entity {
    public String vehicleName = "";
    public String vehicleJSONName = "";
    public PackVehicleObject pack;
    private final List<APart> parts = new ArrayList<APart>();
    private byte clientPackPacketCooldown = 0;

    public EntityVehicleA_Base(World world) {
        super(world);
    }

    public EntityVehicleA_Base(World world, String vehicleName) {
        this(world);
        this.vehicleName = vehicleName;
        this.vehicleJSONName = PackParserSystem.getVehicleJSONName(vehicleName);
        this.pack = PackParserSystem.getVehiclePack(vehicleName);
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.pack == null && this.field_70170_p.field_72995_K) {
            if (this.clientPackPacketCooldown == 0) {
                this.clientPackPacketCooldown = (byte)40;
                MTS.MTSNet.sendToServer((IMessage)new PacketVehicleClientInit(this));
            } else {
                this.clientPackPacketCooldown = (byte)(this.clientPackPacketCooldown - 1);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double posX, double posY, double posZ, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        EntityVehicleA_Base.func_184227_b((double)100.0);
        this.field_70158_ak = true;
    }

    public void addPart(APart part, boolean ignoreCollision) {
        this.parts.add(part);
        if (!ignoreCollision) {
            if (part.isPartCollidingWithBlocks(Vec3d.field_186680_a)) {
                this.func_70080_a(this.field_70165_t, this.field_70163_u + Math.max(0.0, -part.offset.field_72448_b) + (double)part.getHeight(), this.field_70161_v, this.field_70177_z, this.field_70125_A);
            }
            if (part.isPartCollidingWithBlocks(new Vec3d(0.0, Math.max(0.0, -part.offset.field_72448_b) + (double)part.getHeight(), 0.0))) {
                this.func_70080_a(this.field_70165_t, this.field_70163_u + (double)part.getHeight(), this.field_70161_v, this.field_70177_z, this.field_70125_A);
            }
        }
    }

    public void removePart(APart part, boolean playBreakSound) {
        if (this.parts.contains(part)) {
            this.parts.remove(part);
            if (part.isValid()) {
                part.removePart();
                if (!this.field_70170_p.field_72995_K) {
                    MTS.MTSNet.sendToAll((IMessage)new PacketVehicleClientPartRemoval(this, part.offset.field_72450_a, part.offset.field_72448_b, part.offset.field_72449_c));
                }
            }
            if (!this.field_70170_p.field_72995_K && playBreakSound) {
                this.func_184185_a(SoundEvents.field_187769_eM, 2.0f, 1.0f);
            }
        }
    }

    public APart[] getVehicleParts() {
        return (APart[])ImmutableList.copyOf(this.parts).toArray((Object[])new APart[this.parts.size()]);
    }

    public APart getPartAtLocation(double offsetX, double offsetY, double offsetZ) {
        for (APart part : this.parts) {
            if (part.offset.field_72450_a != offsetX || part.offset.field_72448_b != offsetY || part.offset.field_72449_c != offsetZ) continue;
            return part;
        }
        return null;
    }

    public Map<Vec3d, PackVehicleObject.PackPart> getAllPossiblePackParts() {
        HashMap<Vec3d, PackVehicleObject.PackPart> packParts = new HashMap<Vec3d, PackVehicleObject.PackPart>();
        block0: for (PackVehicleObject.PackPart packPart : this.pack.parts) {
            Vec3d partPos = new Vec3d((double)packPart.pos[0], (double)packPart.pos[1], (double)packPart.pos[2]);
            packParts.put(partPos, packPart);
            if (packPart.additionalPart == null) continue;
            for (APart part : this.parts) {
                if (!part.offset.equals((Object)partPos)) continue;
                packParts.put(new Vec3d((double)packPart.additionalPart.pos[0], (double)packPart.additionalPart.pos[1], (double)packPart.additionalPart.pos[2]), packPart.additionalPart);
                continue block0;
            }
        }
        for (APart part : this.parts) {
            if (part.pack.subParts == null) continue;
            PackVehicleObject.PackPart parentPack = this.getPackDefForLocation(part.offset.field_72450_a, part.offset.field_72448_b, part.offset.field_72449_c);
            for (PackVehicleObject.PackPart extraPackPart : part.pack.subParts) {
                PackVehicleObject.PackPart correctedPack = this.getPackForSubPart(parentPack, extraPackPart);
                packParts.put(new Vec3d((double)correctedPack.pos[0], (double)correctedPack.pos[1], (double)correctedPack.pos[2]), correctedPack);
            }
        }
        return packParts;
    }

    public PackVehicleObject.PackPart getPackDefForLocation(double offsetX, double offsetY, double offsetZ) {
        for (PackVehicleObject.PackPart packPart : this.pack.parts) {
            if ((double)packPart.pos[0] == offsetX && (double)packPart.pos[1] == offsetY && (double)packPart.pos[2] == offsetZ) {
                return packPart;
            }
            if (packPart.additionalPart == null || (double)packPart.additionalPart.pos[0] != offsetX || (double)packPart.additionalPart.pos[1] != offsetY || (double)packPart.additionalPart.pos[2] != offsetZ) continue;
            return packPart.additionalPart;
        }
        for (APart part : this.parts) {
            if (part.pack.subParts.size() <= 0) continue;
            PackVehicleObject.PackPart parentPack = this.getPackDefForLocation(part.offset.field_72450_a, part.offset.field_72448_b, part.offset.field_72449_c);
            for (PackVehicleObject.PackPart extraPackPart : part.pack.subParts) {
                PackVehicleObject.PackPart correctedPack = this.getPackForSubPart(parentPack, extraPackPart);
                if ((double)correctedPack.pos[0] != offsetX || (double)correctedPack.pos[1] != offsetY || (double)correctedPack.pos[2] != offsetZ) continue;
                return correctedPack;
            }
        }
        return null;
    }

    private PackVehicleObject.PackPart getPackForSubPart(PackVehicleObject.PackPart parentPack, PackVehicleObject.PackPart subPack) {
        PackVehicleObject.PackPart correctPack = this.pack.new PackVehicleObject.PackPart();
        (correctPack.pos = new float[3])[0] = parentPack.pos[0] >= 0.0f || parentPack.overrideMirror ? parentPack.pos[0] + subPack.pos[0] : parentPack.pos[0] - subPack.pos[0];
        correctPack.pos[1] = parentPack.pos[1] + subPack.pos[1];
        correctPack.pos[2] = parentPack.pos[2] + subPack.pos[2];
        if (parentPack.rot != null || subPack.rot != null) {
            correctPack.rot = new float[3];
        }
        if (parentPack.rot != null) {
            correctPack.rot[0] = correctPack.rot[0] + parentPack.rot[0];
            correctPack.rot[1] = correctPack.rot[1] + parentPack.rot[1];
            correctPack.rot[2] = correctPack.rot[2] + parentPack.rot[2];
        }
        if (subPack.rot != null) {
            correctPack.rot[0] = correctPack.rot[0] + subPack.rot[0];
            correctPack.rot[1] = correctPack.rot[1] + subPack.rot[1];
            correctPack.rot[2] = correctPack.rot[2] + subPack.rot[2];
        }
        correctPack.turnsWithSteer = parentPack.turnsWithSteer;
        correctPack.isController = subPack.isController;
        correctPack.overrideMirror = subPack.overrideMirror;
        correctPack.types = subPack.types;
        correctPack.customTypes = subPack.customTypes;
        correctPack.minValue = subPack.minValue;
        correctPack.maxValue = subPack.maxValue;
        return correctPack;
    }

    public void func_70020_e(NBTTagCompound tagCompound) {
        super.func_70020_e(tagCompound);
        this.vehicleName = tagCompound.func_74779_i("vehicleName");
        this.vehicleJSONName = PackParserSystem.getVehicleJSONName(this.vehicleName);
        this.pack = PackParserSystem.getVehiclePack(this.vehicleName);
        if (this.parts.size() == 0) {
            NBTTagList partTagList = tagCompound.func_150295_c("Parts", 10);
            for (int i = 0; i < partTagList.func_74745_c(); i = (int)((byte)(i + 1))) {
                try {
                    NBTTagCompound partTag = partTagList.func_150305_b(i);
                    PackVehicleObject.PackPart packPart = this.getPackDefForLocation(partTag.func_74769_h("offsetX"), partTag.func_74769_h("offsetY"), partTag.func_74769_h("offsetZ"));
                    Class<? extends APart> partClass = PackParserSystem.getPartPartClass(partTag.func_74779_i("partName"));
                    Constructor<? extends APart> construct = partClass.getConstructor(EntityVehicleE_Powered.class, PackVehicleObject.PackPart.class, String.class, NBTTagCompound.class);
                    APart savedPart = construct.newInstance(new Object[]{(EntityVehicleE_Powered)this, packPart, partTag.func_74779_i("partName"), partTag});
                    this.addPart(savedPart, true);
                    continue;
                }
                catch (Exception e) {
                    MTS.MTSLog.error("ERROR IN LOADING PART FROM NBT!");
                    e.printStackTrace();
                }
            }
        }
    }

    public NBTTagCompound func_189511_e(NBTTagCompound tagCompound) {
        super.func_189511_e(tagCompound);
        tagCompound.func_74778_a("vehicleName", this.vehicleName);
        NBTTagList partTagList = new NBTTagList();
        for (APart part : this.getVehicleParts()) {
            if (!part.isValid()) continue;
            NBTTagCompound partTag = part.getPartNBTTag();
            partTag.func_74778_a("partName", part.partName);
            partTag.func_74780_a("offsetX", part.offset.field_72450_a);
            partTag.func_74780_a("offsetY", part.offset.field_72448_b);
            partTag.func_74780_a("offsetZ", part.offset.field_72449_c);
            partTagList.func_74742_a((NBTBase)partTag);
        }
        tagCompound.func_74782_a("Parts", (NBTBase)partTagList);
        return tagCompound;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
    }
}

