/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.main;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.baseclasses.VehicleAxisAlignedBB;
import minecrafttransportsimulator.packets.vehicles.PacketVehicleDeltas;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.RotationSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleC_Colliding;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.APartGroundDevice;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class EntityVehicleD_Moving
extends EntityVehicleC_Colliding {
    public boolean brakeOn;
    public boolean parkingBrakeOn;
    public float motionRoll;
    public float motionPitch;
    public float motionYaw;
    public double velocity;
    private double clientDeltaX;
    private double clientDeltaY;
    private double clientDeltaZ;
    private float clientDeltaYaw;
    private float clientDeltaPitch;
    private float clientDeltaRoll;
    private double serverDeltaX;
    private double serverDeltaY;
    private double serverDeltaZ;
    private float serverDeltaYaw;
    private float serverDeltaPitch;
    private float serverDeltaRoll;
    public final List<APartGroundDevice> groundedGroundDevices = new ArrayList<APartGroundDevice>();
    public final double clingSpeed = ConfigSystem.getDoubleConfig("ClingSpeed");

    public EntityVehicleD_Moving(World world) {
        super(world);
    }

    public EntityVehicleD_Moving(World world, float posX, float posY, float posZ, float playerRotation, String vehicleName) {
        super(world, posX, posY, posZ, playerRotation, vehicleName);
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        if (this.pack != null) {
            this.getForcesAndMotions();
            this.performGroundOperations();
            this.moveVehicle();
            if (!this.field_70170_p.field_72995_K) {
                this.dampenControlSurfaces();
            }
            this.groundedGroundDevices.clear();
            for (APart part : this.getVehicleParts()) {
                if (!(part instanceof APartGroundDevice) || !((APartGroundDevice)part).isOnGround()) continue;
                this.groundedGroundDevices.add((APartGroundDevice)part);
            }
            for (APart part : this.getVehicleParts()) {
                part.updatePart();
            }
        }
    }

    private void moveVehicle() {
        VehicleAxisAlignedBB offsetBox;
        boolean needCheck = false;
        boolean groundDeviceNeedsLifting = false;
        double originalMotionY = this.field_70181_x;
        for (VehicleAxisAlignedBB box : this.getCurrentCollisionBoxes()) {
            Vec3d offset = RotationSystem.getRotatedPoint(box.rel, this.field_70125_A + this.motionPitch, this.field_70177_z + this.motionYaw, this.rotationRoll + this.motionRoll);
            offsetBox = box.getBoxWithOrigin(this.func_174791_d().func_178787_e(offset).func_72441_c(this.field_70159_w * this.speedFactor, this.field_70181_x * this.speedFactor, this.field_70179_y * this.speedFactor));
            if (this.getAABBCollisions(offsetBox, (APartGroundDevice)this.groundDeviceCollisionBoxMap.get((Object)box), null).isEmpty()) continue;
            needCheck = true;
        }
        if (needCheck) {
            for (VehicleAxisAlignedBB box : this.getCurrentCollisionBoxes()) {
                float collisionDepth = this.getCollisionForAxis(box, true, false, false, (APartGroundDevice)this.groundDeviceCollisionBoxMap.get((Object)box));
                if (collisionDepth < 0.0f) {
                    if (collisionDepth != -2.0f) {
                        if (collisionDepth != -3.0f) continue;
                        groundDeviceNeedsLifting = true;
                        continue;
                    }
                    return;
                }
                if (this.field_70159_w > 0.0) {
                    this.field_70159_w = Math.max(this.field_70159_w - (double)collisionDepth / this.speedFactor, 0.0);
                    continue;
                }
                if (!(this.field_70159_w < 0.0)) continue;
                this.field_70159_w = Math.min(this.field_70159_w + (double)collisionDepth / this.speedFactor, 0.0);
            }
            for (VehicleAxisAlignedBB box : this.getCurrentCollisionBoxes()) {
                float collisionDepth = this.getCollisionForAxis(box, false, false, true, (APartGroundDevice)this.groundDeviceCollisionBoxMap.get((Object)box));
                if (collisionDepth < 0.0f) {
                    if (collisionDepth != -2.0f) {
                        if (collisionDepth != -3.0f) continue;
                        groundDeviceNeedsLifting = true;
                        continue;
                    }
                    return;
                }
                if (this.field_70179_y > 0.0) {
                    this.field_70179_y = Math.max(this.field_70179_y - (double)collisionDepth / this.speedFactor, 0.0);
                    continue;
                }
                if (!(this.field_70179_y < 0.0)) continue;
                this.field_70179_y = Math.min(this.field_70179_y + (double)collisionDepth / this.speedFactor, 0.0);
            }
            for (VehicleAxisAlignedBB box : this.getCurrentCollisionBoxes()) {
                float collisionDepth = this.getCollisionForAxis(box, false, true, false, (APartGroundDevice)this.groundDeviceCollisionBoxMap.get((Object)box));
                if (collisionDepth < 0.0f) {
                    if (collisionDepth != -2.0f) continue;
                    return;
                }
                if (collisionDepth == 0.0f) continue;
                if (this.field_70181_x > 0.0) {
                    this.field_70181_x = Math.max(this.field_70181_x - (double)collisionDepth / this.speedFactor, 0.0);
                    continue;
                }
                if (!(this.field_70181_x < 0.0)) continue;
                this.field_70181_x = Math.min(this.field_70181_x + (double)collisionDepth / this.speedFactor, 0.0);
            }
            block4: for (VehicleAxisAlignedBB box : this.getCurrentCollisionBoxes()) {
                while (this.motionYaw != 0.0f) {
                    Vec3d offset = RotationSystem.getRotatedPoint(box.rel, this.field_70125_A, this.field_70177_z + this.motionYaw, this.rotationRoll);
                    offsetBox = box.getBoxWithOrigin(this.func_174791_d().func_178787_e(offset).func_72441_c(this.field_70159_w * this.speedFactor, this.field_70181_x * this.speedFactor + 0.1, this.field_70179_y * this.speedFactor));
                    if (this.getAABBCollisions(offsetBox, (APartGroundDevice)this.groundDeviceCollisionBoxMap.get((Object)box), null).isEmpty()) continue block4;
                    if (this.motionYaw > 0.0f) {
                        this.motionYaw = Math.max(this.motionYaw - 0.1f, 0.0f);
                        continue;
                    }
                    this.motionYaw = Math.min(this.motionYaw + 0.1f, 0.0f);
                }
            }
            block6: for (VehicleAxisAlignedBB box : this.getCurrentCollisionBoxes()) {
                while (this.motionPitch != 0.0f) {
                    Vec3d offset = RotationSystem.getRotatedPoint(box.rel, this.field_70125_A + this.motionPitch, this.field_70177_z + this.motionYaw, this.rotationRoll);
                    offsetBox = box.getBoxWithOrigin(this.func_174791_d().func_178787_e(offset).func_72441_c(this.field_70159_w * this.speedFactor, this.field_70181_x * this.speedFactor, this.field_70179_y * this.speedFactor));
                    if (this.getAABBCollisions(offsetBox, (APartGroundDevice)this.groundDeviceCollisionBoxMap.get((Object)box), null).isEmpty()) continue block6;
                    if (this.motionPitch < 0.0f && box.rel.field_72449_c <= 0.0 || this.motionPitch > 0.0f && this.field_70125_A < -10.0f && box.rel.field_72449_c > 0.0 && originalMotionY > 0.0) {
                        float yBoost = 0.0f;
                        for (AxisAlignedBB box2 : this.getAABBCollisions(offsetBox, (APartGroundDevice)this.groundDeviceCollisionBoxMap.get((Object)box), null)) {
                            if (!(box2.field_72337_e > offsetBox.field_72338_b + (double)yBoost)) continue;
                            yBoost = (float)((double)yBoost + (box2.field_72337_e - offsetBox.field_72338_b));
                        }
                        yBoost = (float)Math.min(Math.min(this.velocity, (double)Math.abs(this.motionPitch)), (double)yBoost / this.speedFactor);
                        this.field_70181_x += (double)yBoost;
                        originalMotionY += (double)yBoost;
                        continue block6;
                    }
                    if (this.motionPitch > 0.0f) {
                        this.motionPitch = Math.max(this.motionPitch - 0.1f, 0.0f);
                        continue;
                    }
                    this.motionPitch = Math.min(this.motionPitch + 0.1f, 0.0f);
                }
            }
            block9: for (VehicleAxisAlignedBB box : this.getCurrentCollisionBoxes()) {
                while (this.motionRoll != 0.0f) {
                    Vec3d offset = RotationSystem.getRotatedPoint(box.rel, this.field_70125_A + this.motionPitch, this.field_70177_z + this.motionYaw, this.rotationRoll + this.motionRoll);
                    offsetBox = box.getBoxWithOrigin(this.func_174791_d().func_178787_e(offset).func_72441_c(this.field_70159_w * this.speedFactor, this.field_70181_x * this.speedFactor, this.field_70179_y * this.speedFactor));
                    if (this.getAABBCollisions(offsetBox, (APartGroundDevice)this.groundDeviceCollisionBoxMap.get((Object)box), null).isEmpty()) continue block9;
                    if (this.motionRoll > 0.0f) {
                        this.motionRoll = Math.max(this.motionRoll - 0.1f, 0.0f);
                        continue;
                    }
                    this.motionRoll = Math.min(this.motionRoll + 0.1f, 0.0f);
                }
            }
            if (groundDeviceNeedsLifting && this.field_70181_x <= (double)0.15f) {
                this.field_70181_x = 0.15f;
            }
            if (originalMotionY != this.field_70181_x && originalMotionY < 0.0) {
                boolean needPitchUp = false;
                boolean needPitchDown = false;
                boolean needRollRight = false;
                boolean needRollLeft = false;
                boolean needPitchUpAnytime = false;
                boolean needPitchDownAnytime = false;
                boolean needRollRightAnytime = false;
                boolean needRollLeftAnytime = false;
                boolean continueLoop = true;
                int loopCount = 0;
                float modifiedPitch = this.motionPitch;
                float modifiedRoll = this.motionRoll;
                do {
                    needPitchUp = false;
                    needPitchDown = false;
                    needRollRight = false;
                    needRollLeft = false;
                    for (VehicleAxisAlignedBB box : this.getCurrentCollisionBoxes()) {
                        Vec3d offset = RotationSystem.getRotatedPoint(box.rel, this.field_70125_A + this.motionPitch, this.field_70177_z + this.motionYaw, this.rotationRoll + this.motionRoll);
                        VehicleAxisAlignedBB offsetBox2 = box.getBoxWithOrigin(this.func_174791_d().func_178787_e(offset).func_72441_c(this.field_70159_w * this.speedFactor, this.field_70181_x * this.speedFactor, this.field_70179_y * this.speedFactor));
                        if (this.getAABBCollisions(offsetBox2, (APartGroundDevice)this.groundDeviceCollisionBoxMap.get((Object)box), null).isEmpty()) continue;
                        if (box.rel.field_72449_c > 0.0) {
                            needPitchUp = true;
                            needPitchUpAnytime = true;
                        }
                        if (box.rel.field_72449_c <= 0.0 && this.motionPitch >= 0.0f) {
                            needPitchDown = true;
                            needPitchDownAnytime = true;
                        }
                        if (box.rel.field_72450_a > 0.0) {
                            needRollRight = true;
                            needRollRightAnytime = true;
                        }
                        if (!(box.rel.field_72450_a < 0.0)) continue;
                        needRollLeft = true;
                        needRollLeftAnytime = true;
                    }
                    if (needPitchUp && !needPitchDownAnytime) {
                        this.motionPitch -= 0.1f;
                    }
                    if (needPitchDown && !needPitchUpAnytime) {
                        this.motionPitch += 0.1f;
                    }
                    if (needRollLeft && !needRollRightAnytime) {
                        this.motionRoll -= 0.1f;
                    }
                    if (needRollRight && !needRollLeftAnytime) {
                        this.motionRoll += 0.1f;
                    }
                    if (!(needPitchUp || needPitchDown || needRollRight || needRollLeft)) {
                        this.field_70181_x = Math.max(originalMotionY, this.field_70181_x - (double)0.1f);
                    }
                    if (!(needPitchUp || needPitchDown || needRollRight || needRollLeft || !groundDeviceNeedsLifting && this.field_70181_x != originalMotionY)) {
                        continueLoop = false;
                    } else if (needPitchUp && needPitchDown && !needRollRight && !needRollLeft) {
                        continueLoop = false;
                    } else if (needRollRight && needRollLeft && !needPitchUp && !needPitchDown) {
                        continueLoop = false;
                    } else if (needPitchUpAnytime && needPitchDownAnytime && needRollRightAnytime && needRollLeftAnytime) {
                        continueLoop = false;
                        if (loopCount == 1) {
                            loopCount = 0;
                        }
                    }
                    if (loopCount != 0 || continueLoop) continue;
                    this.motionPitch = modifiedPitch;
                    this.motionRoll = modifiedRoll;
                } while (continueLoop && ++loopCount < 20);
            }
            if (this.field_70159_w > 0.0) {
                this.field_70159_w -= (double)0.002f;
            }
            if (this.field_70159_w < 0.0) {
                this.field_70159_w += (double)0.002f;
            }
            if (this.field_70181_x > 0.0) {
                this.field_70181_x -= (double)0.002f;
            }
            if (this.field_70181_x < 0.0) {
                this.field_70181_x += (double)0.002f;
            }
            if (this.field_70179_y > 0.0) {
                this.field_70179_y -= (double)0.002f;
            }
            if (this.field_70179_y < 0.0) {
                this.field_70179_y += (double)0.002f;
            }
        }
        this.prevRotationRoll = this.rotationRoll;
        if (Math.abs(this.field_70159_w) < 0.001) {
            this.field_70159_w = 0.0;
        }
        if (Math.abs(this.field_70181_x) < 0.001) {
            this.field_70181_x = 0.0;
        }
        if (Math.abs(this.field_70179_y) < 0.001) {
            this.field_70179_y = 0.0;
        }
        if ((double)Math.abs(this.motionYaw) < 0.001) {
            this.motionYaw = 0.0f;
        }
        if ((double)Math.abs(this.motionPitch) < 0.001) {
            this.motionPitch = 0.0f;
        }
        if ((double)Math.abs(this.motionRoll) < 0.001) {
            this.motionRoll = 0.0f;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70159_w != 0.0 || this.field_70181_x != 0.0 || this.field_70179_y != 0.0 || this.motionPitch != 0.0f || this.motionYaw != 0.0f || this.motionRoll != 0.0f) {
                this.field_70177_z += this.motionYaw;
                this.field_70125_A += this.motionPitch;
                this.rotationRoll += this.motionRoll;
                this.func_70107_b(this.field_70165_t + this.field_70159_w * this.speedFactor, this.field_70163_u + this.field_70181_x * this.speedFactor, this.field_70161_v + this.field_70179_y * this.speedFactor);
                this.addToServerDeltas(this.field_70159_w * this.speedFactor, this.field_70181_x * this.speedFactor, this.field_70179_y * this.speedFactor, this.motionYaw, this.motionPitch, this.motionRoll);
                MTS.MTSNet.sendToAll((IMessage)new PacketVehicleDeltas(this, this.field_70159_w * this.speedFactor, this.field_70181_x * this.speedFactor, this.field_70179_y * this.speedFactor, this.motionYaw, this.motionPitch, this.motionRoll));
            }
        } else if (this.serverDeltaX != 0.0 || this.serverDeltaY != 0.0 || this.serverDeltaZ != 0.0) {
            double deltaX = this.serverDeltaX - this.clientDeltaX != 0.0 ? this.field_70159_w * this.speedFactor + (this.serverDeltaX - this.clientDeltaX) / 25.0 * Math.abs(this.serverDeltaX - this.clientDeltaX) : 0.0;
            double deltaY = this.serverDeltaY - this.clientDeltaY != 0.0 ? this.field_70181_x * this.speedFactor + (this.serverDeltaY - this.clientDeltaY) / 25.0 * Math.abs(this.serverDeltaY - this.clientDeltaY) : 0.0;
            double deltaZ = this.serverDeltaZ - this.clientDeltaZ != 0.0 ? this.field_70179_y * this.speedFactor + (this.serverDeltaZ - this.clientDeltaZ) / 25.0 * Math.abs(this.serverDeltaZ - this.clientDeltaZ) : 0.0;
            float deltaYaw = this.serverDeltaYaw - this.clientDeltaYaw != 0.0f ? this.motionYaw + (this.serverDeltaYaw - this.clientDeltaYaw) / 25.0f * Math.abs(this.serverDeltaYaw - this.clientDeltaYaw) : 0.0f;
            float deltaPitch = this.serverDeltaPitch - this.clientDeltaPitch != 0.0f ? this.motionPitch + (this.serverDeltaPitch - this.clientDeltaPitch) / 25.0f * Math.abs(this.serverDeltaPitch - this.clientDeltaPitch) : 0.0f;
            float deltaRoll = this.serverDeltaRoll - this.clientDeltaRoll != 0.0f ? this.motionRoll + (this.serverDeltaRoll - this.clientDeltaRoll) / 25.0f * Math.abs(this.serverDeltaRoll - this.clientDeltaRoll) : 0.0f;
            this.func_70107_b(this.field_70165_t + deltaX, this.field_70163_u + deltaY, this.field_70161_v + deltaZ);
            this.field_70177_z += deltaYaw;
            this.field_70125_A += deltaPitch;
            this.rotationRoll += deltaRoll;
            this.addToClientDeltas(deltaX, deltaY, deltaZ, deltaYaw, deltaPitch, deltaRoll);
        } else {
            this.field_70177_z += this.motionYaw;
            this.field_70125_A += this.motionPitch;
            this.rotationRoll += this.motionRoll;
            this.func_70107_b(this.field_70165_t + this.field_70159_w * this.speedFactor, this.field_70163_u + this.field_70181_x * this.speedFactor, this.field_70161_v + this.field_70179_y * this.speedFactor);
        }
        if (this.velocity != 0.0) {
            block13: for (EntityPlayer player : this.field_70170_p.field_73010_i) {
                for (VehicleAxisAlignedBB box : this.getCurrentCollisionBoxes()) {
                    if (!box.offset(this.field_70165_t - this.field_70169_q, this.field_70163_u - this.field_70167_r + (double)0.1f, this.field_70161_v - this.field_70166_s).func_72326_a(player.func_174813_aQ())) continue;
                    if (Math.abs(this.velocity) / this.speedFactor <= this.clingSpeed || box.isInterior) {
                        player.func_70107_b(player.field_70165_t + (this.field_70165_t - this.field_70169_q), player.field_70163_u + (this.field_70163_u - this.field_70167_r), player.field_70161_v + (this.field_70161_v - this.field_70166_s));
                        continue block13;
                    }
                    if (!(Math.abs(this.velocity) / this.speedFactor < 2.0 * this.clingSpeed)) continue block13;
                    double slip = (2.0 * this.clingSpeed - Math.abs(this.velocity) / this.speedFactor) * 4.0;
                    player.func_70107_b(player.field_70165_t + (this.field_70165_t - this.field_70169_q) * slip, player.field_70163_u + (this.field_70163_u - this.field_70167_r) * slip, player.field_70161_v + (this.field_70161_v - this.field_70166_s) * slip);
                    continue block13;
                }
            }
        }
    }

    protected float getBrakingForceFactor() {
        float brakingFactor = 0.0f;
        for (APartGroundDevice groundDevice : this.groundedGroundDevices) {
            float addedFactor = 0.0f;
            if (this.brakeOn || this.parkingBrakeOn) {
                addedFactor = groundDevice.getMotiveFriction();
            }
            if (addedFactor == 0.0f) continue;
            brakingFactor += Math.max(addedFactor - groundDevice.getFrictionLoss(), 0.0f);
        }
        for (VehicleAxisAlignedBB box : this.getCurrentCollisionBoxes()) {
            if (this.groundDeviceCollisionBoxMap.containsKey((Object)box) || this.field_70170_p.func_147461_a((AxisAlignedBB)box.offset(0.0, -0.05f, 0.0)).isEmpty()) continue;
            BlockPos pos = new BlockPos(box.pos.func_72441_c(0.0, -1.0, 0.0));
            float frictionLoss = 0.6f - this.field_70170_p.func_180495_p((BlockPos)pos).func_177230_c().field_149765_K;
            brakingFactor = (float)((double)brakingFactor + Math.max(2.0 - (double)frictionLoss, 0.0));
        }
        return brakingFactor;
    }

    protected float getSkiddingFactor() {
        float skiddingFactor = 0.0f;
        for (APartGroundDevice groundDevice : this.groundedGroundDevices) {
            skiddingFactor += groundDevice.getLateralFriction() - groundDevice.getFrictionLoss();
        }
        return skiddingFactor > 0.0f ? skiddingFactor : 0.0f;
    }

    protected float getTurningFactor() {
        float turningForce = 0.0f;
        float steeringAngle = this.getSteerAngle();
        if (steeringAngle != 0.0f) {
            float turningFactor = 0.0f;
            float turningDistance = 0.0f;
            for (APartGroundDevice groundDevice : this.groundedGroundDevices) {
                float frictionLoss = groundDevice.getFrictionLoss();
                if (!groundDevice.turnsWithSteer || !(groundDevice.getLateralFriction() - frictionLoss > 0.0f)) continue;
                turningFactor += groundDevice.getLateralFriction() - frictionLoss;
                turningDistance = (float)Math.max((double)turningDistance, Math.abs(groundDevice.offset.field_72449_c));
            }
            if (turningFactor > 0.0f) {
                steeringAngle = Math.abs(steeringAngle);
                if (turningFactor < 1.0f) {
                    steeringAngle *= turningFactor;
                }
                steeringAngle /= turningDistance;
                if (Math.abs(this.velocity * this.speedFactor / (double)0.35f) - (double)(turningFactor / 3.0f) > 0.0) {
                    steeringAngle = (float)((double)steeringAngle * Math.pow(0.25, Math.abs(this.velocity * (0.75 + this.speedFactor / (double)0.35f / 4.0)) - (double)(turningFactor / 3.0f)));
                }
                turningForce = -((float)((double)steeringAngle * this.velocity / 2.0));
                turningForce = (float)((double)turningForce * (this.speedFactor / (double)0.35f));
                turningForce *= Math.signum(this.getSteerAngle());
            }
        }
        return turningForce;
    }

    protected void reAdjustGroundSpeed(double groundSpeed) {
        Vec3d groundVec = new Vec3d(this.headingVec.field_72450_a, 0.0, this.headingVec.field_72449_c).func_72432_b();
        this.field_70159_w = groundVec.field_72450_a * groundSpeed;
        this.field_70179_y = groundVec.field_72449_c * groundSpeed;
    }

    private void addToClientDeltas(double dX, double dY, double dZ, float dYaw, float dPitch, float dRoll) {
        this.clientDeltaX += dX;
        this.clientDeltaY += dY;
        this.clientDeltaZ += dZ;
        this.clientDeltaYaw += dYaw;
        this.clientDeltaPitch += dPitch;
        this.clientDeltaRoll += dRoll;
    }

    public void addToServerDeltas(double dX, double dY, double dZ, float dYaw, float dPitch, float dRoll) {
        this.serverDeltaX += dX;
        this.serverDeltaY += dY;
        this.serverDeltaZ += dZ;
        this.serverDeltaYaw += dYaw;
        this.serverDeltaPitch += dPitch;
        this.serverDeltaRoll += dRoll;
    }

    protected abstract void getForcesAndMotions();

    protected abstract void performGroundOperations();

    protected abstract void dampenControlSurfaces();

    @Override
    public void func_70020_e(NBTTagCompound tagCompound) {
        super.func_70020_e(tagCompound);
        this.parkingBrakeOn = tagCompound.func_74767_n("parkingBrakeOn");
        this.brakeOn = tagCompound.func_74767_n("brakeOn");
        this.serverDeltaX = tagCompound.func_74769_h("serverDeltaX");
        this.serverDeltaY = tagCompound.func_74769_h("serverDeltaY");
        this.serverDeltaZ = tagCompound.func_74769_h("serverDeltaZ");
        this.serverDeltaYaw = tagCompound.func_74760_g("serverDeltaYaw");
        this.serverDeltaPitch = tagCompound.func_74760_g("serverDeltaPitch");
        this.serverDeltaRoll = tagCompound.func_74760_g("serverDeltaRoll");
        if (this.field_70170_p.field_72995_K) {
            this.clientDeltaX = this.serverDeltaX;
            this.clientDeltaY = this.serverDeltaY;
            this.clientDeltaZ = this.serverDeltaZ;
            this.clientDeltaYaw = this.serverDeltaYaw;
            this.clientDeltaPitch = this.serverDeltaPitch;
            this.clientDeltaRoll = this.serverDeltaRoll;
        }
    }

    @Override
    public NBTTagCompound func_189511_e(NBTTagCompound tagCompound) {
        super.func_189511_e(tagCompound);
        tagCompound.func_74757_a("brakeOn", this.brakeOn);
        tagCompound.func_74757_a("parkingBrakeOn", this.parkingBrakeOn);
        tagCompound.func_74780_a("serverDeltaX", this.serverDeltaX);
        tagCompound.func_74780_a("serverDeltaY", this.serverDeltaY);
        tagCompound.func_74780_a("serverDeltaZ", this.serverDeltaZ);
        tagCompound.func_74776_a("serverDeltaYaw", this.serverDeltaYaw);
        tagCompound.func_74776_a("serverDeltaPitch", this.serverDeltaPitch);
        tagCompound.func_74776_a("serverDeltaRoll", this.serverDeltaRoll);
        return tagCompound;
    }
}

