/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.main;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.baseclasses.VehicleSound;
import minecrafttransportsimulator.dataclasses.DamageSources;
import minecrafttransportsimulator.dataclasses.MTSRegistry;
import minecrafttransportsimulator.dataclasses.PackInstrumentObject;
import minecrafttransportsimulator.dataclasses.PackVehicleObject;
import minecrafttransportsimulator.packets.vehicles.PacketVehicleClientRemoval;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleD_Moving;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.APartEngine;
import minecrafttransportsimulator.vehicles.parts.PartBarrel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityVehicleE_Powered
extends EntityVehicleD_Moving {
    public boolean soundsNeedInit;
    public boolean hornOn;
    public boolean sirenOn;
    public byte throttle;
    public double fuel;
    public double electricPower = 12.0;
    public double electricUsage;
    public double electricFlow;
    public Vec3d velocityVec = Vec3d.field_186680_a;
    private byte numberEngineBays = 0;
    private final Map<Byte, APartEngine> engineByNumber = new HashMap<Byte, APartEngine>();
    private final Map<Byte, VehicleInstrument> instruments = new HashMap<Byte, VehicleInstrument>();
    private final List<LightTypes> lightsOn = new ArrayList<LightTypes>();
    private final List<VehicleSound> sounds = new ArrayList<VehicleSound>();

    public EntityVehicleE_Powered(World world) {
        super(world);
    }

    public EntityVehicleE_Powered(World world, float posX, float posY, float posZ, float playerRotation, String vehicleName) {
        super(world, posX, posY, posZ, playerRotation, vehicleName);
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        if (this.pack != null) {
            this.updateHeadingVec();
            if (this.fuel < 0.0) {
                this.fuel = 0.0;
            }
            if (this.electricPower > 2.0) {
                for (LightTypes light : this.lightsOn) {
                    if (light.hasBeam) {
                        this.electricUsage += (double)5.0E-4f;
                        continue;
                    }
                    this.electricUsage += (double)1.0E-4f;
                }
            }
            this.electricPower = Math.max(0.0, Math.min(13.0, this.electricPower -= this.electricUsage));
            this.electricFlow = this.electricUsage;
            this.electricUsage = 0.0;
        }
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K) {
            MTS.MTSNet.sendToAll((IMessage)new PacketVehicleClientRemoval(this));
        }
        super.func_70106_y();
    }

    @Override
    public void destroyAtPosition(double x, double y, double z) {
        super.destroyAtPosition(x, y, z);
        for (VehicleInstrument vehicleInstrument : this.instruments.values()) {
            ItemStack stack = new ItemStack((Item)MTSRegistry.instrumentItemMap.get(vehicleInstrument.name));
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack));
        }
        Entity controller = null;
        for (Entity passenger : this.func_184188_bt()) {
            if (!this.getSeatForRider((Entity)passenger).isController || controller == null) continue;
            controller = passenger;
            break;
        }
        for (Entity passenger : this.func_184188_bt()) {
            if (passenger.equals((Object)controller)) {
                passenger.func_70097_a((DamageSource)new DamageSources.DamageSourceCrash(null, this.pack.general.type), (float)(ConfigSystem.getDoubleConfig("CrashDamageFactor") * this.velocity * 20.0));
                continue;
            }
            passenger.func_70097_a((DamageSource)new DamageSources.DamageSourceCrash(controller, this.pack.general.type), (float)(ConfigSystem.getDoubleConfig("CrashDamageFactor") * this.velocity * 20.0));
        }
        if (ConfigSystem.getBooleanConfig("Explosions")) {
            double d = this.fuel;
            for (APart part : this.getVehicleParts()) {
                double fuelFactor;
                PartBarrel barrel;
                if (!(part instanceof PartBarrel) || (barrel = (PartBarrel)part).getFluid() == null || !((fuelFactor = ConfigSystem.getFuelValue(FluidRegistry.getFluidName((Fluid)barrel.getFluid().getFluid()))) > 0.0)) continue;
                d += (double)barrel.getFluidAmount() * fuelFactor;
            }
            this.field_70170_p.func_72885_a((Entity)this, x, y, z, (float)(d / 1000.0 + 1.0), true, true);
        }
    }

    @Override
    protected float getCurrentMass() {
        return (float)((double)super.getCurrentMass() + this.fuel / 50.0);
    }

    @Override
    public void addPart(APart part, boolean ignoreCollision) {
        super.addPart(part, ignoreCollision);
        if (part instanceof APartEngine) {
            byte engineNumber = 0;
            for (PackVehicleObject.PackPart packPart : this.pack.parts) {
                for (String type : packPart.types) {
                    if (!type.startsWith("engine")) continue;
                    if (part.offset.field_72450_a == (double)packPart.pos[0] && part.offset.field_72448_b == (double)packPart.pos[1] && part.offset.field_72449_c == (double)packPart.pos[2]) {
                        this.engineByNumber.put(engineNumber, (APartEngine)part);
                    }
                    engineNumber = (byte)(engineNumber + 1);
                }
            }
        }
    }

    @Override
    public void removePart(APart part, boolean playBreakSound) {
        super.removePart(part, playBreakSound);
        byte engineNumber = 0;
        for (PackVehicleObject.PackPart packPart : this.pack.parts) {
            for (String type : packPart.types) {
                if (!type.startsWith("engine")) continue;
                if (part.offset.field_72450_a == (double)packPart.pos[0] && part.offset.field_72448_b == (double)packPart.pos[1] && part.offset.field_72449_c == (double)packPart.pos[2]) {
                    this.engineByNumber.remove(engineNumber);
                    return;
                }
                engineNumber = (byte)(engineNumber + 1);
            }
        }
    }

    @Override
    protected void performGroundOperations() {
        float skiddingFactor;
        float brakingFactor = this.getBrakingForceFactor();
        if (brakingFactor > 0.0f) {
            double groundSpeed = Math.hypot(this.field_70159_w, this.field_70179_y) * Math.signum(this.velocity);
            if (Math.abs(groundSpeed -= (double)(20.0f * brakingFactor) / this.currentMass * Math.signum(this.velocity)) > 0.1) {
                this.reAdjustGroundSpeed(groundSpeed);
            } else {
                this.field_70159_w = 0.0;
                this.field_70179_y = 0.0;
                this.motionYaw = 0.0f;
            }
        }
        if ((skiddingFactor = this.getSkiddingFactor()) != 0.0f) {
            Vec3d groundHeadingVec;
            Vec3d groundVelocityVec = new Vec3d(this.field_70159_w, 0.0, this.field_70179_y).func_72432_b();
            float vectorDelta = (float)groundVelocityVec.func_72438_d(groundHeadingVec = new Vec3d(this.headingVec.field_72450_a, 0.0, this.headingVec.field_72449_c).func_72432_b());
            byte velocitySign = (byte)(vectorDelta < 1.0f ? 1 : -1);
            if ((double)vectorDelta > 0.001) {
                vectorDelta = Math.min(skiddingFactor, vectorDelta);
                float yawTemp = this.field_70177_z;
                this.field_70177_z += vectorDelta;
                this.updateHeadingVec();
                this.reAdjustGroundSpeed(Math.hypot(this.field_70159_w, this.field_70179_y) * (double)velocitySign);
                this.field_70177_z = yawTemp;
            }
        }
        this.motionYaw += this.getTurningFactor();
    }

    public byte getNumberEngineBays() {
        if (this.numberEngineBays == 0) {
            for (PackVehicleObject.PackPart part : this.pack.parts) {
                for (String type : part.types) {
                    if (!type.startsWith("engine")) continue;
                    this.numberEngineBays = (byte)(this.numberEngineBays + 1);
                }
            }
        }
        return this.numberEngineBays;
    }

    public APartEngine getEngineByNumber(byte number) {
        return this.engineByNumber.get(number);
    }

    public void changeLightStatus(LightTypes light, boolean isOn) {
        if (isOn) {
            if (!this.lightsOn.contains((Object)light)) {
                this.lightsOn.add(light);
            }
        } else if (this.lightsOn.contains((Object)light)) {
            this.lightsOn.remove((Object)light);
        }
    }

    public boolean isLightOn(LightTypes light) {
        return this.lightsOn.contains((Object)light);
    }

    public VehicleInstrument getInstrumentInfoInSlot(byte slot) {
        return this.instruments.containsKey(slot) ? this.instruments.get(slot) : null;
    }

    public void setInstrumentInSlot(byte slot, String instrument) {
        if (instrument.isEmpty()) {
            this.instruments.remove(slot);
        } else {
            this.instruments.put(slot, new VehicleInstrument(instrument));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void initSounds() {
        if (this.pack.motorized.hornSound != null) {
            this.addSound(VehicleSound.SoundTypes.HORN, null);
        }
        if (this.pack.motorized.sirenSound != null) {
            this.addSound(VehicleSound.SoundTypes.SIREN, null);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final List<VehicleSound> getSounds() {
        return this.sounds;
    }

    @SideOnly(value=Side.CLIENT)
    public final void addSound(VehicleSound.SoundTypes typeToAdd, APart optionalPart) {
        VehicleSound newSound = new VehicleSound(this, optionalPart, typeToAdd);
        for (int i = 0; i < this.sounds.size(); i = (int)((byte)(i + 1))) {
            if (!this.sounds.get(i).getSoundUniqueName().equals(newSound.getSoundUniqueName())) continue;
            this.sounds.remove(i);
            break;
        }
        this.sounds.add(newSound);
    }

    @Override
    public void func_70020_e(NBTTagCompound tagCompound) {
        this.soundsNeedInit = this.field_70170_p.field_72995_K && this.pack == null;
        super.func_70020_e(tagCompound);
        this.throttle = tagCompound.func_74771_c("throttle");
        this.fuel = tagCompound.func_74769_h("fuel");
        this.electricPower = tagCompound.func_74769_h("electricPower");
        this.lightsOn.clear();
        String lightsOnString = tagCompound.func_74779_i("lightsOn");
        while (!lightsOnString.isEmpty()) {
            String lightName = lightsOnString.substring(0, lightsOnString.indexOf(44));
            for (LightTypes light : LightTypes.values()) {
                if (!light.name().equals(lightName)) continue;
                this.lightsOn.add(light);
                break;
            }
            lightsOnString = lightsOnString.substring(lightsOnString.indexOf(44) + 1);
        }
        for (byte i = 0; i < this.pack.motorized.instruments.size(); i = (byte)((byte)(i + 1))) {
            String instrumentInSlot;
            VehicleInstrument instrument;
            if (!tagCompound.func_74764_b("instrumentInSlot" + i) || (instrument = new VehicleInstrument(instrumentInSlot = tagCompound.func_74779_i("instrumentInSlot" + i))) == null || !instrument.pack.general.validVehicles.contains(this.pack.general.type)) continue;
            this.instruments.put(i, instrument);
        }
    }

    @Override
    public NBTTagCompound func_189511_e(NBTTagCompound tagCompound) {
        super.func_189511_e(tagCompound);
        tagCompound.func_74774_a("throttle", this.throttle);
        tagCompound.func_74780_a("fuel", this.fuel);
        tagCompound.func_74780_a("electricPower", this.electricPower);
        String lightsOnString = "";
        for (LightTypes light : this.lightsOn) {
            lightsOnString = lightsOnString + light.name() + ",";
        }
        tagCompound.func_74778_a("lightsOn", lightsOnString);
        String[] instrumentsInSlots = new String[this.pack.motorized.instruments.size()];
        for (byte i = 0; i < instrumentsInSlots.length; i = (byte)(i + 1)) {
            if (!this.instruments.containsKey(i)) continue;
            tagCompound.func_74778_a("instrumentInSlot" + i, this.instruments.get((Object)Byte.valueOf((byte)i)).name);
        }
        return tagCompound;
    }

    public static class VehicleInstrument {
        public final String name;
        public final PackInstrumentObject pack;

        public VehicleInstrument(String name) {
            this.name = name;
            this.pack = PackParserSystem.getInstrument(name);
        }
    }

    public static enum LightTypes {
        NAVIGATIONLIGHT(false),
        STROBELIGHT(false),
        TAXILIGHT(true),
        LANDINGLIGHT(true),
        BRAKELIGHT(false),
        BACKUPLIGHT(false),
        LEFTTURNLIGHT(false),
        RIGHTTURNLIGHT(false),
        LEFTINDICATORLIGHT(false),
        RIGHTINDICATORLIGHT(false),
        RUNNINGLIGHT(false),
        HEADLIGHT(true),
        EMERGENCYLIGHT(false);

        public final boolean hasBeam;

        private LightTypes(boolean hasBeam) {
            this.hasBeam = hasBeam;
        }
    }
}

