/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.main;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.packets.control.SteeringPacket;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.APartGroundDevice;
import minecrafttransportsimulator.vehicles.parts.PartEngineCar;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class EntityVehicleF_Car
extends EntityVehicleE_Powered {
    public short steeringAngle;
    public short steeringCooldown;
    public List<APartGroundDevice> wheels = new ArrayList<APartGroundDevice>();
    public List<APartGroundDevice> groundedWheels = new ArrayList<APartGroundDevice>();
    private float momentPitch;
    private double wheelForce;
    private double dragForce;
    private double gravitationalForce;
    private double gravitationalTorque;

    public EntityVehicleF_Car(World world) {
        super(world);
    }

    public EntityVehicleF_Car(World world, float posX, float posY, float posZ, float rotation, String vehicleName) {
        super(world, posX, posY, posZ, rotation, vehicleName);
    }

    @Override
    public void func_70030_z() {
        super.func_70030_z();
        if (this.pack != null) {
            this.groundedWheels.clear();
            for (APartGroundDevice wheel : this.wheels) {
                if (!wheel.isOnGround()) continue;
                this.groundedWheels.add(wheel);
            }
        }
    }

    @Override
    protected void getBasicProperties() {
        this.momentPitch = (float)(2.0 * this.currentMass);
        this.velocityVec = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.velocity = this.velocityVec.func_72430_b(this.headingVec);
        this.velocityVec = this.velocityVec.func_72432_b();
        this.changeLightStatus(EntityVehicleE_Powered.LightTypes.BRAKELIGHT, this.brakeOn);
        this.changeLightStatus(EntityVehicleE_Powered.LightTypes.LEFTINDICATORLIGHT, this.brakeOn && !this.isLightOn(EntityVehicleE_Powered.LightTypes.LEFTTURNLIGHT));
        this.changeLightStatus(EntityVehicleE_Powered.LightTypes.RIGHTINDICATORLIGHT, this.brakeOn && !this.isLightOn(EntityVehicleE_Powered.LightTypes.RIGHTTURNLIGHT));
        this.changeLightStatus(EntityVehicleE_Powered.LightTypes.BACKUPLIGHT, this.getEngineByNumber((byte)0) != null && ((PartEngineCar)this.getEngineByNumber((byte)0)).getGearshiftRotation() < 0.0f);
    }

    @Override
    protected void getForcesAndMotions() {
        this.wheelForce = this.getEngineByNumber((byte)0) != null ? this.getEngineByNumber((byte)0).getForceOutput() : 0.0;
        this.dragForce = 0.5 * this.airDensity * this.velocity * this.velocity * 5.0 * (double)this.pack.car.dragCoefficient;
        this.gravitationalForce = this.currentMass * 0.0245;
        this.gravitationalTorque = this.gravitationalForce * 1.0;
        this.field_70159_w += (this.headingVec.field_72450_a * this.wheelForce - this.velocityVec.field_72450_a * this.dragForce) / this.currentMass;
        this.field_70179_y += (this.headingVec.field_72449_c * this.wheelForce - this.velocityVec.field_72449_c * this.dragForce) / this.currentMass;
        this.field_70181_x += (this.headingVec.field_72448_b * this.wheelForce - this.velocityVec.field_72448_b * this.dragForce - this.gravitationalForce) / this.currentMass;
        this.motionYaw = 0.0f;
        this.motionPitch = (float)((1.0 - Math.abs(this.headingVec.field_72448_b)) * this.gravitationalTorque / (double)this.momentPitch);
        this.motionRoll = 0.0f;
    }

    @Override
    protected void dampenControlSurfaces() {
        if (this.steeringCooldown == 0) {
            if (this.steeringAngle != 0) {
                MTS.MTSNet.sendToAll((IMessage)new SteeringPacket(this.func_145782_y(), this.steeringAngle < 0, 0));
                this.steeringAngle = (short)(this.steeringAngle + (this.steeringAngle < 0 ? 20 : -20));
            }
        } else {
            this.steeringCooldown = (short)(this.steeringCooldown - 1);
        }
    }

    @Override
    public void addPart(APart part, boolean ignoreCollision) {
        super.addPart(part, ignoreCollision);
        if (part instanceof APartGroundDevice && ((APartGroundDevice)part).canBeDrivenByEngine()) {
            this.wheels.add((APartGroundDevice)part);
        }
    }

    @Override
    public void removePart(APart part, boolean playBreakSound) {
        super.removePart(part, playBreakSound);
        if (this.wheels.contains(part)) {
            this.wheels.remove(part);
        }
    }

    @Override
    public float getSteerAngle() {
        return (float)(-this.steeringAngle) / 10.0f;
    }

    @Override
    public void func_70020_e(NBTTagCompound tagCompound) {
        super.func_70020_e(tagCompound);
        this.steeringAngle = tagCompound.func_74765_d("steeringAngle");
    }

    @Override
    public NBTTagCompound func_189511_e(NBTTagCompound tagCompound) {
        super.func_189511_e(tagCompound);
        tagCompound.func_74777_a("steeringAngle", this.steeringAngle);
        return tagCompound;
    }
}

