/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.vehicles.parts;

import minecrafttransportsimulator.MTS;
import minecrafttransportsimulator.dataclasses.PackPartObject;
import minecrafttransportsimulator.dataclasses.PackVehicleObject;
import minecrafttransportsimulator.items.parts.ItemPartBullet;
import minecrafttransportsimulator.packets.parts.PacketPartGunReload;
import minecrafttransportsimulator.systems.PackParserSystem;
import minecrafttransportsimulator.systems.SFXSystem;
import minecrafttransportsimulator.vehicles.main.EntityVehicleE_Powered;
import minecrafttransportsimulator.vehicles.parts.APart;
import minecrafttransportsimulator.vehicles.parts.PartBullet;
import minecrafttransportsimulator.vehicles.parts.PartCrate;
import minecrafttransportsimulator.vehicles.parts.PartSeat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class APartGun
extends APart
implements SFXSystem.FXPart {
    public int shotsFired;
    public int bulletsLeft;
    public float currentPitch;
    public float currentYaw;
    public String loadedBullet;
    public boolean reloading;
    public int playerControllerID = -1;
    public int temp;
    public int cooldownTimeRemaining;
    public int reloadTimeRemaining;
    private long lastTickFired;
    private long lastTickToFire;

    public APartGun(EntityVehicleE_Powered vehicle, PackVehicleObject.PackPart packPart, String partName, NBTTagCompound dataTag) {
        super(vehicle, packPart, partName, dataTag);
        this.shotsFired = dataTag.func_74762_e("shotsFired");
        this.bulletsLeft = dataTag.func_74762_e("bulletsLeft");
        this.currentPitch = dataTag.func_74760_g("currentPitch");
        this.currentYaw = dataTag.func_74760_g("currentYaw");
        this.loadedBullet = dataTag.func_74779_i("loadedBullet");
    }

    @Override
    public boolean interactPart(EntityPlayer player) {
        ItemStack heldStack;
        if (!this.vehicle.field_70170_p.field_72995_K && !this.reloading && (heldStack = player.func_184614_ca()) != null && heldStack.func_77973_b() instanceof ItemPartBullet) {
            ItemPartBullet bulletItem = (ItemPartBullet)heldStack.func_77973_b();
            if ((this.loadedBullet.isEmpty() && bulletItem.bulletPackData.diameter == this.pack.gun.diameter || this.loadedBullet.equals(bulletItem.partName)) && bulletItem.bulletPackData.quantity <= this.pack.gun.capacity + this.bulletsLeft) {
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_174925_a((Item)bulletItem, -1, 1, null);
                }
                this.loadedBullet = bulletItem.partName;
                this.bulletsLeft += bulletItem.bulletPackData.quantity;
                this.reloadTimeRemaining = this.pack.gun.reloadTime;
                this.reloading = true;
                MTS.MTSNet.sendToAll((IMessage)new PacketPartGunReload(this, bulletItem.partName));
            }
        }
        return true;
    }

    @Override
    public void attackPart(DamageSource source, float damage) {
        if (!source.func_94541_c()) {
            this.shotsFired += (int)(damage * 2.0f);
            if (source.func_76347_k()) {
                this.temp = (int)((float)this.temp + damage);
            }
        } else {
            this.shotsFired += (int)(damage * 10.0f);
            this.reloadTimeRemaining = this.pack.gun.reloadTime;
            this.reloading = true;
        }
    }

    @Override
    public void updatePart() {
        super.updatePart();
        if (this.playerControllerID != -1) {
            PartSeat seat = this.vehicle.getSeatForRider(this.vehicle.field_70170_p.func_73045_a(this.playerControllerID));
            if (seat != null && (this.parentPart == null ? seat.isController : this.parentPart.equals(seat))) {
                if (this.bulletsLeft == 0 && this.pack.gun.autoReload && !this.reloading) {
                    for (APart part : this.vehicle.getVehicleParts()) {
                        if (!(part instanceof PartCrate)) continue;
                        InventoryBasic crateInventory = ((PartCrate)part).crateInventory;
                        for (int i = 0; i < crateInventory.func_70302_i_(); i = (int)((byte)(i + 1))) {
                            ItemStack stack = crateInventory.func_70301_a(i);
                            if (stack == null || !(stack.func_77973_b() instanceof ItemPartBullet)) continue;
                            ItemPartBullet bullet = (ItemPartBullet)stack.func_77973_b();
                            if (this.loadedBullet != null && !this.loadedBullet.equals(bullet.partName)) continue;
                            PackPartObject bulletPack = PackParserSystem.getPartPack(bullet.partName);
                            if (bulletPack.bullet.quantity + this.bulletsLeft > this.pack.gun.capacity) continue;
                            this.reloadTimeRemaining = this.pack.gun.reloadTime;
                            this.reloading = true;
                            crateInventory.func_70298_a(i, 1);
                            this.loadedBullet = bullet.partName;
                            this.bulletsLeft = bulletPack.bullet.quantity;
                            MTS.MTSNet.sendToAll((IMessage)new PacketPartGunReload(this, bullet.partName));
                            return;
                        }
                    }
                    this.loadedBullet = "";
                }
                if (this.reloading) {
                    --this.reloadTimeRemaining;
                    if (this.reloadTimeRemaining <= 0) {
                        this.reloading = false;
                    }
                }
                if (this.playerControllerID != -1 && this.bulletsLeft > 0 && !this.reloading) {
                    if (this.cooldownTimeRemaining == 0) {
                        this.cooldownTimeRemaining = this.pack.gun.fireDelay;
                        this.lastTickToFire = this.vehicle.field_70170_p.func_82737_E();
                        --this.bulletsLeft;
                    }
                    if (this.cooldownTimeRemaining > 0) {
                        --this.cooldownTimeRemaining;
                    }
                }
            } else {
                this.playerControllerID = -1;
            }
        }
    }

    @Override
    public NBTTagCompound getPartNBTTag() {
        NBTTagCompound dataTag = new NBTTagCompound();
        dataTag.func_74768_a("shotsFired", this.shotsFired);
        dataTag.func_74768_a("bulletsLeft", this.bulletsLeft);
        dataTag.func_74776_a("currentPitch", this.currentPitch);
        dataTag.func_74776_a("currentYaw", this.currentYaw);
        dataTag.func_74778_a("loadedBullet", this.loadedBullet);
        return dataTag;
    }

    @Override
    public float getWidth() {
        return 0.75f;
    }

    @Override
    public float getHeight() {
        return 0.75f;
    }

    @Override
    public Vec3d getActionRotation(float partialTicks) {
        return new Vec3d((double)this.currentPitch, (double)this.currentYaw, 0.0);
    }

    public abstract float getMinYaw();

    public abstract float getMaxYaw();

    public abstract float getMinPitch();

    public abstract float getMaxPitch();

    public abstract boolean canUseLargeAmmo();

    @Override
    @SideOnly(value=Side.CLIENT)
    public void spawnParticles() {
        if (this.lastTickToFire != this.lastTickFired) {
            float bulletYaw = (float)((double)this.vehicle.field_70177_z - this.partRotation.field_72448_b + (double)this.currentYaw + (Math.random() - 0.5) * (double)(this.pack.gun.diameter / this.pack.gun.length));
            float bulletPitch = (float)((double)this.vehicle.field_70125_A + this.partRotation.field_72450_a + (double)this.currentPitch + (Math.random() - 0.5) * (double)(this.pack.gun.diameter / this.pack.gun.length));
            float f = MathHelper.func_76134_b((float)(-bulletYaw * ((float)Math.PI / 180) - (float)Math.PI));
            float f1 = MathHelper.func_76126_a((float)(-bulletYaw * ((float)Math.PI / 180) - (float)Math.PI));
            float f2 = -MathHelper.func_76134_b((float)(-bulletPitch * ((float)Math.PI / 180)));
            float f3 = MathHelper.func_76126_a((float)(-bulletPitch * ((float)Math.PI / 180)));
            Vec3d bulletOrientation = new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
            double bulletMotionX = bulletOrientation.field_72450_a * (double)this.pack.gun.muzzleVelocity / 20.0 / 10.0;
            double bulletMotionY = bulletOrientation.field_72448_b * (double)this.pack.gun.muzzleVelocity / 20.0 / 10.0;
            double bulletMotionZ = bulletOrientation.field_72449_c * (double)this.pack.gun.muzzleVelocity / 20.0 / 10.0;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new PartBullet(this.vehicle.field_70170_p, this.partPos.field_72450_a, this.partPos.field_72448_b, this.partPos.field_72449_c, bulletMotionX, bulletMotionY, bulletMotionZ, this.loadedBullet, this.playerControllerID, this.vehicle));
            MTS.proxy.playSound(this.partPos, this.partName + "_firing", 1.0f, 1.0f);
            this.lastTickFired = this.lastTickToFire;
        }
    }
}

